/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client;

import java.net.URI;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import voldemort.client.AbstractStoreClientFactory;
import voldemort.client.ClientConfig;
import voldemort.client.RoutingTier;
import voldemort.client.protocol.RequestFormatFactory;
import voldemort.client.protocol.RequestFormatType;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.ClientStoreVerifier;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.cluster.failuredetector.FailureDetectorConfig;
import voldemort.cluster.failuredetector.FailureDetectorListener;
import voldemort.cluster.failuredetector.FailureDetectorUtils;
import voldemort.store.Store;
import voldemort.store.http.HttpStore;
import voldemort.utils.ByteArray;
import voldemort.utils.VoldemortIOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpStoreClientFactory
extends AbstractStoreClientFactory {
    public static final String URL_SCHEME = "http";
    private static final String VOLDEMORT_USER_AGENT = "vldmrt/0.01";
    private final DefaultHttpClient httpClient;
    private final RequestFormatFactory requestFormatFactory;
    private final boolean reroute;

    public HttpStoreClientFactory(ClientConfig config) {
        super(config);
        ThreadSafeClientConnManager mgr = new ThreadSafeClientConnManager(SchemeRegistryFactory.createDefault(), (long)config.getConnectionTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        mgr.setMaxTotal(config.getMaxTotalConnections());
        mgr.setDefaultMaxPerRoute(config.getMaxConnectionsPerNode());
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)mgr);
        HttpParams clientParams = this.httpClient.getParams();
        HttpProtocolParams.setUserAgent((HttpParams)clientParams, (String)VOLDEMORT_USER_AGENT);
        HttpProtocolParams.setVersion((HttpParams)clientParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpConnectionParams.setConnectionTimeout((HttpParams)clientParams, (int)config.getConnectionTimeout(TimeUnit.MILLISECONDS));
        HttpConnectionParams.setSoTimeout((HttpParams)clientParams, (int)config.getSocketTimeout(TimeUnit.MILLISECONDS));
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)clientParams, (boolean)false);
        this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        HttpClientParams.setCookiePolicy((HttpParams)clientParams, (String)"ignoreCookies");
        this.reroute = config.getRoutingTier().equals((Object)RoutingTier.SERVER);
        this.requestFormatFactory = new RequestFormatFactory();
    }

    @Override
    protected Store<ByteArray, byte[], byte[]> getStore(String name, String host, int port, RequestFormatType type) {
        return new HttpStore(name, host, port, (HttpClient)this.httpClient, this.requestFormatFactory.getRequestFormat(type), this.reroute);
    }

    @Override
    protected FailureDetector initFailureDetector(final ClientConfig config, Collection<Node> nodes) {
        ClientStoreVerifier storeVerifier = new ClientStoreVerifier(){

            @Override
            protected Store<ByteArray, byte[], byte[]> getStoreInternal(Node node) {
                return HttpStoreClientFactory.this.getStore("metadata", node.getHost(), node.getHttpPort(), config.getRequestFormatType());
            }
        };
        FailureDetectorConfig failureDetectorConfig = new FailureDetectorConfig(config).setNodes(nodes).setStoreVerifier(storeVerifier);
        return FailureDetectorUtils.create(failureDetectorConfig, config.isJmxEnabled(), new FailureDetectorListener[0]);
    }

    @Override
    protected int getPort(Node node) {
        return node.getHttpPort();
    }

    @Override
    protected void validateUrl(URI url) {
        if (!URL_SCHEME.equals(url.getScheme())) {
            throw new IllegalArgumentException("Illegal scheme in bootstrap URL for HttpStoreClientFactory: expected 'http' but found '" + url.getScheme() + "'.");
        }
    }

    @Override
    public void close() {
        super.close();
        VoldemortIOUtils.closeQuietly((HttpClient)this.httpClient);
    }
}

