/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.store.InsufficientOperationalNodesException;
import voldemort.store.InsufficientZoneResponsesException;
import voldemort.store.InvalidMetadataException;
import voldemort.store.nonblockingstore.NonblockingStore;
import voldemort.store.nonblockingstore.NonblockingStoreCallback;
import voldemort.store.routed.BasicPipelineData;
import voldemort.store.routed.Pipeline;
import voldemort.store.routed.Response;
import voldemort.store.routed.action.AbstractKeyBasedAction;
import voldemort.utils.ByteArray;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformParallelRequests<V, PD extends BasicPipelineData<V>>
extends AbstractKeyBasedAction<ByteArray, V, PD> {
    private final int preferred;
    private final int required;
    private final long timeoutMs;
    private final Map<Integer, NonblockingStore> nonblockingStores;
    private final FailureDetector failureDetector;
    private final Pipeline.Event insufficientSuccessesEvent;
    private final Pipeline.Event insufficientZonesEvent;
    private byte[] transforms;

    public PerformParallelRequests(PD pipelineData, Pipeline.Event completeEvent, ByteArray key, byte[] transforms, FailureDetector failureDetector, int preferred, int required, long timeoutMs, Map<Integer, NonblockingStore> nonblockingStores, Pipeline.Event insufficientSuccessesEvent, Pipeline.Event insufficientZonesEvent) {
        super(pipelineData, completeEvent, key);
        this.failureDetector = failureDetector;
        this.preferred = preferred;
        this.required = required;
        this.transforms = transforms;
        this.timeoutMs = timeoutMs;
        this.nonblockingStores = nonblockingStores;
        this.insufficientSuccessesEvent = insufficientSuccessesEvent;
        this.insufficientZonesEvent = insufficientZonesEvent;
    }

    @Override
    public void execute(final Pipeline pipeline) {
        ConcurrentHashMap responses;
        block21: {
            List<Node> nodes = ((BasicPipelineData)this.pipelineData).getNodes();
            int attempts = Math.min(this.preferred, nodes.size());
            responses = new ConcurrentHashMap();
            final CountDownLatch latch = new CountDownLatch(attempts);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Attempting " + attempts + " " + pipeline.getOperation().getSimpleName() + " operations in parallel"));
            }
            for (int i = 0; i < attempts; ++i) {
                final Node node = nodes.get(i);
                ((BasicPipelineData)this.pipelineData).incrementNodeIndex();
                final long startMs = this.logger.isDebugEnabled() ? System.currentTimeMillis() : -1L;
                NonblockingStoreCallback callback = new NonblockingStoreCallback(){

                    public void requestComplete(Object result, long requestTime) {
                        if (PerformParallelRequests.this.logger.isTraceEnabled()) {
                            PerformParallelRequests.this.logger.trace((Object)(pipeline.getOperation().getSimpleName() + " response received (" + requestTime + " ms.) from node " + node.getId()));
                        }
                        Response<Object, Object> response = new Response<Object, Object>(node, PerformParallelRequests.this.key, result, requestTime);
                        if (PerformParallelRequests.this.logger.isDebugEnabled()) {
                            PerformParallelRequests.this.logger.debug((Object)("Finished " + pipeline.getOperation().getSimpleName() + " for key " + PerformParallelRequests.this.key + " (keyRef: " + System.identityHashCode(PerformParallelRequests.this.key) + "); started at " + startMs + " took " + requestTime + " ms on node " + node.getId() + "(" + node.getHost() + ")"));
                        }
                        responses.put(node.getId(), response);
                        latch.countDown();
                        if (pipeline.isFinished() && response.getValue() instanceof Exception) {
                            if (response.getValue() instanceof InvalidMetadataException) {
                                ((BasicPipelineData)PerformParallelRequests.this.pipelineData).reportException((InvalidMetadataException)response.getValue());
                                PerformParallelRequests.this.logger.warn((Object)("Received invalid metadata problem after a successful " + pipeline.getOperation().getSimpleName() + " call on node " + node.getId() + ", store '" + ((BasicPipelineData)PerformParallelRequests.this.pipelineData).getStoreName() + "'"));
                            } else {
                                PerformParallelRequests.this.handleResponseError(response, pipeline, PerformParallelRequests.this.failureDetector);
                            }
                        }
                    }
                };
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Submitting " + pipeline.getOperation().getSimpleName() + " request on node " + node.getId()));
                }
                NonblockingStore store = this.nonblockingStores.get(node.getId());
                if (pipeline.getOperation() == Pipeline.Operation.GET) {
                    store.submitGetRequest((ByteArray)this.key, this.transforms, callback, this.timeoutMs);
                    continue;
                }
                if (pipeline.getOperation() == Pipeline.Operation.GET_VERSIONS) {
                    store.submitGetVersionsRequest((ByteArray)this.key, callback, this.timeoutMs);
                    continue;
                }
                throw new IllegalStateException(this.getClass().getName() + " does not support pipeline operation " + (Object)((Object)pipeline.getOperation()));
            }
            try {
                latch.await(this.timeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block21;
                this.logger.warn((Object)e, (Throwable)e);
            }
        }
        for (Response response : responses.values()) {
            if (response.getValue() instanceof Exception) {
                if (!this.handleResponseError(response, pipeline, this.failureDetector)) continue;
                return;
            }
            ((BasicPipelineData)this.pipelineData).incrementSuccesses();
            Response rCast = (Response)Utils.uncheckedCast(response);
            ((BasicPipelineData)this.pipelineData).getResponses().add(rCast);
            this.failureDetector.recordSuccess(response.getNode(), response.getRequestTime());
            ((BasicPipelineData)this.pipelineData).getZoneResponses().add(response.getNode().getZoneId());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("GET for key " + this.key + " (keyRef: " + System.identityHashCode(this.key) + "); successes: " + ((BasicPipelineData)this.pipelineData).getSuccesses() + " preferred: " + this.preferred + " required: " + this.required));
        }
        if (((BasicPipelineData)this.pipelineData).getSuccesses() < this.required) {
            if (this.insufficientSuccessesEvent != null) {
                pipeline.addEvent(this.insufficientSuccessesEvent);
            } else {
                ((BasicPipelineData)this.pipelineData).setFatalError(new InsufficientOperationalNodesException(this.required + " " + pipeline.getOperation().getSimpleName() + "s required, but only " + ((BasicPipelineData)this.pipelineData).getSuccesses() + " succeeded", new ArrayList<Node>(((BasicPipelineData)this.pipelineData).getReplicationSet()), new ArrayList<Node>(((BasicPipelineData)this.pipelineData).getNodes()), new ArrayList<Node>(((BasicPipelineData)this.pipelineData).getFailedNodes()), ((BasicPipelineData)this.pipelineData).getFailures()));
                pipeline.abort();
            }
        } else if (((BasicPipelineData)this.pipelineData).getZonesRequired() != null) {
            int zonesSatisfied = ((BasicPipelineData)this.pipelineData).getZoneResponses().size();
            if (zonesSatisfied >= ((BasicPipelineData)this.pipelineData).getZonesRequired() + 1) {
                pipeline.addEvent(this.completeEvent);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Operation " + pipeline.getOperation().getSimpleName() + "failed due to insufficent zone responses, required " + ((BasicPipelineData)this.pipelineData).getZonesRequired() + " obtained " + zonesSatisfied + " " + ((BasicPipelineData)this.pipelineData).getZoneResponses()));
                }
                if (this.insufficientZonesEvent != null) {
                    pipeline.addEvent(this.insufficientZonesEvent);
                } else {
                    ((BasicPipelineData)this.pipelineData).setFatalError(new InsufficientZoneResponsesException(((BasicPipelineData)this.pipelineData).getZonesRequired() + 1 + " " + pipeline.getOperation().getSimpleName() + "s required zone, but only " + zonesSatisfied + " succeeded"));
                }
            }
        } else {
            pipeline.addEvent(this.completeEvent);
        }
    }
}

