/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import voldemort.utils.HashFunction;
import voldemort.utils.Utils;

public class FnvHashFunction
implements HashFunction {
    private static final long FNV_BASIS = -2128831035L;
    private static final long FNV_PRIME = 16777619L;
    public static final long FNV_BASIS_64 = -3750763034362895579L;
    public static final long FNV_PRIME_64 = 1099511628211L;

    public int hash(byte[] key) {
        long hash = -2128831035L;
        for (int i = 0; i < key.length; ++i) {
            hash ^= (long)(0xFF & key[i]);
            hash *= 16777619L;
        }
        return (int)hash;
    }

    public long hash64(long val) {
        long hashval = -3750763034362895579L;
        for (int i = 0; i < 8; ++i) {
            long octet = val & 0xFFL;
            val >>= 8;
            hashval ^= octet;
            hashval *= 1099511628211L;
        }
        return Math.abs(hashval);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            Utils.croak("USAGE: java FnvHashFunction iterations buckets");
        }
        int numIterations = Integer.parseInt(args[0]);
        int numBuckets = Integer.parseInt(args[1]);
        int[] buckets = new int[numBuckets];
        FnvHashFunction hash = new FnvHashFunction();
        for (int i = 0; i < numIterations; ++i) {
            int val = hash.hash(Integer.toString(i).getBytes());
            int n = Math.abs(val) % numBuckets;
            buckets[n] = buckets[n] + 1;
        }
        double expected = (double)numIterations / (double)numBuckets;
        for (int i = 0; i < numBuckets; ++i) {
            System.out.println(i + " " + buckets[i] + " " + (double)buckets[i] / expected);
        }
    }
}

