/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.protocol.vold;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.protocol.RequestFormat;
import voldemort.server.RequestRoutingType;
import voldemort.store.ErrorCodeMapper;
import voldemort.store.StoreUtils;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteBufferBackedInputStream;
import voldemort.utils.ByteUtils;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoldemortNativeClientRequestFormat
implements RequestFormat {
    private final ErrorCodeMapper mapper;
    private final int protocolVersion;
    private final Logger logger = Logger.getLogger(this.getClass());

    public VoldemortNativeClientRequestFormat(int protocolVersion) {
        this.mapper = new ErrorCodeMapper();
        this.protocolVersion = protocolVersion;
    }

    @Override
    public void writeDeleteRequest(DataOutputStream outputStream, String storeName, ByteArray key, VectorClock version, RequestRoutingType routingType) throws IOException {
        StoreUtils.assertValidKey(key);
        outputStream.writeByte(3);
        outputStream.writeUTF(storeName);
        outputStream.writeBoolean(routingType.equals((Object)RequestRoutingType.ROUTED));
        if (this.protocolVersion > 1) {
            outputStream.writeByte(routingType.getRoutingTypeCode());
        }
        outputStream.writeInt(key.length());
        outputStream.write(key.get());
        VectorClock clock = version;
        outputStream.writeShort(clock.sizeInBytes());
        outputStream.write(clock.toBytes());
    }

    @Override
    public boolean isCompleteDeleteResponse(ByteBuffer buffer) {
        return this.isCompleteResponse(buffer, (byte)3);
    }

    @Override
    public boolean readDeleteResponse(DataInputStream inputStream) throws IOException {
        this.checkException(inputStream);
        return inputStream.readBoolean();
    }

    @Override
    public void writeGetRequest(DataOutputStream outputStream, String storeName, ByteArray key, byte[] transforms, RequestRoutingType routingType) throws IOException {
        StoreUtils.assertValidKey(key);
        outputStream.writeByte(1);
        outputStream.writeUTF(storeName);
        outputStream.writeBoolean(routingType.equals((Object)RequestRoutingType.ROUTED));
        if (this.protocolVersion > 1) {
            outputStream.writeByte(routingType.getRoutingTypeCode());
        }
        outputStream.writeInt(key.length());
        outputStream.write(key.get());
        if (this.protocolVersion > 2) {
            if (transforms != null) {
                outputStream.writeBoolean(true);
                outputStream.writeInt(transforms.length);
                outputStream.write(transforms);
            } else {
                outputStream.writeBoolean(false);
            }
        }
    }

    @Override
    public List<Versioned<byte[]>> readGetResponse(DataInputStream inputStream) throws IOException {
        this.checkException(inputStream);
        return this.readResults(inputStream);
    }

    @Override
    public boolean isCompleteGetResponse(ByteBuffer buffer) {
        return this.isCompleteResponse(buffer, (byte)1);
    }

    private List<Versioned<byte[]>> readResults(DataInputStream inputStream) throws IOException {
        int resultSize = inputStream.readInt();
        ArrayList<Versioned<byte[]>> results = new ArrayList<Versioned<byte[]>>(resultSize);
        for (int i = 0; i < resultSize; ++i) {
            int valueSize = inputStream.readInt();
            byte[] bytes = new byte[valueSize];
            ByteUtils.read(inputStream, bytes);
            VectorClock clock = new VectorClock(bytes);
            results.add(new Versioned<byte[]>(ByteUtils.copy(bytes, clock.sizeInBytes(), bytes.length), clock));
        }
        return results;
    }

    @Override
    public void writeGetAllRequest(DataOutputStream output, String storeName, Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms, RequestRoutingType routingType) throws IOException {
        StoreUtils.assertValidKeys(keys);
        output.writeByte(4);
        output.writeUTF(storeName);
        output.writeBoolean(routingType.equals((Object)RequestRoutingType.ROUTED));
        if (this.protocolVersion > 1) {
            output.writeByte(routingType.getRoutingTypeCode());
        }
        ArrayList<ByteArray> l = new ArrayList<ByteArray>();
        for (ByteArray byteArray : keys) {
            l.add(byteArray);
        }
        output.writeInt(l.size());
        for (ByteArray byteArray : keys) {
            output.writeInt(byteArray.length());
            output.write(byteArray.get());
        }
        if (this.protocolVersion > 2) {
            if (transforms != null) {
                output.writeBoolean(true);
                output.writeInt(transforms.size());
                for (Map.Entry entry : transforms.entrySet()) {
                    output.writeInt(((ByteArray)entry.getKey()).length());
                    output.write(((ByteArray)entry.getKey()).get());
                    if (entry.getValue() != null) {
                        output.writeInt(((byte[])entry.getValue()).length);
                        output.write((byte[])entry.getValue());
                        continue;
                    }
                    output.writeInt(0);
                }
            } else {
                output.writeBoolean(false);
            }
        }
    }

    @Override
    public boolean isCompleteGetAllResponse(ByteBuffer buffer) {
        return this.isCompleteResponse(buffer, (byte)4);
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> readGetAllResponse(DataInputStream stream) throws IOException {
        this.checkException(stream);
        int numResults = stream.readInt();
        HashMap<ByteArray, List<Versioned<byte[]>>> results = new HashMap<ByteArray, List<Versioned<byte[]>>>(numResults);
        for (int i = 0; i < numResults; ++i) {
            int keySize = stream.readInt();
            byte[] key = new byte[keySize];
            stream.readFully(key);
            results.put(new ByteArray(key), this.readResults(stream));
        }
        return results;
    }

    @Override
    public void writePutRequest(DataOutputStream outputStream, String storeName, ByteArray key, byte[] value, byte[] transforms, VectorClock version, RequestRoutingType routingType) throws IOException {
        StoreUtils.assertValidKey(key);
        outputStream.writeByte(2);
        outputStream.writeUTF(storeName);
        outputStream.writeBoolean(routingType.equals((Object)RequestRoutingType.ROUTED));
        if (this.protocolVersion > 1) {
            outputStream.writeByte(routingType.getRoutingTypeCode());
        }
        outputStream.writeInt(key.length());
        outputStream.write(key.get());
        outputStream.writeInt(value.length + version.sizeInBytes());
        outputStream.write(version.toBytes());
        outputStream.write(value);
        if (this.protocolVersion > 2) {
            if (transforms != null) {
                outputStream.writeBoolean(true);
                outputStream.writeInt(transforms.length);
                outputStream.write(transforms);
            } else {
                outputStream.writeBoolean(false);
            }
        }
    }

    @Override
    public boolean isCompletePutResponse(ByteBuffer buffer) {
        return this.isCompleteResponse(buffer, (byte)2);
    }

    @Override
    public void readPutResponse(DataInputStream inputStream) throws IOException {
        this.checkException(inputStream);
    }

    private void checkException(DataInputStream inputStream) throws IOException {
        short retCode = inputStream.readShort();
        if (retCode != 0) {
            String error = inputStream.readUTF();
            throw this.mapper.getError(retCode, error);
        }
    }

    @Override
    public boolean isCompleteGetVersionResponse(ByteBuffer buffer) {
        return this.isCompleteResponse(buffer, (byte)10);
    }

    @Override
    public List<Version> readGetVersionResponse(DataInputStream stream) throws IOException {
        this.checkException(stream);
        int resultSize = stream.readInt();
        ArrayList<Version> results = new ArrayList<Version>(resultSize);
        for (int i = 0; i < resultSize; ++i) {
            int versionSize = stream.readInt();
            byte[] bytes = new byte[versionSize];
            ByteUtils.read(stream, bytes);
            VectorClock clock = new VectorClock(bytes);
            results.add(clock);
        }
        return results;
    }

    @Override
    public void writeGetVersionRequest(DataOutputStream output, String storeName, ByteArray key, RequestRoutingType routingType) throws IOException {
        StoreUtils.assertValidKey(key);
        output.writeByte(10);
        output.writeUTF(storeName);
        output.writeBoolean(routingType.equals((Object)RequestRoutingType.ROUTED));
        if (this.protocolVersion > 1) {
            output.writeByte(routingType.getRoutingTypeCode());
        }
        output.writeInt(key.length());
        output.write(key.get());
    }

    private boolean isCompleteResponse(ByteBuffer buffer, byte opCode) {
        DataInputStream inputStream = new DataInputStream(new ByteBufferBackedInputStream(buffer));
        try {
            try {
                switch (opCode) {
                    case 1: {
                        this.readGetResponse(inputStream);
                        break;
                    }
                    case 10: {
                        this.readGetVersionResponse(inputStream);
                        break;
                    }
                    case 4: {
                        this.readGetAllResponse(inputStream);
                        break;
                    }
                    case 3: {
                        this.readDeleteResponse(inputStream);
                        break;
                    }
                    case 2: {
                        this.readPutResponse(inputStream);
                    }
                }
            }
            catch (VoldemortException e) {
                // empty catch block
            }
            return !buffer.hasRemaining();
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Probable partial read occurred causing exception", (Throwable)e);
            }
            return false;
        }
    }
}

