/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.rebalance;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import voldemort.client.rebalance.RebalanceClusterPlan;
import voldemort.client.rebalance.RebalanceNodePlan;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.cluster.Cluster;
import voldemort.store.StoreDefinition;
import voldemort.utils.ByteArray;
import voldemort.utils.KeyDistributionGenerator;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedClusterTransition {
    private static final AtomicInteger idGen = new AtomicInteger(0);
    private final Cluster currentCluster;
    private final Cluster targetCluster;
    private final RebalanceClusterPlan rebalanceClusterPlan;
    private final List<RebalancePartitionsInfo> orderedRebalancePartitionsInfoList;
    private final List<StoreDefinition> storeDefs;
    private String printedContent;
    private final int id = idGen.incrementAndGet();

    public OrderedClusterTransition(Cluster currentCluster, Cluster targetCluster, List<StoreDefinition> storeDefs, RebalanceClusterPlan rebalanceClusterPlan) {
        this.currentCluster = currentCluster;
        this.targetCluster = targetCluster;
        this.storeDefs = storeDefs;
        this.rebalanceClusterPlan = rebalanceClusterPlan;
        this.orderedRebalancePartitionsInfoList = this.orderedClusterPlan(rebalanceClusterPlan);
    }

    public List<StoreDefinition> getStoreDefs() {
        return this.storeDefs;
    }

    public int getId() {
        return this.id;
    }

    public Cluster getTargetCluster() {
        return this.targetCluster;
    }

    public Cluster getCurrentCluster() {
        return this.currentCluster;
    }

    public List<RebalancePartitionsInfo> getOrderedRebalancePartitionsInfoList() {
        return this.orderedRebalancePartitionsInfoList;
    }

    public String toString() {
        if (this.printedContent == null) {
            StringBuilder sb = new StringBuilder();
            List<ByteArray> keys = KeyDistributionGenerator.generateKeys(10000);
            sb.append("- Rebalance Task Id : ").append(this.getId()).append(Utils.NEWLINE);
            sb.append("- Current cluster : ").append(KeyDistributionGenerator.printOverallDistribution(this.getCurrentCluster(), this.getStoreDefs(), keys)).append(Utils.NEWLINE);
            sb.append("- Target cluster : ").append(KeyDistributionGenerator.printOverallDistribution(this.getTargetCluster(), this.getStoreDefs(), keys)).append(Utils.NEWLINE);
            sb.append("- Partition distribution : ").append(Utils.NEWLINE).append(this.getRebalanceClusterPlan().printPartitionDistribution()).append(Utils.NEWLINE);
            sb.append("- Ordered rebalance node plan : ").append(Utils.NEWLINE).append(this.printRebalanceNodePlan(this.getOrderedRebalancePartitionsInfoList()));
            this.printedContent = sb.toString();
        }
        return this.printedContent;
    }

    private String printRebalanceNodePlan(List<RebalancePartitionsInfo> rebalancePartitionInfoList) {
        StringBuilder builder = new StringBuilder();
        for (RebalancePartitionsInfo partitionInfo : rebalancePartitionInfoList) {
            builder.append(partitionInfo).append(Utils.NEWLINE);
        }
        return builder.toString();
    }

    private RebalanceClusterPlan getRebalanceClusterPlan() {
        return this.rebalanceClusterPlan;
    }

    private List<RebalancePartitionsInfo> orderedClusterPlan(RebalanceClusterPlan rebalanceClusterPlan) {
        Queue<RebalanceNodePlan> rebalancingTaskQueue = rebalanceClusterPlan.getRebalancingTaskQueue();
        ArrayList clusterRebalancePartitionsInfos = Lists.newArrayList();
        for (RebalanceNodePlan rebalanceNodePlan : rebalancingTaskQueue) {
            clusterRebalancePartitionsInfos.addAll(rebalanceNodePlan.getRebalanceTaskList());
        }
        return this.orderedPartitionInfos(clusterRebalancePartitionsInfos);
    }

    private List<RebalancePartitionsInfo> orderedPartitionInfos(List<RebalancePartitionsInfo> clusterRebalancePartitionsInfo) {
        ArrayList<RebalancePartitionsInfo> listPrimaries = new ArrayList<RebalancePartitionsInfo>();
        ArrayList<RebalancePartitionsInfo> listReplicas = new ArrayList<RebalancePartitionsInfo>();
        for (RebalancePartitionsInfo partitionInfo : clusterRebalancePartitionsInfo) {
            List<Integer> stealMasterPartitions = partitionInfo.getStealMasterPartitions();
            if (stealMasterPartitions != null && !stealMasterPartitions.isEmpty()) {
                listPrimaries.add(partitionInfo);
                continue;
            }
            listReplicas.add(partitionInfo);
        }
        listPrimaries.addAll(listReplicas);
        return listPrimaries;
    }
}

