/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly;

import java.nio.ByteBuffer;
import voldemort.store.readonly.SearchStrategy;
import voldemort.utils.ByteUtils;

public class InterpolationSearchStrategy
implements SearchStrategy {
    public int indexOf(ByteBuffer index, byte[] key, int indexFileSize) {
        int lowIdx = 0;
        int indexSize = 4 + key.length;
        int highIdx = indexFileSize / indexSize - 1;
        long lastIdx = highIdx;
        long lowValue = 0L;
        long highValue = 0xFFFFFFFFL;
        long keyInt = ByteUtils.readUnsignedInt(key, 0);
        byte[] found = new byte[key.length];
        while (lowIdx <= highIdx && keyInt >= lowValue && keyInt <= highValue) {
            int guess;
            if (highIdx == lowIdx) {
                guess = highIdx;
            } else {
                long size = highIdx - lowIdx;
                long offset = (size - 1L) * (keyInt - lowValue) / (highValue - lowValue);
                guess = lowIdx + (int)offset;
            }
            index.position(guess * indexSize);
            index.get(found);
            int compare = ByteUtils.compare(key, found);
            if (compare == 0) {
                return index.getInt();
            }
            long foundInt = ByteUtils.readUnsignedInt(found, 0);
            if (compare == -1) {
                if (guess == 0) {
                    return -1;
                }
                highIdx = guess - 1;
                highValue = foundInt;
                continue;
            }
            if ((long)guess == lastIdx) {
                return -1;
            }
            lowIdx = guess + 1;
            lowValue = foundInt;
        }
        return -1;
    }
}

