/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.store.InsufficientOperationalNodesException;
import voldemort.store.InsufficientZoneResponsesException;
import voldemort.store.Store;
import voldemort.store.routed.Pipeline;
import voldemort.store.routed.PutPipelineData;
import voldemort.store.routed.action.AbstractKeyBasedAction;
import voldemort.utils.ByteArray;
import voldemort.utils.Time;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformSerialPutRequests
extends AbstractKeyBasedAction<ByteArray, Void, PutPipelineData> {
    private final FailureDetector failureDetector;
    private final int required;
    private final Map<Integer, Store<ByteArray, byte[], byte[]>> stores;
    private final Versioned<byte[]> versioned;
    private final Time time;
    private final Pipeline.Event masterDeterminedEvent;
    private byte[] transforms;

    public PerformSerialPutRequests(PutPipelineData pipelineData, Pipeline.Event completeEvent, ByteArray key, byte[] transforms, FailureDetector failureDetector, Map<Integer, Store<ByteArray, byte[], byte[]>> stores, int required, Versioned<byte[]> versioned, Time time, Pipeline.Event masterDeterminedEvent) {
        super(pipelineData, completeEvent, key);
        this.failureDetector = failureDetector;
        this.stores = stores;
        this.required = required;
        this.versioned = versioned;
        this.time = time;
        this.transforms = transforms;
        this.masterDeterminedEvent = masterDeterminedEvent;
    }

    @Override
    public void execute(Pipeline pipeline) {
        int currentNode = 0;
        List<Node> nodes = ((PutPipelineData)this.pipelineData).getNodes();
        long startMasterMs = -1L;
        long startMasterNs = -1L;
        if (this.logger.isDebugEnabled()) {
            startMasterMs = System.currentTimeMillis();
            startMasterNs = System.nanoTime();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Performing serial put requests to determine master");
        }
        Node node = null;
        while (currentNode < nodes.size()) {
            node = nodes.get(currentNode);
            ((PutPipelineData)this.pipelineData).incrementNodeIndex();
            VectorClock versionedClock = (VectorClock)this.versioned.getVersion();
            Versioned<byte[]> versionedCopy = new Versioned<byte[]>(this.versioned.getValue(), versionedClock.incremented(node.getId(), this.time.getMilliseconds()));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Attempt #" + (currentNode + 1) + " to perform put (node " + node.getId() + ")"));
            }
            long start = System.nanoTime();
            try {
                this.stores.get(node.getId()).put((ByteArray)this.key, versionedCopy, this.transforms);
                long requestTime = (System.nanoTime() - start) / 1000000L;
                ((PutPipelineData)this.pipelineData).incrementSuccesses();
                this.failureDetector.recordSuccess(node, requestTime);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Put on node " + node.getId() + " succeeded, using as master"));
                }
                ((PutPipelineData)this.pipelineData).setMaster(node);
                ((PutPipelineData)this.pipelineData).setVersionedCopy(versionedCopy);
                ((PutPipelineData)this.pipelineData).getZoneResponses().add(node.getZoneId());
                break;
            }
            catch (Exception e) {
                long requestTime = (System.nanoTime() - start) / 1000000L;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Master PUT at node " + currentNode + "(" + node.getHost() + ")" + " failed (" + e.getMessage() + ") in " + (System.nanoTime() - start) + " ns" + " (keyRef: " + System.identityHashCode(this.key) + ")"));
                }
                if (this.handleResponseError(e, node, requestTime, pipeline, this.failureDetector)) {
                    return;
                }
                ++currentNode;
            }
        }
        if (((PutPipelineData)this.pipelineData).getSuccesses() < 1) {
            List<Exception> failures = ((PutPipelineData)this.pipelineData).getFailures();
            ((PutPipelineData)this.pipelineData).setFatalError(new InsufficientOperationalNodesException("No master node succeeded!", failures.size() > 0 ? failures.get(0) : null));
            pipeline.abort();
            return;
        }
        if (++currentNode == nodes.size()) {
            if (((PutPipelineData)this.pipelineData).getSuccesses() < this.required) {
                ((PutPipelineData)this.pipelineData).setFatalError(new InsufficientOperationalNodesException(this.required + " " + pipeline.getOperation().getSimpleName() + "s required, but only " + ((PutPipelineData)this.pipelineData).getSuccesses() + " succeeded", new ArrayList<Node>(((PutPipelineData)this.pipelineData).getReplicationSet()), new ArrayList<Node>(((PutPipelineData)this.pipelineData).getNodes()), new ArrayList<Node>(((PutPipelineData)this.pipelineData).getFailedNodes()), ((PutPipelineData)this.pipelineData).getFailures()));
                pipeline.abort();
            } else if (((PutPipelineData)this.pipelineData).getZonesRequired() != null) {
                int zonesSatisfied = ((PutPipelineData)this.pipelineData).getZoneResponses().size();
                if (zonesSatisfied >= ((PutPipelineData)this.pipelineData).getZonesRequired() + 1) {
                    pipeline.addEvent(this.completeEvent);
                } else {
                    ((PutPipelineData)this.pipelineData).setFatalError(new InsufficientZoneResponsesException(((PutPipelineData)this.pipelineData).getZonesRequired() + 1 + " " + pipeline.getOperation().getSimpleName() + "s required zone, but only " + zonesSatisfied + " succeeded"));
                    pipeline.abort();
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Finished master PUT for key " + this.key + " (keyRef: " + System.identityHashCode(this.key) + "); started at " + startMasterMs + " took " + (System.nanoTime() - startMasterNs) + " ns on node " + (node == null ? "NULL" : Integer.valueOf(node.getId())) + "(" + (node == null ? "NULL" : node.getHost()) + "); now complete"));
                }
                pipeline.addEvent(this.completeEvent);
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Finished master PUT for key " + this.key + " (keyRef: " + System.identityHashCode(this.key) + "); started at " + startMasterMs + " took " + (System.nanoTime() - startMasterNs) + " ns on node " + (node == null ? "NULL" : Integer.valueOf(node.getId())) + "(" + (node == null ? "NULL" : node.getHost()) + ")"));
            }
            pipeline.addEvent(this.masterDeterminedEvent);
        }
    }
}

