/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.socket.clientrequest;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import voldemort.store.socket.clientrequest.ClientRequest;
import voldemort.utils.SelectorManagerWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientRequestExecutor
extends SelectorManagerWorker {
    private ClientRequest<?> clientRequest;
    private long expiration;
    private boolean isExpired = false;

    public ClientRequestExecutor(Selector selector, SocketChannel socketChannel, int socketBufferSize) {
        super(selector, socketChannel, socketBufferSize);
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public boolean isValid() {
        if (this.isClosed()) {
            return false;
        }
        Socket s = this.socketChannel.socket();
        return !s.isClosed() && s.isBound() && s.isConnected();
    }

    public synchronized boolean checkTimeout(SelectionKey selectionKey) {
        if (this.expiration <= 0L) {
            return true;
        }
        if (System.nanoTime() <= this.expiration) {
            return true;
        }
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            this.logger.warn((Object)("Client request associated with " + this.socketChannel.socket() + " timed out"));
        }
        this.isExpired = true;
        this.close();
        return false;
    }

    public synchronized void addClientRequest(ClientRequest<?> clientRequest) {
        this.addClientRequest(clientRequest, -1L);
    }

    public synchronized void addClientRequest(ClientRequest<?> clientRequest, long timeoutMs) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Associating client with " + this.socketChannel.socket()));
        }
        this.clientRequest = clientRequest;
        if (timeoutMs == -1L) {
            this.expiration = -1L;
        } else {
            this.expiration = System.nanoTime() + 1000000L * timeoutMs;
            if (this.expiration < System.nanoTime()) {
                throw new IllegalArgumentException("timeout " + timeoutMs + " not valid");
            }
        }
        this.outputStream.getBuffer().clear();
        boolean wasSuccessful = clientRequest.formatRequest(new DataOutputStream(this.outputStream));
        if (this.logger.isTraceEnabled()) {
            this.traceInputBufferState("About to clear read buffer");
        }
        if (this.inputStream.getBuffer().capacity() >= this.resizeThreshold) {
            this.inputStream.setBuffer(ByteBuffer.allocate(this.socketBufferSize));
        } else {
            this.inputStream.getBuffer().clear();
        }
        if (this.logger.isTraceEnabled()) {
            this.traceInputBufferState("Cleared read buffer");
        }
        this.outputStream.getBuffer().flip();
        if (wasSuccessful) {
            SelectionKey selectionKey = this.socketChannel.keyFor(this.selector);
            if (selectionKey != null) {
                selectionKey.interestOps(4);
                this.selector.wakeup();
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Client associated with " + this.socketChannel.socket() + " was not registered with Selector " + this.selector + ", assuming initial protocol negotiation"));
            }
        } else {
            if (this.logger.isEnabledFor((Priority)Level.WARN)) {
                this.logger.warn((Object)("Client associated with " + this.socketChannel.socket() + " did not successfully buffer output for request"));
            }
            this.completeClientRequest();
        }
    }

    @Override
    public void close() {
        if (!this.isClosed.compareAndSet(false, true)) {
            return;
        }
        this.completeClientRequest();
        this.closeInternal();
    }

    @Override
    protected void read(SelectionKey selectionKey) throws IOException {
        if (!this.checkTimeout(selectionKey)) {
            return;
        }
        int count = 0;
        count = this.socketChannel.read(this.inputStream.getBuffer());
        if (count == -1) {
            throw new EOFException("EOF for " + this.socketChannel.socket());
        }
        if (this.logger.isTraceEnabled()) {
            this.traceInputBufferState("Read " + count + " bytes");
        }
        if (count == 0) {
            return;
        }
        int position = this.inputStream.getBuffer().position();
        this.inputStream.getBuffer().flip();
        if (!this.clientRequest.isCompleteResponse(this.inputStream.getBuffer())) {
            this.handleIncompleteRequest(position);
            return;
        }
        this.inputStream.getBuffer().rewind();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Starting read for " + this.socketChannel.socket()));
        }
        this.clientRequest.parseResponse(new DataInputStream(this.inputStream));
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Finished read for " + this.socketChannel.socket()));
        }
        selectionKey.interestOps(0);
        this.completeClientRequest();
    }

    @Override
    protected void write(SelectionKey selectionKey) throws IOException {
        if (!this.checkTimeout(selectionKey)) {
            return;
        }
        if (this.outputStream.getBuffer().hasRemaining()) {
            int count = this.socketChannel.write(this.outputStream.getBuffer());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Wrote " + count + " bytes, remaining: " + this.outputStream.getBuffer().remaining() + " for " + this.socketChannel.socket()));
            }
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Wrote no bytes for " + this.socketChannel.socket()));
        }
        if (this.outputStream.getBuffer().hasRemaining()) {
            return;
        }
        if (this.outputStream.getBuffer().capacity() >= this.resizeThreshold) {
            this.outputStream.setBuffer(ByteBuffer.allocate(this.socketBufferSize));
        } else {
            this.outputStream.getBuffer().clear();
        }
        selectionKey.interestOps(1);
    }

    private synchronized void completeClientRequest() {
        if (this.clientRequest == null) {
            if (this.logger.isEnabledFor((Priority)Level.WARN)) {
                this.logger.warn((Object)("No client associated with " + this.socketChannel.socket()));
            }
            return;
        }
        ClientRequest<?> local = this.clientRequest;
        this.clientRequest = null;
        this.expiration = 0L;
        if (this.isExpired) {
            local.timeOut();
        } else {
            local.complete();
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Marked client associated with " + this.socketChannel.socket() + " as complete"));
        }
    }
}

