/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger.builtin;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutorManager;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.ExecutorManagerException;
import azkaban.sla.SlaOption;
import azkaban.trigger.TriggerAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SlaAlertAction
implements TriggerAction {
    public static final String type = "AlertAction";
    private static final Logger logger = Logger.getLogger(SlaAlertAction.class);
    private String actionId;
    private SlaOption slaOption;
    private int execId;
    private static Map<String, ExecutorManager.Alerter> alerters;
    private Map<String, Object> context;
    private static ExecutorManagerAdapter executorManager;

    public SlaAlertAction(String id, SlaOption slaOption, int execId) {
        this.actionId = id;
        this.slaOption = slaOption;
        this.execId = execId;
    }

    public static void setAlerters(Map<String, ExecutorManager.Alerter> alts) {
        alerters = alts;
    }

    public static void setExecutorManager(ExecutorManagerAdapter em) {
        executorManager = em;
    }

    @Override
    public String getId() {
        return this.actionId;
    }

    @Override
    public String getType() {
        return type;
    }

    public static SlaAlertAction createFromJson(Object obj) throws Exception {
        return SlaAlertAction.createFromJson((HashMap)obj);
    }

    public static SlaAlertAction createFromJson(HashMap<String, Object> obj) throws Exception {
        HashMap<String, Object> jsonObj = obj;
        if (!jsonObj.get("type").equals(type)) {
            throw new Exception("Cannot create action of AlertAction from " + jsonObj.get("type"));
        }
        String actionId = (String)jsonObj.get("actionId");
        SlaOption slaOption = SlaOption.fromObject(jsonObj.get("slaOption"));
        int execId = Integer.valueOf((String)jsonObj.get("execId"));
        return new SlaAlertAction(actionId, slaOption, execId);
    }

    @Override
    public TriggerAction fromJson(Object obj) throws Exception {
        return SlaAlertAction.createFromJson(obj);
    }

    @Override
    public Object toJson() {
        HashMap<String, Object> jsonObj = new HashMap<String, Object>();
        jsonObj.put("actionId", this.actionId);
        jsonObj.put("type", type);
        jsonObj.put("slaOption", this.slaOption.toObject());
        jsonObj.put("execId", String.valueOf(this.execId));
        return jsonObj;
    }

    @Override
    public void doAction() throws Exception {
        logger.info((Object)"Alerting on sla failure.");
        Map<String, Object> alert = this.slaOption.getInfo();
        if (alert.containsKey("SlaAlertType")) {
            String alertType = (String)alert.get("SlaAlertType");
            ExecutorManager.Alerter alerter = alerters.get(alertType);
            if (alerter != null) {
                try {
                    alerter.alertOnSla(this.slaOption, this.createSlaMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error((Object)("Failed to alert by " + alertType));
                }
            } else {
                logger.error((Object)("Alerter type " + alertType + " doesn't exist. Failed to alert."));
            }
        }
    }

    private String createSlaMessage() {
        ExecutableFlow flow = null;
        try {
            flow = executorManager.getExecutableFlow(this.execId);
        }
        catch (ExecutorManagerException e) {
            e.printStackTrace();
            logger.error((Object)"Failed to get executable flow.");
        }
        String type = this.slaOption.getType();
        if (type.equals("FlowFinish")) {
            String flowName = (String)this.slaOption.getInfo().get("FlowName");
            String duration = (String)this.slaOption.getInfo().get("Duration");
            String basicinfo = "SLA Alert: Your flow " + flowName + " failed to FINISH within " + duration + "</br>";
            String expected = "Here is details : </br>Flow " + flowName + " in execution " + this.execId + " is expected to FINISH within " + duration + " from " + flow.getStartTime() + "</br>";
            String actual = "Actual flow status is " + (Object)((Object)flow.getStatus());
            return basicinfo + expected + actual;
        }
        if (type.equals("FlowSucceed")) {
            String flowName = (String)this.slaOption.getInfo().get("FlowName");
            String duration = (String)this.slaOption.getInfo().get("Duration");
            String basicinfo = "SLA Alert: Your flow " + flowName + " failed to SUCCEED within " + duration + "</br>";
            String expected = "Here is details : </br>Flow " + flowName + " in execution " + this.execId + " expected to FINISH within " + duration + " from " + flow.getStartTime() + "</br>";
            String actual = "Actual flow status is " + (Object)((Object)flow.getStatus());
            return basicinfo + expected + actual;
        }
        if (type.equals("JobFinish")) {
            String jobName = (String)this.slaOption.getInfo().get("JobName");
            String duration = (String)this.slaOption.getInfo().get("Duration");
            return "SLA Alert: Your job " + jobName + " failed to FINISH within " + duration + " in execution " + this.execId;
        }
        if (type.equals("JobSucceed")) {
            String jobName = (String)this.slaOption.getInfo().get("JobName");
            String duration = (String)this.slaOption.getInfo().get("Duration");
            return "SLA Alert: Your job " + jobName + " failed to SUCCEED within " + duration + " in execution " + this.execId;
        }
        return "Unrecognized SLA type " + type;
    }

    @Override
    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    @Override
    public String getDescription() {
        return "AlertAction with " + this.slaOption.toString();
    }
}

