/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import voldemort.serialization.SerializationException;
import voldemort.utils.ByteUtils;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VoldemortOperation {
    private final byte opCode;
    private final String key;
    private final byte[] value;
    private final VectorClock version;

    private VoldemortOperation(byte opCode, String key, byte[] value, VectorClock version) {
        this.opCode = opCode;
        this.key = key;
        this.value = value;
        this.version = version;
    }

    public VoldemortOperation(byte[] bytes) {
        if (bytes == null || bytes.length <= 1) {
            throw new SerializationException("Not enough bytes to serialize");
        }
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            this.opCode = inputStream.readByte();
            switch (this.opCode) {
                case 1: {
                    this.version = null;
                    this.key = inputStream.readUTF();
                    this.value = null;
                    break;
                }
                case 2: {
                    this.version = new VectorClock(bytes, 1);
                    this.key = inputStream.readUTF();
                    int valueSize = inputStream.readInt();
                    this.value = new byte[valueSize];
                    ByteUtils.read(inputStream, this.value);
                    break;
                }
                case 3: {
                    this.version = new VectorClock(bytes, 1);
                    this.key = inputStream.readUTF();
                    this.value = null;
                    break;
                }
                default: {
                    throw new SerializationException("Unknown opcode: " + bytes[0]);
                }
            }
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    public byte[] getBytes() {
        try {
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteOutput);
            output.writeByte(this.opCode);
            if (this.opCode != 1) {
                output.write(this.version.toBytes());
            }
            output.writeUTF(this.key);
            if (this.opCode == 2) {
                output.writeInt(this.value.length);
                output.write(this.value);
            }
            return byteOutput.toByteArray();
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    public VoldemortOperation makeGetOperation(String key) {
        return new VoldemortOperation(1, key, null, null);
    }

    public VoldemortOperation makePutOperation(String key, Versioned<byte[]> versioned) {
        return new VoldemortOperation(2, key, versioned.getValue(), (VectorClock)versioned.getVersion());
    }

    public VoldemortOperation makeDeleteOperation(String key, Version version) {
        return new VoldemortOperation(3, key, null, (VectorClock)version);
    }
}

