/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.gossip;

import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.store.metadata.MetadataStore;
import voldemort.versioning.Versioned;

public class Gossiper
implements Runnable {
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final Random random = new Random();
    private final MetadataStore metadataStore;
    private final AdminClient adminClient;
    private final int gossipInterval;
    private static final Logger logger = Logger.getLogger(Gossiper.class);

    public Gossiper(MetadataStore metadataStore, AdminClient adminClient, int gossipInterval) {
        this.metadataStore = metadataStore;
        this.gossipInterval = gossipInterval;
        this.adminClient = adminClient;
    }

    public void start() {
        logger.info((Object)"Gossip started");
        this.running.set(true);
    }

    public void stop() {
        logger.info((Object)"Gossip stopped");
        this.running.set(false);
    }

    public void run() {
        while (this.running.get()) {
            try {
                Thread.sleep(this.gossipInterval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            Node node = this.selectPeer();
            this.adminClient.setAdminClientCluster(this.metadataStore.getCluster());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Starting gossip with " + node));
            }
            for (String key : MetadataStore.GOSSIP_KEYS) {
                try {
                    this.gossipKey(node, key);
                }
                catch (VoldemortException e) {
                    logger.warn((Object)("Unable to Gossip key " + key + " with " + node), (Throwable)e);
                }
            }
        }
    }

    protected Node selectPeer() {
        Node node;
        Cluster cluster = this.metadataStore.getCluster();
        int nodes = cluster.getNumberOfNodes();
        while ((node = cluster.getNodeById(this.random.nextInt(nodes))).getId() == this.metadataStore.getNodeId()) {
        }
        return node;
    }

    protected void gossipKey(Node node, String key) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Gossiping key " + key));
        }
        Versioned<String> remoteVersioned = this.adminClient.getRemoteMetadata(node.getId(), key);
        Versioned<String> localVersioned = this.adminClient.getRemoteMetadata(this.metadataStore.getNodeId(), key);
        switch (remoteVersioned.getVersion().compare(localVersioned.getVersion())) {
            case AFTER: {
                logger.info((Object)("Updating key " + key + " from " + node));
                this.adminClient.updateRemoteMetadata(this.metadataStore.getNodeId(), key, remoteVersioned);
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Updated key " + key + ": " + remoteVersioned));
                break;
            }
            case BEFORE: {
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Remote(" + remoteVersioned + ") came before, allowing them to initiate Gossip"));
                break;
            }
            case CONCURRENTLY: {
                logger.error((Object)(key + " is concurrent between local node(" + localVersioned + ") and remote at " + node + "(" + remoteVersioned + ")"));
            }
        }
    }
}

