/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.scheduler;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.server.storage.ScanPermitWrapper;
import voldemort.store.StorageEngine;
import voldemort.utils.ClosableIterator;
import voldemort.utils.EventThrottler;
import voldemort.utils.Pair;
import voldemort.utils.Time;
import voldemort.utils.Utils;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataCleanupJob<K, V, T>
implements Runnable {
    private static final Logger logger = Logger.getLogger(DataCleanupJob.class);
    private final StorageEngine<K, V, T> store;
    private final ScanPermitWrapper cleanupPermits;
    private final long maxAgeMs;
    private final Time time;
    private final EventThrottler throttler;
    private long totalEntriesScanned = 0L;
    private AtomicLong progressThisRun;

    public DataCleanupJob(StorageEngine<K, V, T> store, ScanPermitWrapper cleanupPermits, long maxAgeMs, Time time, EventThrottler throttler) {
        this.store = Utils.notNull(store);
        this.cleanupPermits = Utils.notNull(cleanupPermits);
        this.maxAgeMs = maxAgeMs;
        this.time = time;
        this.throttler = throttler;
        this.progressThisRun = new AtomicLong(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        ClosableIterator<Pair<K, Versioned<V>>> iterator;
        block15: {
            block14: {
                this.acquireCleanupPermit(this.progressThisRun);
                iterator = null;
                try {
                    try {
                        logger.info((Object)("Starting data cleanup on store \"" + this.store.getName() + "\"..."));
                        int deleted = 0;
                        long now = this.time.getMilliseconds();
                        iterator = this.store.entries();
                        while (iterator.hasNext()) {
                            if (Thread.currentThread().isInterrupted()) {
                                logger.info((Object)"Datacleanup job halted.");
                                Object var8_7 = null;
                                this.closeIterator(iterator);
                                break block14;
                            }
                            this.progressThisRun.incrementAndGet();
                            Pair keyAndVal = (Pair)iterator.next();
                            VectorClock clock = (VectorClock)((Versioned)keyAndVal.getSecond()).getVersion();
                            if (now - clock.getTimestamp() > this.maxAgeMs) {
                                this.store.delete(keyAndVal.getFirst(), clock);
                                if (++deleted % 10000 == 0) {
                                    logger.debug((Object)("Deleted item " + deleted));
                                }
                            }
                            this.throttler.maybeThrottle(1);
                        }
                        logger.info((Object)("Data cleanup on store \"" + this.store.getName() + "\" is complete; " + deleted + " items deleted. " + this.progressThisRun.get() + " items scanned"));
                        break block15;
                    }
                    catch (Exception e) {
                        logger.error((Object)("Error in data cleanup job for store " + this.store.getName() + ": "), (Throwable)e);
                        Object var8_9 = null;
                        this.closeIterator(iterator);
                        logger.info((Object)("Releasing lock  after data cleanup on \"" + this.store.getName() + "\"."));
                        this.cleanupPermits.release();
                        DataCleanupJob dataCleanupJob = this;
                        synchronized (dataCleanupJob) {
                            this.totalEntriesScanned += this.progressThisRun.get();
                            this.progressThisRun.set(0L);
                            return;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    this.closeIterator(iterator);
                    logger.info((Object)("Releasing lock  after data cleanup on \"" + this.store.getName() + "\"."));
                    this.cleanupPermits.release();
                    DataCleanupJob dataCleanupJob = this;
                    synchronized (dataCleanupJob) {
                        this.totalEntriesScanned += this.progressThisRun.get();
                        this.progressThisRun.set(0L);
                        throw throwable;
                    }
                }
            }
            logger.info((Object)("Releasing lock  after data cleanup on \"" + this.store.getName() + "\"."));
            this.cleanupPermits.release();
            DataCleanupJob dataCleanupJob = this;
            synchronized (dataCleanupJob) {
                this.totalEntriesScanned += this.progressThisRun.get();
                this.progressThisRun.set(0L);
                return;
            }
        }
        Object var8_8 = null;
        this.closeIterator(iterator);
        logger.info((Object)("Releasing lock  after data cleanup on \"" + this.store.getName() + "\"."));
        this.cleanupPermits.release();
        DataCleanupJob dataCleanupJob = this;
        synchronized (dataCleanupJob) {
            this.totalEntriesScanned += this.progressThisRun.get();
            this.progressThisRun.set(0L);
            return;
        }
    }

    private void closeIterator(ClosableIterator<Pair<K, Versioned<V>>> iterator) {
        try {
            if (iterator != null) {
                iterator.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error in closing iterator " + this.store.getName() + " "), (Throwable)e);
        }
    }

    private void acquireCleanupPermit(AtomicLong progress) {
        logger.info((Object)("Acquiring lock to perform data cleanup on \"" + this.store.getName() + "\"."));
        try {
            this.cleanupPermits.acquire(progress);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Datacleanup interrupted while waiting for cleanup permit.", e);
        }
    }

    @JmxGetter(name="numEntriesScanned", description="Returns number of entries scanned")
    public synchronized long getEntriesScanned() {
        return this.totalEntriesScanned + this.progressThisRun.get();
    }
}

