/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.bdb;

import com.sleepycat.je.LockMode;
import voldemort.server.VoldemortConfig;

public class BdbRuntimeConfig {
    public static final long DEFAULT_STATS_CACHE_TTL_MS = 5000L;
    public static final LockMode DEFAULT_LOCK_MODE = LockMode.READ_UNCOMMITTED;
    public static final boolean DEFAULT_EXPOSE_SPACE_UTIL = true;
    private long statsCacheTtlMs = 5000L;
    private LockMode lockMode = DEFAULT_LOCK_MODE;
    private boolean exposeSpaceUtil = true;

    public BdbRuntimeConfig() {
    }

    public BdbRuntimeConfig(VoldemortConfig config) {
        LockMode lockMode = config.getBdbReadUncommitted() ? LockMode.READ_UNCOMMITTED : LockMode.DEFAULT;
        this.setLockMode(lockMode);
        this.setStatsCacheTtlMs(config.getBdbStatsCacheTtlMs());
        this.setExposeSpaceUtil(config.getBdbExposeSpaceUtilization());
    }

    public long getStatsCacheTtlMs() {
        return this.statsCacheTtlMs;
    }

    public BdbRuntimeConfig setStatsCacheTtlMs(long statsCacheTtlMs) {
        this.statsCacheTtlMs = statsCacheTtlMs;
        return this;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public BdbRuntimeConfig setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    public void setExposeSpaceUtil(boolean expose) {
        this.exposeSpaceUtil = expose;
    }

    public boolean getExposeSpaceUtil() {
        return this.exposeSpaceUtil;
    }
}

