/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.slop;

import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.cluster.Cluster;
import voldemort.serialization.ByteArraySerializer;
import voldemort.serialization.IdentitySerializer;
import voldemort.serialization.SlopSerializer;
import voldemort.store.StorageEngine;
import voldemort.store.StoreCapabilityType;
import voldemort.store.serialized.SerializingStorageEngine;
import voldemort.store.slop.Slop;
import voldemort.store.stats.SlopStats;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlopStorageEngine
implements StorageEngine<ByteArray, byte[], byte[]> {
    public static final String SLOP_STORE_NAME = "slop";
    private final StorageEngine<ByteArray, byte[], byte[]> slopEngine;
    private final SlopSerializer slopSerializer;
    private final SlopStats slopStats;

    public SlopStorageEngine(StorageEngine<ByteArray, byte[], byte[]> slopEngine, Cluster cluster) {
        this.slopEngine = slopEngine;
        this.slopSerializer = new SlopSerializer();
        this.slopStats = new SlopStats(cluster);
    }

    @JmxGetter(name="outstandingTotal", description="slops outstanding since last push")
    public long getOutstandingTotal() {
        return this.slopStats.getTotalCount(SlopStats.Tracked.OUTSTANDING);
    }

    @JmxGetter(name="outstandingByNode", description="slops outstanding by node since last push")
    public Map<Integer, Long> getOutstandingByNode() {
        return this.slopStats.asMap(SlopStats.Tracked.OUTSTANDING);
    }

    @JmxGetter(name="outstandingByZone", description="slops outstanding by zone since last push")
    public Map<Integer, Long> getOutstandingByZone() {
        return this.slopStats.byZone(SlopStats.Tracked.OUTSTANDING);
    }

    public void resetStats(Map<Integer, Long> newValues) {
        this.slopStats.setAll(SlopStats.Tracked.OUTSTANDING, newValues);
    }

    public StorageEngine<ByteArray, Slop, byte[]> asSlopStore() {
        return SerializingStorageEngine.wrap(this, new ByteArraySerializer(), this.slopSerializer, new IdentitySerializer());
    }

    @Override
    public ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> entries() {
        return this.slopEngine.entries();
    }

    @Override
    public ClosableIterator<ByteArray> keys() {
        return this.slopEngine.keys();
    }

    @Override
    public void truncate() {
        this.slopEngine.truncate();
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key, byte[] transforms) throws VoldemortException {
        return this.slopEngine.get(key, transforms);
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms) throws VoldemortException {
        return this.slopEngine.getAll(keys, transforms);
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> value, byte[] transforms) throws VoldemortException {
        this.slopEngine.put(key, value, transforms);
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        return this.slopEngine.delete(key, version);
    }

    @Override
    public String getName() {
        return this.slopEngine.getName();
    }

    @Override
    public void close() throws VoldemortException {
        this.slopEngine.close();
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        return this.slopEngine.getCapability(capability);
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        return this.slopEngine.getVersions(key);
    }

    @Override
    public boolean isPartitionAware() {
        return this.slopEngine.isPartitionAware();
    }
}

