/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.socket.clientrequest;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import voldemort.VoldemortException;
import voldemort.store.StoreTimeoutException;
import voldemort.store.UnreachableStoreException;
import voldemort.store.socket.clientrequest.ClientRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClientRequest<T>
implements ClientRequest<T> {
    private T result;
    private Exception error;
    private volatile boolean isComplete = false;
    private volatile boolean isParsed = false;
    private volatile boolean isTimedOut = false;

    protected abstract void formatRequestInternal(DataOutputStream var1) throws IOException;

    protected abstract T parseResponseInternal(DataInputStream var1) throws IOException;

    @Override
    public boolean formatRequest(DataOutputStream outputStream) {
        try {
            this.formatRequestInternal(outputStream);
        }
        catch (IOException e) {
            this.error = e;
            return false;
        }
        catch (VoldemortException e) {
            this.error = e;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseResponse(DataInputStream inputStream) {
        block5: {
            try {
                try {
                    this.result = this.parseResponseInternal(inputStream);
                }
                catch (IOException e) {
                    this.error = e;
                    Object var4_3 = null;
                    this.isParsed = true;
                    break block5;
                }
                catch (VoldemortException e) {
                    this.error = e;
                    Object var4_4 = null;
                    this.isParsed = true;
                }
                Object var4_2 = null;
                this.isParsed = true;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.isParsed = true;
                throw throwable;
            }
        }
    }

    @Override
    public T getResult() throws VoldemortException, IOException {
        if (this.isTimedOut) {
            throw new StoreTimeoutException("Request timed out");
        }
        if (!this.isComplete) {
            throw new IllegalStateException("Client response not complete, cannot determine result");
        }
        if (!this.isParsed) {
            throw new UnreachableStoreException("Client response not read/parsed, cannot determine result");
        }
        if (this.error instanceof IOException) {
            throw (IOException)this.error;
        }
        if (this.error instanceof VoldemortException) {
            throw (VoldemortException)this.error;
        }
        return this.result;
    }

    @Override
    public final void complete() {
        this.isComplete = true;
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public final void timeOut() {
        this.isTimedOut = true;
    }

    @Override
    public boolean isTimedOut() {
        return this.isTimedOut;
    }
}

