/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.rebalance.task;

import com.google.common.collect.Lists;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.rebalance.RebalanceClientConfig;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.client.rebalance.task.RebalanceTask;
import voldemort.server.rebalance.AlreadyRebalancingException;
import voldemort.store.UnreachableStoreException;
import voldemort.store.metadata.MetadataStore;
import voldemort.utils.RebalanceUtils;

public class StealerBasedRebalanceTask
extends RebalanceTask {
    private static final Logger logger = Logger.getLogger(StealerBasedRebalanceTask.class);
    private final int stealerNodeId;

    public StealerBasedRebalanceTask(int taskId, RebalancePartitionsInfo stealInfo, RebalanceClientConfig config, Semaphore donorPermit, AdminClient adminClient) {
        super(taskId, Lists.newArrayList((Object[])new RebalancePartitionsInfo[]{stealInfo}), config, donorPermit, adminClient);
        this.stealerNodeId = stealInfo.getStealerId();
    }

    private int startNodeRebalancing() {
        AlreadyRebalancingException rebalanceException = null;
        for (int nTries = 0; nTries < this.config.getMaxTriesRebalancing(); ++nTries) {
            try {
                RebalanceUtils.printLog(this.taskId, logger, "Starting on node " + this.stealerNodeId + " rebalancing task " + this.stealInfos.get(0));
                int asyncOperationId = this.adminClient.rebalanceNode((RebalancePartitionsInfo)this.stealInfos.get(0));
                return asyncOperationId;
            }
            catch (AlreadyRebalancingException e) {
                RebalanceUtils.printLog(this.taskId, logger, "Node " + this.stealerNodeId + " is currently rebalancing. Waiting till completion");
                this.adminClient.waitForCompletion(this.stealerNodeId, "server.state", MetadataStore.VoldemortState.NORMAL_SERVER.toString(), this.config.getRebalancingClientTimeoutSeconds(), TimeUnit.SECONDS);
                rebalanceException = e;
                continue;
            }
        }
        throw new VoldemortException("Failed to start rebalancing with plan: " + this.getStealInfos(), rebalanceException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block5: {
            int rebalanceAsyncId = -1;
            try {
                try {
                    RebalanceUtils.printLog(this.taskId, logger, "Acquiring donor permit for node " + ((RebalancePartitionsInfo)this.stealInfos.get(0)).getDonorId() + " for " + this.stealInfos);
                    this.donorPermit.acquire();
                    rebalanceAsyncId = this.startNodeRebalancing();
                    this.adminClient.waitForCompletion(this.stealerNodeId, rebalanceAsyncId, this.config.getRebalancingClientTimeoutSeconds(), TimeUnit.SECONDS);
                    RebalanceUtils.printLog(this.taskId, logger, "Succesfully finished rebalance for async operation id " + rebalanceAsyncId);
                }
                catch (UnreachableStoreException e) {
                    this.exception = e;
                    logger.error((Object)("Stealer node " + this.stealerNodeId + " is unreachable, please make sure it is up and running : " + e.getMessage()), (Throwable)e);
                    Object var4_3 = null;
                    this.donorPermit.release();
                    this.isComplete.set(true);
                    break block5;
                }
                catch (Exception e) {
                    this.exception = e;
                    logger.error((Object)("Rebalance failed : " + e.getMessage()), (Throwable)e);
                    Object var4_4 = null;
                    this.donorPermit.release();
                    this.isComplete.set(true);
                }
                Object var4_2 = null;
                this.donorPermit.release();
                this.isComplete.set(true);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.donorPermit.release();
                this.isComplete.set(true);
                throw throwable;
            }
        }
    }

    public String toString() {
        return "Stealer based rebalance task on stealer node " + this.stealerNodeId + " : " + this.getStealInfos();
    }
}

