/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import voldemort.serialization.SerializationException;
import voldemort.serialization.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectSerializer<T>
implements Serializer<T> {
    @Override
    public byte[] toBytes(T object) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(stream);
            out.writeObject(object);
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public T toObject(byte[] bytes) {
        try {
            return (T)new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        catch (ClassNotFoundException c) {
            throw new SerializationException(c);
        }
    }
}

