/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.niosocket;

import java.net.InetSocketAddress;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import voldemort.server.niosocket.AsyncRequestHandler;
import voldemort.server.protocol.RequestHandlerFactory;
import voldemort.utils.SelectorManager;

public class NioSelectorManager
extends SelectorManager {
    private final InetSocketAddress endpoint;
    private final Queue<SocketChannel> socketChannelQueue;
    private final RequestHandlerFactory requestHandlerFactory;
    private final int socketBufferSize;
    private MutableInt numActiveConnections;

    public NioSelectorManager(InetSocketAddress endpoint, RequestHandlerFactory requestHandlerFactory, int socketBufferSize) {
        this.endpoint = endpoint;
        this.socketChannelQueue = new ConcurrentLinkedQueue<SocketChannel>();
        this.requestHandlerFactory = requestHandlerFactory;
        this.socketBufferSize = socketBufferSize;
        this.numActiveConnections = new MutableInt(0);
    }

    public void accept(SocketChannel socketChannel) {
        if (this.isClosed.get()) {
            throw new IllegalStateException("Cannot accept more channels, selector manager closed");
        }
        this.socketChannelQueue.add(socketChannel);
        this.selector.wakeup();
    }

    protected void processEvents() {
        block12: {
            try {
                SocketChannel socketChannel = null;
                while ((socketChannel = this.socketChannelQueue.poll()) != null) {
                    if (this.isClosed.get()) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.debug((Object)("Closed, exiting for " + this.endpoint));
                        }
                        break;
                    }
                    try {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Registering connection from " + socketChannel.socket().getPort()));
                        }
                        socketChannel.socket().setTcpNoDelay(true);
                        socketChannel.socket().setReuseAddress(true);
                        socketChannel.socket().setSendBufferSize(this.socketBufferSize);
                        if (socketChannel.socket().getReceiveBufferSize() != this.socketBufferSize && this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Requested socket receive buffer size was " + this.socketBufferSize + " bytes but actual size is " + socketChannel.socket().getReceiveBufferSize() + " bytes."));
                        }
                        if (socketChannel.socket().getSendBufferSize() != this.socketBufferSize && this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Requested socket send buffer size was " + this.socketBufferSize + " bytes but actual size is " + socketChannel.socket().getSendBufferSize() + " bytes."));
                        }
                        socketChannel.configureBlocking(false);
                        AsyncRequestHandler attachment = new AsyncRequestHandler(this.selector, socketChannel, this.requestHandlerFactory, this.socketBufferSize, this.numActiveConnections);
                        if (this.isClosed.get()) continue;
                        socketChannel.register(this.selector, 1, attachment);
                        this.numActiveConnections.increment();
                    }
                    catch (ClosedSelectorException e) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"Selector is closed, exiting");
                        }
                        this.close();
                        break;
                    }
                    catch (Exception e) {
                        if (!this.logger.isEnabledFor((Priority)Level.ERROR)) continue;
                        this.logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!this.logger.isEnabledFor((Priority)Level.ERROR)) break block12;
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public Integer getNumActiveConnections() {
        return this.numActiveConnections.toInteger();
    }

    public Integer getNumQueuedConnections() {
        return this.socketChannelQueue.size();
    }
}

