/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.bdb.stats;

import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.dbi.EnvironmentImpl;
import java.util.Map;
import java.util.SortedMap;
import voldemort.store.bdb.stats.BdbEnvironmentStats;

public final class SpaceUtilizationStats {
    private final EnvironmentImpl envImpl;
    private SortedMap<Long, FileSummary> summaryMap;
    private long totalSpaceUsed = 0L;
    private long totalSpaceUtilized = 0L;

    public SpaceUtilizationStats(Environment env) {
        this(DbInternal.getEnvironmentImpl((Environment)env));
    }

    private SpaceUtilizationStats(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        UtilizationProfile profile = this.envImpl.getUtilizationProfile();
        this.summaryMap = profile.getFileSummaryMap(true);
        for (Map.Entry<Long, FileSummary> entry : this.summaryMap.entrySet()) {
            FileSummary fs = entry.getValue();
            this.totalSpaceUsed += (long)fs.totalSize;
            this.totalSpaceUtilized += (long)(fs.totalSize - fs.getObsoleteSize());
        }
    }

    public long getTotalSpaceUsed() {
        return this.totalSpaceUsed;
    }

    public long getTotalSpaceUtilized() {
        return this.totalSpaceUtilized;
    }

    public String getSummariesAsString() {
        StringBuffer summaryDetails = new StringBuffer();
        if (this.summaryMap != null) {
            summaryDetails.append("file,util%\n");
            for (Map.Entry<Long, FileSummary> entry : this.summaryMap.entrySet()) {
                FileSummary fs = entry.getValue();
                long bytesUsed = fs.totalSize - fs.getObsoleteSize();
                summaryDetails.append(String.format("%s,%f\n", Long.toHexString(entry.getKey()), BdbEnvironmentStats.safeGetPercentage(bytesUsed, fs.totalSize)));
            }
            summaryDetails.append(String.format("total,%f\n", BdbEnvironmentStats.safeGetPercentage(this.totalSpaceUtilized, this.totalSpaceUsed)));
        }
        return summaryDetails.toString();
    }
}

