/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly;

import com.google.common.base.Joiner;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Maps;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.routing.RoutingStrategy;
import voldemort.routing.RoutingStrategyFactory;
import voldemort.serialization.DefaultSerializerFactory;
import voldemort.serialization.Serializer;
import voldemort.serialization.SerializerDefinition;
import voldemort.serialization.json.EndOfFileException;
import voldemort.serialization.json.JsonReader;
import voldemort.store.StoreDefinition;
import voldemort.store.compress.CompressionStrategy;
import voldemort.store.compress.CompressionStrategyFactory;
import voldemort.store.readonly.ExternalSorter;
import voldemort.store.readonly.ReadOnlyStorageFormat;
import voldemort.store.readonly.ReadOnlyStorageMetadata;
import voldemort.store.readonly.ReadOnlyUtils;
import voldemort.utils.ByteUtils;
import voldemort.utils.CmdUtils;
import voldemort.utils.Pair;
import voldemort.utils.RebalanceUtils;
import voldemort.utils.Utils;
import voldemort.xml.ClusterMapper;
import voldemort.xml.StoreDefinitionsMapper;

public class JsonStoreBuilder {
    private static final Logger logger = Logger.getLogger(JsonStoreBuilder.class);
    private final JsonReader reader;
    private final Cluster cluster;
    private final StoreDefinition storeDefinition;
    private final RoutingStrategy routingStrategy;
    private final File outputDir;
    private final File tempDir;
    private final int internalSortSize;
    private final int numThreads;
    private final int numChunks;
    private final int ioBufferSize;
    private final boolean gzipIntermediate;

    public JsonStoreBuilder(JsonReader reader, Cluster cluster, StoreDefinition storeDefinition, RoutingStrategy routingStrategy, File outputDir, File tempDir, int internalSortSize, int numThreads, int numChunks, int ioBufferSize, boolean gzipIntermediate) {
        if (cluster.getNumberOfNodes() < storeDefinition.getReplicationFactor()) {
            throw new IllegalStateException("Number of nodes is " + cluster.getNumberOfNodes() + " but the replication factor is " + storeDefinition.getReplicationFactor() + ".");
        }
        this.reader = reader;
        this.cluster = cluster;
        this.storeDefinition = storeDefinition;
        this.tempDir = tempDir == null ? new File(Utils.notNull(System.getProperty("java.io.tmpdir"))) : tempDir;
        this.outputDir = outputDir;
        this.routingStrategy = routingStrategy;
        this.internalSortSize = internalSortSize;
        this.numThreads = numThreads;
        this.numChunks = numChunks;
        this.ioBufferSize = ioBufferSize;
        this.gzipIntermediate = gzipIntermediate;
    }

    public static void main(String[] args) throws IOException {
        Set<String> missing;
        OptionParser parser = new OptionParser();
        parser.accepts("help", "print usage information");
        parser.accepts("cluster", "[REQUIRED] path to cluster xml config file").withRequiredArg().describedAs("cluster.xml");
        parser.accepts("stores", "[REQUIRED] path to stores xml config file").withRequiredArg().describedAs("stores.xml");
        parser.accepts("name", "[REQUIRED] store name").withRequiredArg().describedAs("store name");
        parser.accepts("buffer", "[REQUIRED] number of key/value pairs to buffer in memory").withRequiredArg().ofType(Integer.class);
        parser.accepts("input", "[REQUIRED] input file to read from").withRequiredArg().describedAs("input-file");
        parser.accepts("output", "[REQUIRED] directory to output stores to").withRequiredArg().describedAs("output directory");
        parser.accepts("threads", "number of threads").withRequiredArg().ofType(Integer.class);
        parser.accepts("chunks", "number of chunks [per node, per partition, per partition + replica]").withRequiredArg().ofType(Integer.class);
        parser.accepts("io-buffer-size", "size of i/o buffers in bytes").withRequiredArg().ofType(Integer.class);
        parser.accepts("temp-dir", "temporary directory for sorted file pieces").withRequiredArg().describedAs("temp dir");
        parser.accepts("gzip", "compress intermediate chunk files");
        parser.accepts("format", "read-only store format [" + ReadOnlyStorageFormat.READONLY_V0.getCode() + "," + ReadOnlyStorageFormat.READONLY_V1.getCode() + "," + ReadOnlyStorageFormat.READONLY_V2.getCode() + "]").withRequiredArg().ofType(String.class);
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        if ((missing = CmdUtils.missing(options, "cluster", "stores", "name", "buffer", "input", "output")).size() > 0) {
            System.err.println("Missing required arguments: " + Joiner.on((String)", ").join(missing));
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        String clusterFile = (String)options.valueOf("cluster");
        String storeDefFile = (String)options.valueOf("stores");
        String storeName = (String)options.valueOf("name");
        int sortBufferSize = (Integer)options.valueOf("buffer");
        String inputFile = (String)options.valueOf("input");
        File outputDir = new File((String)options.valueOf("output"));
        int numThreads = CmdUtils.valueOf(options, "threads", Integer.valueOf(2));
        int chunks = CmdUtils.valueOf(options, "chunks", Integer.valueOf(2));
        int ioBufferSize = CmdUtils.valueOf(options, "io-buffer-size", Integer.valueOf(1000000));
        ReadOnlyStorageFormat storageFormat = ReadOnlyStorageFormat.fromCode(CmdUtils.valueOf(options, "format", ReadOnlyStorageFormat.READONLY_V2.getCode()));
        boolean gzipIntermediate = options.has("gzip");
        File tempDir = new File(CmdUtils.valueOf(options, "temp-dir", System.getProperty("java.io.tmpdir")));
        try {
            JsonReader reader = new JsonReader(new BufferedReader(new FileReader(inputFile), ioBufferSize));
            Cluster cluster = new ClusterMapper().readCluster(new BufferedReader(new FileReader(clusterFile)));
            StoreDefinition storeDef = null;
            List<StoreDefinition> stores = new StoreDefinitionsMapper().readStoreList(new BufferedReader(new FileReader(storeDefFile)));
            for (StoreDefinition def : stores) {
                if (!def.getName().equals(storeName)) continue;
                storeDef = def;
            }
            if (storeDef == null) {
                Utils.croak("No store found with name \"" + storeName + "\"");
            }
            if (!outputDir.exists()) {
                Utils.croak("Directory \"" + outputDir.getAbsolutePath() + "\" does not exist.");
            }
            RoutingStrategy routingStrategy = new RoutingStrategyFactory().updateRoutingStrategy(storeDef, cluster);
            new JsonStoreBuilder(reader, cluster, storeDef, routingStrategy, outputDir, tempDir, sortBufferSize, numThreads, chunks, ioBufferSize, gzipIntermediate).build(storageFormat);
        }
        catch (FileNotFoundException e) {
            Utils.croak(e.getMessage());
        }
    }

    public void build(ReadOnlyStorageFormat type) throws IOException {
        switch (type) {
            case READONLY_V0: {
                this.buildVersion0();
                break;
            }
            case READONLY_V1: {
                this.buildVersion1();
                break;
            }
            case READONLY_V2: {
                this.buildVersion2();
                break;
            }
            default: {
                throw new VoldemortException("Invalid storage format " + (Object)((Object)type));
            }
        }
    }

    public void buildVersion0() throws IOException {
        logger.info((Object)("Building store " + this.storeDefinition.getName() + " for " + this.cluster.getNumberOfNodes() + " with " + this.numChunks + " chunks per node and type " + (Object)((Object)ReadOnlyStorageFormat.READONLY_V0)));
        int numNodes = this.cluster.getNumberOfNodes();
        DataOutputStream[][] indexes = new DataOutputStream[numNodes][this.numChunks];
        DataOutputStream[][] datas = new DataOutputStream[numNodes][this.numChunks];
        int[][] positions = new int[numNodes][this.numChunks];
        for (Node node : this.cluster.getNodes()) {
            int nodeId = node.getId();
            File nodeDir = new File(this.outputDir, "node-" + Integer.toString(nodeId));
            nodeDir.mkdirs();
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(nodeDir, ".metadata")));
            ReadOnlyStorageMetadata metadata = new ReadOnlyStorageMetadata();
            metadata.add("format", ReadOnlyStorageFormat.READONLY_V0.getCode());
            writer.write(metadata.toJsonString());
            writer.close();
            for (int chunk = 0; chunk < this.numChunks; ++chunk) {
                File indexFile = new File(nodeDir, chunk + ".index");
                File dataFile = new File(nodeDir, chunk + ".data");
                positions[nodeId][chunk] = 0;
                indexes[nodeId][chunk] = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile), this.ioBufferSize));
                datas[nodeId][chunk] = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(dataFile), this.ioBufferSize));
            }
        }
        logger.info((Object)"Reading items...");
        int count = 0;
        ExternalSorter<KeyValuePair> sorter = new ExternalSorter<KeyValuePair>(new KeyValuePairSerializer(), new KeyMd5Comparator(), this.internalSortSize, this.tempDir.getAbsolutePath(), this.ioBufferSize, this.numThreads, this.gzipIntermediate);
        JsonObjectIterator iter = new JsonObjectIterator(this.reader, this.storeDefinition);
        for (KeyValuePair pair : sorter.sorted((Iterator<KeyValuePair>)((Object)iter))) {
            List<Node> nodes = this.routingStrategy.routeRequest(pair.getKey());
            byte[] keyMd5 = pair.getKeyMd5();
            for (int i = 0; i < this.storeDefinition.getReplicationFactor(); ++i) {
                int nodeId = nodes.get(i).getId();
                int chunk = ReadOnlyUtils.chunk(keyMd5, this.numChunks);
                int numBytes = pair.getValue().length;
                datas[nodeId][chunk].writeInt(numBytes);
                datas[nodeId][chunk].write(pair.getValue());
                indexes[nodeId][chunk].write(keyMd5);
                indexes[nodeId][chunk].writeInt(positions[nodeId][chunk]);
                int[] nArray = positions[nodeId];
                int n = chunk;
                nArray[n] = nArray[n] + (numBytes + 4);
                this.checkOverFlow(chunk, positions[nodeId][chunk]);
            }
            ++count;
        }
        logger.info((Object)(count + " items read."));
        logger.info((Object)"Closing all store files.");
        for (int node = 0; node < numNodes; ++node) {
            for (int chunk = 0; chunk < this.numChunks; ++chunk) {
                indexes[node][chunk].close();
                datas[node][chunk].close();
            }
        }
    }

    public void buildVersion1() throws IOException {
        logger.info((Object)("Building store " + this.storeDefinition.getName() + " for " + this.cluster.getNumberOfPartitions() + " partitions with " + this.numChunks + " chunks per partitions and type " + (Object)((Object)ReadOnlyStorageFormat.READONLY_V1)));
        int numNodes = this.cluster.getNumberOfNodes();
        DataOutputStream[][] indexes = new DataOutputStream[numNodes][];
        DataOutputStream[][] datas = new DataOutputStream[numNodes][];
        int[][] positions = new int[numNodes][];
        int[] partitionIdToChunkOffset = new int[this.cluster.getNumberOfPartitions()];
        int[] partitionIdToNodeId = new int[this.cluster.getNumberOfPartitions()];
        for (Node node : this.cluster.getNodes()) {
            int nodeId = node.getId();
            indexes[nodeId] = new DataOutputStream[node.getNumberOfPartitions() * this.numChunks];
            datas[nodeId] = new DataOutputStream[node.getNumberOfPartitions() * this.numChunks];
            positions[nodeId] = new int[node.getNumberOfPartitions() * this.numChunks];
            File nodeDir = new File(this.outputDir, "node-" + Integer.toString(nodeId));
            nodeDir.mkdirs();
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(nodeDir, ".metadata")));
            ReadOnlyStorageMetadata metadata = new ReadOnlyStorageMetadata();
            metadata.add("format", ReadOnlyStorageFormat.READONLY_V1.getCode());
            writer.write(metadata.toJsonString());
            writer.close();
            int globalChunk = 0;
            for (Integer partition : node.getPartitionIds()) {
                partitionIdToChunkOffset[partition.intValue()] = globalChunk;
                partitionIdToNodeId[partition.intValue()] = node.getId();
                for (int chunk = 0; chunk < this.numChunks; ++chunk) {
                    File indexFile = new File(nodeDir, Integer.toString(partition) + "_" + Integer.toString(chunk) + ".index");
                    File dataFile = new File(nodeDir, Integer.toString(partition) + "_" + Integer.toString(chunk) + ".data");
                    positions[nodeId][globalChunk] = 0;
                    indexes[nodeId][globalChunk] = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile), this.ioBufferSize));
                    datas[nodeId][globalChunk] = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(dataFile), this.ioBufferSize));
                    ++globalChunk;
                }
            }
        }
        logger.info((Object)"Reading items...");
        int count = 0;
        ExternalSorter<KeyValuePair> sorter = new ExternalSorter<KeyValuePair>(new KeyValuePairSerializer(), new KeyMd5Comparator(), this.internalSortSize, this.tempDir.getAbsolutePath(), this.ioBufferSize, this.numThreads, this.gzipIntermediate);
        JsonObjectIterator iter = new JsonObjectIterator(this.reader, this.storeDefinition);
        for (KeyValuePair pair : sorter.sorted((Iterator<KeyValuePair>)((Object)iter))) {
            byte[] keyMd5 = pair.getKeyMd5();
            List<Integer> partitionIds = this.routingStrategy.getPartitionList(pair.getKey());
            for (Integer partitionId : partitionIds) {
                int localChunkId = ReadOnlyUtils.chunk(keyMd5, this.numChunks);
                int chunk = localChunkId + partitionIdToChunkOffset[partitionId];
                int nodeId = partitionIdToNodeId[partitionId];
                datas[nodeId][chunk].writeInt(pair.getValue().length);
                datas[nodeId][chunk].write(pair.getValue());
                indexes[nodeId][chunk].write(keyMd5);
                indexes[nodeId][chunk].writeInt(positions[nodeId][chunk]);
                int[] nArray = positions[nodeId];
                int n = chunk;
                nArray[n] = nArray[n] + (pair.getValue().length + 4);
                this.checkOverFlow(chunk, positions[nodeId][chunk]);
            }
            ++count;
        }
        logger.info((Object)(count + " items read."));
        logger.info((Object)"Closing all store files.");
        for (Node node : this.cluster.getNodes()) {
            for (int chunk = 0; chunk < this.numChunks * node.getNumberOfPartitions(); ++chunk) {
                indexes[node.getId()][chunk].close();
                datas[node.getId()][chunk].close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void buildVersion2() throws IOException {
        void var10_20;
        logger.info((Object)("Building store " + this.storeDefinition.getName() + " for " + this.cluster.getNumberOfPartitions() + " partitions, " + this.storeDefinition.getReplicationFactor() + " replica types, " + this.numChunks + " chunks per partitions per replica type and type " + (Object)((Object)ReadOnlyStorageFormat.READONLY_V2)));
        DataOutputStream[][] indexes = new DataOutputStream[this.cluster.getNumberOfPartitions()][];
        DataOutputStream[][] datas = new DataOutputStream[this.cluster.getNumberOfPartitions()][];
        int[][] positions = new int[this.cluster.getNumberOfPartitions()][];
        File tempDirectory = new File(Utils.notNull(System.getProperty("java.io.tmpdir")), "tempDir-" + Integer.toString(new Random().nextInt()));
        Utils.mkdirs(tempDirectory);
        for (int partitionId = 0; partitionId < this.cluster.getNumberOfPartitions(); ++partitionId) {
            indexes[partitionId] = new DataOutputStream[this.storeDefinition.getReplicationFactor() * this.numChunks];
            datas[partitionId] = new DataOutputStream[this.storeDefinition.getReplicationFactor() * this.numChunks];
            positions[partitionId] = new int[this.storeDefinition.getReplicationFactor() * this.numChunks];
            int globalChunkId = 0;
            for (int repType = 0; repType < this.storeDefinition.getReplicationFactor(); ++repType) {
                for (int chunk = 0; chunk < this.numChunks; ++chunk) {
                    File indexFile = new File(tempDirectory, Integer.toString(partitionId) + "_" + Integer.toString(repType) + "_" + Integer.toString(chunk) + ".index");
                    File file = new File(tempDirectory, Integer.toString(partitionId) + "_" + Integer.toString(repType) + "_" + Integer.toString(chunk) + ".data");
                    positions[partitionId][globalChunkId] = 0;
                    indexes[partitionId][globalChunkId] = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile), this.ioBufferSize));
                    datas[partitionId][globalChunkId] = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file), this.ioBufferSize));
                    ++globalChunkId;
                }
            }
        }
        logger.info((Object)"Reading items...");
        ExternalSorter<KeyValuePair> sorter = new ExternalSorter<KeyValuePair>(new KeyValuePairSerializer(), new KeyMd5Comparator(), this.internalSortSize, this.tempDir.getAbsolutePath(), this.ioBufferSize, this.numThreads, this.gzipIntermediate);
        JsonObjectIterator iter = new JsonObjectIterator(this.reader, this.storeDefinition);
        int count = 0;
        HashMap previousElements = Maps.newHashMap();
        for (KeyValuePair keyValuePair : sorter.sorted((Iterator<KeyValuePair>)((Object)iter))) {
            List<Integer> partitionIds = this.routingStrategy.getPartitionList(keyValuePair.getKey());
            int masterPartition = partitionIds.get(0);
            int localChunkId = ReadOnlyUtils.chunk(keyValuePair.getKeyMd5(), this.numChunks);
            for (int replicaType = 0; replicaType < partitionIds.size(); ++replicaType) {
                int globalChunkId = replicaType * this.numChunks + localChunkId;
                Pair<Integer, Integer> key = Pair.create(masterPartition, globalChunkId);
                if (!previousElements.containsKey(key)) {
                    previousElements.put(key, Pair.create(ByteUtils.copy(keyValuePair.getKeyMd5(), 0, 8), this.generateFirstElement(keyValuePair)));
                    continue;
                }
                Pair previousElement = (Pair)previousElements.get(key);
                if (ByteUtils.compare((byte[])previousElement.getFirst(), keyValuePair.getKeyMd5(), 0, 8) == 0) {
                    short numKeys = ByteUtils.readShort((byte[])previousElement.getSecond(), 0);
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    DataOutputStream valueStream = new DataOutputStream(stream);
                    valueStream.writeShort(numKeys + 1);
                    valueStream.write(ByteUtils.copy((byte[])previousElement.getSecond(), 2, ((byte[])previousElement.getSecond()).length));
                    valueStream.writeInt(keyValuePair.getKey().length);
                    valueStream.writeInt(keyValuePair.getValue().length);
                    valueStream.write(keyValuePair.getKey());
                    valueStream.write(keyValuePair.getValue());
                    valueStream.flush();
                    previousElements.put(key, Pair.create(previousElement.getFirst(), stream.toByteArray()));
                    continue;
                }
                indexes[masterPartition][globalChunkId].write((byte[])previousElement.getFirst());
                indexes[masterPartition][globalChunkId].writeInt(positions[masterPartition][globalChunkId]);
                datas[masterPartition][globalChunkId].write((byte[])previousElement.getSecond());
                int[] nArray = positions[masterPartition];
                int n = globalChunkId;
                nArray[n] = nArray[n] + ((byte[])previousElement.getSecond()).length;
                previousElements.put(key, Pair.create(ByteUtils.copy(keyValuePair.getKeyMd5(), 0, 8), this.generateFirstElement(keyValuePair)));
            }
            ++count;
        }
        logger.info((Object)(count + " items read."));
        for (Map.Entry entry : previousElements.entrySet()) {
            int partitionId = (Integer)((Pair)entry.getKey()).getFirst();
            int globalChunkId = (Integer)((Pair)entry.getKey()).getSecond();
            byte[] keyMd5 = (byte[])((Pair)entry.getValue()).getFirst();
            byte[] value = (byte[])((Pair)entry.getValue()).getSecond();
            indexes[partitionId][globalChunkId].write(keyMd5);
            indexes[partitionId][globalChunkId].writeInt(positions[partitionId][globalChunkId]);
            datas[partitionId][globalChunkId].write(value);
        }
        File[] nodeDirs = new File[this.cluster.getNumberOfNodes()];
        for (Node node : this.cluster.getNodes()) {
            int nodeId = node.getId();
            File nodeDir = new File(this.outputDir, "node-" + Integer.toString(nodeId));
            nodeDir.mkdirs();
            nodeDirs[node.getId()] = nodeDir;
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(nodeDir, ".metadata")));
            ReadOnlyStorageMetadata metadata = new ReadOnlyStorageMetadata();
            metadata.add("format", ReadOnlyStorageFormat.READONLY_V2.getCode());
            writer.write(metadata.toJsonString());
            writer.close();
        }
        logger.info((Object)"Closing all store files.");
        boolean bl = false;
        while (var10_20 < this.cluster.getNumberOfPartitions()) {
            for (int chunk = 0; chunk < this.numChunks * this.storeDefinition.getReplicationFactor(); ++chunk) {
                indexes[var10_20][chunk].close();
                datas[var10_20][chunk].close();
            }
            ++var10_20;
        }
        RoutingStrategy routingStrategy = new RoutingStrategyFactory().updateRoutingStrategy(this.storeDefinition, this.cluster);
        Map<Integer, Integer> replicaMapping = RebalanceUtils.getCurrentPartitionMapping(this.cluster);
        for (File file : tempDirectory.listFiles()) {
            String fileName = file.getName();
            if (!fileName.matches("^[\\d]+_[\\d]+_[\\d]+\\.(data|index)")) continue;
            String[] props = fileName.split("_");
            int partitionId = Integer.parseInt(props[0]);
            int replicaType = Integer.parseInt(props[1]);
            int nodeId = replicaMapping.get(routingStrategy.getReplicatingPartitionList(partitionId).get(replicaType));
            Utils.move(file, new File(nodeDirs[nodeId], fileName));
        }
    }

    private byte[] generateFirstElement(KeyValuePair currentPair) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream valueStream = new DataOutputStream(stream);
        valueStream.writeShort(1);
        valueStream.writeInt(currentPair.getKey().length);
        valueStream.writeInt(currentPair.getValue().length);
        valueStream.write(currentPair.getKey());
        valueStream.write(currentPair.getValue());
        valueStream.flush();
        return stream.toByteArray();
    }

    private void checkOverFlow(int chunk, int position) {
        if (position < 0) {
            throw new VoldemortException("Chunk overflow: chunk " + chunk + " has exceeded " + Integer.MAX_VALUE + " bytes.");
        }
    }

    private static class KeyValuePair {
        private final byte[] key;
        private final byte[] keyMd5;
        private final byte[] value;

        public KeyValuePair(byte[] key, byte[] keyMd5, byte[] value) {
            this.key = key;
            this.keyMd5 = keyMd5;
            this.value = value;
        }

        public byte[] getKey() {
            return this.key;
        }

        public byte[] getKeyMd5() {
            return this.keyMd5;
        }

        public byte[] getValue() {
            return this.value;
        }

        public String toString() {
            return new String("Key - " + new String(this.key) + " - Value -  " + new String(this.value) + " - KeyMD5 - " + new String(this.keyMd5));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyMd5Comparator
    implements Comparator<KeyValuePair> {
        @Override
        public int compare(KeyValuePair kv1, KeyValuePair kv2) {
            return ByteUtils.compare(kv1.getKeyMd5(), kv2.getKeyMd5());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JsonObjectIterator
    extends AbstractIterator<KeyValuePair> {
        private final JsonReader reader;
        private final Serializer<Object> keySerializer;
        private final Serializer<Object> valueSerializer;
        private final MessageDigest digest;
        private final SerializerDefinition keySerializerDefinition;
        private final SerializerDefinition valueSerializerDefinition;
        private CompressionStrategy valueCompressor;
        private CompressionStrategy keyCompressor;

        public JsonObjectIterator(JsonReader reader, StoreDefinition storeDefinition) {
            DefaultSerializerFactory factory = new DefaultSerializerFactory();
            this.reader = reader;
            this.digest = ByteUtils.getDigest("MD5");
            this.keySerializerDefinition = storeDefinition.getKeySerializer();
            this.valueSerializerDefinition = storeDefinition.getValueSerializer();
            this.keySerializer = factory.getSerializer(storeDefinition.getKeySerializer());
            this.valueSerializer = factory.getSerializer(storeDefinition.getValueSerializer());
            this.keyCompressor = new CompressionStrategyFactory().get(this.keySerializerDefinition.getCompression());
            this.valueCompressor = new CompressionStrategyFactory().get(this.valueSerializerDefinition.getCompression());
        }

        protected KeyValuePair computeNext() {
            try {
                Object key = this.reader.read();
                Object value = null;
                try {
                    value = this.reader.read();
                }
                catch (EndOfFileException e) {
                    throw new VoldemortException("Invalid file: reached end of file with key but no matching value.", e);
                }
                byte[] keyBytes = this.keySerializer.toBytes(key);
                byte[] valueBytes = this.valueSerializer.toBytes(value);
                if (this.keySerializerDefinition.hasCompression()) {
                    keyBytes = this.keyCompressor.deflate(keyBytes);
                }
                if (this.valueSerializerDefinition.hasCompression()) {
                    valueBytes = this.valueCompressor.deflate(valueBytes);
                }
                byte[] keyMd5 = this.digest.digest(keyBytes);
                this.digest.reset();
                return new KeyValuePair(keyBytes, keyMd5, valueBytes);
            }
            catch (EndOfFileException e) {
                return (KeyValuePair)this.endOfData();
            }
            catch (IOException e) {
                throw new VoldemortException("Unable to deflate key/value pair.", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyValuePairSerializer
    implements Serializer<KeyValuePair> {
        private final MessageDigest digest = ByteUtils.getDigest("MD5");

        private KeyValuePairSerializer() {
        }

        @Override
        public byte[] toBytes(KeyValuePair pair) {
            byte[] key = pair.getKey();
            byte[] value = pair.getValue();
            byte[] bytes = new byte[key.length + value.length + 8];
            ByteUtils.writeInt(bytes, key.length, 0);
            ByteUtils.writeInt(bytes, value.length, 4);
            System.arraycopy(key, 0, bytes, 8, key.length);
            System.arraycopy(value, 0, bytes, 8 + key.length, value.length);
            return bytes;
        }

        @Override
        public KeyValuePair toObject(byte[] bytes) {
            int keySize = ByteUtils.readInt(bytes, 0);
            int valueSize = ByteUtils.readInt(bytes, 4);
            byte[] key = new byte[keySize];
            byte[] value = new byte[valueSize];
            System.arraycopy(bytes, 8, key, 0, keySize);
            System.arraycopy(bytes, 8 + keySize, value, 0, valueSize);
            byte[] md5 = this.digest.digest(key);
            this.digest.reset();
            return new KeyValuePair(key, md5, value);
        }
    }
}

