/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import voldemort.VoldemortException;
import voldemort.client.TimeoutConfig;
import voldemort.cluster.Cluster;
import voldemort.cluster.Zone;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.store.Store;
import voldemort.store.StoreDefinition;
import voldemort.store.StoreRequest;
import voldemort.store.StoreUtils;
import voldemort.store.nonblockingstore.NonblockingStore;
import voldemort.store.routed.BasicPipelineData;
import voldemort.store.routed.GetAllPipelineData;
import voldemort.store.routed.Pipeline;
import voldemort.store.routed.PipelineRoutedStats;
import voldemort.store.routed.PutPipelineData;
import voldemort.store.routed.ReadRepairer;
import voldemort.store.routed.Response;
import voldemort.store.routed.RoutedStore;
import voldemort.store.routed.action.ConfigureNodes;
import voldemort.store.routed.action.GetAllConfigureNodes;
import voldemort.store.routed.action.GetAllReadRepair;
import voldemort.store.routed.action.IncrementClock;
import voldemort.store.routed.action.PerformDeleteHintedHandoff;
import voldemort.store.routed.action.PerformParallelDeleteRequests;
import voldemort.store.routed.action.PerformParallelGetAllRequests;
import voldemort.store.routed.action.PerformParallelPutRequests;
import voldemort.store.routed.action.PerformParallelRequests;
import voldemort.store.routed.action.PerformPutHintedHandoff;
import voldemort.store.routed.action.PerformSerialGetAllRequests;
import voldemort.store.routed.action.PerformSerialPutRequests;
import voldemort.store.routed.action.PerformSerialRequests;
import voldemort.store.routed.action.PerformZoneSerialRequests;
import voldemort.store.routed.action.ReadRepair;
import voldemort.store.slop.HintedHandoff;
import voldemort.store.slop.Slop;
import voldemort.store.slop.strategy.HintedHandoffStrategy;
import voldemort.store.slop.strategy.HintedHandoffStrategyFactory;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;
import voldemort.utils.JmxUtils;
import voldemort.utils.SystemTime;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineRoutedStore
extends RoutedStore {
    private static AtomicInteger jmxIdCounter = new AtomicInteger(0);
    private final Map<Integer, NonblockingStore> nonblockingStores;
    private final Map<Integer, Store<ByteArray, Slop, byte[]>> slopStores;
    private final Map<Integer, NonblockingStore> nonblockingSlopStores;
    private final HintedHandoffStrategy handoffStrategy;
    private Zone clientZone;
    private boolean zoneRoutingEnabled;
    private PipelineRoutedStats stats;
    private final int jmxId;

    public PipelineRoutedStore(String name, Map<Integer, Store<ByteArray, byte[], byte[]>> innerStores, Map<Integer, NonblockingStore> nonblockingStores, Map<Integer, Store<ByteArray, Slop, byte[]>> slopStores, Map<Integer, NonblockingStore> nonblockingSlopStores, Cluster cluster, StoreDefinition storeDef, boolean repairReads, int clientZoneId, TimeoutConfig timeoutConfig, FailureDetector failureDetector, boolean jmxEnabled) {
        super(name, innerStores, cluster, storeDef, repairReads, timeoutConfig, failureDetector, SystemTime.INSTANCE);
        this.nonblockingSlopStores = nonblockingSlopStores;
        this.clientZone = cluster.getZoneById(clientZoneId);
        this.zoneRoutingEnabled = storeDef.getRoutingStrategyType().compareTo("zone-routing") == 0;
        this.jmxId = jmxIdCounter.getAndIncrement();
        this.nonblockingStores = new ConcurrentHashMap<Integer, NonblockingStore>(nonblockingStores);
        this.slopStores = slopStores;
        if (storeDef.hasHintedHandoffStrategyType()) {
            HintedHandoffStrategyFactory factory = new HintedHandoffStrategyFactory(this.zoneRoutingEnabled, this.clientZone.getId());
            this.handoffStrategy = factory.updateHintedHandoffStrategy(storeDef, cluster);
        } else {
            this.handoffStrategy = null;
        }
        if (jmxEnabled) {
            this.stats = new PipelineRoutedStats();
            JmxUtils.registerMbean(this.stats, JmxUtils.createObjectName(JmxUtils.getPackageName(this.stats.getClass()), this.getName() + this.jmxId()));
        }
    }

    @Override
    public List<Versioned<byte[]>> get(final ByteArray key, final byte[] transforms) {
        StoreUtils.assertValidKey(key);
        long startTimeMs = -1L;
        long startTimeNs = -1L;
        if (this.logger.isDebugEnabled()) {
            startTimeMs = System.currentTimeMillis();
            startTimeNs = System.nanoTime();
        }
        BasicPipelineData pipelineData = new BasicPipelineData();
        if (this.zoneRoutingEnabled) {
            pipelineData.setZonesRequired(this.storeDef.getZoneCountReads());
        } else {
            pipelineData.setZonesRequired(null);
        }
        pipelineData.setStats(this.stats);
        Pipeline pipeline = new Pipeline(Pipeline.Operation.GET, this.timeoutConfig.getOperationTimeout((byte)1), TimeUnit.MILLISECONDS);
        boolean allowReadRepair = this.repairReads && transforms == null;
        StoreRequest<List<Versioned<byte[]>>> blockingStoreRequest = new StoreRequest<List<Versioned<byte[]>>>(){

            @Override
            public List<Versioned<byte[]>> request(Store<ByteArray, byte[], byte[]> store) {
                return store.get(key, transforms);
            }
        };
        pipeline.addEventAction(Pipeline.Event.STARTED, new ConfigureNodes(pipelineData, Pipeline.Event.CONFIGURED, this.failureDetector, this.storeDef.getRequiredReads(), this.routingStrategy, key, this.clientZone));
        pipeline.addEventAction(Pipeline.Event.CONFIGURED, new PerformParallelRequests(pipelineData, allowReadRepair ? Pipeline.Event.RESPONSES_RECEIVED : Pipeline.Event.COMPLETED, key, transforms, this.failureDetector, this.storeDef.getPreferredReads(), this.storeDef.getRequiredReads(), this.timeoutConfig.getOperationTimeout((byte)1), this.nonblockingStores, Pipeline.Event.INSUFFICIENT_SUCCESSES, Pipeline.Event.INSUFFICIENT_ZONES));
        pipeline.addEventAction(Pipeline.Event.INSUFFICIENT_SUCCESSES, new PerformSerialRequests(pipelineData, allowReadRepair ? Pipeline.Event.RESPONSES_RECEIVED : Pipeline.Event.COMPLETED, key, this.failureDetector, this.innerStores, this.storeDef.getPreferredReads(), this.storeDef.getRequiredReads(), blockingStoreRequest, null));
        if (allowReadRepair) {
            pipeline.addEventAction(Pipeline.Event.RESPONSES_RECEIVED, new ReadRepair(pipelineData, Pipeline.Event.COMPLETED, this.storeDef.getPreferredReads(), this.timeoutConfig.getOperationTimeout((byte)1), this.nonblockingStores, this.readRepairer));
        }
        if (this.zoneRoutingEnabled) {
            pipeline.addEventAction(Pipeline.Event.INSUFFICIENT_ZONES, new PerformZoneSerialRequests(pipelineData, allowReadRepair ? Pipeline.Event.RESPONSES_RECEIVED : Pipeline.Event.COMPLETED, key, this.failureDetector, this.innerStores, blockingStoreRequest));
        }
        pipeline.addEvent(Pipeline.Event.STARTED);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Operation " + pipeline.getOperation().getSimpleName() + " Key " + ByteUtils.toHexString(key.get())));
        }
        try {
            pipeline.execute();
        }
        catch (VoldemortException e) {
            this.stats.reportException(e);
            throw e;
        }
        if (pipelineData.getFatalError() != null) {
            throw pipelineData.getFatalError();
        }
        ArrayList<Versioned<byte[]>> results = new ArrayList<Versioned<byte[]>>();
        for (Response response : pipelineData.getResponses()) {
            List value = (List)response.getValue();
            if (value == null) continue;
            results.addAll(value);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Finished " + pipeline.getOperation().getSimpleName() + " for key " + key + " keyRef: " + System.identityHashCode(key) + "; started at " + startTimeMs + " took " + (System.nanoTime() - startTimeNs) + " values: " + this.formatNodeValuesFromGet(pipelineData.getResponses())));
        }
        return results;
    }

    private String formatNodeValuesFromGet(List<Response<ByteArray, List<Versioned<byte[]>>>> results) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (Response<ByteArray, List<Versioned<byte[]>>> r : results) {
            builder.append("(nodeId=" + r.getNode().getId() + ", key=" + r.getKey() + ", retrieved= " + r.getValue() + "), ");
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        long startTimeMs = -1L;
        long startTimeNs = -1L;
        if (this.logger.isDebugEnabled()) {
            startTimeMs = System.currentTimeMillis();
            startTimeNs = System.nanoTime();
        }
        boolean allowReadRepair = this.repairReads && (transforms == null || transforms.size() == 0);
        GetAllPipelineData pipelineData = new GetAllPipelineData();
        if (this.zoneRoutingEnabled) {
            pipelineData.setZonesRequired(this.storeDef.getZoneCountReads());
        } else {
            pipelineData.setZonesRequired(null);
        }
        pipelineData.setStats(this.stats);
        Pipeline pipeline = new Pipeline(Pipeline.Operation.GET_ALL, this.timeoutConfig.getOperationTimeout((byte)4), TimeUnit.MILLISECONDS);
        pipeline.addEventAction(Pipeline.Event.STARTED, new GetAllConfigureNodes(pipelineData, Pipeline.Event.CONFIGURED, this.failureDetector, this.storeDef.getPreferredReads(), this.storeDef.getRequiredReads(), this.routingStrategy, keys, transforms, this.clientZone));
        pipeline.addEventAction(Pipeline.Event.CONFIGURED, new PerformParallelGetAllRequests(pipelineData, Pipeline.Event.INSUFFICIENT_SUCCESSES, this.failureDetector, this.timeoutConfig.getOperationTimeout((byte)4), this.nonblockingStores));
        pipeline.addEventAction(Pipeline.Event.INSUFFICIENT_SUCCESSES, new PerformSerialGetAllRequests(pipelineData, allowReadRepair ? Pipeline.Event.RESPONSES_RECEIVED : Pipeline.Event.COMPLETED, keys, this.failureDetector, this.innerStores, this.storeDef.getPreferredReads(), this.storeDef.getRequiredReads(), this.timeoutConfig.isPartialGetAllAllowed()));
        if (allowReadRepair) {
            pipeline.addEventAction(Pipeline.Event.RESPONSES_RECEIVED, new GetAllReadRepair(pipelineData, Pipeline.Event.COMPLETED, this.storeDef.getPreferredReads(), this.timeoutConfig.getOperationTimeout((byte)4), this.nonblockingStores, (ReadRepairer<ByteArray, byte[]>)this.readRepairer));
        }
        pipeline.addEvent(Pipeline.Event.STARTED);
        if (this.logger.isDebugEnabled()) {
            StringBuilder keyStr = new StringBuilder();
            for (ByteArray key : keys) {
                keyStr.append(ByteUtils.toHexString(key.get()) + ",");
            }
            this.logger.debug((Object)("Operation " + pipeline.getOperation().getSimpleName() + " Keys " + keyStr.toString()));
        }
        try {
            pipeline.execute();
        }
        catch (VoldemortException e) {
            this.stats.reportException(e);
            throw e;
        }
        if (pipelineData.getFatalError() != null) {
            throw pipelineData.getFatalError();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Finished " + pipeline.getOperation().getSimpleName() + "for keys " + keys + " keyRef: " + System.identityHashCode(keys) + "; started at " + startTimeMs + " took " + (System.nanoTime() - startTimeNs) + " values: " + this.formatNodeValuesFromGetAll(pipelineData.getResponses())));
        }
        return pipelineData.getResult();
    }

    private String formatNodeValuesFromGetAll(List<Response<Iterable<ByteArray>, Map<ByteArray, List<Versioned<byte[]>>>>> list) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (Response<Iterable<ByteArray>, Map<ByteArray, List<Versioned<byte[]>>>> r : list) {
            builder.append("(nodeId=" + r.getNode().getId() + ", key=" + r.getKey() + ", retrieved= " + r.getValue() + ")");
            builder.append(", ");
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public List<Version> getVersions(final ByteArray key) {
        StoreUtils.assertValidKey(key);
        long startTimeMs = -1L;
        long startTimeNs = -1L;
        if (this.logger.isDebugEnabled()) {
            startTimeMs = System.currentTimeMillis();
            startTimeNs = System.nanoTime();
        }
        BasicPipelineData pipelineData = new BasicPipelineData();
        if (this.zoneRoutingEnabled) {
            pipelineData.setZonesRequired(this.storeDef.getZoneCountReads());
        } else {
            pipelineData.setZonesRequired(null);
        }
        pipelineData.setStats(this.stats);
        Pipeline pipeline = new Pipeline(Pipeline.Operation.GET_VERSIONS, this.timeoutConfig.getOperationTimeout((byte)10), TimeUnit.MILLISECONDS);
        StoreRequest<List<Version>> blockingStoreRequest = new StoreRequest<List<Version>>(){

            @Override
            public List<Version> request(Store<ByteArray, byte[], byte[]> store) {
                return store.getVersions(key);
            }
        };
        pipeline.addEventAction(Pipeline.Event.STARTED, new ConfigureNodes(pipelineData, Pipeline.Event.CONFIGURED, this.failureDetector, this.storeDef.getRequiredReads(), this.routingStrategy, key, this.clientZone));
        pipeline.addEventAction(Pipeline.Event.CONFIGURED, new PerformParallelRequests(pipelineData, Pipeline.Event.COMPLETED, key, null, this.failureDetector, this.storeDef.getPreferredReads(), this.storeDef.getRequiredReads(), this.timeoutConfig.getOperationTimeout((byte)10), this.nonblockingStores, Pipeline.Event.INSUFFICIENT_SUCCESSES, Pipeline.Event.INSUFFICIENT_ZONES));
        pipeline.addEventAction(Pipeline.Event.INSUFFICIENT_SUCCESSES, new PerformSerialRequests(pipelineData, Pipeline.Event.COMPLETED, key, this.failureDetector, this.innerStores, this.storeDef.getPreferredReads(), this.storeDef.getRequiredReads(), blockingStoreRequest, null));
        if (this.zoneRoutingEnabled) {
            pipeline.addEventAction(Pipeline.Event.INSUFFICIENT_ZONES, new PerformZoneSerialRequests(pipelineData, Pipeline.Event.COMPLETED, key, this.failureDetector, this.innerStores, blockingStoreRequest));
        }
        pipeline.addEvent(Pipeline.Event.STARTED);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Operation  " + pipeline.getOperation().getSimpleName() + " Key " + ByteUtils.toHexString(key.get())));
        }
        try {
            pipeline.execute();
        }
        catch (VoldemortException e) {
            this.stats.reportException(e);
            throw e;
        }
        if (pipelineData.getFatalError() != null) {
            throw pipelineData.getFatalError();
        }
        ArrayList<Version> results = new ArrayList<Version>();
        for (Response response : pipelineData.getResponses()) {
            results.addAll((Collection)response.getValue());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Finished " + pipeline.getOperation().getSimpleName() + " for key " + key + " keyRef: " + System.identityHashCode(key) + "; started at " + startTimeMs + " took " + (System.nanoTime() - startTimeNs) + " values: " + this.formatNodeValuesFromGetVersions(pipelineData.getResponses())));
        }
        return results;
    }

    private <R> String formatNodeValuesFromGetVersions(List<Response<ByteArray, List<Version>>> results) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (Response<ByteArray, List<Version>> r : results) {
            builder.append("(nodeId=" + r.getNode().getId() + ", key=" + r.getKey() + ", retrieved= " + r.getValue() + "), ");
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        long startTimeMs = -1L;
        long startTimeNs = -1L;
        if (this.logger.isDebugEnabled()) {
            startTimeMs = System.currentTimeMillis();
            startTimeNs = System.nanoTime();
        }
        BasicPipelineData<Boolean> pipelineData = new BasicPipelineData<Boolean>();
        if (this.zoneRoutingEnabled) {
            pipelineData.setZonesRequired(this.storeDef.getZoneCountWrites());
        } else {
            pipelineData.setZonesRequired(null);
        }
        pipelineData.setStoreName(this.name);
        pipelineData.setStats(this.stats);
        Pipeline pipeline = new Pipeline(Pipeline.Operation.DELETE, this.timeoutConfig.getOperationTimeout((byte)3), TimeUnit.MILLISECONDS);
        pipeline.setEnableHintedHandoff(this.isHintedHandoffEnabled());
        HintedHandoff hintedHandoff = null;
        if (this.isHintedHandoffEnabled()) {
            hintedHandoff = new HintedHandoff(this.failureDetector, this.slopStores, this.nonblockingSlopStores, this.handoffStrategy, pipelineData.getFailedNodes(), this.timeoutConfig.getOperationTimeout((byte)3));
        }
        pipeline.addEventAction(Pipeline.Event.STARTED, new ConfigureNodes(pipelineData, Pipeline.Event.CONFIGURED, this.failureDetector, this.storeDef.getRequiredWrites(), this.routingStrategy, key, this.clientZone));
        pipeline.addEventAction(Pipeline.Event.CONFIGURED, new PerformParallelDeleteRequests(pipelineData, this.isHintedHandoffEnabled() ? Pipeline.Event.RESPONSES_RECEIVED : Pipeline.Event.COMPLETED, key, this.failureDetector, this.storeDef.getPreferredWrites(), this.storeDef.getRequiredWrites(), this.timeoutConfig.getOperationTimeout((byte)3), this.nonblockingStores, hintedHandoff, version));
        if (this.isHintedHandoffEnabled()) {
            pipeline.addEventAction(Pipeline.Event.RESPONSES_RECEIVED, new PerformDeleteHintedHandoff(pipelineData, Pipeline.Event.COMPLETED, key, version, hintedHandoff));
            pipeline.addEventAction(Pipeline.Event.ABORTED, new PerformDeleteHintedHandoff(pipelineData, Pipeline.Event.ERROR, key, version, hintedHandoff));
        }
        pipeline.addEvent(Pipeline.Event.STARTED);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Operation " + pipeline.getOperation().getSimpleName() + " Key " + ByteUtils.toHexString(key.get())));
        }
        try {
            pipeline.execute();
        }
        catch (VoldemortException e) {
            this.stats.reportException(e);
            throw e;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Finished " + pipeline.getOperation().getSimpleName() + " for key " + key.get() + " keyRef: " + System.identityHashCode(key) + "; started at " + startTimeMs + " took " + (System.nanoTime() - startTimeNs)));
        }
        if (pipelineData.getFatalError() != null) {
            throw pipelineData.getFatalError();
        }
        for (Response response : pipelineData.getResponses()) {
            if (!((Boolean)response.getValue()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isHintedHandoffEnabled() {
        return this.slopStores != null;
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> versioned, byte[] transforms) throws VoldemortException {
        long startTimeMs = -1L;
        long startTimeNs = -1L;
        if (this.logger.isDebugEnabled()) {
            startTimeMs = System.currentTimeMillis();
            startTimeNs = System.nanoTime();
        }
        StoreUtils.assertValidKey(key);
        PutPipelineData pipelineData = new PutPipelineData();
        if (this.zoneRoutingEnabled) {
            pipelineData.setZonesRequired(this.storeDef.getZoneCountWrites());
        } else {
            pipelineData.setZonesRequired(null);
        }
        pipelineData.setStartTimeNs(System.nanoTime());
        pipelineData.setStoreName(this.name);
        pipelineData.setStats(this.stats);
        Pipeline pipeline = new Pipeline(Pipeline.Operation.PUT, this.timeoutConfig.getOperationTimeout((byte)2), TimeUnit.MILLISECONDS);
        pipeline.setEnableHintedHandoff(this.isHintedHandoffEnabled());
        HintedHandoff hintedHandoff = null;
        if (this.isHintedHandoffEnabled()) {
            hintedHandoff = new HintedHandoff(this.failureDetector, this.slopStores, this.nonblockingSlopStores, this.handoffStrategy, pipelineData.getFailedNodes(), this.timeoutConfig.getOperationTimeout((byte)2));
        }
        pipeline.addEventAction(Pipeline.Event.STARTED, new ConfigureNodes(pipelineData, Pipeline.Event.CONFIGURED, this.failureDetector, this.storeDef.getRequiredWrites(), this.routingStrategy, key, this.clientZone));
        pipeline.addEventAction(Pipeline.Event.CONFIGURED, new PerformSerialPutRequests(pipelineData, this.isHintedHandoffEnabled() ? Pipeline.Event.RESPONSES_RECEIVED : Pipeline.Event.COMPLETED, key, transforms, this.failureDetector, this.innerStores, this.storeDef.getRequiredWrites(), versioned, this.time, Pipeline.Event.MASTER_DETERMINED));
        pipeline.addEventAction(Pipeline.Event.MASTER_DETERMINED, new PerformParallelPutRequests(pipelineData, Pipeline.Event.RESPONSES_RECEIVED, key, transforms, this.failureDetector, this.storeDef.getPreferredWrites(), this.storeDef.getRequiredWrites(), this.timeoutConfig.getOperationTimeout((byte)2), this.nonblockingStores, hintedHandoff));
        if (this.isHintedHandoffEnabled()) {
            pipeline.addEventAction(Pipeline.Event.ABORTED, new PerformPutHintedHandoff(pipelineData, Pipeline.Event.ERROR, key, versioned, transforms, hintedHandoff, this.time));
            pipeline.addEventAction(Pipeline.Event.RESPONSES_RECEIVED, new PerformPutHintedHandoff(pipelineData, Pipeline.Event.HANDOFF_FINISHED, key, versioned, transforms, hintedHandoff, this.time));
            pipeline.addEventAction(Pipeline.Event.HANDOFF_FINISHED, new IncrementClock(pipelineData, Pipeline.Event.COMPLETED, versioned, this.time));
        } else {
            pipeline.addEventAction(Pipeline.Event.RESPONSES_RECEIVED, new IncrementClock(pipelineData, Pipeline.Event.COMPLETED, versioned, this.time));
        }
        pipeline.addEvent(Pipeline.Event.STARTED);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Operation " + pipeline.getOperation().getSimpleName() + " Key " + ByteUtils.toHexString(key.get())));
        }
        try {
            pipeline.execute();
        }
        catch (VoldemortException e) {
            this.stats.reportException(e);
            throw e;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Finished " + pipeline.getOperation().getSimpleName() + " for key " + key + " keyRef: " + System.identityHashCode(key) + "; started at " + startTimeMs + " took " + (System.nanoTime() - startTimeNs) + " value: " + versioned.getValue() + " (size: " + versioned.getValue().length + ")"));
        }
        if (pipelineData.getFatalError() != null) {
            throw pipelineData.getFatalError();
        }
    }

    @Override
    public void close() {
        VoldemortException exception = null;
        for (NonblockingStore store : this.nonblockingStores.values()) {
            try {
                store.close();
            }
            catch (VoldemortException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
        super.close();
    }

    private String jmxId() {
        return this.jmxId == 0 ? "" : Integer.toString(this.jmxId);
    }
}

