/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import voldemort.annotations.concurrency.Threadsafe;
import voldemort.utils.SystemTime;
import voldemort.utils.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Threadsafe
public class CachedCallable<T>
implements Callable<T> {
    private final Callable<T> inner;
    private final long ttlMs;
    private final Time time;
    private final AtomicReference<T> valueRef;
    private volatile long lastCalledMs;

    public CachedCallable(Callable<T> inner, long ttlMs) {
        this(inner, ttlMs, SystemTime.INSTANCE);
    }

    public CachedCallable(Callable<T> inner, long ttlMs, Time time) {
        this.inner = inner;
        this.ttlMs = ttlMs;
        this.time = time;
        this.valueRef = new AtomicReference();
    }

    @Override
    public T call() throws Exception {
        T newValue;
        T value = this.valueRef.get();
        long now = this.time.getMilliseconds();
        if ((value == null || now - this.lastCalledMs > this.ttlMs) && this.valueRef.compareAndSet(value, newValue = this.inner.call())) {
            this.lastCalledMs = now;
            return newValue;
        }
        return this.valueRef.get();
    }
}

