/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import voldemort.client.TimeoutConfig;
import voldemort.client.protocol.RequestFormatType;
import voldemort.cluster.failuredetector.FailureDetectorConfig;
import voldemort.store.bdb.BdbStorageConfiguration;
import voldemort.store.memory.CacheStorageConfiguration;
import voldemort.store.memory.InMemoryStorageConfiguration;
import voldemort.store.mysql.MysqlStorageConfiguration;
import voldemort.store.readonly.BinarySearchStrategy;
import voldemort.store.readonly.ReadOnlyStorageConfiguration;
import voldemort.utils.ConfigurationException;
import voldemort.utils.Props;
import voldemort.utils.UndefinedPropertyException;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoldemortConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String VOLDEMORT_HOME_VAR_NAME = "VOLDEMORT_HOME";
    public static final String VOLDEMORT_CONFIG_DIR = "VOLDEMORT_CONFIG_DIR";
    private static final String VOLDEMORT_NODE_ID_VAR_NAME = "VOLDEMORT_NODE_ID";
    public static int VOLDEMORT_DEFAULT_ADMIN_PORT = 6660;
    public static final long REPORTING_INTERVAL_BYTES = 0x1900000L;
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private int nodeId;
    private String voldemortHome;
    private String dataDirectory;
    private String metadataDirectory;
    private long bdbCacheSize;
    private boolean bdbWriteTransactions;
    private boolean bdbFlushTransactions;
    private boolean bdbSortedDuplicates;
    private String bdbDataDirectory;
    private long bdbMaxLogFileSize;
    private int bdbBtreeFanout;
    private long bdbCheckpointBytes;
    private long bdbCheckpointMs;
    private boolean bdbOneEnvPerStore;
    private int bdbCleanerMinFileUtilization;
    private int bdbCleanerMinUtilization;
    private int bdbCleanerLookAheadCacheSize;
    private boolean bdbCheckpointerHighPriority;
    private int bdbCleanerMaxBatchFiles;
    private boolean bdbReadUncommitted;
    private int bdbCleanerThreads;
    private long bdbLockTimeoutMs;
    private int bdbLockNLockTables;
    private int bdbLogFaultReadSize;
    private int bdbLogIteratorReadSize;
    private boolean bdbFairLatches;
    private long bdbStatsCacheTtlMs;
    private boolean bdbExposeSpaceUtilization;
    private long bdbMinimumSharedCache;
    private String mysqlUsername;
    private String mysqlPassword;
    private String mysqlDatabaseName;
    private String mysqlHost;
    private int mysqlPort;
    private int readOnlyBackups;
    private String readOnlyStorageDir;
    private String readOnlySearchStrategy;
    private int readOnlyDeleteBackupTimeMs;
    private long maxBytesPerSecond;
    private long minBytesPerSecond;
    private long reportingIntervalBytes;
    private int fetcherBufferSize;
    private int coreThreads;
    private int maxThreads;
    private int socketTimeoutMs;
    private int socketBufferSize;
    private boolean socketKeepAlive;
    private boolean useNioConnector;
    private int nioConnectorSelectors;
    private int nioAdminConnectorSelectors;
    private int clientSelectors;
    private int clientRoutingTimeoutMs;
    private TimeoutConfig clientTimeoutConfig;
    private int clientMaxConnectionsPerNode;
    private int clientConnectionTimeoutMs;
    private int clientMaxThreads;
    private int clientThreadIdleMs;
    private int clientMaxQueuedRequests;
    private int schedulerThreads;
    private boolean mayInterruptService;
    private int numScanPermits;
    private RequestFormatType requestFormatType;
    private boolean enableSlop;
    private boolean enableSlopPusherJob;
    private boolean enableRepair;
    private boolean enableGui;
    private boolean enableHttpServer;
    private boolean enableSocketServer;
    private boolean enableAdminServer;
    private boolean enableJmx;
    private boolean enablePipelineRoutedStore;
    private boolean enableVerboseLogging;
    private boolean enableStatTracking;
    private boolean enableServerRouting;
    private boolean enableMetadataChecking;
    private boolean enableNetworkClassLoader;
    private boolean enableGossip;
    private boolean enableRebalanceService;
    private boolean enableJmxClusterName;
    private List<String> storageConfigurations;
    private Props allProps;
    private String slopStoreType;
    private String pusherType;
    private long slopFrequencyMs;
    private long repairStartMs;
    private long slopMaxWriteBytesPerSec;
    private long slopMaxReadBytesPerSec;
    private int slopBatchSize;
    private int slopZonesDownToTerminate;
    private int adminCoreThreads;
    private int adminMaxThreads;
    private int adminStreamBufferSize;
    private int adminSocketTimeout;
    private int adminConnectionTimeout;
    private long streamMaxReadBytesPerSec;
    private long streamMaxWriteBytesPerSec;
    private int gossipInterval;
    private String failureDetectorImplementation;
    private long failureDetectorBannagePeriod;
    private int failureDetectorThreshold;
    private int failureDetectorThresholdCountMinimum;
    private long failureDetectorThresholdInterval;
    private long failureDetectorAsyncRecoveryInterval;
    private volatile List<String> failureDetectorCatastrophicErrorTypes;
    private long failureDetectorRequestLengthThreshold;
    private int retentionCleanupFirstStartTimeInHour;
    private int retentionCleanupScheduledPeriodInHour;
    private int maxRebalancingAttempt;
    private long rebalancingTimeoutSec;
    private int maxParallelStoresRebalancing;
    private boolean rebalancingOptimization;

    public VoldemortConfig(Properties props) {
        this(new Props(props));
    }

    public VoldemortConfig(Props props) {
        try {
            this.nodeId = props.getInt("node.id");
        }
        catch (UndefinedPropertyException e) {
            this.nodeId = this.getIntEnvVariable(VOLDEMORT_NODE_ID_VAR_NAME);
        }
        this.voldemortHome = props.getString("voldemort.home");
        this.dataDirectory = props.getString("data.directory", this.voldemortHome + File.separator + "data");
        this.metadataDirectory = props.getString("metadata.directory", this.voldemortHome + File.separator + "config");
        this.bdbCacheSize = props.getBytes("bdb.cache.size", 0xC800000L);
        this.bdbWriteTransactions = props.getBoolean("bdb.write.transactions", false);
        this.bdbFlushTransactions = props.getBoolean("bdb.flush.transactions", false);
        this.bdbDataDirectory = props.getString("bdb.data.directory", this.dataDirectory + File.separator + "bdb");
        this.bdbMaxLogFileSize = props.getBytes("bdb.max.logfile.size", 0x3C00000L);
        this.bdbBtreeFanout = props.getInt("bdb.btree.fanout", 512);
        this.bdbCheckpointBytes = props.getLong("bdb.checkpoint.interval.bytes", 0x1400000L);
        this.bdbCheckpointMs = props.getLong("bdb.checkpoint.interval.ms", 30000L);
        this.bdbSortedDuplicates = props.getBoolean("bdb.enable.sorted.duplicates", true);
        this.bdbOneEnvPerStore = props.getBoolean("bdb.one.env.per.store", false);
        this.bdbCleanerMinFileUtilization = props.getInt("bdb.cleaner.min.file.utilization", 5);
        this.bdbCleanerMinUtilization = props.getInt("bdb.cleaner.minUtilization", 50);
        this.bdbCleanerThreads = props.getInt("bdb.cleaner.threads", 1);
        this.bdbCleanerLookAheadCacheSize = props.getInt("bdb.cleaner.lookahead.cache.size", 8192);
        this.bdbLockTimeoutMs = props.getLong("bdb.lock.timeout.ms", 500L);
        this.bdbLockNLockTables = props.getInt("bdb.lock.nLockTables", 1);
        this.bdbLogFaultReadSize = props.getInt("bdb.log.fault.read.size", 2048);
        this.bdbLogIteratorReadSize = props.getInt("bdb.log.iterator.read.size", 8192);
        this.bdbFairLatches = props.getBoolean("bdb.fair.latches", false);
        this.bdbCheckpointerHighPriority = props.getBoolean("bdb.checkpointer.high.priority", false);
        this.bdbCleanerMaxBatchFiles = props.getInt("bdb.cleaner.max.batch.files", 0);
        this.bdbReadUncommitted = props.getBoolean("bdb.lock.read_uncommitted", true);
        this.bdbStatsCacheTtlMs = props.getLong("bdb.stats.cache.ttl.ms", 5000L);
        this.bdbExposeSpaceUtilization = props.getBoolean("bdb.expose.space.utilization", true);
        this.bdbMinimumSharedCache = props.getLong("bdb.minimum.shared.cache", 0L);
        this.readOnlyBackups = props.getInt("readonly.backups", 1);
        this.readOnlySearchStrategy = props.getString("readonly.search.strategy", BinarySearchStrategy.class.getName());
        this.readOnlyStorageDir = props.getString("readonly.data.directory", this.dataDirectory + File.separator + "read-only");
        this.readOnlyDeleteBackupTimeMs = props.getInt("readonly.delete.backup.ms", 0);
        this.maxBytesPerSecond = props.getBytes("fetcher.max.bytes.per.sec", 0L);
        this.minBytesPerSecond = props.getBytes("fetcher.min.bytes.per.sec", 0L);
        this.reportingIntervalBytes = props.getBytes("fetcher.reporting.interval.bytes", 0x1900000L);
        this.fetcherBufferSize = (int)props.getBytes("hdfs.fetcher.buffer.size", 65536L);
        this.mysqlUsername = props.getString("mysql.user", "root");
        this.mysqlPassword = props.getString("mysql.password", "");
        this.mysqlHost = props.getString("mysql.host", "localhost");
        this.mysqlPort = props.getInt("mysql.port", 3306);
        this.mysqlDatabaseName = props.getString("mysql.database", "voldemort");
        this.maxThreads = props.getInt("max.threads", 100);
        this.coreThreads = props.getInt("core.threads", Math.max(1, this.maxThreads / 2));
        this.adminMaxThreads = props.getInt("admin.max.threads", 20);
        this.adminCoreThreads = props.getInt("admin.core.threads", Math.max(1, this.adminMaxThreads / 2));
        this.adminStreamBufferSize = (int)props.getBytes("admin.streams.buffer.size", 10000000L);
        this.adminConnectionTimeout = props.getInt("admin.client.connection.timeout.sec", 60);
        this.adminSocketTimeout = props.getInt("admin.client.socket.timeout.sec", 86400);
        this.streamMaxReadBytesPerSec = props.getBytes("stream.read.byte.per.sec", 10000000L);
        this.streamMaxWriteBytesPerSec = props.getBytes("stream.write.byte.per.sec", 10000000L);
        this.socketTimeoutMs = props.getInt("socket.timeout.ms", 5000);
        this.socketBufferSize = (int)props.getBytes("socket.buffer.size", 65536L);
        this.socketKeepAlive = props.getBoolean("socket.keepalive", false);
        this.useNioConnector = props.getBoolean("enable.nio.connector", true);
        this.nioConnectorSelectors = props.getInt("nio.connector.selectors", Math.max(8, Runtime.getRuntime().availableProcessors()));
        this.nioAdminConnectorSelectors = props.getInt("nio.admin.connector.selectors", Math.max(8, Runtime.getRuntime().availableProcessors()));
        this.clientSelectors = props.getInt("client.selectors", 4);
        this.clientMaxConnectionsPerNode = props.getInt("client.max.connections.per.node", 50);
        this.clientConnectionTimeoutMs = props.getInt("client.connection.timeout.ms", 500);
        this.clientRoutingTimeoutMs = props.getInt("client.routing.timeout.ms", 15000);
        this.clientTimeoutConfig = new TimeoutConfig(this.clientRoutingTimeoutMs, false);
        this.clientTimeoutConfig.setOperationTimeout((byte)1, props.getInt("client.routing.get.timeout.ms", this.clientRoutingTimeoutMs));
        this.clientTimeoutConfig.setOperationTimeout((byte)4, props.getInt("client.routing.getall.timeout.ms", this.clientRoutingTimeoutMs));
        this.clientTimeoutConfig.setOperationTimeout((byte)2, props.getInt("client.routing.put.timeout.ms", this.clientRoutingTimeoutMs));
        this.clientTimeoutConfig.setOperationTimeout((byte)10, props.getLong("client.routing.getversions.timeout.ms", this.clientTimeoutConfig.getOperationTimeout((byte)2)));
        this.clientTimeoutConfig.setOperationTimeout((byte)3, props.getInt("client.routing.delete.timeout.ms", this.clientRoutingTimeoutMs));
        this.clientTimeoutConfig.setPartialGetAllAllowed(props.getBoolean("client.routing.allow.partial.getall", false));
        this.clientMaxThreads = props.getInt("client.max.threads", 500);
        this.clientThreadIdleMs = props.getInt("client.thread.idle.ms", 100000);
        this.clientMaxQueuedRequests = props.getInt("client.max.queued.requests", 1000);
        this.enableHttpServer = props.getBoolean("http.enable", true);
        this.enableSocketServer = props.getBoolean("socket.enable", true);
        this.enableAdminServer = props.getBoolean("admin.enable", true);
        this.enableJmx = props.getBoolean("jmx.enable", true);
        this.enablePipelineRoutedStore = props.getBoolean("enable.pipeline.routed.store", true);
        this.enableSlop = props.getBoolean("slop.enable", true);
        this.enableSlopPusherJob = props.getBoolean("slop.pusher.enable", true);
        this.slopMaxWriteBytesPerSec = props.getBytes("slop.write.byte.per.sec", 10000000L);
        this.enableVerboseLogging = props.getBoolean("enable.verbose.logging", true);
        this.enableStatTracking = props.getBoolean("enable.stat.tracking", true);
        this.enableServerRouting = props.getBoolean("enable.server.routing", true);
        this.enableMetadataChecking = props.getBoolean("enable.metadata.checking", true);
        this.enableGossip = props.getBoolean("enable.gossip", false);
        this.enableRebalanceService = props.getBoolean("enable.rebalancing", true);
        this.enableRepair = props.getBoolean("enable.repair", true);
        this.enableJmxClusterName = props.getBoolean("enable.jmx.clustername", false);
        this.gossipInterval = props.getInt("gossip.interval.ms", 30000);
        this.slopMaxWriteBytesPerSec = props.getBytes("slop.write.byte.per.sec", 10000000L);
        this.slopMaxReadBytesPerSec = props.getBytes("slop.read.byte.per.sec", 10000000L);
        this.slopStoreType = props.getString("slop.store.engine", "bdb");
        this.slopFrequencyMs = props.getLong("slop.frequency.ms", 300000L);
        this.repairStartMs = props.getLong("repair.start.ms", 86400000L);
        this.slopBatchSize = props.getInt("slop.batch.size", 100);
        this.pusherType = props.getString("pusher.type", "streaming");
        this.slopZonesDownToTerminate = props.getInt("slop.zones.terminate", 0);
        this.schedulerThreads = props.getInt("scheduler.threads", 6);
        this.mayInterruptService = props.getBoolean("service.interruptible", true);
        this.numScanPermits = props.getInt("num.scan.permits", 1);
        this.storageConfigurations = props.getList("storage.configs", (List<String>)ImmutableList.of((Object)BdbStorageConfiguration.class.getName(), (Object)MysqlStorageConfiguration.class.getName(), (Object)InMemoryStorageConfiguration.class.getName(), (Object)CacheStorageConfiguration.class.getName(), (Object)ReadOnlyStorageConfiguration.class.getName()));
        this.retentionCleanupFirstStartTimeInHour = props.getInt("retention.cleanup.first.start.hour", 0);
        this.retentionCleanupScheduledPeriodInHour = props.getInt("retention.cleanup.period.hours", 24);
        this.allProps = props;
        String requestFormatName = props.getString("request.format", RequestFormatType.VOLDEMORT_V1.getCode());
        this.requestFormatType = RequestFormatType.fromCode(requestFormatName);
        this.maxRebalancingAttempt = props.getInt("max.rebalancing.attempts", 3);
        this.rebalancingTimeoutSec = props.getLong("rebalancing.timeout.seconds", 864000L);
        this.maxParallelStoresRebalancing = props.getInt("max.parallel.stores.rebalancing", 3);
        this.rebalancingOptimization = props.getBoolean("rebalancing.optimization", true);
        this.failureDetectorImplementation = props.getString("failuredetector.implementation", FailureDetectorConfig.DEFAULT_IMPLEMENTATION_CLASS_NAME);
        if (props.containsKey("client.node.bannage.ms") && !props.containsKey("failuredetector.bannage.period")) {
            props.put("failuredetector.bannage.period", props.get("client.node.bannage.ms"));
        }
        this.failureDetectorBannagePeriod = props.getLong("failuredetector.bannage.period", 30000L);
        this.failureDetectorThreshold = props.getInt("failuredetector.threshold", 95);
        this.failureDetectorThresholdCountMinimum = props.getInt("failuredetector.threshold.countminimum", 30);
        this.failureDetectorThresholdInterval = props.getLong("failuredetector.threshold.interval", 300000L);
        this.failureDetectorAsyncRecoveryInterval = props.getLong("failuredetector.asyncrecovery.interval", 10000L);
        this.failureDetectorCatastrophicErrorTypes = props.getList("failuredetector.catastrophic.error.types", FailureDetectorConfig.DEFAULT_CATASTROPHIC_ERROR_TYPES);
        this.failureDetectorRequestLengthThreshold = props.getLong("failuredetector.request.length.threshold", this.getSocketTimeoutMs());
        this.enableNetworkClassLoader = props.getBoolean("enable.network.classloader", false);
        this.validateParams();
    }

    private void validateParams() {
        if (this.coreThreads < 0) {
            throw new IllegalArgumentException("core.threads cannot be less than 1");
        }
        if (this.coreThreads > this.maxThreads) {
            throw new IllegalArgumentException("core.threads cannot be greater than max.threads.");
        }
        if (this.maxThreads < 1) {
            throw new ConfigurationException("max.threads cannot be less than 1.");
        }
        if (this.slopFrequencyMs < 1L) {
            throw new ConfigurationException("slop.frequency.ms cannot be less than 1.");
        }
        if (this.socketTimeoutMs < 0) {
            throw new ConfigurationException("socket.timeout.ms must be 0 or more ms.");
        }
        if (this.clientSelectors < 1) {
            throw new ConfigurationException("client.selectors must be 1 or more.");
        }
        if (this.clientRoutingTimeoutMs < 0) {
            throw new ConfigurationException("routing.timeout.ms must be 0 or more ms.");
        }
        if (this.schedulerThreads < 1) {
            throw new ConfigurationException("Must have at least 1 scheduler thread, " + this.schedulerThreads + " set.");
        }
        if (this.enableServerRouting && !this.enableSocketServer) {
            throw new ConfigurationException("Server-side routing is enabled, this requires the socket server to also be enabled.");
        }
    }

    private int getIntEnvVariable(String name) {
        String var = System.getenv(name);
        if (var == null) {
            throw new ConfigurationException("The environment variable " + name + " is not defined.");
        }
        try {
            return Integer.parseInt(var);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Invalid format for environment variable " + name + ", expecting an integer.", e);
        }
    }

    public static VoldemortConfig loadFromEnvironmentVariable() {
        String voldemortHome = System.getenv(VOLDEMORT_HOME_VAR_NAME);
        if (voldemortHome == null) {
            throw new ConfigurationException("No environment variable VOLDEMORT_HOME has been defined, set it!");
        }
        String voldemortConfigDir = System.getenv(VOLDEMORT_CONFIG_DIR);
        if (voldemortConfigDir != null && !Utils.isReadableDir(voldemortConfigDir)) {
            throw new ConfigurationException("Attempt to load configuration from VOLDEMORT_CONFIG_DIR, " + voldemortConfigDir + " failed. That is not a readable directory.");
        }
        return VoldemortConfig.loadFromVoldemortHome(voldemortHome, voldemortConfigDir);
    }

    public static VoldemortConfig loadFromVoldemortHome(String voldemortHome) {
        String voldemortConfigDir = voldemortHome + File.separator + "config";
        return VoldemortConfig.loadFromVoldemortHome(voldemortHome, voldemortConfigDir);
    }

    public static VoldemortConfig loadFromVoldemortHome(String voldemortHome, String voldemortConfigDir) {
        String propertiesFile;
        if (!Utils.isReadableDir(voldemortHome)) {
            throw new ConfigurationException("Attempt to load configuration from VOLDEMORT_HOME, " + voldemortHome + " failed. That is not a readable directory.");
        }
        if (voldemortConfigDir == null) {
            voldemortConfigDir = voldemortHome + File.separator + "config";
        }
        if (!Utils.isReadableFile(propertiesFile = voldemortConfigDir + File.separator + "server.properties")) {
            throw new ConfigurationException(propertiesFile + " is not a readable configuration file.");
        }
        Props properties = null;
        try {
            properties = new Props(new File(propertiesFile));
            properties.put("voldemort.home", voldemortHome);
            properties.put("metadata.directory", voldemortConfigDir);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        return new VoldemortConfig(properties);
    }

    public int getGossipInterval() {
        return this.gossipInterval;
    }

    public void setGossipInterval(int gossipInterval) {
        this.gossipInterval = gossipInterval;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    public String getVoldemortHome() {
        return this.voldemortHome;
    }

    public void setVoldemortHome(String voldemortHome) {
        this.voldemortHome = voldemortHome;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public String getMetadataDirectory() {
        return this.metadataDirectory;
    }

    public void setMetadataDirectory(String metadataDirectory) {
        this.metadataDirectory = metadataDirectory;
    }

    public long getBdbCacheSize() {
        return this.bdbCacheSize;
    }

    public void setBdbCacheSize(int bdbCacheSize) {
        this.bdbCacheSize = bdbCacheSize;
    }

    public boolean getBdbExposeSpaceUtilization() {
        return this.bdbExposeSpaceUtilization;
    }

    public void setBdbExposeSpaceUtilization(boolean bdbExposeSpaceUtilization) {
        this.bdbExposeSpaceUtilization = bdbExposeSpaceUtilization;
    }

    public boolean isBdbFlushTransactionsEnabled() {
        return this.bdbFlushTransactions;
    }

    public void setBdbFlushTransactions(boolean bdbSyncTransactions) {
        this.bdbFlushTransactions = bdbSyncTransactions;
    }

    public String getBdbDataDirectory() {
        return this.bdbDataDirectory;
    }

    public void setBdbDataDirectory(String bdbDataDirectory) {
        this.bdbDataDirectory = bdbDataDirectory;
    }

    public long getBdbMaxLogFileSize() {
        return this.bdbMaxLogFileSize;
    }

    public void setBdbMaxLogFileSize(long bdbMaxLogFileSize) {
        this.bdbMaxLogFileSize = bdbMaxLogFileSize;
    }

    public int getBdbCleanerMinFileUtilization() {
        return this.bdbCleanerMinFileUtilization;
    }

    public final void setBdbCleanerMinFileUtilization(int minFileUtilization) {
        if (minFileUtilization < 0 || minFileUtilization > 50) {
            throw new IllegalArgumentException("minFileUtilization should be between 0 and 50 (both inclusive)");
        }
        this.bdbCleanerMinFileUtilization = minFileUtilization;
    }

    public boolean getBdbCheckpointerHighPriority() {
        return this.bdbCheckpointerHighPriority;
    }

    public final void setBdbCheckpointerHighPriority(boolean bdbCheckpointerHighPriority) {
        this.bdbCheckpointerHighPriority = bdbCheckpointerHighPriority;
    }

    public int getBdbCleanerMaxBatchFiles() {
        return this.bdbCleanerMaxBatchFiles;
    }

    public final void setBdbCleanerMaxBatchFiles(int bdbCleanerMaxBatchFiles) {
        if (bdbCleanerMaxBatchFiles < 0 || bdbCleanerMaxBatchFiles > 100000) {
            throw new IllegalArgumentException("bdbCleanerMaxBatchFiles should be between 0 and 100000 (both inclusive)");
        }
        this.bdbCleanerMaxBatchFiles = bdbCleanerMaxBatchFiles;
    }

    public int getBdbCleanerThreads() {
        return this.bdbCleanerThreads;
    }

    public final void setBdbCleanerThreads(int bdbCleanerThreads) {
        if (bdbCleanerThreads <= 0) {
            throw new IllegalArgumentException("bdbCleanerThreads should be greater than 0");
        }
        this.bdbCleanerThreads = bdbCleanerThreads;
    }

    public int getBdbCleanerLookAheadCacheSize() {
        return this.bdbCleanerLookAheadCacheSize;
    }

    public final void setBdbCleanerLookAheadCacheSize(int bdbCleanerLookAheadCacheSize) {
        if (bdbCleanerLookAheadCacheSize < 0) {
            throw new IllegalArgumentException("bdbCleanerLookAheadCacheSize should be at least 0");
        }
        this.bdbCleanerLookAheadCacheSize = bdbCleanerLookAheadCacheSize;
    }

    public long getBdbLockTimeoutMs() {
        return this.bdbLockTimeoutMs;
    }

    public final void setBdbLockTimeoutMs(long bdbLockTimeoutMs) {
        if (bdbLockTimeoutMs < 0L) {
            throw new IllegalArgumentException("bdbLockTimeoutMs should be greater than 0");
        }
        this.bdbLockTimeoutMs = bdbLockTimeoutMs;
    }

    public void setBdbLockNLockTables(int bdbLockNLockTables) {
        if (bdbLockNLockTables < 1 || bdbLockNLockTables > Short.MAX_VALUE) {
            throw new IllegalArgumentException("bdbLockNLockTables should be greater than 0 and less than 32767");
        }
        this.bdbLockNLockTables = bdbLockNLockTables;
    }

    public int getBdbLockNLockTables() {
        return this.bdbLockNLockTables;
    }

    public void setBdbLogFaultReadSize(int bdbLogFaultReadSize) {
        this.bdbLogFaultReadSize = bdbLogFaultReadSize;
    }

    public int getBdbLogFaultReadSize() {
        return this.bdbLogFaultReadSize;
    }

    public void setBdbLogIteratorReadSize(int bdbLogIteratorReadSize) {
        this.bdbLogIteratorReadSize = bdbLogIteratorReadSize;
    }

    public int getBdbLogIteratorReadSize() {
        return this.bdbLogIteratorReadSize;
    }

    public boolean getBdbFairLatches() {
        return this.bdbFairLatches;
    }

    public void setBdbFairLatches(boolean bdbFairLatches) {
        this.bdbFairLatches = bdbFairLatches;
    }

    public boolean getBdbReadUncommitted() {
        return this.bdbReadUncommitted;
    }

    public void setBdbReadUncommitted(boolean bdbReadUncommitted) {
        this.bdbReadUncommitted = bdbReadUncommitted;
    }

    public int getBdbCleanerMinUtilization() {
        return this.bdbCleanerMinUtilization;
    }

    public final void setBdbCleanerMinUtilization(int minUtilization) {
        if (minUtilization < 0 || minUtilization > 90) {
            throw new IllegalArgumentException("minUtilization should be between 0 and 90 (both inclusive)");
        }
        this.bdbCleanerMinUtilization = minUtilization;
    }

    public int getBdbBtreeFanout() {
        return this.bdbBtreeFanout;
    }

    public void setBdbBtreeFanout(int bdbBtreeFanout) {
        this.bdbBtreeFanout = bdbBtreeFanout;
    }

    public int getCoreThreads() {
        return this.coreThreads;
    }

    public void setCoreThreads(int coreThreads) {
        this.coreThreads = coreThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getAdminCoreThreads() {
        return this.adminCoreThreads;
    }

    public void setAdminCoreThreads(int coreThreads) {
        this.adminCoreThreads = coreThreads;
    }

    public int getAdminMaxThreads() {
        return this.adminMaxThreads;
    }

    public void setAdminMaxThreads(int maxThreads) {
        this.adminMaxThreads = maxThreads;
    }

    public boolean isHttpServerEnabled() {
        return this.enableHttpServer;
    }

    public void setEnableHttpServer(boolean enableHttpServer) {
        this.enableHttpServer = enableHttpServer;
    }

    public boolean isSocketServerEnabled() {
        return this.enableSocketServer;
    }

    public void setAdminServerEnabled(boolean enableSocketServer) {
        this.enableSocketServer = enableSocketServer;
    }

    public boolean isAdminServerEnabled() {
        return this.enableAdminServer;
    }

    public long getStreamMaxReadBytesPerSec() {
        return this.streamMaxReadBytesPerSec;
    }

    public void setStreamMaxReadBytesPerSec(long streamMaxReadBytesPerSec) {
        this.streamMaxReadBytesPerSec = streamMaxReadBytesPerSec;
    }

    public long getStreamMaxWriteBytesPerSec() {
        return this.streamMaxWriteBytesPerSec;
    }

    public void setStreamMaxWriteBytesPerSec(long streamMaxWriteBytesPerSec) {
        this.streamMaxWriteBytesPerSec = streamMaxWriteBytesPerSec;
    }

    public long getSlopMaxWriteBytesPerSec() {
        return this.slopMaxWriteBytesPerSec;
    }

    public void setSlopMaxWriteBytesPerSec(long slopMaxWriteBytesPerSec) {
        this.slopMaxWriteBytesPerSec = slopMaxWriteBytesPerSec;
    }

    public long getSlopMaxReadBytesPerSec() {
        return this.slopMaxReadBytesPerSec;
    }

    public void setSlopMaxReadBytesPerSec(long slopMaxReadBytesPerSec) {
        this.slopMaxReadBytesPerSec = slopMaxReadBytesPerSec;
    }

    public void setEnableAdminServer(boolean enableAdminServer) {
        this.enableAdminServer = enableAdminServer;
    }

    public boolean isJmxEnabled() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public boolean isPipelineRoutedStoreEnabled() {
        return this.enablePipelineRoutedStore;
    }

    public void setEnablePipelineRoutedStore(boolean enablePipelineRoutedStore) {
        this.enablePipelineRoutedStore = enablePipelineRoutedStore;
    }

    public boolean isGuiEnabled() {
        return this.enableGui;
    }

    public void setEnableGui(boolean enableGui) {
        this.enableGui = enableGui;
    }

    public String getMysqlUsername() {
        return this.mysqlUsername;
    }

    public void setMysqlUsername(String mysqlUsername) {
        this.mysqlUsername = mysqlUsername;
    }

    public String getMysqlPassword() {
        return this.mysqlPassword;
    }

    public void setMysqlPassword(String mysqlPassword) {
        this.mysqlPassword = mysqlPassword;
    }

    public String getMysqlDatabaseName() {
        return this.mysqlDatabaseName;
    }

    public void setMysqlDatabaseName(String mysqlDatabaseName) {
        this.mysqlDatabaseName = mysqlDatabaseName;
    }

    public String getMysqlHost() {
        return this.mysqlHost;
    }

    public void setMysqlHost(String mysqlHost) {
        this.mysqlHost = mysqlHost;
    }

    public int getMysqlPort() {
        return this.mysqlPort;
    }

    public void setMysqlPort(int mysqlPort) {
        this.mysqlPort = mysqlPort;
    }

    public String getSlopStoreType() {
        return this.slopStoreType;
    }

    public void setSlopStoreType(String slopStoreType) {
        this.slopStoreType = slopStoreType;
    }

    public String getPusherType() {
        return this.pusherType;
    }

    public void setPusherType(String pusherType) {
        this.pusherType = pusherType;
    }

    public int getSlopZonesDownToTerminate() {
        return this.slopZonesDownToTerminate;
    }

    public void setSlopZonesDownToTerminate(int slopZonesDownToTerminate) {
        this.slopZonesDownToTerminate = slopZonesDownToTerminate;
    }

    public int getSlopBatchSize() {
        return this.slopBatchSize;
    }

    public void setSlopBatchSize(int slopBatchSize) {
        this.slopBatchSize = slopBatchSize;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public long getSlopFrequencyMs() {
        return this.slopFrequencyMs;
    }

    public void setSlopFrequencyMs(long slopFrequencyMs) {
        this.slopFrequencyMs = slopFrequencyMs;
    }

    public long getRepairStartMs() {
        return this.repairStartMs;
    }

    public void setRepairStartMs(long repairStartMs) {
        this.repairStartMs = repairStartMs;
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public int getClientSelectors() {
        return this.clientSelectors;
    }

    public void setClientSelectors(int clientSelectors) {
        this.clientSelectors = clientSelectors;
    }

    public int getClientRoutingTimeoutMs() {
        return this.clientRoutingTimeoutMs;
    }

    public void setClientRoutingTimeoutMs(int routingTimeoutMs) {
        this.clientRoutingTimeoutMs = routingTimeoutMs;
    }

    public TimeoutConfig getTimeoutConfig() {
        return this.clientTimeoutConfig;
    }

    public int getClientMaxConnectionsPerNode() {
        return this.clientMaxConnectionsPerNode;
    }

    public void setClientMaxConnectionsPerNode(int maxConnectionsPerNode) {
        this.clientMaxConnectionsPerNode = maxConnectionsPerNode;
    }

    public int getClientConnectionTimeoutMs() {
        return this.clientConnectionTimeoutMs;
    }

    public void setClientConnectionTimeoutMs(int connectionTimeoutMs) {
        this.clientConnectionTimeoutMs = connectionTimeoutMs;
    }

    @Deprecated
    public int getClientNodeBannageMs() {
        return (int)this.failureDetectorBannagePeriod;
    }

    @Deprecated
    public void setClientNodeBannageMs(int nodeBannageMs) {
        this.failureDetectorBannagePeriod = nodeBannageMs;
    }

    public int getClientMaxThreads() {
        return this.clientMaxThreads;
    }

    public void setClientMaxThreads(int clientMaxThreads) {
        this.clientMaxThreads = clientMaxThreads;
    }

    public int getClientThreadIdleMs() {
        return this.clientThreadIdleMs;
    }

    public void setClientThreadIdleMs(int clientThreadIdleMs) {
        this.clientThreadIdleMs = clientThreadIdleMs;
    }

    public int getClientMaxQueuedRequests() {
        return this.clientMaxQueuedRequests;
    }

    public void setClientMaxQueuedRequests(int clientMaxQueuedRequests) {
        this.clientMaxQueuedRequests = clientMaxQueuedRequests;
    }

    public boolean isSlopEnabled() {
        return this.enableSlop;
    }

    public void setEnableSlop(boolean enableSlop) {
        this.enableSlop = enableSlop;
    }

    public boolean isSlopPusherJobEnabled() {
        return this.enableSlopPusherJob;
    }

    public void setEnableSlopPusherJob(boolean enableSlopPusherJob) {
        this.enableSlopPusherJob = enableSlopPusherJob;
    }

    public boolean isRepairEnabled() {
        return this.enableRepair;
    }

    public void setEnableRepair(boolean enableRepair) {
        this.enableRepair = enableRepair;
    }

    public boolean isVerboseLoggingEnabled() {
        return this.enableVerboseLogging;
    }

    public void setEnableVerboseLogging(boolean enableVerboseLogging) {
        this.enableVerboseLogging = enableVerboseLogging;
    }

    public boolean isStatTrackingEnabled() {
        return this.enableStatTracking;
    }

    public void setEnableStatTracking(boolean enableStatTracking) {
        this.enableStatTracking = enableStatTracking;
    }

    public boolean isMetadataCheckingEnabled() {
        return this.enableMetadataChecking;
    }

    public void setEnableMetadataChecking(boolean enableMetadataChecking) {
        this.enableMetadataChecking = enableMetadataChecking;
    }

    public long getBdbCheckpointBytes() {
        return this.bdbCheckpointBytes;
    }

    public void setBdbCheckpointBytes(long bdbCheckpointBytes) {
        this.bdbCheckpointBytes = bdbCheckpointBytes;
    }

    public long getBdbCheckpointMs() {
        return this.bdbCheckpointMs;
    }

    public void setBdbCheckpointMs(long bdbCheckpointMs) {
        this.bdbCheckpointMs = bdbCheckpointMs;
    }

    public long getBdbStatsCacheTtlMs() {
        return this.bdbStatsCacheTtlMs;
    }

    public void setBdbStatsCacheTtlMs(long statsCacheTtlMs) {
        this.bdbStatsCacheTtlMs = statsCacheTtlMs;
    }

    public long getBdbMinimumSharedCache() {
        return this.bdbMinimumSharedCache;
    }

    public void setBdbMinimumSharedCache(long minimumSharedCache) {
        this.bdbMinimumSharedCache = minimumSharedCache;
    }

    public int getSchedulerThreads() {
        return this.schedulerThreads;
    }

    public void setSchedulerThreads(int schedulerThreads) {
        this.schedulerThreads = schedulerThreads;
    }

    public boolean canInterruptService() {
        return this.mayInterruptService;
    }

    public void setInterruptible(boolean canInterrupt) {
        this.mayInterruptService = canInterrupt;
    }

    public String getReadOnlyDataStorageDirectory() {
        return this.readOnlyStorageDir;
    }

    public void setReadOnlyDataStorageDirectory(String readOnlyStorageDir) {
        this.readOnlyStorageDir = readOnlyStorageDir;
    }

    public int getReadOnlyBackups() {
        return this.readOnlyBackups;
    }

    public void setReadOnlyBackups(int readOnlyBackups) {
        this.readOnlyBackups = readOnlyBackups;
    }

    public int getReadOnlyDeleteBackupMs() {
        return this.readOnlyDeleteBackupTimeMs;
    }

    public void setReadOnlyDeleteBackupMs(int readOnlyDeleteBackupTimeMs) {
        this.readOnlyDeleteBackupTimeMs = readOnlyDeleteBackupTimeMs;
    }

    public boolean isBdbWriteTransactionsEnabled() {
        return this.bdbWriteTransactions;
    }

    public void setBdbWriteTransactions(boolean bdbWriteTransactions) {
        this.bdbWriteTransactions = bdbWriteTransactions;
    }

    public boolean isBdbSortedDuplicatesEnabled() {
        return this.bdbSortedDuplicates;
    }

    public void setBdbSortedDuplicates(boolean enable) {
        this.bdbSortedDuplicates = enable;
    }

    public void setBdbOneEnvPerStore(boolean bdbOneEnvPerStore) {
        this.bdbOneEnvPerStore = bdbOneEnvPerStore;
    }

    public boolean isBdbOneEnvPerStore() {
        return this.bdbOneEnvPerStore;
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public boolean getSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public void setSocketKeepAlive(boolean on) {
        this.socketKeepAlive = on;
    }

    public boolean getUseNioConnector() {
        return this.useNioConnector;
    }

    public void setUseNioConnector(boolean useNio) {
        this.useNioConnector = useNio;
    }

    public int getNioConnectorSelectors() {
        return this.nioConnectorSelectors;
    }

    public void setNioConnectorSelectors(int nioConnectorSelectors) {
        this.nioConnectorSelectors = nioConnectorSelectors;
    }

    public int getNioAdminConnectorSelectors() {
        return this.nioAdminConnectorSelectors;
    }

    public void setNioAdminConnectorSelectors(int nioAdminConnectorSelectors) {
        this.nioAdminConnectorSelectors = nioAdminConnectorSelectors;
    }

    public int getAdminSocketBufferSize() {
        return this.adminStreamBufferSize;
    }

    public void setAdminSocketBufferSize(int socketBufferSize) {
        this.adminStreamBufferSize = socketBufferSize;
    }

    public List<String> getStorageConfigurations() {
        return this.storageConfigurations;
    }

    public void setStorageConfigurations(List<String> storageConfigurations) {
        this.storageConfigurations = storageConfigurations;
    }

    public Props getAllProps() {
        return this.allProps;
    }

    public void setRequestFormatType(RequestFormatType type) {
        this.requestFormatType = type;
    }

    public RequestFormatType getRequestFormatType() {
        return this.requestFormatType;
    }

    public boolean isServerRoutingEnabled() {
        return this.enableServerRouting;
    }

    public void setEnableServerRouting(boolean enableServerRouting) {
        this.enableServerRouting = enableServerRouting;
    }

    public int getNumScanPermits() {
        return this.numScanPermits;
    }

    public void setNumScanPermits(int numScanPermits) {
        this.numScanPermits = numScanPermits;
    }

    public String getFailureDetectorImplementation() {
        return this.failureDetectorImplementation;
    }

    public void setFailureDetectorImplementation(String failureDetectorImplementation) {
        this.failureDetectorImplementation = failureDetectorImplementation;
    }

    public long getFailureDetectorBannagePeriod() {
        return this.failureDetectorBannagePeriod;
    }

    public void setFailureDetectorBannagePeriod(long failureDetectorBannagePeriod) {
        this.failureDetectorBannagePeriod = failureDetectorBannagePeriod;
    }

    public int getFailureDetectorThreshold() {
        return this.failureDetectorThreshold;
    }

    public void setFailureDetectorThreshold(int failureDetectorThreshold) {
        this.failureDetectorThreshold = failureDetectorThreshold;
    }

    public int getFailureDetectorThresholdCountMinimum() {
        return this.failureDetectorThresholdCountMinimum;
    }

    public void setFailureDetectorThresholdCountMinimum(int failureDetectorThresholdCountMinimum) {
        this.failureDetectorThresholdCountMinimum = failureDetectorThresholdCountMinimum;
    }

    public long getFailureDetectorThresholdInterval() {
        return this.failureDetectorThresholdInterval;
    }

    public void setFailureDetectorThresholdInterval(long failureDetectorThresholdInterval) {
        this.failureDetectorThresholdInterval = failureDetectorThresholdInterval;
    }

    public long getFailureDetectorAsyncRecoveryInterval() {
        return this.failureDetectorAsyncRecoveryInterval;
    }

    public void setFailureDetectorAsyncRecoveryInterval(long failureDetectorAsyncRecoveryInterval) {
        this.failureDetectorAsyncRecoveryInterval = failureDetectorAsyncRecoveryInterval;
    }

    public List<String> getFailureDetectorCatastrophicErrorTypes() {
        return this.failureDetectorCatastrophicErrorTypes;
    }

    public void setFailureDetectorCatastrophicErrorTypes(List<String> failureDetectorCatastrophicErrorTypes) {
        this.failureDetectorCatastrophicErrorTypes = failureDetectorCatastrophicErrorTypes;
    }

    public long getFailureDetectorRequestLengthThreshold() {
        return this.failureDetectorRequestLengthThreshold;
    }

    public void setFailureDetectorRequestLengthThreshold(long failureDetectorRequestLengthThreshold) {
        this.failureDetectorRequestLengthThreshold = failureDetectorRequestLengthThreshold;
    }

    public int getRetentionCleanupFirstStartTimeInHour() {
        return this.retentionCleanupFirstStartTimeInHour;
    }

    public void setRetentionCleanupFirstStartTimeInHour(int retentionCleanupFirstStartTimeInHour) {
        this.retentionCleanupFirstStartTimeInHour = retentionCleanupFirstStartTimeInHour;
    }

    public int getRetentionCleanupScheduledPeriodInHour() {
        return this.retentionCleanupScheduledPeriodInHour;
    }

    public void setRetentionCleanupScheduledPeriodInHour(int retentionCleanupScheduledPeriodInHour) {
        this.retentionCleanupScheduledPeriodInHour = retentionCleanupScheduledPeriodInHour;
    }

    public int getAdminSocketTimeout() {
        return this.adminSocketTimeout;
    }

    public void setAdminSocketTimeout(int adminSocketTimeout) {
        this.adminSocketTimeout = adminSocketTimeout;
    }

    public int getAdminConnectionTimeout() {
        return this.adminConnectionTimeout;
    }

    public void setAdminConnectionTimeout(int adminConnectionTimeout) {
        this.adminConnectionTimeout = adminConnectionTimeout;
    }

    public void setMaxRebalancingAttempt(int maxRebalancingAttempt) {
        this.maxRebalancingAttempt = maxRebalancingAttempt;
    }

    public int getMaxRebalancingAttempt() {
        return this.maxRebalancingAttempt;
    }

    public long getRebalancingTimeoutSec() {
        return this.rebalancingTimeoutSec;
    }

    public void setRebalancingTimeoutSec(long rebalancingTimeoutSec) {
        this.rebalancingTimeoutSec = rebalancingTimeoutSec;
    }

    public VoldemortConfig(int nodeId, String voldemortHome) {
        this(new Props().with("node.id", nodeId).with("voldemort.home", voldemortHome));
    }

    public boolean isGossipEnabled() {
        return this.enableGossip;
    }

    public void setEnableGossip(boolean enableGossip) {
        this.enableGossip = enableGossip;
    }

    public String getReadOnlySearchStrategy() {
        return this.readOnlySearchStrategy;
    }

    public long getMaxBytesPerSecond() {
        return this.maxBytesPerSecond;
    }

    public void setMaxBytesPerSecond(long maxBytesPerSecond) {
        this.maxBytesPerSecond = maxBytesPerSecond;
    }

    public long getMinBytesPerSecond() {
        return this.minBytesPerSecond;
    }

    public void setMinBytesPerSecond(long minBytesPerSecond) {
        this.minBytesPerSecond = minBytesPerSecond;
    }

    public long getReportingIntervalBytes() {
        return this.reportingIntervalBytes;
    }

    public void setReportingIntervalBytes(long reportingIntervalBytes) {
        this.reportingIntervalBytes = reportingIntervalBytes;
    }

    public int getFetcherBufferSize() {
        return this.fetcherBufferSize;
    }

    public void setFetcherBufferSize(int fetcherBufferSize) {
        this.fetcherBufferSize = fetcherBufferSize;
    }

    public void setReadOnlySearchStrategy(String readOnlySearchStrategy) {
        this.readOnlySearchStrategy = readOnlySearchStrategy;
    }

    public boolean isNetworkClassLoaderEnabled() {
        return this.enableNetworkClassLoader;
    }

    public void setEnableNetworkClassLoader(boolean enableNetworkClassLoader) {
        this.enableNetworkClassLoader = enableNetworkClassLoader;
    }

    public void setEnableRebalanceService(boolean enableRebalanceService) {
        this.enableRebalanceService = enableRebalanceService;
    }

    public boolean isEnableRebalanceService() {
        return this.enableRebalanceService;
    }

    public int getMaxParallelStoresRebalancing() {
        return this.maxParallelStoresRebalancing;
    }

    public void setMaxParallelStoresRebalancing(int maxParallelStoresRebalancing) {
        this.maxParallelStoresRebalancing = maxParallelStoresRebalancing;
    }

    public boolean getRebalancingOptimization() {
        return this.rebalancingOptimization;
    }

    public void setMaxParallelStoresRebalancing(boolean rebalancingOptimization) {
        this.rebalancingOptimization = rebalancingOptimization;
    }

    public boolean isEnableJmxClusterName() {
        return this.enableJmxClusterName;
    }

    public void setEnableJmxClusterName(boolean enableJmxClusterName) {
        this.enableJmxClusterName = enableJmxClusterName;
    }
}

