/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed.action;

import java.util.List;
import java.util.Map;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.store.InsufficientZoneResponsesException;
import voldemort.store.Store;
import voldemort.store.StoreRequest;
import voldemort.store.routed.BasicPipelineData;
import voldemort.store.routed.Pipeline;
import voldemort.store.routed.Response;
import voldemort.store.routed.action.AbstractKeyBasedAction;
import voldemort.utils.ByteArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformZoneSerialRequests<V, PD extends BasicPipelineData<V>>
extends AbstractKeyBasedAction<ByteArray, V, PD> {
    private final FailureDetector failureDetector;
    private final Map<Integer, Store<ByteArray, byte[], byte[]>> stores;
    private final StoreRequest<V> storeRequest;

    public PerformZoneSerialRequests(PD pipelineData, Pipeline.Event completeEvent, ByteArray key, FailureDetector failureDetector, Map<Integer, Store<ByteArray, byte[], byte[]>> stores, StoreRequest<V> storeRequest) {
        super(pipelineData, completeEvent, key);
        this.failureDetector = failureDetector;
        this.stores = stores;
        this.storeRequest = storeRequest;
    }

    @Override
    public void execute(Pipeline pipeline) {
        List<Node> nodes = ((BasicPipelineData)this.pipelineData).getNodes();
        while (((BasicPipelineData)this.pipelineData).getNodeIndex() < nodes.size() && ((BasicPipelineData)this.pipelineData).getZoneResponses().size() + 1 < ((BasicPipelineData)this.pipelineData).getZonesRequired()) {
            block5: {
                Node node = nodes.get(((BasicPipelineData)this.pipelineData).getNodeIndex());
                long start = System.nanoTime();
                try {
                    Store<ByteArray, byte[], byte[]> store = this.stores.get(node.getId());
                    V result = this.storeRequest.request(store);
                    Response<Object, V> response = new Response<Object, V>(node, this.key, result, (System.nanoTime() - start) / 1000000L);
                    ((BasicPipelineData)this.pipelineData).incrementSuccesses();
                    ((BasicPipelineData)this.pipelineData).getResponses().add(response);
                    this.failureDetector.recordSuccess(response.getNode(), response.getRequestTime());
                    ((BasicPipelineData)this.pipelineData).getZoneResponses().add(node.getZoneId());
                }
                catch (Exception e) {
                    long requestTime = (System.nanoTime() - start) / 1000000L;
                    if (!this.handleResponseError(e, node, requestTime, pipeline, this.failureDetector)) break block5;
                    return;
                }
            }
            ((BasicPipelineData)this.pipelineData).incrementNodeIndex();
        }
        int zonesSatisfied = ((BasicPipelineData)this.pipelineData).getZoneResponses().size();
        if (zonesSatisfied >= ((BasicPipelineData)this.pipelineData).getZonesRequired() + 1) {
            pipeline.addEvent(this.completeEvent);
        } else {
            ((BasicPipelineData)this.pipelineData).setFatalError(new InsufficientZoneResponsesException(((BasicPipelineData)this.pipelineData).getZonesRequired() + 1 + " " + pipeline.getOperation().getSimpleName() + "s required zone, but only " + zonesSatisfied + " succeeded"));
            pipeline.abort();
        }
    }
}

