/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JobTrackerInstrumentation;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterInt;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.source.JvmMetricsSource;

class JobTrackerMetricsSource
extends JobTrackerInstrumentation
implements MetricsSource {
    final MetricsRegistry registry = new MetricsRegistry("jobtracker");
    final MetricMutableGaugeInt mapSlots = this.registry.newGauge("map_slots", "", 0);
    final MetricMutableGaugeInt redSlots = this.registry.newGauge("reduce_slots", "", 0);
    final MetricMutableGaugeInt blMapSlots = this.registry.newGauge("blacklisted_maps", "", 0);
    final MetricMutableGaugeInt blRedSlots = this.registry.newGauge("blacklisted_reduces", "", 0);
    final MetricMutableCounterInt mapsLaunched = this.registry.newCounter("maps_launched", "", 0);
    final MetricMutableCounterInt mapsCompleted = this.registry.newCounter("maps_completed", "", 0);
    final MetricMutableCounterInt mapsFailed = this.registry.newCounter("maps_failed", "", 0);
    final MetricMutableCounterInt redsLaunched = this.registry.newCounter("reduces_launched", "", 0);
    final MetricMutableCounterInt redsCompleted = this.registry.newCounter("reduces_completed", "", 0);
    final MetricMutableCounterInt redsFailed = this.registry.newCounter("reduces_failed", "", 0);
    final MetricMutableCounterInt jobsSubmitted = this.registry.newCounter("jobs_submitted", "", 0);
    final MetricMutableCounterInt jobsCompleted = this.registry.newCounter("jobs_completed", "", 0);
    final MetricMutableGaugeInt waitingMaps = this.registry.newGauge("waiting_maps", "", 0);
    final MetricMutableGaugeInt waitingReds = this.registry.newGauge("waiting_reduces", "", 0);
    final MetricMutableGaugeInt reservedMapSlots = this.registry.newGauge("reserved_map_slots", "", 0);
    final MetricMutableGaugeInt reservedRedSlots = this.registry.newGauge("reserved_reduce_slots", "", 0);
    final MetricMutableGaugeInt occupiedMapSlots = this.registry.newGauge("occupied_map_slots", "", 0);
    final MetricMutableGaugeInt occupiedRedSlots = this.registry.newGauge("occupied_reduce_slots", "", 0);
    final MetricMutableCounterInt jobsFailed = this.registry.newCounter("jobs_failed", "", 0);
    final MetricMutableCounterInt jobsKilled = this.registry.newCounter("jobs_killed", "", 0);
    final MetricMutableGaugeInt jobsPreparing = this.registry.newGauge("jobs_preparing", "", 0);
    final MetricMutableGaugeInt jobsRunning = this.registry.newGauge("jobs_running", "", 0);
    final MetricMutableGaugeInt runningMaps = this.registry.newGauge("running_maps", "", 0);
    final MetricMutableGaugeInt runningReds = this.registry.newGauge("running_reduces", "", 0);
    final MetricMutableCounterInt mapsKilled = this.registry.newCounter("maps_killed", "", 0);
    final MetricMutableCounterInt redsKilled = this.registry.newCounter("reduces_killed", "", 0);
    final MetricMutableGaugeInt numTrackers = this.registry.newGauge("trackers", "", 0);
    final MetricMutableGaugeInt blacklistedTrackers = this.registry.newGauge("trackers_blacklisted", "", 0);
    final MetricMutableGaugeInt graylistedTrackers = this.registry.newGauge("trackers_graylisted", "", 0);
    final MetricMutableGaugeInt decTrackers = this.registry.newGauge("trackers_decommissioned", "", 0);
    final MetricMutableCounterLong numHeartbeats = this.registry.newCounter("heartbeats", "", 0L);
    final String sessionId;

    public JobTrackerMetricsSource(JobTracker jt, JobConf conf) {
        super(jt, conf);
        this.sessionId = conf.getSessionId();
        this.registry.setContext("mapred").tag("sessionId", "", this.sessionId);
        JvmMetricsSource.create("JobTracker", this.sessionId);
    }

    @Override
    public void getMetrics(MetricsBuilder builder, boolean all) {
        this.registry.snapshot(builder.addRecord(this.registry.name()), all);
    }

    @Override
    public void launchMap(TaskAttemptID taskAttemptID) {
        this.mapsLaunched.incr();
        this.decWaitingMaps(taskAttemptID.getJobID(), 1);
    }

    @Override
    public void completeMap(TaskAttemptID taskAttemptID) {
        this.mapsCompleted.incr();
    }

    @Override
    public void failedMap(TaskAttemptID taskAttemptID) {
        this.mapsFailed.incr();
        this.addWaitingMaps(taskAttemptID.getJobID(), 1);
    }

    @Override
    public void launchReduce(TaskAttemptID taskAttemptID) {
        this.redsLaunched.incr();
        this.decWaitingReduces(taskAttemptID.getJobID(), 1);
    }

    @Override
    public void completeReduce(TaskAttemptID taskAttemptID) {
        this.redsCompleted.incr();
    }

    @Override
    public void failedReduce(TaskAttemptID taskAttemptID) {
        this.redsFailed.incr();
        this.addWaitingReduces(taskAttemptID.getJobID(), 1);
    }

    @Override
    public void submitJob(JobConf conf, JobID id) {
        this.jobsSubmitted.incr();
    }

    @Override
    public void completeJob(JobConf conf, JobID id) {
        this.jobsCompleted.incr();
    }

    @Override
    public void addWaitingMaps(JobID id, int task) {
        this.waitingMaps.incr(task);
    }

    @Override
    public void decWaitingMaps(JobID id, int task) {
        this.waitingMaps.decr(task);
    }

    @Override
    public void addWaitingReduces(JobID id, int task) {
        this.waitingReds.incr(task);
    }

    @Override
    public void decWaitingReduces(JobID id, int task) {
        this.waitingReds.decr(task);
    }

    @Override
    public void setMapSlots(int slots) {
        this.mapSlots.set(slots);
    }

    @Override
    public void setReduceSlots(int slots) {
        this.redSlots.set(slots);
    }

    @Override
    public void addBlackListedMapSlots(int slots) {
        this.blMapSlots.incr(slots);
    }

    @Override
    public void decBlackListedMapSlots(int slots) {
        this.blMapSlots.decr(slots);
    }

    @Override
    public void addBlackListedReduceSlots(int slots) {
        this.blRedSlots.incr(slots);
    }

    @Override
    public void decBlackListedReduceSlots(int slots) {
        this.blRedSlots.decr(slots);
    }

    @Override
    public void addReservedMapSlots(int slots) {
        this.reservedMapSlots.incr(slots);
    }

    @Override
    public void decReservedMapSlots(int slots) {
        this.reservedMapSlots.decr(slots);
    }

    @Override
    public void addReservedReduceSlots(int slots) {
        this.reservedRedSlots.incr(slots);
    }

    @Override
    public void decReservedReduceSlots(int slots) {
        this.reservedRedSlots.decr(slots);
    }

    @Override
    public void addOccupiedMapSlots(int slots) {
        this.occupiedMapSlots.incr(slots);
    }

    @Override
    public void decOccupiedMapSlots(int slots) {
        this.occupiedMapSlots.decr(slots);
    }

    @Override
    public void addOccupiedReduceSlots(int slots) {
        this.occupiedRedSlots.incr(slots);
    }

    @Override
    public void decOccupiedReduceSlots(int slots) {
        this.occupiedRedSlots.decr(slots);
    }

    @Override
    public void failedJob(JobConf conf, JobID id) {
        this.jobsFailed.incr();
    }

    @Override
    public void killedJob(JobConf conf, JobID id) {
        this.jobsKilled.incr();
    }

    @Override
    public void addPrepJob(JobConf conf, JobID id) {
        this.jobsPreparing.incr();
    }

    @Override
    public void decPrepJob(JobConf conf, JobID id) {
        this.jobsPreparing.decr();
    }

    @Override
    public void addRunningJob(JobConf conf, JobID id) {
        this.jobsRunning.incr();
    }

    @Override
    public void decRunningJob(JobConf conf, JobID id) {
        this.jobsRunning.decr();
    }

    @Override
    public void addRunningMaps(int task) {
        this.runningMaps.incr(task);
    }

    @Override
    public void decRunningMaps(int task) {
        this.runningMaps.decr(task);
    }

    @Override
    public void addRunningReduces(int task) {
        this.runningReds.incr(task);
    }

    @Override
    public void decRunningReduces(int task) {
        this.runningReds.decr(task);
    }

    @Override
    public void killedMap(TaskAttemptID taskAttemptID) {
        this.mapsKilled.incr();
    }

    @Override
    public void killedReduce(TaskAttemptID taskAttemptID) {
        this.redsKilled.incr();
    }

    @Override
    public void addTrackers(int trackers) {
        this.numTrackers.incr(trackers);
    }

    @Override
    public void decTrackers(int trackers) {
        this.numTrackers.decr(trackers);
    }

    @Override
    public void addBlackListedTrackers(int trackers) {
        this.blacklistedTrackers.incr(trackers);
    }

    @Override
    public void decBlackListedTrackers(int trackers) {
        this.blacklistedTrackers.decr(trackers);
    }

    @Override
    public void addGrayListedTrackers(int trackers) {
        this.graylistedTrackers.incr(trackers);
    }

    @Override
    public void decGrayListedTrackers(int trackers) {
        this.graylistedTrackers.decr(trackers);
    }

    @Override
    public void setDecommissionedTrackers(int trackers) {
        this.decTrackers.set(trackers);
    }

    @Override
    public void heartbeat() {
        this.numHeartbeats.incr();
    }
}

