/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.shock;

import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.shock.SSHSocketImplFactory;

class SSHSocketImpl
extends SocketImpl {
    private static final Log log = LogFactory.getLog(SSHSocketImpl.class);
    Session session;
    ChannelDirectTCPIP channel;
    InputStream is;
    OutputStream os;
    public static final String defaultDomain = ".inktomisearch.com";

    SSHSocketImpl(Session session) {
        this.session = session;
    }

    protected void accept(SocketImpl s) throws IOException {
        throw new IOException("SSHSocketImpl does not implement accept");
    }

    protected int available() throws IOException {
        if (this.is == null) {
            throw new ConnectException("Not connected");
        }
        return this.is.available();
    }

    protected void bind(InetAddress host, int port) throws IOException {
        if (host != null && !host.isAnyLocalAddress() || port != 0) {
            throw new IOException("SSHSocketImpl does not implement bind");
        }
    }

    protected void close() throws IOException {
        if (this.channel != null) {
            this.is = null;
            this.os = null;
        }
    }

    protected void connect(String host, int port) throws IOException {
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            host = host + defaultDomain;
            addr = InetAddress.getByName(host);
        }
        this.connect(addr, port);
    }

    protected void connect(InetAddress address, int port) throws IOException {
        this.connect(new InetSocketAddress(address, port), 300000);
    }

    protected void connect(SocketAddress address, int timeout) throws IOException {
        try {
            if (!this.session.isConnected()) {
                this.session.connect();
            }
            this.channel = (ChannelDirectTCPIP)this.session.openChannel("direct-tcpip");
            this.channel.setHost(((InetSocketAddress)address).getHostName());
            this.channel.setPort(((InetSocketAddress)address).getPort());
            this.channel.setOrgPort(22);
            this.is = new PipedInputStream();
            this.os = new PipedOutputStream();
            this.channel.setInputStream((InputStream)new PipedInputStream((PipedOutputStream)this.os));
            this.channel.setOutputStream((OutputStream)new PipedOutputStream((PipedInputStream)this.is));
            this.channel.connect();
            if (!this.channel.isConnected()) {
                log.error((Object)"Not connected");
            }
            if (this.channel.isEOF()) {
                log.error((Object)"EOF");
            }
        }
        catch (JSchException e) {
            log.error((Object)e);
            IOException newE = new IOException(e.getMessage());
            newE.setStackTrace(e.getStackTrace());
            throw newE;
        }
    }

    protected void create(boolean stream) throws IOException {
        if (!stream) {
            throw new IOException("Cannot handle UDP streams");
        }
    }

    protected InputStream getInputStream() throws IOException {
        return this.is;
    }

    protected OutputStream getOutputStream() throws IOException {
        return this.os;
    }

    protected void listen(int backlog) throws IOException {
        throw new IOException("SSHSocketImpl does not implement listen");
    }

    protected void sendUrgentData(int data) throws IOException {
        throw new IOException("SSHSocketImpl does not implement sendUrgentData");
    }

    public Object getOption(int optID) throws SocketException {
        if (optID == 4097) {
            return 1024;
        }
        throw new SocketException("SSHSocketImpl does not implement getOption for " + optID);
    }

    public void setOption(int optID, Object value) throws SocketException {
    }

    public static void main(String[] args) {
        try {
            int i;
            System.setProperty("ssh.gateway", "ucdev2");
            SSHSocketImplFactory fac = SSHSocketImplFactory.getFactory();
            Socket.setSocketImplFactory(fac);
            for (i = 0; i < 10; ++i) {
                new Thread(){

                    public void run() {
                        try {
                            log.error((Object)("Starting " + this));
                            SSHSocketImpl.connectTest("www.yahoo.com");
                            log.error((Object)("Finished " + this));
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                    }
                }.start();
            }
            Thread.sleep(1000000L);
            SSHSocketImpl.connectTest("www.news.com");
            log.info((Object)"******** Starting PART II");
            for (i = 0; i < 10; ++i) {
                new Thread(){

                    public void run() {
                        try {
                            log.error((Object)("Starting " + this));
                            SSHSocketImpl.connectTest("www.flickr.com");
                            log.error((Object)("Finished " + this));
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                    }
                }.start();
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private static void connectTest(String host) throws JSchException, IOException {
        Socket s = new Socket(host, 80);
        s.getOutputStream().write("GET / HTTP/1.0\r\n\r\n".getBytes());
        byte[] b = new byte[80];
        int rc = s.getInputStream().read(b);
        System.out.write(b, 0, rc);
        s.close();
    }

    private static void lsTest(SSHSocketImplFactory fac) throws JSchException, IOException {
        int rc;
        Process p = fac.ssh("ls");
        byte[] b = new byte[1024];
        final InputStream es = p.getErrorStream();
        new Thread(){

            public void run() {
                try {
                    while (es.available() > 0) {
                        es.read();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
        p.getOutputStream().close();
        InputStream is = p.getInputStream();
        while ((rc = is.read(b)) > 0) {
            System.out.write(b, 0, rc);
        }
    }
}

