/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.jobExecutor;

import azkaban.jobExecutor.AbstractJob;
import azkaban.utils.Props;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class WordCountLocal
extends AbstractJob {
    private String _input = null;
    private String _output = null;
    private Map<String, Integer> _dic = new HashMap();

    public WordCountLocal(String id, Props prop) {
        super(id, Logger.getLogger(WordCountLocal.class));
        this._input = prop.getString("input");
        this._output = prop.getString("output");
    }

    public void run() throws Exception {
        if (this._input == null) {
            throw new Exception("input file is null");
        }
        if (this._output == null) {
            throw new Exception("output file is null");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(this._input)));
        String line = null;
        while ((line = in.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(line);
            while (tokenizer.hasMoreTokens()) {
                String word = tokenizer.nextToken();
                if (word.toString().equals("end_here")) {
                    String[] errArray = new String[1];
                    System.out.println("string in possition 2 is " + errArray[1]);
                }
                if (this._dic.containsKey(word)) {
                    Integer num = (Integer)this._dic.get(word);
                    this._dic.put(word, num + 1);
                    continue;
                }
                this._dic.put(word, 1);
            }
        }
        in.close();
        PrintWriter out = new PrintWriter(new FileOutputStream(this._output));
        for (Map.Entry entry : this._dic.entrySet()) {
            out.println(String.valueOf((String)entry.getKey()) + "\t" + entry.getValue());
        }
        out.close();
    }

    public Props getJobGeneratedProperties() {
        return new Props();
    }

    public boolean isCanceled() {
        return false;
    }
}

