/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server;

import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.server.AbstractService;
import voldemort.server.ServiceType;
import voldemort.server.StatusManager;
import voldemort.server.VoldemortService;
import voldemort.utils.JmxUtils;

@JmxManaged(description="A server that handles remote operations on stores via TCP/IP.")
public abstract class AbstractSocketService
extends AbstractService
implements VoldemortService {
    protected final int port;
    protected final String serviceName;
    protected final boolean enableJmx;

    public AbstractSocketService(ServiceType type, int port, String serviceName, boolean enableJmx) {
        super(type);
        this.port = port;
        this.serviceName = serviceName;
        this.enableJmx = enableJmx;
    }

    @JmxGetter(name="port", description="The port on which the server is accepting connections.")
    public final int getPort() {
        return this.port;
    }

    public abstract StatusManager getStatusManager();

    protected void enableJmx(Object obj) {
        if (this.enableJmx) {
            JmxUtils.registerMbean(this.serviceName, obj);
        }
    }
}

