/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.protocol.admin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.protocol.VoldemortFilter;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.protocol.admin.filter.DefaultVoldemortFilter;
import voldemort.client.protocol.pb.ProtoUtils;
import voldemort.client.protocol.pb.VAdminProto;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.cluster.Cluster;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortConfig;
import voldemort.server.protocol.RequestHandler;
import voldemort.server.protocol.StreamRequestHandler;
import voldemort.server.protocol.admin.AsyncOperation;
import voldemort.server.protocol.admin.AsyncOperationService;
import voldemort.server.protocol.admin.AsyncOperationStatus;
import voldemort.server.protocol.admin.FetchEntriesStreamRequestHandler;
import voldemort.server.protocol.admin.FetchKeysStreamRequestHandler;
import voldemort.server.protocol.admin.FetchPartitionFileStreamRequestHandler;
import voldemort.server.protocol.admin.UpdatePartitionEntriesStreamRequestHandler;
import voldemort.server.protocol.admin.UpdateSlopEntriesRequestHandler;
import voldemort.server.rebalance.Rebalancer;
import voldemort.server.storage.RepairJob;
import voldemort.server.storage.StorageService;
import voldemort.store.ErrorCodeMapper;
import voldemort.store.StorageEngine;
import voldemort.store.StoreDefinition;
import voldemort.store.StoreDefinitionBuilder;
import voldemort.store.StoreOperationFailureException;
import voldemort.store.backup.NativeBackupable;
import voldemort.store.metadata.MetadataStore;
import voldemort.store.readonly.FileFetcher;
import voldemort.store.readonly.ReadOnlyStorageEngine;
import voldemort.store.readonly.ReadOnlyUtils;
import voldemort.store.stats.StreamStats;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteBufferBackedInputStream;
import voldemort.utils.ByteUtils;
import voldemort.utils.ClosableIterator;
import voldemort.utils.EventThrottler;
import voldemort.utils.NetworkClassLoader;
import voldemort.utils.Pair;
import voldemort.utils.RebalanceUtils;
import voldemort.utils.ReflectUtils;
import voldemort.utils.Utils;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;
import voldemort.xml.ClusterMapper;
import voldemort.xml.StoreDefinitionsMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminServiceRequestHandler
implements RequestHandler {
    private static final Logger logger = Logger.getLogger(AdminServiceRequestHandler.class);
    private static final Object lock = new Object();
    private final ErrorCodeMapper errorCodeMapper;
    private final MetadataStore metadataStore;
    private final StorageService storageService;
    private final StoreRepository storeRepository;
    private final NetworkClassLoader networkClassLoader;
    private final VoldemortConfig voldemortConfig;
    private final AsyncOperationService asyncService;
    private final Rebalancer rebalancer;
    private final StreamStats stats;
    private FileFetcher fileFetcher;

    public AdminServiceRequestHandler(ErrorCodeMapper errorCodeMapper, StorageService storageService, StoreRepository storeRepository, MetadataStore metadataStore, VoldemortConfig voldemortConfig, AsyncOperationService asyncService, Rebalancer rebalancer, StreamStats stats) {
        this.errorCodeMapper = errorCodeMapper;
        this.storageService = storageService;
        this.metadataStore = metadataStore;
        this.storeRepository = storeRepository;
        this.voldemortConfig = voldemortConfig;
        this.networkClassLoader = new NetworkClassLoader(Thread.currentThread().getContextClassLoader());
        this.asyncService = asyncService;
        this.rebalancer = rebalancer;
        this.stats = stats;
        this.setFetcherClass(voldemortConfig);
    }

    private void setFetcherClass(VoldemortConfig voldemortConfig) {
        if (voldemortConfig != null) {
            String className = voldemortConfig.getAllProps().getString("file.fetcher.class", null);
            if (className == null || className.trim().length() == 0) {
                this.fileFetcher = null;
            } else {
                try {
                    logger.info((Object)("Loading fetcher " + className));
                    Class<?> cls = Class.forName(className.trim());
                    this.fileFetcher = (FileFetcher)ReflectUtils.callConstructor(cls, new Class[]{VoldemortConfig.class, this.storageService.getDynThrottleLimit().getClass()}, new Object[]{voldemortConfig, this.storageService.getDynThrottleLimit()});
                }
                catch (Exception e) {
                    throw new VoldemortException("Error loading file fetcher class " + className, e);
                }
            }
        } else {
            this.fileFetcher = null;
        }
    }

    @Override
    public StreamRequestHandler handleRequest(DataInputStream inputStream, DataOutputStream outputStream) throws IOException {
        VAdminProto.VoldemortAdminRequest.Builder request = VAdminProto.VoldemortAdminRequest.newBuilder();
        int size = inputStream.readInt();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("In handleRequest, request specified size of " + size + " bytes"));
        }
        if (size < 0) {
            throw new IOException("In handleRequest, request specified size of " + size + " bytes");
        }
        byte[] input = new byte[size];
        ByteUtils.read(inputStream, input);
        request.mergeFrom(input);
        switch (request.getType()) {
            case GET_METADATA: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleGetMetadata(request.getGetMetadata()));
                break;
            }
            case UPDATE_METADATA: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleUpdateMetadata(request.getUpdateMetadata()));
                break;
            }
            case DELETE_PARTITION_ENTRIES: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleDeletePartitionEntries(request.getDeletePartitionEntries()));
                break;
            }
            case FETCH_PARTITION_ENTRIES: {
                return this.handleFetchPartitionEntries(request.getFetchPartitionEntries());
            }
            case UPDATE_PARTITION_ENTRIES: {
                return this.handleUpdatePartitionEntries(request.getUpdatePartitionEntries());
            }
            case INITIATE_FETCH_AND_UPDATE: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleFetchAndUpdate(request.getInitiateFetchAndUpdate()));
                break;
            }
            case ASYNC_OPERATION_STATUS: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleAsyncStatus(request.getAsyncOperationStatus()));
                break;
            }
            case INITIATE_REBALANCE_NODE: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleRebalanceNode(request.getInitiateRebalanceNode()));
                break;
            }
            case INITIATE_REBALANCE_NODE_ON_DONOR: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleRebalanceNodeOnDonor(request.getInitiateRebalanceNodeOnDonor()));
                break;
            }
            case ASYNC_OPERATION_LIST: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleAsyncOperationList(request.getAsyncOperationList()));
                break;
            }
            case ASYNC_OPERATION_STOP: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleAsyncOperationStop(request.getAsyncOperationStop()));
                break;
            }
            case TRUNCATE_ENTRIES: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleTruncateEntries(request.getTruncateEntries()));
                break;
            }
            case ADD_STORE: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleAddStore(request.getAddStore()));
                break;
            }
            case DELETE_STORE: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleDeleteStore(request.getDeleteStore()));
                break;
            }
            case FETCH_STORE: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleFetchStore(request.getFetchStore()));
                break;
            }
            case SWAP_STORE: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleSwapStore(request.getSwapStore()));
                break;
            }
            case ROLLBACK_STORE: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleRollbackStore(request.getRollbackStore()));
                break;
            }
            case GET_RO_MAX_VERSION_DIR: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleGetROMaxVersionDir(request.getGetRoMaxVersionDir()));
                break;
            }
            case GET_RO_CURRENT_VERSION_DIR: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleGetROCurrentVersionDir(request.getGetRoCurrentVersionDir()));
                break;
            }
            case GET_RO_STORAGE_FORMAT: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleGetROStorageFormat(request.getGetRoStorageFormat()));
                break;
            }
            case FETCH_PARTITION_FILES: {
                return this.handleFetchPartitionFiles(request.getFetchPartitionFiles());
            }
            case UPDATE_SLOP_ENTRIES: {
                return this.handleUpdateSlopEntries(request.getUpdateSlopEntries());
            }
            case FAILED_FETCH_STORE: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleFailedFetch(request.getFailedFetchStore()));
                break;
            }
            case REBALANCE_STATE_CHANGE: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleRebalanceStateChange(request.getRebalanceStateChange()));
                break;
            }
            case DELETE_STORE_REBALANCE_STATE: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleDeleteStoreRebalanceState(request.getDeleteStoreRebalanceState()));
                break;
            }
            case REPAIR_JOB: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleRepairJob(request.getRepairJob()));
                break;
            }
            case NATIVE_BACKUP: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleNativeBackup(request.getNativeBackup()));
                break;
            }
            case RESERVE_MEMORY: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleReserveMemory(request.getReserveMemory()));
                break;
            }
            default: {
                throw new VoldemortException("Unkown operation " + (Object)((Object)request.getType()));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VAdminProto.DeleteStoreRebalanceStateResponse handleDeleteStoreRebalanceState(VAdminProto.DeleteStoreRebalanceStateRequest request) {
        VAdminProto.DeleteStoreRebalanceStateResponse.Builder response = VAdminProto.DeleteStoreRebalanceStateResponse.newBuilder();
        Rebalancer rebalancer = this.rebalancer;
        synchronized (rebalancer) {
            try {
                int nodeId = request.getNodeId();
                String storeName = request.getStoreName();
                logger.info((Object)("Removing rebalancing state for donor node " + nodeId + " and store " + storeName + " from stealer node " + this.metadataStore.getNodeId()));
                RebalancePartitionsInfo info = this.metadataStore.getRebalancerState().find(nodeId);
                if (info == null) {
                    throw new VoldemortException("Could not find state for donor node " + nodeId);
                }
                HashMap<Integer, List<Integer>> replicaToPartition = info.getReplicaToAddPartitionList(storeName);
                if (replicaToPartition == null) {
                    throw new VoldemortException("Could not find state for donor node " + nodeId + " and store " + storeName);
                }
                info.removeStore(storeName);
                logger.info((Object)("Removed rebalancing state for donor node " + nodeId + " and store " + storeName + " from stealer node " + this.metadataStore.getNodeId()));
                if (info.getUnbalancedStoreList().isEmpty()) {
                    this.metadataStore.deleteRebalancingState(info);
                    logger.info((Object)("Removed entire rebalancing state for donor node " + nodeId + " from stealer node " + this.metadataStore.getNodeId()));
                }
            }
            catch (VoldemortException e) {
                response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
                logger.error((Object)("handleDeleteStoreRebalanceState failed for request(" + request.toString() + ")"), (Throwable)e);
            }
        }
        return response.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VAdminProto.RebalanceStateChangeResponse handleRebalanceStateChange(VAdminProto.RebalanceStateChangeRequest request) {
        VAdminProto.RebalanceStateChangeResponse.Builder response = VAdminProto.RebalanceStateChangeResponse.newBuilder();
        Rebalancer rebalancer = this.rebalancer;
        synchronized (rebalancer) {
            try {
                ArrayList rebalancePartitionsInfo = Lists.newArrayList();
                for (VAdminProto.RebalancePartitionInfoMap map : request.getRebalancePartitionInfoListList()) {
                    rebalancePartitionsInfo.add(ProtoUtils.decodeRebalancePartitionInfoMap(map));
                }
                Cluster cluster = new ClusterMapper().readCluster(new StringReader(request.getClusterString()));
                boolean swapRO = request.getSwapRo();
                boolean changeClusterMetadata = request.getChangeClusterMetadata();
                boolean changeRebalanceState = request.getChangeRebalanceState();
                boolean rollback = request.getRollback();
                this.rebalancer.rebalanceStateChange(cluster, rebalancePartitionsInfo, swapRO, changeClusterMetadata, changeRebalanceState, rollback);
            }
            catch (VoldemortException e) {
                response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
                logger.error((Object)("handleRebalanceStateChange failed for request(" + request.toString() + ")"), (Throwable)e);
            }
        }
        return response.build();
    }

    public VAdminProto.AsyncOperationStatusResponse handleRebalanceNodeOnDonor(VAdminProto.InitiateRebalanceNodeOnDonorRequest request) {
        VAdminProto.AsyncOperationStatusResponse.Builder response = VAdminProto.AsyncOperationStatusResponse.newBuilder();
        try {
            if (!this.voldemortConfig.isEnableRebalanceService()) {
                throw new VoldemortException("Rebalance service is not enabled for node: " + this.metadataStore.getNodeId());
            }
            List<RebalancePartitionsInfo> rebalanceStealInfos = ProtoUtils.decodeRebalancePartitionInfoMap(request.getRebalancePartitionInfoList());
            RebalanceUtils.assertSameDonor(rebalanceStealInfos, this.metadataStore.getNodeId());
            int requestId = this.rebalancer.rebalanceNodeOnDonor(rebalanceStealInfos);
            response.setRequestId(requestId).setDescription(rebalanceStealInfos.toString()).setStatus("Started rebalancing on donor").setComplete(false);
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleRebalanceNodeOnDonor failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    public VAdminProto.AsyncOperationStatusResponse handleRebalanceNode(VAdminProto.InitiateRebalanceNodeRequest request) {
        VAdminProto.AsyncOperationStatusResponse.Builder response = VAdminProto.AsyncOperationStatusResponse.newBuilder();
        try {
            if (!this.voldemortConfig.isEnableRebalanceService()) {
                throw new VoldemortException("Rebalance service is not enabled for node: " + this.metadataStore.getNodeId());
            }
            if (!this.metadataStore.getServerState().equals((Object)MetadataStore.VoldemortState.REBALANCING_MASTER_SERVER)) {
                response.setError(ProtoUtils.encodeError(this.errorCodeMapper, new VoldemortException("Voldemort server " + this.metadataStore.getNodeId() + " not in rebalancing state")));
                return response.build();
            }
            RebalancePartitionsInfo rebalanceStealInfo = ProtoUtils.decodeRebalancePartitionInfoMap(request.getRebalancePartitionInfo());
            int requestId = this.rebalancer.rebalanceNode(rebalanceStealInfo);
            response.setRequestId(requestId).setDescription(rebalanceStealInfo.toString()).setStatus("Started rebalancing").setComplete(false);
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleRebalanceNode failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    public VAdminProto.GetROCurrentVersionDirResponse handleGetROCurrentVersionDir(VAdminProto.GetROCurrentVersionDirRequest request) {
        List<String> storeNames = request.getStoreNameList();
        VAdminProto.GetROCurrentVersionDirResponse.Builder response = VAdminProto.GetROCurrentVersionDirResponse.newBuilder();
        try {
            for (String storeName : storeNames) {
                ReadOnlyStorageEngine store = AdminServiceRequestHandler.getReadOnlyStorageEngine(this.metadataStore, this.storeRepository, storeName);
                VAdminProto.ROStoreVersionDirMap storeResponse = VAdminProto.ROStoreVersionDirMap.newBuilder().setStoreName(storeName).setStoreDir(store.getCurrentDirPath()).build();
                response.addRoStoreVersions(storeResponse);
            }
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleGetROCurrentVersion failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    public VAdminProto.GetROMaxVersionDirResponse handleGetROMaxVersionDir(VAdminProto.GetROMaxVersionDirRequest request) {
        List<String> storeNames = request.getStoreNameList();
        VAdminProto.GetROMaxVersionDirResponse.Builder response = VAdminProto.GetROMaxVersionDirResponse.newBuilder();
        try {
            for (String storeName : storeNames) {
                ReadOnlyStorageEngine store = AdminServiceRequestHandler.getReadOnlyStorageEngine(this.metadataStore, this.storeRepository, storeName);
                File storeDirPath = new File(store.getStoreDirPath());
                if (!storeDirPath.exists()) {
                    throw new VoldemortException("Unable to locate the directory of the read-only store " + storeName);
                }
                File[] versionDirs = ReadOnlyUtils.getVersionDirs(storeDirPath);
                File[] kthDir = ReadOnlyUtils.findKthVersionedDir(versionDirs, versionDirs.length - 1, versionDirs.length - 1);
                VAdminProto.ROStoreVersionDirMap storeResponse = VAdminProto.ROStoreVersionDirMap.newBuilder().setStoreName(storeName).setStoreDir(kthDir[0].getAbsolutePath()).build();
                response.addRoStoreVersions(storeResponse);
            }
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleGetROMaxVersion failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    public VAdminProto.GetROStorageFormatResponse handleGetROStorageFormat(VAdminProto.GetROStorageFormatRequest request) {
        List<String> storeNames = request.getStoreNameList();
        VAdminProto.GetROStorageFormatResponse.Builder response = VAdminProto.GetROStorageFormatResponse.newBuilder();
        try {
            for (String storeName : storeNames) {
                ReadOnlyStorageEngine store = AdminServiceRequestHandler.getReadOnlyStorageEngine(this.metadataStore, this.storeRepository, storeName);
                VAdminProto.ROStoreVersionDirMap storeResponse = VAdminProto.ROStoreVersionDirMap.newBuilder().setStoreName(storeName).setStoreDir(store.getReadOnlyStorageFormat().getCode()).build();
                response.addRoStoreVersions(storeResponse);
            }
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleGetROStorageFormat failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    public VAdminProto.FailedFetchStoreResponse handleFailedFetch(VAdminProto.FailedFetchStoreRequest request) {
        String storeDir = request.getStoreDir();
        String storeName = request.getStoreName();
        VAdminProto.FailedFetchStoreResponse.Builder response = VAdminProto.FailedFetchStoreResponse.newBuilder();
        try {
            if (!Utils.isReadableDir(storeDir)) {
                throw new VoldemortException("Could not read folder " + storeDir + " correctly to delete it");
            }
            ReadOnlyStorageEngine store = AdminServiceRequestHandler.getReadOnlyStorageEngine(this.metadataStore, this.storeRepository, storeName);
            if (store.getCurrentVersionId() == ReadOnlyUtils.getVersionId(new File(storeDir))) {
                logger.warn((Object)("Cannot delete " + storeDir + " for " + storeName + " since it is the current dir"));
                return response.build();
            }
            logger.info((Object)("Deleting data from failed fetch for RO store '" + storeName + "' and directory '" + storeDir + "'"));
            Utils.rm(new File(storeDir));
            logger.info((Object)("Successfully deleted data from failed fetch for RO store '" + storeName + "' and directory '" + storeDir + "'"));
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleFailedFetch failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    public StreamRequestHandler handleFetchPartitionFiles(VAdminProto.FetchPartitionFilesRequest request) {
        return new FetchPartitionFileStreamRequestHandler(request, this.metadataStore, this.voldemortConfig, this.storeRepository, this.stats);
    }

    public StreamRequestHandler handleUpdateSlopEntries(VAdminProto.UpdateSlopEntriesRequest request) {
        return new UpdateSlopEntriesRequestHandler(request, this.errorCodeMapper, this.storeRepository, this.stats);
    }

    public StreamRequestHandler handleFetchPartitionEntries(VAdminProto.FetchPartitionEntriesRequest request) {
        boolean fetchValues;
        boolean bl = fetchValues = request.hasFetchValues() && request.getFetchValues();
        if (fetchValues) {
            return new FetchEntriesStreamRequestHandler(request, this.metadataStore, this.errorCodeMapper, this.voldemortConfig, this.storeRepository, this.networkClassLoader, this.stats);
        }
        return new FetchKeysStreamRequestHandler(request, this.metadataStore, this.errorCodeMapper, this.voldemortConfig, this.storeRepository, this.networkClassLoader, this.stats);
    }

    public StreamRequestHandler handleUpdatePartitionEntries(VAdminProto.UpdatePartitionEntriesRequest request) {
        return new UpdatePartitionEntriesStreamRequestHandler(request, this.errorCodeMapper, this.voldemortConfig, this.storeRepository, this.networkClassLoader, this.stats);
    }

    public VAdminProto.AsyncOperationListResponse handleAsyncOperationList(VAdminProto.AsyncOperationListRequest request) {
        VAdminProto.AsyncOperationListResponse.Builder response = VAdminProto.AsyncOperationListResponse.newBuilder();
        boolean showComplete = request.getShowComplete();
        try {
            logger.info((Object)("Retrieving list of async operations " + (showComplete ? " [ including completed ids ]" : "")));
            List<Integer> asyncIds = this.asyncService.getAsyncOperationList(showComplete);
            logger.info((Object)("Retrieved list of async operations - " + asyncIds));
            response.addAllRequestIds(asyncIds);
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleAsyncOperationList failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    public VAdminProto.AsyncOperationStopResponse handleAsyncOperationStop(VAdminProto.AsyncOperationStopRequest request) {
        VAdminProto.AsyncOperationStopResponse.Builder response = VAdminProto.AsyncOperationStopResponse.newBuilder();
        int requestId = request.getRequestId();
        try {
            logger.info((Object)("Stopping async id " + requestId));
            this.asyncService.stopOperation(requestId);
            logger.info((Object)("Successfully stopped async id " + requestId));
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleAsyncOperationStop failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    public VAdminProto.RollbackStoreResponse handleRollbackStore(VAdminProto.RollbackStoreRequest request) {
        String storeName = request.getStoreName();
        long pushVersion = request.getPushVersion();
        VAdminProto.RollbackStoreResponse.Builder response = VAdminProto.RollbackStoreResponse.newBuilder();
        try {
            ReadOnlyStorageEngine store = AdminServiceRequestHandler.getReadOnlyStorageEngine(this.metadataStore, this.storeRepository, storeName);
            File rollbackVersionDir = new File(store.getStoreDirPath(), "version-" + pushVersion);
            logger.info((Object)("Rolling back data for RO store '" + storeName + "' to version directory '" + rollbackVersionDir + "'"));
            store.rollback(rollbackVersionDir);
            logger.info((Object)("Successfully rolled back data for RO store '" + storeName + "' to version directory '" + rollbackVersionDir + "'"));
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleRollbackStore failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    public VAdminProto.RepairJobResponse handleRepairJob(VAdminProto.RepairJobRequest request) {
        VAdminProto.RepairJobResponse.Builder response = VAdminProto.RepairJobResponse.newBuilder();
        try {
            int requestId = this.asyncService.getUniqueRequestId();
            this.asyncService.submitOperation(requestId, new AsyncOperation(requestId, "Repair Job"){

                public void operate() {
                    RepairJob job = AdminServiceRequestHandler.this.storeRepository.getRepairJob();
                    if (job != null) {
                        logger.info((Object)("Starting the repair job now on ID : " + AdminServiceRequestHandler.this.metadataStore.getNodeId()));
                        job.run();
                    } else {
                        logger.error((Object)"RepairJob is not initialized.");
                    }
                }

                public void stop() {
                    this.status.setException(new VoldemortException("Repair job interrupted"));
                }
            });
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("Repair job failed for request : " + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    private String swapStore(String storeName, String directory) throws VoldemortException {
        ReadOnlyStorageEngine store = AdminServiceRequestHandler.getReadOnlyStorageEngine(this.metadataStore, this.storeRepository, storeName);
        if (!Utils.isReadableDir(directory)) {
            throw new VoldemortException("Store directory '" + directory + "' is not a readable directory.");
        }
        String currentDirPath = store.getCurrentDirPath();
        logger.info((Object)("Swapping RO store '" + storeName + "' to version directory '" + directory + "'"));
        store.swapFiles(directory);
        logger.info((Object)("Swapping swapped RO store '" + storeName + "' to version directory '" + directory + "'"));
        return currentDirPath;
    }

    public VAdminProto.SwapStoreResponse handleSwapStore(VAdminProto.SwapStoreRequest request) {
        String dir = request.getStoreDir();
        String storeName = request.getStoreName();
        VAdminProto.SwapStoreResponse.Builder response = VAdminProto.SwapStoreResponse.newBuilder();
        if (!this.metadataStore.getServerState().equals((Object)MetadataStore.VoldemortState.NORMAL_SERVER)) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, new VoldemortException("Voldemort server " + this.metadataStore.getNodeId() + " not in normal state while swapping store " + storeName + " with directory " + dir)));
            return response.build();
        }
        try {
            response.setPreviousStoreDir(this.swapStore(storeName, dir));
            return response.build();
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleSwapStore failed for request(" + request.toString() + ")"), (Throwable)e);
            return response.build();
        }
    }

    public VAdminProto.AsyncOperationStatusResponse handleFetchStore(VAdminProto.FetchStoreRequest request) {
        final String fetchUrl = request.getStoreDir();
        final String storeName = request.getStoreName();
        int requestId = this.asyncService.getUniqueRequestId();
        VAdminProto.AsyncOperationStatusResponse.Builder response = VAdminProto.AsyncOperationStatusResponse.newBuilder().setRequestId(requestId).setComplete(false).setDescription("Fetch store").setStatus("started");
        try {
            long pushVersion;
            final ReadOnlyStorageEngine store = AdminServiceRequestHandler.getReadOnlyStorageEngine(this.metadataStore, this.storeRepository, storeName);
            if (request.hasPushVersion()) {
                pushVersion = request.getPushVersion();
                if (pushVersion <= store.getCurrentVersionId()) {
                    throw new VoldemortException("Version of push specified (" + pushVersion + ") should be greater than current version " + store.getCurrentVersionId() + " for store " + storeName + " on node " + this.metadataStore.getNodeId());
                }
            } else {
                File[] storeDirList = ReadOnlyUtils.getVersionDirs(new File(store.getStoreDirPath()));
                if (storeDirList == null || storeDirList.length == 0) {
                    throw new VoldemortException("Push version required since no version folders exist for store " + storeName + " on node " + this.metadataStore.getNodeId());
                }
                long maxVersion = ReadOnlyUtils.getVersionId(ReadOnlyUtils.findKthVersionedDir(storeDirList, storeDirList.length - 1, storeDirList.length - 1)[0]);
                pushVersion = maxVersion + 1L;
            }
            this.asyncService.submitOperation(requestId, new AsyncOperation(requestId, "Fetch store"){
                private String fetchDirPath;
                {
                    super(x0, x1);
                    this.fetchDirPath = null;
                }

                public void markComplete() {
                    if (this.fetchDirPath != null) {
                        this.status.setStatus(this.fetchDirPath);
                    }
                    this.status.setComplete(true);
                }

                public void operate() {
                    File fetchDir = null;
                    if (AdminServiceRequestHandler.this.fileFetcher == null) {
                        logger.warn((Object)"File fetcher class has not instantiated correctly. Assuming local file");
                        if (!Utils.isReadableDir(fetchUrl)) {
                            throw new VoldemortException("Fetch url " + fetchUrl + " is not readable");
                        }
                        fetchDir = new File(store.getStoreDirPath(), "version-" + Long.toString(pushVersion));
                        if (fetchDir.exists()) {
                            throw new VoldemortException("Version directory " + fetchDir.getAbsolutePath() + " already exists");
                        }
                        Utils.move(new File(fetchUrl), fetchDir);
                    } else {
                        logger.info((Object)("Started executing fetch of " + fetchUrl + " for RO store '" + storeName + "'"));
                        this.updateStatus("0 MB copied at 0 MB/sec - 0 % complete");
                        try {
                            AdminServiceRequestHandler.this.fileFetcher.setAsyncOperationStatus(this.status);
                            fetchDir = AdminServiceRequestHandler.this.fileFetcher.fetch(fetchUrl, store.getStoreDirPath() + File.separator + "version-" + Long.toString(pushVersion));
                            if (fetchDir == null) {
                                String errorMessage = "File fetcher failed for " + fetchUrl + " and store '" + storeName + "' due to incorrect input path/checksum error";
                                this.updateStatus(errorMessage);
                                logger.error((Object)errorMessage);
                                throw new VoldemortException(errorMessage);
                            }
                            String message = "Successfully executed fetch of " + fetchUrl + " for RO store '" + storeName + "'";
                            this.updateStatus(message);
                            logger.info((Object)message);
                        }
                        catch (VoldemortException ve) {
                            String errorMessage = "File fetcher failed for " + fetchUrl + " and store '" + storeName + "' due to too many push jobs happening at the same time.";
                            this.updateStatus(errorMessage);
                            logger.error((Object)errorMessage);
                            throw new VoldemortException(errorMessage);
                        }
                        catch (Exception e) {
                            throw new VoldemortException("Exception in Fetcher = " + e.getMessage());
                        }
                    }
                    this.fetchDirPath = fetchDir.getAbsolutePath();
                }

                public void stop() {
                    this.status.setException(new VoldemortException("Fetcher interrupted"));
                }
            });
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleFetchStore failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    public VAdminProto.AsyncOperationStatusResponse handleFetchAndUpdate(VAdminProto.InitiateFetchAndUpdateRequest request) {
        final int nodeId = request.getNodeId();
        final HashMap<Integer, List<Integer>> replicaToPartitionList = ProtoUtils.decodePartitionTuple(request.getReplicaToPartitionList());
        final DefaultVoldemortFilter filter = request.hasFilter() ? AdminServiceRequestHandler.getFilterFromRequest(request.getFilter(), this.voldemortConfig, this.networkClassLoader) : new DefaultVoldemortFilter();
        final String storeName = request.getStore();
        final boolean optimize = request.hasOptimize() ? request.getOptimize() : false;
        final Cluster initialCluster = request.hasInitialCluster() ? new ClusterMapper().readCluster(new StringReader(request.getInitialCluster())) : null;
        int requestId = this.asyncService.getUniqueRequestId();
        VAdminProto.AsyncOperationStatusResponse.Builder response = VAdminProto.AsyncOperationStatusResponse.newBuilder().setRequestId(requestId).setComplete(false).setDescription("Fetch and update").setStatus("Started");
        final StoreDefinition storeDef = this.metadataStore.getStoreDef(storeName);
        final boolean isReadOnlyStore = storeDef.getType().compareTo("read-only") == 0;
        try {
            this.asyncService.submitOperation(requestId, new AsyncOperation(requestId, "Fetch and Update"){
                private final AtomicBoolean running;
                {
                    super(x0, x1);
                    this.running = new AtomicBoolean(true);
                }

                public void stop() {
                    this.running.set(false);
                    logger.info((Object)("Stopping fetch and update for store " + storeName + " from node " + nodeId + "( " + replicaToPartitionList + " )"));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operate() {
                    AdminClient adminClient = RebalanceUtils.createTempAdminClient(AdminServiceRequestHandler.this.voldemortConfig, AdminServiceRequestHandler.this.metadataStore.getCluster(), AdminServiceRequestHandler.this.voldemortConfig.getClientMaxConnectionsPerNode());
                    try {
                        StorageEngine<ByteArray, byte[], byte[]> storageEngine = AdminServiceRequestHandler.getStorageEngine(AdminServiceRequestHandler.this.storeRepository, storeName);
                        EventThrottler throttler = new EventThrottler(AdminServiceRequestHandler.this.voldemortConfig.getStreamMaxWriteBytesPerSec());
                        if (isReadOnlyStore) {
                            ReadOnlyStorageEngine readOnlyStorageEngine = (ReadOnlyStorageEngine)storageEngine;
                            String destinationDir = readOnlyStorageEngine.getCurrentDirPath();
                            logger.info((Object)("Fetching files for RO store '" + storeName + "' from node " + nodeId + " ( " + replicaToPartitionList + " )"));
                            this.updateStatus("Fetching files for RO store '" + storeName + "' from node " + nodeId + " ( " + replicaToPartitionList + " )");
                            adminClient.fetchPartitionFiles(nodeId, storeName, replicaToPartitionList, destinationDir, readOnlyStorageEngine.getChunkedFileSet().getChunkIdToNumChunks().keySet(), this.running);
                        } else {
                            logger.info((Object)("Fetching entries for RW store '" + storeName + "' from node " + nodeId + " ( " + replicaToPartitionList + " )"));
                            this.updateStatus("Fetching entries for RW store '" + storeName + "' from node " + nodeId + " ( " + replicaToPartitionList + " ) ");
                            HashMap optimizedReplicaToPartitionList = Maps.newHashMap();
                            if (initialCluster != null && optimize && !storageEngine.isPartitionAware() && AdminServiceRequestHandler.this.voldemortConfig.getRebalancingOptimization()) {
                                optimizedReplicaToPartitionList.putAll(RebalanceUtils.getOptimizedReplicaToPartitionList(AdminServiceRequestHandler.this.metadataStore.getNodeId(), initialCluster, storeDef, replicaToPartitionList));
                                logger.info((Object)("After running RW level optimization - Fetching entries for RW store '" + storeName + "' from node " + nodeId + " ( " + optimizedReplicaToPartitionList + " )"));
                                this.updateStatus("After running RW level optimization - Fetching entries for RW store '" + storeName + "' from node " + nodeId + " ( " + optimizedReplicaToPartitionList + " )");
                            } else {
                                optimizedReplicaToPartitionList.putAll(replicaToPartitionList);
                            }
                            if (optimizedReplicaToPartitionList.size() > 0) {
                                Iterator<Pair<ByteArray, Versioned<byte[]>>> entriesIterator = adminClient.fetchEntries(nodeId, storeName, optimizedReplicaToPartitionList, filter, false, initialCluster, 0L);
                                long numTuples = 0L;
                                long startTime = System.currentTimeMillis();
                                while (this.running.get() && entriesIterator.hasNext()) {
                                    Pair<ByteArray, Versioned<byte[]>> entry = entriesIterator.next();
                                    ByteArray key = entry.getFirst();
                                    Versioned<byte[]> value = entry.getSecond();
                                    try {
                                        storageEngine.put(key, value, null);
                                    }
                                    catch (ObsoleteVersionException e) {
                                        logger.debug((Object)"Fetch and update threw Obsolete version exception. Ignoring");
                                    }
                                    long totalTime = (System.currentTimeMillis() - startTime) / 1000L;
                                    throttler.maybeThrottle(key.length() + AdminServiceRequestHandler.valueSize(value));
                                    if (numTuples % 100000L == 0L && numTuples > 0L) {
                                        logger.info((Object)(numTuples + " entries copied from node " + nodeId + " for store '" + storeName + "'c"));
                                        this.updateStatus(numTuples + " entries copied from node " + nodeId + " for store '" + storeName + "' in " + totalTime + " seconds");
                                    }
                                    ++numTuples;
                                }
                                long totalTime = (System.currentTimeMillis() - startTime) / 1000L;
                                if (this.running.get()) {
                                    logger.info((Object)("Completed fetching " + numTuples + " entries from node " + nodeId + " for store '" + storeName + "' in " + totalTime + " seconds"));
                                } else {
                                    logger.info((Object)("Fetch and update stopped after fetching " + numTuples + " entries for node " + nodeId + " for store '" + storeName + "' in " + totalTime + " seconds"));
                                }
                            } else {
                                logger.info((Object)("No entries to fetch from node " + nodeId + " for store '" + storeName + "'"));
                            }
                        }
                        Object var16_16 = null;
                        adminClient.stop();
                    }
                    catch (Throwable throwable) {
                        Object var16_17 = null;
                        adminClient.stop();
                        throw throwable;
                    }
                }
            });
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleFetchAndUpdate failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    public VAdminProto.AsyncOperationStatusResponse handleAsyncStatus(VAdminProto.AsyncOperationStatusRequest request) {
        VAdminProto.AsyncOperationStatusResponse.Builder response = VAdminProto.AsyncOperationStatusResponse.newBuilder();
        try {
            int requestId = request.getRequestId();
            AsyncOperationStatus operationStatus = this.asyncService.getOperationStatus(requestId);
            boolean requestComplete = this.asyncService.isComplete(requestId);
            response.setDescription(operationStatus.getDescription());
            response.setComplete(requestComplete);
            response.setStatus(operationStatus.getStatus());
            response.setRequestId(requestId);
            if (operationStatus.hasException()) {
                throw new VoldemortException(operationStatus.getException());
            }
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleAsyncStatus failed for request(" + request.toString().trim() + ")"), (Throwable)e);
        }
        return response.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VAdminProto.DeletePartitionEntriesResponse handleDeletePartitionEntries(VAdminProto.DeletePartitionEntriesRequest request) {
        VAdminProto.DeletePartitionEntriesResponse.Builder response = VAdminProto.DeletePartitionEntriesResponse.newBuilder();
        ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> iterator = null;
        try {
            try {
                boolean isReadWriteStore;
                String storeName = request.getStore();
                HashMap<Integer, List<Integer>> replicaToPartitionList = ProtoUtils.decodePartitionTuple(request.getReplicaToPartitionList());
                boolean bl = isReadWriteStore = this.metadataStore.getStoreDef(storeName).getType().compareTo("read-only") != 0;
                if (!isReadWriteStore) {
                    throw new VoldemortException("Cannot delete partitions for store " + storeName + " on node " + this.metadataStore.getNodeId() + " since it is not a RW store");
                }
                StorageEngine<ByteArray, byte[], byte[]> storageEngine = AdminServiceRequestHandler.getStorageEngine(this.storeRepository, storeName);
                DefaultVoldemortFilter filter = request.hasFilter() ? AdminServiceRequestHandler.getFilterFromRequest(request.getFilter(), this.voldemortConfig, this.networkClassLoader) : new DefaultVoldemortFilter();
                EventThrottler throttler = new EventThrottler(this.voldemortConfig.getStreamMaxReadBytesPerSec());
                iterator = storageEngine.entries();
                long deleteSuccess = 0L;
                logger.info((Object)("Deleting entries for RW store " + storeName + " from node " + this.metadataStore.getNodeId() + " ( " + replicaToPartitionList + " )"));
                while (iterator.hasNext()) {
                    Pair entry = (Pair)iterator.next();
                    ByteArray key = (ByteArray)entry.getFirst();
                    Versioned value = (Versioned)entry.getSecond();
                    throttler.maybeThrottle(key.length() + AdminServiceRequestHandler.valueSize(value));
                    if (!RebalanceUtils.checkKeyBelongsToPartition(this.metadataStore.getNodeId(), key.get(), replicaToPartitionList, request.hasInitialCluster() ? new ClusterMapper().readCluster(new StringReader(request.getInitialCluster())) : this.metadataStore.getCluster(), this.metadataStore.getStoreDef(storeName)) || !filter.accept(key, value) || !storageEngine.delete(key, value.getVersion()) || ++deleteSuccess % 10000L != 0L) continue;
                    logger.info((Object)(deleteSuccess + " entries deleted from node " + this.metadataStore.getNodeId() + " for store " + storeName));
                }
                logger.info((Object)("Completed deletion of entries for RW store " + storeName + " from node " + this.metadataStore.getNodeId() + " ( " + replicaToPartitionList + " )"));
                response.setCount(deleteSuccess);
            }
            catch (VoldemortException e) {
                response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
                logger.error((Object)("handleDeletePartitionEntries failed for request(" + request.toString() + ")"), (Throwable)e);
                Object var16_16 = null;
                if (null != iterator) {
                    iterator.close();
                }
            }
            Object var16_15 = null;
            if (null != iterator) {
                iterator.close();
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            if (null != iterator) {
                iterator.close();
            }
            throw throwable;
        }
        return response.build();
    }

    public VAdminProto.UpdateMetadataResponse handleUpdateMetadata(VAdminProto.UpdateMetadataRequest request) {
        VAdminProto.UpdateMetadataResponse.Builder response = VAdminProto.UpdateMetadataResponse.newBuilder();
        try {
            ByteArray key = ProtoUtils.decodeBytes(request.getKey());
            String keyString = ByteUtils.getString(key.get(), "UTF-8");
            if (MetadataStore.METADATA_KEYS.contains(keyString)) {
                Versioned<byte[]> versionedValue = ProtoUtils.decodeVersioned(request.getVersioned());
                logger.info((Object)("Updating metadata for key '" + keyString + "'"));
                this.metadataStore.put(new ByteArray(ByteUtils.getBytes(keyString, "UTF-8")), versionedValue, null);
                logger.info((Object)("Successfully updated metadata for key '" + keyString + "'"));
            }
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleUpdateMetadata failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    public VAdminProto.GetMetadataResponse handleGetMetadata(VAdminProto.GetMetadataRequest request) {
        VAdminProto.GetMetadataResponse.Builder response;
        block4: {
            response = VAdminProto.GetMetadataResponse.newBuilder();
            try {
                ByteArray key = ProtoUtils.decodeBytes(request.getKey());
                String keyString = ByteUtils.getString(key.get(), "UTF-8");
                if (MetadataStore.METADATA_KEYS.contains(keyString)) {
                    int size;
                    List<Versioned<byte[]>> versionedList = this.metadataStore.get(key, null);
                    int n = size = versionedList.size() > 0 ? 1 : 0;
                    if (size > 0) {
                        Versioned<byte[]> versioned = versionedList.get(0);
                        response.setVersion(ProtoUtils.encodeVersioned(versioned));
                    }
                    break block4;
                }
                throw new VoldemortException("Metadata Key passed '" + keyString + "' is not handled yet");
            }
            catch (VoldemortException e) {
                response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
                logger.error((Object)("handleGetMetadata failed for request(" + request.toString() + ")"), (Throwable)e);
            }
        }
        return response.build();
    }

    public VAdminProto.TruncateEntriesResponse handleTruncateEntries(VAdminProto.TruncateEntriesRequest request) {
        VAdminProto.TruncateEntriesResponse.Builder response = VAdminProto.TruncateEntriesResponse.newBuilder();
        try {
            String storeName = request.getStore();
            StorageEngine<ByteArray, byte[], byte[]> storageEngine = AdminServiceRequestHandler.getStorageEngine(this.storeRepository, storeName);
            logger.info((Object)("Truncating data for store '" + storeName + "'"));
            storageEngine.truncate();
            logger.info((Object)("Successfully truncated data for store '" + storeName + "'"));
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleTruncateEntries failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VAdminProto.DeleteStoreResponse handleDeleteStore(VAdminProto.DeleteStoreRequest request) {
        VAdminProto.DeleteStoreResponse.Builder response = VAdminProto.DeleteStoreResponse.newBuilder();
        if (!this.metadataStore.getServerState().equals((Object)MetadataStore.VoldemortState.NORMAL_SERVER)) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, new VoldemortException("Voldemort server is not in normal state")));
            return response.build();
        }
        try {
            String storeName = request.getStoreName();
            Object object = lock;
            synchronized (object) {
                if (this.storeRepository.hasLocalStore(storeName)) {
                    if (storeName.compareTo("slop") == 0) {
                        this.storageService.unregisterEngine(this.storeRepository.getStorageEngine(storeName), false, "slop");
                    } else {
                        List<StoreDefinition> oldStoreDefList = this.metadataStore.getStoreDefList();
                        ArrayList<StoreDefinition> newStoreDefList = new ArrayList<StoreDefinition>();
                        for (StoreDefinition storeDef : oldStoreDefList) {
                            boolean isReadOnly;
                            boolean bl = isReadOnly = storeDef.getType().compareTo("read-only") == 0;
                            if (storeDef.isView()) {
                                if (storeDef.getViewTargetStoreName().compareTo(storeName) != 0) {
                                    newStoreDefList.add(storeDef);
                                    continue;
                                }
                                logger.info((Object)("Deleting view '" + storeDef.getName() + "'"));
                                this.storageService.unregisterEngine(this.storeRepository.getStorageEngine(storeDef.getName()), isReadOnly, storeDef.getType());
                                logger.info((Object)("Successfully deleted view '" + storeDef.getName() + "'"));
                                continue;
                            }
                            if (storeDef.getName().compareTo(storeName) != 0) {
                                newStoreDefList.add(storeDef);
                                continue;
                            }
                            logger.info((Object)("Deleting store '" + storeDef.getName() + "'"));
                            this.storageService.unregisterEngine(this.storeRepository.getStorageEngine(storeDef.getName()), isReadOnly, storeDef.getType());
                            logger.info((Object)("Successfully deleted store '" + storeDef.getName() + "'"));
                        }
                        try {
                            this.metadataStore.put("stores.xml", newStoreDefList);
                        }
                        catch (Exception e) {
                            throw new VoldemortException(e);
                        }
                    }
                } else {
                    throw new StoreOperationFailureException(String.format("Store '%s' does not exist on this server", storeName));
                }
            }
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleDeleteStore failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VAdminProto.AddStoreResponse handleAddStore(VAdminProto.AddStoreRequest request) {
        VAdminProto.AddStoreResponse.Builder response = VAdminProto.AddStoreResponse.newBuilder();
        if (!this.metadataStore.getServerState().equals((Object)MetadataStore.VoldemortState.NORMAL_SERVER)) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, new VoldemortException("Voldemort server is not in normal state")));
            return response.build();
        }
        try {
            StoreDefinitionsMapper mapper = new StoreDefinitionsMapper();
            StoreDefinition def = mapper.readStore(new StringReader(request.getStoreDefinition()));
            Object object = lock;
            synchronized (object) {
                if (!this.storeRepository.hasLocalStore(def.getName())) {
                    List<Object> currentStoreDefs;
                    if (def.getReplicationFactor() > this.metadataStore.getCluster().getNumberOfNodes()) {
                        throw new StoreOperationFailureException("Cannot add a store whose replication factor ( " + def.getReplicationFactor() + " ) is greater than the number of nodes ( " + this.metadataStore.getCluster().getNumberOfNodes() + " )");
                    }
                    logger.info((Object)("Adding new store '" + def.getName() + "'"));
                    this.storageService.openStore(def);
                    List<Versioned<byte[]>> v = this.metadataStore.get("stores.xml", null);
                    if ((v.size() > 0 ? 1 : 0) > 0) {
                        Versioned<byte[]> currentValue = v.get(0);
                        currentStoreDefs = mapper.readStoreList(new StringReader(ByteUtils.getString(currentValue.getValue(), "UTF-8")));
                    } else {
                        currentStoreDefs = Lists.newArrayList();
                    }
                    currentStoreDefs.add(def);
                    try {
                        this.metadataStore.put("stores.xml", currentStoreDefs);
                    }
                    catch (Exception e) {
                        throw new VoldemortException(e);
                    }
                } else {
                    logger.error((Object)("Failure to add a store with the same name '" + def.getName() + "'"));
                    throw new StoreOperationFailureException(String.format("Store '%s' already exists on this server", def.getName()));
                }
                logger.info((Object)("Successfully added new store '" + def.getName() + "'"));
            }
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleAddStore failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    @Override
    public boolean isCompleteRequest(ByteBuffer buffer) {
        DataInputStream inputStream = new DataInputStream(new ByteBufferBackedInputStream(buffer));
        try {
            int dataSize = inputStream.readInt();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("In isCompleteRequest, dataSize: " + dataSize + ", buffer position: " + buffer.position()));
            }
            if (dataSize == -1) {
                return true;
            }
            buffer.position(buffer.position() + dataSize);
            return true;
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("In isCompleteRequest, probable partial read occurred: " + e));
            }
            return false;
        }
    }

    static VoldemortFilter getFilterFromRequest(VAdminProto.VoldemortFilter request, VoldemortConfig voldemortConfig, NetworkClassLoader networkClassLoader) {
        VoldemortFilter filter = null;
        byte[] classBytes = ProtoUtils.decodeBytes(request.getData()).get();
        String className = request.getName();
        logger.debug((Object)("Attempt to load VoldemortFilter class:" + className));
        try {
            if (voldemortConfig.isNetworkClassLoaderEnabled()) {
                logger.warn((Object)"NetworkLoader is experimental and should not be used for now.");
                Class<?> cl = networkClassLoader.loadClass(className, classBytes, 0, classBytes.length);
                filter = (VoldemortFilter)cl.newInstance();
            } else {
                Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(className);
                filter = (VoldemortFilter)cl.newInstance();
            }
        }
        catch (Exception e) {
            throw new VoldemortException("Failed to load and instantiate the filter class", e);
        }
        return filter;
    }

    static int valueSize(Versioned<byte[]> value) {
        return value.getValue().length + ((VectorClock)value.getVersion()).sizeInBytes() + 1;
    }

    static ReadOnlyStorageEngine getReadOnlyStorageEngine(MetadataStore metadata, StoreRepository repo, String name) {
        StorageEngine<ByteArray, byte[], byte[]> storageEngine = AdminServiceRequestHandler.getStorageEngine(repo, name);
        if (metadata.getStoreDef(name).getType().compareTo("read-only") != 0) {
            throw new VoldemortException("Store " + name + " is not a read-only store, cannot complete operation");
        }
        return (ReadOnlyStorageEngine)storageEngine;
    }

    static StorageEngine<ByteArray, byte[], byte[]> getStorageEngine(StoreRepository storeRepository, String storeName) {
        StorageEngine<ByteArray, byte[], byte[]> storageEngine = storeRepository.getStorageEngine(storeName);
        if (storageEngine == null) {
            throw new VoldemortException("No store named '" + storeName + "'.");
        }
        return storageEngine;
    }

    public VAdminProto.AsyncOperationStatusResponse handleNativeBackup(VAdminProto.NativeBackupRequest request) {
        final File backupDir = new File(request.getBackupDir());
        final boolean isIncremental = request.getIncremental();
        final boolean verifyFiles = request.getVerifyFiles();
        String storeName = request.getStoreName();
        int requestId = this.asyncService.getUniqueRequestId();
        VAdminProto.AsyncOperationStatusResponse.Builder response = VAdminProto.AsyncOperationStatusResponse.newBuilder().setRequestId(requestId).setComplete(false).setDescription("Native backup").setStatus("started");
        try {
            final StorageEngine<ByteArray, byte[], byte[]> storageEngine = AdminServiceRequestHandler.getStorageEngine(this.storeRepository, storeName);
            final long start = System.currentTimeMillis();
            if (storageEngine instanceof NativeBackupable) {
                this.asyncService.submitOperation(requestId, new AsyncOperation(requestId, "Native backup"){

                    public void markComplete() {
                        long end = System.currentTimeMillis();
                        this.status.setStatus("Native backup completed in " + (end - start) + "ms");
                        this.status.setComplete(true);
                    }

                    public void operate() {
                        ((NativeBackupable)((Object)storageEngine)).nativeBackup(backupDir, verifyFiles, isIncremental, this.status);
                    }

                    public void stop() {
                        this.status.setException(new VoldemortException("Fetcher interrupted"));
                    }
                });
            } else {
                response.setError(ProtoUtils.encodeError(this.errorCodeMapper, new VoldemortException("Selected store is not native backupable")));
            }
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleFetchStore failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VAdminProto.ReserveMemoryResponse handleReserveMemory(VAdminProto.ReserveMemoryRequest request) {
        VAdminProto.ReserveMemoryResponse.Builder response = VAdminProto.ReserveMemoryResponse.newBuilder();
        try {
            String storeName = request.getStoreName();
            long reserveMB = request.getSizeInMb();
            Object object = lock;
            synchronized (object) {
                if (this.storeRepository.hasLocalStore(storeName)) {
                    logger.info((Object)("Setting memory foot print of store '" + storeName + "' to " + reserveMB + " MB"));
                    List<StoreDefinition> storeDefList = this.metadataStore.getStoreDefList();
                    for (int i = 0; i < storeDefList.size(); ++i) {
                        StoreDefinition storeDef = storeDefList.get(i);
                        if (storeDef.isView() || !storeDef.getName().equals(storeName)) continue;
                        StoreDefinition newStoreDef = new StoreDefinitionBuilder().setName(storeDef.getName()).setType(storeDef.getType()).setDescription(storeDef.getDescription()).setOwners(storeDef.getOwners()).setKeySerializer(storeDef.getKeySerializer()).setValueSerializer(storeDef.getValueSerializer()).setRoutingPolicy(storeDef.getRoutingPolicy()).setRoutingStrategyType(storeDef.getRoutingStrategyType()).setReplicationFactor(storeDef.getReplicationFactor()).setPreferredReads(storeDef.getPreferredReads()).setRequiredReads(storeDef.getRequiredReads()).setPreferredWrites(storeDef.getPreferredWrites()).setRequiredWrites(storeDef.getRequiredWrites()).setRetentionPeriodDays(storeDef.getRetentionDays()).setRetentionScanThrottleRate(storeDef.getRetentionScanThrottleRate()).setZoneReplicationFactor(storeDef.getZoneReplicationFactor()).setZoneCountReads(storeDef.getZoneCountReads()).setZoneCountWrites(storeDef.getZoneCountWrites()).setHintedHandoffStrategy(storeDef.getHintedHandoffStrategyType()).setHintPrefListSize(storeDef.getHintPrefListSize()).setMemoryFootprintMB(reserveMB).build();
                        storeDefList.set(i, newStoreDef);
                        this.storageService.updateStore(newStoreDef);
                        break;
                    }
                    try {
                        this.metadataStore.put("stores.xml", storeDefList);
                    }
                    catch (Exception e) {
                        throw new VoldemortException(e);
                    }
                } else {
                    logger.error((Object)("Failure to reserve memory. Store '" + storeName + "' does not exist"));
                    throw new StoreOperationFailureException(String.format("Store '%s' does not exist on this server", storeName));
                }
            }
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error((Object)("handleReserveMemory failed for request(" + request.toString() + ")"), (Throwable)e);
        }
        return response.build();
    }
}

