/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.annotations.concurrency.NotThreadsafe;
import voldemort.utils.SystemTime;
import voldemort.utils.Time;

@NotThreadsafe
public class EventThrottler {
    private static final Logger logger = Logger.getLogger(EventThrottler.class);
    private static final long DEFAULT_CHECK_INTERVAL_MS = 50L;
    private final Time time;
    private final long ratesPerSecond;
    private final long intervalMs;
    private long startTime;
    private long eventsSeenInLastInterval;

    public EventThrottler(long ratesPerSecond) {
        this(SystemTime.INSTANCE, ratesPerSecond, 50L);
    }

    public long getRate() {
        return this.ratesPerSecond;
    }

    public EventThrottler(Time time, long ratePerSecond, long intervalMs) {
        this.time = time;
        this.intervalMs = intervalMs;
        this.ratesPerSecond = ratePerSecond;
        this.eventsSeenInLastInterval = 0L;
        this.startTime = 0L;
    }

    public synchronized void maybeThrottle(int eventsSeen) {
        long rateLimit = this.getRate();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rate = " + rateLimit));
        }
        this.eventsSeenInLastInterval += (long)eventsSeen;
        long now = this.time.getNanoseconds();
        long ellapsedNs = now - this.startTime;
        if (ellapsedNs > this.intervalMs * 1000000L && this.eventsSeenInLastInterval > 0L) {
            long eventsPerSec = this.eventsSeenInLastInterval * 1000000000L / ellapsedNs;
            if (eventsPerSec > rateLimit) {
                double maxEventsPerMs = (double)rateLimit / 1000.0;
                long ellapsedMs = ellapsedNs / 1000000L;
                long sleepTime = Math.round((double)this.eventsSeenInLastInterval / maxEventsPerMs - (double)ellapsedMs);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Natural rate is " + eventsPerSec + " events/sec max allowed rate is " + rateLimit + " events/sec, sleeping for " + sleepTime + " ms to compensate."));
                }
                if (sleepTime > 0L) {
                    try {
                        this.time.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        throw new VoldemortException(e);
                    }
                }
            }
            this.startTime = now;
            this.eventsSeenInLastInterval = 0L;
        }
    }
}

