/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.protocol.admin;

import com.google.protobuf.Message;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import voldemort.VoldemortException;
import voldemort.client.protocol.pb.ProtoUtils;
import voldemort.client.protocol.pb.VAdminProto;
import voldemort.server.StoreRepository;
import voldemort.server.protocol.StreamRequestHandler;
import voldemort.server.protocol.admin.AdminServiceRequestHandler;
import voldemort.store.ErrorCodeMapper;
import voldemort.store.StorageEngine;
import voldemort.store.stats.StreamStats;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;

public class UpdateSlopEntriesRequestHandler
implements StreamRequestHandler {
    private VAdminProto.UpdateSlopEntriesRequest request;
    private final VAdminProto.UpdateSlopEntriesResponse.Builder responseBuilder = VAdminProto.UpdateSlopEntriesResponse.newBuilder();
    private final ErrorCodeMapper errorCodeMapper;
    private final StoreRepository storeRepository;
    private final long startTime;
    private long counter = 0L;
    private final StreamStats stats;
    private final StreamStats.Handle handle;
    private final Logger logger = Logger.getLogger(this.getClass());

    public UpdateSlopEntriesRequestHandler(VAdminProto.UpdateSlopEntriesRequest request, ErrorCodeMapper errorCodeMapper, StoreRepository storeRepository, StreamStats stats) {
        this.request = request;
        this.errorCodeMapper = errorCodeMapper;
        this.storeRepository = storeRepository;
        this.stats = stats;
        this.handle = stats.makeHandle(StreamStats.Operation.SLOP, new HashMap<Integer, List<Integer>>());
        this.startTime = System.currentTimeMillis();
    }

    public StreamRequestHandler.StreamRequestDirection getDirection() {
        return StreamRequestHandler.StreamRequestDirection.READING;
    }

    public void close(DataOutputStream outputStream) throws IOException {
        ProtoUtils.writeMessage(outputStream, (Message)this.responseBuilder.build());
    }

    public void handleError(DataOutputStream outputStream, VoldemortException e) throws IOException {
        this.responseBuilder.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            this.logger.error((Object)("handleUpdatePartitionEntries failed for request(" + (Object)((Object)this.request) + ")"), (Throwable)e);
        }
    }

    public StreamRequestHandler.StreamRequestHandlerState handleRequest(DataInputStream inputStream, DataOutputStream outputStream) throws IOException {
        long startNs = System.nanoTime();
        if (this.request == null) {
            int size = 0;
            try {
                size = inputStream.readInt();
            }
            catch (EOFException e) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Incomplete read for message size");
                }
                this.stats.recordNetworkTime(this.handle, System.nanoTime() - startNs);
                return StreamRequestHandler.StreamRequestHandlerState.INCOMPLETE_READ;
            }
            if (size == -1) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Message size -1, completed partition update");
                }
                this.stats.recordNetworkTime(this.handle, System.nanoTime() - startNs);
                this.stats.closeHandle(this.handle);
                return StreamRequestHandler.StreamRequestHandlerState.COMPLETE;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("UpdatePartitionEntriesRequest message size: " + size));
            }
            byte[] input = new byte[size];
            try {
                ByteUtils.read(inputStream, input);
                this.stats.recordNetworkTime(this.handle, System.nanoTime() - startNs);
            }
            catch (EOFException e) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Incomplete read for message");
                }
                return StreamRequestHandler.StreamRequestHandlerState.INCOMPLETE_READ;
            }
            VAdminProto.UpdateSlopEntriesRequest.Builder builder = VAdminProto.UpdateSlopEntriesRequest.newBuilder();
            builder.mergeFrom(input);
            this.request = builder.build();
        }
        StorageEngine<ByteArray, byte[], byte[]> storageEngine = AdminServiceRequestHandler.getStorageEngine(this.storeRepository, this.request.getStore());
        ByteArray key = ProtoUtils.decodeBytes(this.request.getKey());
        VectorClock vectorClock = ProtoUtils.decodeClock(this.request.getVersion());
        switch (this.request.getRequestType()) {
            case PUT: {
                try {
                    byte[] transforms = null;
                    if (this.request.hasTransform()) {
                        transforms = ProtoUtils.decodeBytes(this.request.getTransform()).get();
                    }
                    byte[] value = ProtoUtils.decodeBytes(this.request.getValue()).get();
                    startNs = System.nanoTime();
                    storageEngine.put(key, Versioned.value(value, vectorClock), transforms);
                    this.stats.recordDiskTime(this.handle, System.nanoTime() - startNs);
                    if (!this.logger.isTraceEnabled()) break;
                    this.logger.trace((Object)"updateSlopEntries (Streaming put) successful");
                }
                catch (ObsoleteVersionException e) {
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug((Object)"updateSlopEntries (Streaming put) threw ObsoleteVersionException, Ignoring.");
                }
                break;
            }
            case DELETE: {
                try {
                    startNs = System.nanoTime();
                    storageEngine.delete(key, vectorClock);
                    this.stats.recordDiskTime(this.handle, System.nanoTime() - startNs);
                    if (!this.logger.isTraceEnabled()) break;
                    this.logger.trace((Object)"updateSlopEntries (Streaming delete) successful");
                }
                catch (ObsoleteVersionException e) {
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug((Object)"updateSlopEntries (Streaming delete) threw ObsoleteVersionException, Ignoring.");
                }
                break;
            }
            default: {
                throw new VoldemortException("Unsupported operation ");
            }
        }
        ++this.counter;
        this.handle.incrementEntriesScanned();
        if (0L == this.counter % 100000L) {
            long totalTime = (System.currentTimeMillis() - this.startTime) / 1000L;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("updateSlopEntries() updated " + this.counter + " entries in " + totalTime + " s"));
            }
        }
        this.request = null;
        return StreamRequestHandler.StreamRequestHandlerState.READING;
    }
}

