/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import voldemort.utils.ByteBufferBackedInputStream;
import voldemort.utils.ByteBufferBackedOutputStream;
import voldemort.utils.ByteUtils;

public abstract class SelectorManagerWorker
implements Runnable {
    protected final Selector selector;
    protected final SocketChannel socketChannel;
    protected final int socketBufferSize;
    protected final int resizeThreshold;
    protected final ByteBufferBackedInputStream inputStream;
    protected final ByteBufferBackedOutputStream outputStream;
    protected final long createTimestamp;
    protected final AtomicBoolean isClosed;
    protected final Logger logger = Logger.getLogger(this.getClass());

    public SelectorManagerWorker(Selector selector, SocketChannel socketChannel, int socketBufferSize) {
        this.selector = selector;
        this.socketChannel = socketChannel;
        this.socketBufferSize = socketBufferSize;
        this.resizeThreshold = socketBufferSize * 2;
        this.inputStream = new ByteBufferBackedInputStream(ByteBuffer.allocate(socketBufferSize));
        this.outputStream = new ByteBufferBackedOutputStream(ByteBuffer.allocate(socketBufferSize));
        this.createTimestamp = System.nanoTime();
        this.isClosed = new AtomicBoolean(false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Accepting remote connection from " + socketChannel.socket()));
        }
    }

    protected abstract void read(SelectionKey var1) throws IOException;

    protected abstract void write(SelectionKey var1) throws IOException;

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void run() {
        block10: {
            try {
                SelectionKey selectionKey = this.socketChannel.keyFor(this.selector);
                if (selectionKey.isReadable()) {
                    this.read(selectionKey);
                    break block10;
                }
                if (selectionKey.isWritable()) {
                    this.write(selectionKey);
                    break block10;
                }
                if (!selectionKey.isValid()) {
                    throw new IllegalStateException("Selection key not valid for " + this.socketChannel.socket());
                }
                throw new IllegalStateException("Unknown state, not readable, writable, or valid for " + this.socketChannel.socket());
            }
            catch (ClosedByInterruptException e) {
                this.close();
            }
            catch (CancelledKeyException e) {
                this.close();
            }
            catch (EOFException e) {
                this.close();
            }
            catch (IOException e) {
                this.logger.info((Object)("Connection reset from " + this.socketChannel.socket() + " with message - " + e.getMessage()));
                this.close();
            }
            catch (Throwable t) {
                if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
                    this.logger.error((Object)t.getMessage(), t);
                }
                this.close();
            }
        }
    }

    public void close() {
        if (!this.isClosed.compareAndSet(false, true)) {
            return;
        }
        this.closeInternal();
    }

    protected void closeInternal() {
        block10: {
            block9: {
                block8: {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Closing remote connection from " + this.socketChannel.socket()));
                    }
                    try {
                        this.socketChannel.socket().close();
                    }
                    catch (IOException e) {
                        if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block8;
                        this.logger.warn((Object)e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    this.socketChannel.close();
                }
                catch (IOException e) {
                    if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block9;
                    this.logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            SelectionKey selectionKey = this.socketChannel.keyFor(this.selector);
            if (selectionKey != null) {
                try {
                    selectionKey.attach(null);
                    selectionKey.cancel();
                }
                catch (Exception e) {
                    if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block10;
                    this.logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    protected void prepForWrite(SelectionKey selectionKey) {
        if (this.logger.isTraceEnabled()) {
            this.traceInputBufferState("About to clear read buffer");
        }
        if (this.inputStream.getBuffer().capacity() >= this.resizeThreshold) {
            this.inputStream.setBuffer(ByteBuffer.allocate(this.socketBufferSize));
        } else {
            this.inputStream.getBuffer().clear();
        }
        if (this.logger.isTraceEnabled()) {
            this.traceInputBufferState("Cleared read buffer");
        }
        this.outputStream.getBuffer().flip();
        selectionKey.interestOps(4);
    }

    protected void handleIncompleteRequest(int newPosition) {
        if (this.logger.isTraceEnabled()) {
            this.traceInputBufferState("Incomplete read request detected, before update");
        }
        this.inputStream.getBuffer().position(newPosition);
        this.inputStream.getBuffer().limit(this.inputStream.getBuffer().capacity());
        if (this.logger.isTraceEnabled()) {
            this.traceInputBufferState("Incomplete read request detected, after update");
        }
        if (!this.inputStream.getBuffer().hasRemaining()) {
            this.inputStream.setBuffer(ByteUtils.expand(this.inputStream.getBuffer(), this.inputStream.getBuffer().capacity() * 2));
            if (this.logger.isTraceEnabled()) {
                this.traceInputBufferState("Expanded input buffer");
            }
        }
    }

    protected void traceInputBufferState(String preamble) {
        this.logger.trace((Object)(preamble + " - position: " + this.inputStream.getBuffer().position() + ", limit: " + this.inputStream.getBuffer().limit() + ", remaining: " + this.inputStream.getBuffer().remaining() + ", capacity: " + this.inputStream.getBuffer().capacity() + " - for " + this.socketChannel.socket()));
    }
}

