/*
 * Copyright © 2016-2017 The Thingsboard Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

export default function addLocaleChinese(locales) {
	var zh_CN = {
		"access" : {
			"unauthorized" : "未授权",
			"unauthorized-access" : "未授权访问",
			"unauthorized-access-text" : "您应该登录以访问此资源！",
			"access-forbidden" : "禁止访问",
			"access-forbidden-text" : "您没有访问此位置的权限<br/>如果您仍希望访问此位置,请尝试使用其他用户登录。",
			"refresh-token-expired" : "会话已过期",
			"refresh-token-failed" : "无法刷新会话"
		},
		"action" : {
			"activate" : "激活",
			"suspend" : "挂起",
			"save" : "保存",
			"saveAs" : "另存为",
			"cancel" : "取消",
			"ok" : "确定",
			"delete" : "删除",
			"add" : "添加",
			"yes" : "是",
			"no" : "否",
			"update" : "更新",
			"remove" : "移出",
			"search" : "检索",
			"assign" : "分配",
			"unassign" : "取消分配",
			"apply" : "应用",
			"apply-changes" : "应用更改",
			"edit-mode" : "编辑模式",
			"enter-edit-mode" : "进入编辑模式",
			"decline-changes" : "取消更改",
			"close" : "关闭",
			"back" : "后退",
			"run" : "运行",
			"sign-in" : "登录！",
			"edit" : "编辑",
			"view" : "查看",
			"create" : "创建",
			"drag" : "拖拽",
			"refresh" : "刷新",
			"undo" : "撤销",
			"copy" : "复制",
			"paste" : "粘贴",
			"import" : "导入",
			"export" : "导出"
		},
		"aggregation" : {
			"aggregation" : "聚合",
			"function" : "数据聚合函数",
			"limit" : "上限",
			"group-interval" : "按组分隔",
			"min" : "最小值",
			"max" : "最大值",
			"avg" : "平均值",
			"sum" : "总数",
			"count" : "计数",
			"none" : "空"
		},
		"admin" : {
			"general" : "常规",
			"general-settings" : "常规设置",
			"outgoing-mail" : "发送邮件",
			"outgoing-mail-settings" : "发送邮件设置",
			"system-settings" : "系统设置",
			"test-mail-sent" : "测试邮件已成功发送！",
			"base-url" : "基本URL",
			"base-url-required" : "基本URL是必需的。",
			"mail-from" : "邮件来自",
			"mail-from-required" : "需要邮件发件人。",
			"smtp-protocol" : "SMTP协议",
			"smtp-host" : "SMTP主机",
			"smtp-host-required" : "SMTP主机是必需的。",
			"smtp-port" : "SMTP端口",
			"smtp-port-required" : "您必须提供smtp端口。",
			"smtp-port-invalid" : "这看起来不是有效的smtp端口。",
			"timeout-msec" : "超时 (ms)",
			"timeout-required" : "超时值是必需的。",
			"timeout-invalid" : "这看起来不像有效的超时值。",
			"enable-tls" : "启用TLS",
			"send-test-mail" : "发送测试邮件"
		},
		"attribute" : {
			"attributes" : "属性",
			"latest-telemetry" : "最新遥测",
			"attributes-scope" : "设备属性范围",
			"scope-latest-telemetry" : "最新遥测",
			"scope-client" : "客户端属性",
			"scope-server" : "服务端属性",
			"scope-shared" : "共享属性",
			"add" : "添加属性",
			"key" : "键",
			"key-required" : "属性键是必需的。",
			"value" : "值",
			"value-required" : "属性值是必需的。",
			"delete-attributes-title" : "您确定要删除 { count, select, 1 {1 attribute} other {# attributes} }?",
			"delete-attributes-text" : "注意,确认后所有选中的属性都会被删除。",
			"delete-attributes" : "删除属性",
			"enter-attribute-value" : "输入属性值",
			"show-on-widget" : "在窗口小部件上显示",
			"widget-mode" : "小部件模式",
			"next-widget" : "下一个小部件",
			"prev-widget" : "上一个小部件",
			"add-to-dashboard" : "添加到仪表板",
			"add-widget-to-dashboard" : "将小部件添加到仪表板",
			"selected-attributes" : "{ count, select, 1 {1 attribute} other {# attributes} } 被选中",
			"selected-telemetry" : "{ count, select, 1 {1 telemetry unit} other {# telemetry units} } 被选中"
		},
		"confirm-on-exit" : {
			"message" : "您有未保存的更改。确定要离开此页吗？",
			"html-message" : "您有未保存的更改。<br/>确定要离开此页面吗？",
			"title" : "未保存的更改"
		},
		"contact" : {
			"country" : "国家",
			"city" : "城市",
			"state" : "州",
			"postal-code" : "邮政编码",
			"postal-code-invalid" : "只允许数字。",
			"address" : "地址",
			"address2" : "地址2",
			"phone" : "手机",
			"email" : "邮箱",
			"no-address" : "无地址"
		},
		"common" : {
			"username" : "用户名",
			"password" : "密码",
			"enter-username" : "输入用户名",
			"enter-password" : "输入密码",
			"enter-search" : "输入检索条件"
		},
		"customer" : {
			"customers" : "客户",
			"management" : "客户管理",
			"dashboard" : "客户仪表板",
			"dashboards" : "客户仪表板",
			"devices" : "客户设备",
			"add" : "添加客户",
			"delete" : "删除客户",
			"manage-customer-users" : "管理客户的用户",
			"manage-customer-devices" : "管理客户设备",
			"manage-customer-dashboards" : "管理客户仪表板",
			"add-customer-text" : "添加新客户",
			"no-customers-text" : "没有找到客户",
			"customer-details" : "客户详情",
			"delete-customer-title" : "您确定要删除客户'{{customerTitle}}'吗？",
			"delete-customer-text" : "小心！确认后，客户及其所有相关数据将不可恢复。",
			"delete-customers-title" : "您确定要删除 { count, select, 1 {1 customer} other {# customers} }？",
			"delete-customers-action-title" : "删除 { count, select, 1 {1 customer} other {# customers} }",
			"delete-customers-text" : "小心！确认后，所有选定的客户将被删除，所有相关数据将不可恢复。",
			"manage-users" : "管理用户",
			"manage-devices" : "管理设备",
			"manage-dashboards" : "管理仪表板",
			"title" : "标题",
			"title-required" : "需要标题。",
			"description" : "描述"
		},
		"datetime" : {
			"date-from" : "日期从",
			"time-from" : "时间从",
			"date-to" : "日期到",
			"time-to" : "时间到"
		},
		"dashboard" : {
			"dashboard" : "仪表板",
			"dashboards" : "可视化库",
			"management" : "仪表板管理",
			"view-dashboards" : "查看仪表板",
			"add" : "添加仪表板",
			"assign-dashboard-to-customer" : "将仪表板分配给客户",
			"assign-dashboard-to-customer-text" : "请选择要分配给客户的仪表板",
			"assign-to-customer-text" : "请选择客户分配仪表板",
			"assign-to-customer" : "分配给客户",
			"unassign-from-customer" : "取消分配客户",
			"no-dashboards-text" : "没有找到仪表板",
			"no-widgets" : "没有配置小部件",
			"add-widget" : "添加新的小部件",
			"title" : "标题",
			"select-widget-title" : "选择小部件",
			"select-widget-subtitle" : "可用的小部件类型列表",
			"delete" : "删除仪表板",
			"title-required" : "需要标题。",
			"description" : "描述",
			"details" : "详情",
			"dashboard-details" : "仪表板详情",
			"add-dashboard-text" : "添加新的仪表板",
			"assign-dashboards" : "分配仪表板",
			"assign-new-dashboard" : "分配新的仪表板",
			"assign-dashboards-text" : "分配 { count, select, 1 {1 dashboard} other {# dashboards} } 给客户",
			"delete-dashboards" : "删除仪表板",
			"unassign-dashboards" : "取消分配仪表板",
			"unassign-dashboards-action-title" : "从客户取消分配 { count, select, 1 {1 dashboard} other {# dashboards} }",
			"delete-dashboard-title" : "您确定要删除仪表板 '{{dashboardTitle}}'？",
			"delete-dashboard-text" : "小心！确认后仪表板及其所有相关数据将不可恢复。",
			"delete-dashboards-title" : "你确定要删除 { count, select, 1 {1 dashboard} other {# dashboards} }？",
			"delete-dashboards-action-title" : "删除 { count, select, 1 {1 dashboard} other {# dashboards} }",
			"delete-dashboards-text" : "小心！确认后所有被选中的仪表板将被删除，所有相关数据将不可恢复。",
			"unassign-dashboard-title" : "您确定要取消分配仪表板 '{{dashboardTitle}}'？",
			"unassign-dashboard-text" : "确认后,仪表板将取消分配,客户将无法访问。",
			"unassign-dashboard" : "取消分配仪表板",
			"unassign-dashboards-title" : "您确定要取消分配 { count, select, 1 {1 dashboard} other {# dashboards} }？",
			"unassign-dashboards-text" : "确认后,所有选定的仪表板将被取消分配,并且用户将无法访问。",
			"select-dashboard" : "选择仪表板",
			"no-dashboards-matching" : "找不到符合 '{{dashboard}}' 的仪表板。",
			"dashboard-required" : "仪表板是必需的。",
			"select-existing" : "选择现有仪表板",
			"create-new" : "创建新的仪表板",
			"new-dashboard-title" : "新仪表板标题",
			"open-dashboard" : "打开仪表板",
			"set-background" : "设置背景",
			"background-color" : "背景颜色",
			"background-image" : "背景图片",
			"background-size-mode" : "背景大小模式",
			"no-image" : "无图像选择",
			"drop-image" : "拖拽图像或单击以选择要上传的文件。",
			"settings" : "设置",
			"columns-count" : "列数",
			"columns-count-required" : "需要列数。",
			"min-columns-count-message" : "只允许最少10列",
			"max-columns-count-message" : "只允许最大1000列",
			"widgets-margins" : "部件间边距",
			"horizontal-margin" : "水平边距",
			"horizontal-margin-required" : "需要水平边距值。",
			"min-horizontal-margin-message" : "只允许0作为最小水平边距值。",
			"max-horizontal-margin-message" : "只允许50作为最大水平边距值。",
			"vertical-margin" : "垂直边距",
			"vertical-margin-required" : "需要垂直边距值。",
			"min-vertical-margin-message" : "只允许0作为最小垂直边距值。",
			"max-vertical-margin-message" : "只允许50作为最大垂直边距值。",
			"display-title" : "显示仪表板标题",
			"title-color" : "标题颜色",
			"import" : "导入仪表板",
			"export" : "导出仪表板",
			"export-failed-error" : "无法导出仪表板: {{error}}",
			"create-new-dashboard" : "创建新的仪表板",
			"dashboard-file" : "仪表板文件",
			"invalid-dashboard-file-error" : "无法导入仪表板: 仪表板数据结构无效。",
			"dashboard-import-missing-aliases-title" : "配置导入仪表板使用的别名",
			"create-new-widget" : "创建新小部件",
			"import-widget" : "导入小部件",
			"widget-file" : "小部件文件",
			"invalid-widget-file-error" : "无法导入窗口小部件: 窗口小部件数据结构无效。",
			"widget-import-missing-aliases-title" : "配置导入的窗口小部件使用的别名",
			"open-toolbar" : "打开仪表板工具栏",
			"close-toolbar" : "关闭工具栏",
			"configuration-error" : "配置错误",
			"alias-resolution-error-title" : "仪表板别名配置错误",
			"invalid-aliases-config" : "无法找到与某些别名过滤器匹配的任何设备。<br/>" +
				"请联系您的管理员以解决此问题。",
			"select-devices" : "选择设备",
			"assignedToCustomer" : "分配给客户"
		},
		"datakey" : {
			"settings": "设置",
			"advanced": "高级",
			"label": "标签",
			"color": "颜色",
			"data-generation-func": "数据生成功能",
			"use-data-post-processing-func": "使用数据后处理功能",
			"configuration": "数据键配置",
			"timeseries": "时间序列",
			"attributes": "属性",
			"timeseries-required": "需要设备时间序列。",
			"timeseries-or-attributes-required": "设备时间/属性是必需的。",
			"function-types": "函数类型",
			"function-types-required": "需要函数类型。"
		},
		"datasource" : {
			"type": "数据源类型",
			"add-datasource-prompt": "请添加数据源"
		},
		"details" : {
			"edit-mode": "编辑模式",
			"toggle-edit-mode": "切换编辑模式"
		},
		"device" : {
			"device": "设备",
			"device-required": "设备是必需的",
			"devices": "设备",
			"management": "设备管理",
			"view-devices": "查看设备",
			"device-alias": "设备别名",
			"aliases": "设备别名",
			"no-alias-matching" : "'{{alias}}' 没有找到。",
			"no-aliases-found" : "找不到别名。",
			"no-key-matching" : "'{{key}}' 没有找到。",
			"no-keys-found" : "找不到密钥。",
			"create-new-alias": "创建一个新的！",
			"create-new-key": "创建一个新的！",
			"duplicate-alias-error" : "找到重复别名 '{{alias}}'.<br>设备别名必须是唯一的。",
			"configure-alias" : "配置 '{{alias}}' 别名",
			"no-devices-matching" : "找不到与 '{{device}}' 匹配的设备。",
			"alias" : "别名",
			"alias-required" : "需要设备别名。",
			"remove-alias": "删除设备别名",
			"add-alias": "添加设备别名",
			"name-starts-with" : "名称前缀",
			"device-list" : "设备列表",
			"use-device-name-filter" : "使用过滤器",
			"device-list-empty" : "没有被选中的设备",
			"device-name-filter-required" : "设备名称过滤器是必需得。",
			"device-name-filter-no-device-matched" : "找不到以'{{device}}' 开头的设备。",
			"add" : "添加设备",
			"assign-to-customer": "分配给客户",
			"assign-device-to-customer": "将设备分配给客户",
			"assign-device-to-customer-text": "请选择要分配给客户的设备",
			"no-devices-text": "找不到设备",
			"assign-to-customer-text": "请选择客户分配设备",
			"device-details": "设备详细信息",
			"add-device-text": "添加新设备",
			"credentials": "凭据",
			"manage-credentials": "管理凭据",
			"delete": "删除设备",
			"assign-devices": "分配设备",
			"assign-devices-text": "将{count,select,1 {1 device} other {#devices}}分配给客户",
			"delete-devices": "删除设备",
			"unassign-from-customer": "取消分配客户",
			"unassign-devices": "取消分配设备",
			"unassign-devices-action-title": "从客户处取消分配{count,select,1 {1 device} other {#devices}}",
			"assign-new-device": "分配新设备",
			"view-credentials": "查看凭据",
			"delete-device-title": "您确定要删除设备的{{deviceName}}吗？",
			"delete-device-text": "小心！确认后设备及其所有相关数据将不可恢复。",
			"delete-devices-title": "您确定要删除{count,select,1 {1 device} other {#devices}}？",
			"delete-devices-action-title": "删除 {count,select,1 {1 device} other {#devices}}",
			"delete-devices-text": "小心！确认后所有选定的设备将被删除,所有相关数据将不可恢复。",
			"unassign-device-title": "您确定要取消分配设备 '{{deviceName}}'？",
			"unassign-device-text": "确认后,设备将被取消分配,客户将无法访问。",
			"unassign-device": "取消分配设备",
			"unassign-devices-title": "您确定要取消分配{count,select,1 {1 device} other {#devices}}？",
			"unassign-devices-text": "确认后,所有选定的设备将被取消分配,并且客户将无法访问。",
			"device-credentials": "设备凭据",
			"credentials-type": "凭据类型",
			"access-token": "访问令牌",
			"access-token-required": "需要访问令牌",
			"access-token-invalid": "访问令牌长度必须为1到20个字符。",
			"rsa-key": "RSA公钥",
			"access-token-required": "需要RSA公钥",
			"secret": "密钥",
			"secret-required": "密钥是必需的",
			"name": "名称",
			"name-required": "名称是必需的。",
			"description": "说明",
			"events": "事件",
			"details": "详细信息",
			"copyId": "复制设备ID",
			"copyAccessToken": "复制访问令牌",
			"idCopiedMessage": "设备ID已复制到剪贴板",
			"accessTokenCopiedMessage": "设备访问令牌已复制到剪贴板",
			"assignedToCustomer": "分配给客户",
			"unable-delete-device-alias-title": "无法删除设备别名",
			"unable-delete-device-alias-text": "设备别名 '{{deviceAlias}}' 不能够被删除，因为它被下列部件所使用:<br/>{{widgetsList}}",
			"is-gateway": "是网关"
		},
		"dialog" : {
			"close" : "关闭对话框"
		},
		"error" : {
			"unable-to-connect": "无法连接到服务器！请检查您的互联网连接。",
			"unhandled-error-code": "未处理的错误代码: {{errorCode}}",
			"unknown-error": "未知错误"
		},
		"event" : {
			"event-type": "事件类型",
			"type-alarm": "报警",
			"type-error": "错误",
			"type-lc-event": "生命周期事件",
			"type-stats": "类型统计",
			"no-events-prompt": "找不到事件",
			"error": "错误",
			"alarm": "报警",
			"event-time": "事件时间",
			"server": "服务器",
			"body": "整体",
			"method": "方法",
			"event": "事件",
			"status": "状态",
			"success": "成功",
			"failed": "失败",
			"messages-processed": "消息处理",
			"errors-occurred": "错误发生"
		},
		"fullscreen" : {
			"expand": "展开到全屏",
			"exit": "退出全屏",
			"toggle": "切换全屏模式",
			"fullscreen": "全屏"
		},
		"function" : {
			"function" : "功能"
		},
		"grid" : {
			"delete-item-title": "您确定要删除此项吗？",
			"delete-item-text": "注意,确认后此项和所有相关数据将变得不可恢复。",
			"delete-items-title": "您确定要删除{count,select,1 {1 item} other {#items}}？",
			"delete-items-action-title": "删除{count,select,1 {1 item} other {#items}}",
			"delete-items-text": "注意,确认后所有选择的项目将被删除,所有相关数据将变得不可恢复。",
			"add-item-text": "添加新项目",
			"no-items-text": "没有找到项目",
			"item-details": "项目详细信息",
			"delete-item": "删除项目",
			"delete-items": "删除项目",
			"scroll-to-top": "滚动到顶部"
		},
		"help" : {
			"goto-help-page" : "转到帮助页面"
		},
		"home" : {
			"home": "首页",
			"profile": "属性",
			"logout": "注销",
			"menu": "菜单",
			"avatar": "化身",
			"open-user-menu": "打开用户菜单"
		},
		"import" : {
			"no-file": "没有选择文件",
			"drop-file": "删除JSON文件或单击以选择要上传的文件。"
		},
		"item" : {
			"selected" : "选择"
		},
		"js-func" : {
			"no-return-error": "函数必须返回值！",
			"return-type-mismatch": "函数必须返回'{{type}}'类型的值！"
		},
		"legend" : {
			"position" : "Legend position",
			"show-max" : "Show max value",
			"show-min" : "Show min value",
			"show-avg" : "Show average value",
			"show-total" : "Show total value",
			"settings" : "Legend settings",
			"min" : "min",
			"max" : "max",
			"avg" : "avg",
			"total" : "total"
		},
		"login" : {
			"login": "登录",
			"request-password-reset": "请求密码重置",
			"reset-password": "重置密码",
			"create-password": "创建密码",
			"passwords-mismatch-error": "输入的密码必须相同！",
			"password-again": "密码再次",
			"sign-in": "登录 ",
			"username": "用户名（电子邮件）",
			"remember-me": "记住我",
			"forgot-password": "忘记密码？",
			"password-reset": "密码重置",
			"new-password": "新密码",
			"new-password-again": "新密码再次",
			"password-link-sent-message": "密码重置链接已成功发送！",
			"email": "电子邮件"
		},
		"plugin" : {
			"plugins" : "Plugins",
			"delete" : "Delete plugin",
			"activate" : "Activate plugin",
			"suspend" : "Suspend plugin",
			"active" : "Active",
			"suspended" : "Suspended",
			"name" : "Name",
			"name-required" : "Name is required.",
			"description" : "Description",
			"add" : "Add Plugin",
			"delete-plugin-title" : "Are you sure you want to delete the plugin '{{pluginName}}'?",
			"delete-plugin-text" : "Be careful, after the confirmation the plugin and all related data will become unrecoverable.",
			"delete-plugins-title" : "Are you sure you want to delete { count, select, 1 {1 plugin} other {# plugins} }?",
			"delete-plugins-action-title" : "Delete { count, select, 1 {1 plugin} other {# plugins} }",
			"delete-plugins-text" : "Be careful, after the confirmation all selected plugins will be removed and all related data will become unrecoverable.",
			"add-plugin-text" : "Add new plugin",
			"no-plugins-text" : "No plugins found",
			"plugin-details" : "Plugin details",
			"api-token" : "API token",
			"api-token-required" : "API token is required.",
			"type" : "Plugin type",
			"type-required" : "Plugin type is required.",
			"configuration" : "Plugin configuration",
			"system" : "System",
			"select-plugin" : "Select plugin",
			"plugin" : "Plugin",
			"no-plugins-matching" : "No plugins matching '{{plugin}}' were found.",
			"plugin-required" : "Plugin is required.",
			"plugin-require-match" : "Please select an existing plugin.",
			"events" : "Events",
			"details" : "Details",
			"import" : "Import plugin",
			"export" : "Export plugin",
			"export-failed-error" : "Unable to export plugin: {{error}}",
			"create-new-plugin" : "Create new plugin",
			"plugin-file" : "Plugin file",
			"invalid-plugin-file-error" : "Unable to import plugin: Invalid plugin data structure."
		},
		"position" : {
			"top" : "Top",
			"bottom" : "Bottom",
			"left" : "Left",
			"right" : "Right"
		},
		"profile" : {
			"profile": "属性",
			"change-password": "更改密码",
			"current-password": "当前密码"
		},
		"rule" : {
			"rules" : "Rules",
			"delete" : "Delete rule",
			"activate" : "Activate rule",
			"suspend" : "Suspend rule",
			"active" : "Active",
			"suspended" : "Suspended",
			"name" : "Name",
			"name-required" : "Name is required.",
			"description" : "Description",
			"add" : "Add Rule",
			"delete-rule-title" : "Are you sure you want to delete the rule '{{ruleName}}'?",
			"delete-rule-text" : "Be careful, after the confirmation the rule and all related data will become unrecoverable.",
			"delete-rules-title" : "Are you sure you want to delete { count, select, 1 {1 rule} other {# rules} }?",
			"delete-rules-action-title" : "Delete { count, select, 1 {1 rule} other {# rules} }",
			"delete-rules-text" : "Be careful, after the confirmation all selected rules will be removed and all related data will become unrecoverable.",
			"add-rule-text" : "Add new rule",
			"no-rules-text" : "No rules found",
			"rule-details" : "Rule details",
			"filters" : "Filters",
			"filter" : "Filter",
			"add-filter-prompt" : "Please add filter",
			"remove-filter" : "Remove filter",
			"add-filter" : "Add filter",
			"filter-name" : "Filter name",
			"filter-type" : "Filter type",
			"edit-filter" : "Edit filter",
			"view-filter" : "View filter",
			"component-name" : "Name",
			"component-name-required" : "Name is required.",
			"component-type" : "Type",
			"component-type-required" : "Type is required.",
			"processor" : "Processor",
			"no-processor-configured" : "No processor configured",
			"create-processor" : "Create processor",
			"processor-name" : "Processor name",
			"processor-type" : "Processor type",
			"plugin-action" : "Plugin action",
			"action-name" : "Action name",
			"action-type" : "Action type",
			"create-action-prompt" : "Please create action",
			"create-action" : "Create action",
			"details" : "Details",
			"events" : "Events",
			"system" : "System",
			"import" : "Import rule",
			"export" : "Export rule",
			"export-failed-error" : "Unable to export rule: {{error}}",
			"create-new-rule" : "Create new rule",
			"rule-file" : "Rule file",
			"invalid-rule-file-error" : "Unable to import rule: Invalid rule data structure."
		},
		"rule-plugin" : {
			"management" : "Rules and plugins management"
		},
		"tenant" : {
			"tenants" : "Tenants",
			"management" : "Tenant management",
			"add" : "Add Tenant",
			"admins" : "Admins",
			"manage-tenant-admins" : "Manage tenant admins",
			"delete" : "Delete tenant",
			"add-tenant-text" : "Add new tenant",
			"no-tenants-text" : "No tenants found",
			"tenant-details" : "Tenant details",
			"delete-tenant-title" : "Are you sure you want to delete the tenant '{{tenantTitle}}'?",
			"delete-tenant-text" : "Be careful, after the confirmation the tenant and all related data will become unrecoverable.",
			"delete-tenants-title" : "Are you sure you want to delete { count, select, 1 {1 tenant} other {# tenants} }?",
			"delete-tenants-action-title" : "Delete { count, select, 1 {1 tenant} other {# tenants} }",
			"delete-tenants-text" : "Be careful, after the confirmation all selected tenants will be removed and all related data will become unrecoverable.",
			"title" : "Title",
			"title-required" : "Title is required.",
			"description" : "Description"
		},
		"timeinterval" : {
			"seconds-interval" : "{ seconds, select, 1 {1 second} other {# seconds} }",
			"minutes-interval" : "{ minutes, select, 1 {1 minute} other {# minutes} }",
			"hours-interval" : "{ hours, select, 1 {1 hour} other {# hours} }",
			"days-interval" : "{ days, select, 1 {1 day} other {# days} }",
			"days" : "Days",
			"hours" : "Hours",
			"minutes" : "Minutes",
			"seconds" : "Seconds",
			"advanced" : "Advanced"
		},
		"timewindow" : {
			"days" : "{ days, select, 1 { day } other {# days } }",
			"hours" : "{ hours, select, 0 { hour } 1 {1 hour } other {# hours } }",
			"minutes" : "{ minutes, select, 0 { minute } 1 {1 minute } other {# minutes } }",
			"seconds" : "{ seconds, select, 0 { second } 1 {1 second } other {# seconds } }",
			"realtime" : "Realtime",
			"history" : "History",
			"last-prefix" : "last",
			"period" : "from {{ startTime }} to {{ endTime }}",
			"edit" : "Edit timewindow",
			"date-range" : "Date range",
			"last" : "Last",
			"time-period" : "Time period"
		},
		"user" : {
			"users" : "Users",
			"customer-users" : "Customer Users",
			"tenant-admins" : "Tenant Admins",
			"sys-admin" : "System administrator",
			"tenant-admin" : "Tenant administrator",
			"customer" : "Customer",
			"anonymous" : "Anonymous",
			"add" : "Add User",
			"delete" : "Delete user",
			"add-user-text" : "Add new user",
			"no-users-text" : "No users found",
			"user-details" : "User details",
			"delete-user-title" : "Are you sure you want to delete the user '{{userEmail}}'?",
			"delete-user-text" : "Be careful, after the confirmation the user and all related data will become unrecoverable.",
			"delete-users-title" : "Are you sure you want to delete { count, select, 1 {1 user} other {# users} }?",
			"delete-users-action-title" : "Delete { count, select, 1 {1 user} other {# users} }",
			"delete-users-text" : "Be careful, after the confirmation all selected users will be removed and all related data will become unrecoverable.",
			"activation-email-sent-message" : "Activation email was successfully sent!",
			"resend-activation" : "Resend activation",
			"email" : "Email",
			"email-required" : "Email is required.",
			"first-name" : "First Name",
			"last-name" : "Last Name",
			"description" : "Description",
			"default-dashboard" : "Default dashboard",
			"always-fullscreen" : "Always fullscreen"
		},
		"value" : {
			"type" : "Value type",
			"string" : "String",
			"string-value" : "String value",
			"integer" : "Integer",
			"integer-value" : "Integer value",
			"invalid-integer-value" : "Invalid integer value",
			"double" : "Double",
			"double-value" : "Double value",
			"boolean" : "Boolean",
			"boolean-value" : "Boolean value",
			"false" : "False",
			"true" : "True"
		},
		"widget" : {
			"widget-library" : "Widgets Library",
			"widget-bundle" : "Widgets Bundle",
			"select-widgets-bundle" : "Select widgets bundle",
			"management" : "Widget management",
			"editor" : "Widget Editor",
			"widget-type-not-found" : "Problem loading widget configuration.<br>Probably associated\n    widget type was removed.",
			"widget-type-load-error" : "Widget wasn't loaded due to the following errors:",
			"remove" : "Remove widget",
			"edit" : "Edit widget",
			"remove-widget-title" : "Are you sure you want to remove the widget '{{widgetTitle}}'?",
			"remove-widget-text" : "After the confirmation the widget and all related data will become unrecoverable.",
			"timeseries" : "Time series",
			"latest-values" : "Latest values",
			"rpc" : "Control widget",
			"static" : "Static widget",
			"select-widget-type" : "Select widget type",
			"missing-widget-title-error" : "Widget title must be specified!",
			"widget-saved" : "Widget saved",
			"unable-to-save-widget-error" : "Unable to save widget! Widget has errors!",
			"save" : "Save widget",
			"saveAs" : "Save widget as",
			"save-widget-type-as" : "Save widget type as",
			"save-widget-type-as-text" : "Please enter new widget title and/or select target widgets bundle",
			"toggle-fullscreen" : "Toggle fullscreen",
			"run" : "Run widget",
			"title" : "Widget title",
			"title-required" : "Widget title is required.",
			"type" : "Widget type",
			"resources" : "Resources",
			"resource-url" : "JavaScript/CSS URL",
			"remove-resource" : "Remove resource",
			"add-resource" : "Add resource",
			"html" : "HTML",
			"tidy" : "Tidy",
			"css" : "CSS",
			"settings-schema" : "Settings schema",
			"datakey-settings-schema" : "Data key settings schema",
			"javascript" : "Javascript",
			"remove-widget-type-title" : "Are you sure you want to remove the widget type '{{widgetName}}'?",
			"remove-widget-type-text" : "After the confirmation the widget type and all related data will become unrecoverable.",
			"remove-widget-type" : "Remove widget type",
			"add-widget-type" : "Add new widget type",
			"widget-type-load-failed-error" : "Failed to load widget type!",
			"widget-template-load-failed-error" : "Failed to load widget template!",
			"add" : "Add Widget",
			"undo" : "Undo widget changes",
			"export" : "Export widget"
		},
		"widgets-bundle" : {
			"current" : "Current bundle",
			"widgets-bundles" : "Widgets Bundles",
			"add" : "Add Widgets Bundle",
			"delete" : "Delete widgets bundle",
			"title" : "Title",
			"title-required" : "Title is required.",
			"add-widgets-bundle-text" : "Add new widgets bundle",
			"no-widgets-bundles-text" : "No widgets bundles found",
			"empty" : "Widgets bundle is empty",
			"details" : "Details",
			"widgets-bundle-details" : "Widgets bundle details",
			"delete-widgets-bundle-title" : "Are you sure you want to delete the widgets bundle '{{widgetsBundleTitle}}'?",
			"delete-widgets-bundle-text" : "Be careful, after the confirmation the widgets bundle and all related data will become unrecoverable.",
			"delete-widgets-bundles-title" : "Are you sure you want to delete { count, select, 1 {1 widgets bundle} other {# widgets bundles} }?",
			"delete-widgets-bundles-action-title" : "Delete { count, select, 1 {1 widgets bundle} other {# widgets bundles} }",
			"delete-widgets-bundles-text" : "Be careful, after the confirmation all selected widgets bundles will be removed and all related data will become unrecoverable.",
			"no-widgets-bundles-matching" : "No widgets bundles matching '{{widgetsBundle}}' were found.",
			"widgets-bundle-required" : "Widgets bundle is required.",
			"system" : "System",
			"import" : "Import widgets bundle",
			"export" : "Export widgets bundle",
			"export-failed-error" : "Unable to export widgets bundle: {{error}}",
			"create-new-widgets-bundle" : "Create new widgets bundle",
			"widgets-bundle-file" : "Widgets bundle file",
			"invalid-widgets-bundle-file-error" : "Unable to import widgets bundle: Invalid widgets bundle data structure."
		},
		"widget-config" : {
			"data" : "Data",
			"settings" : "Settings",
			"advanced" : "Advanced",
			"title" : "Title",
			"general-settings" : "General settings",
			"display-title" : "Display title",
			"drop-shadow" : "Drop shadow",
			"enable-fullscreen" : "Enable fullscreen",
			"background-color" : "Background color",
			"text-color" : "Text color",
			"padding" : "Padding",
			"title-style" : "Title style",
			"mobile-mode-settings" : "Mobile mode settings",
			"order" : "Order",
			"height" : "Height",
			"units" : "Special symbol to show next to value",
			"decimals" : "Number of digits after floating point",
			"timewindow" : "Timewindow",
			"use-dashboard-timewindow" : "Use dashboard timewindow",
			"display-legend" : "Display legend",
			"datasources" : "Datasources",
			"datasource-type" : "Type",
			"datasource-parameters" : "Parameters",
			"remove-datasource" : "Remove datasource",
			"add-datasource" : "Add datasource",
			"target-device" : "Target device"
		},
		"widget-type" : {
			"import" : "Import widget type",
			"export" : "Export widget type",
			"export-failed-error" : "Unable to export widget type: {{error}}",
			"create-new-widget-type" : "Create new widget type",
			"widget-type-file" : "Widget type file",
			"invalid-widget-type-file-error" : "Unable to import widget type: Invalid widget type data structure."
		},
		"language" : {
			"language" : "语言",
			"en_US" : "英语",
			"ko_KR" : "韩语",
            "zh_CN": "汉语"
		}
	};
	angular.extend(locales, {
		'zh_CN' : zh_CN
	});
}