/*
 * Copyright © 2016-2018 The Thingsboard Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
export default function addLocaleRussian(locales) {
    var ru_RU = {
        "access": {
            "unauthorized": "Неавторизированный",
            "unauthorized-access": "Несанкционированный доступ",
            "unauthorized-access-text": "Вы должны войти в систему для получения доступа к этому ресурсу!",
            "access-forbidden": "Доступ запрещен",
            "access-forbidden-text": "У вас нет прав доступа к этому ресурсу!<br/>Для получения доступа попробуйте войти под другим пользователем.",
            "refresh-token-expired": "Сессия истекла",
            "refresh-token-failed": "Не удалось обновить сессию"
        },
        "action": {
            "activate": "Активировать",
            "suspend": "Приостановить",
            "save": "Сохранить",
            "saveAs": "Сохранить как",
            "cancel": "Отмена",
            "ok": "ОК",
            "delete": "Удалить",
            "add": "Добавить",
            "yes": "Да",
            "no": "Нет",
            "update": "Обновить",
            "remove": "Удалить",
            "search": "Поиск",
            "assign": "Присвоить",
            "unassign": "Отменить присвоение",
            "share": "Поделиться",
            "make-private": "Закрыть для общего доступа",
            "apply": "Применить",
            "apply-changes": "Применить изменения",
            "edit-mode": "Режим редактирования",
            "enter-edit-mode": "Режим редактирования",
            "decline-changes": "Отменить изменения",
            "close": "Закрыть",
            "back": "Назад",
            "run": "Запуск",
            "sign-in": "Войти",
            "edit": "Редактировать",
            "view": "Просмотреть",
            "create": "Создать",
            "drag": "Переместить",
            "refresh": "Обновить",
            "undo": "Откатить",
            "copy": "Копировать",
            "paste": "Вставить",
            "import": "Импортировать",
            "export": "Экспортировать",
            "share-via": "Поделиться в {{provider}}"
        },
        "aggregation": {
            "aggregation": "Агрегация",
            "function": "Тип агрегации данных",
            "limit": "Максимальное значение",
            "group-interval": "Интервал группировки",
            "min": "Мин",
            "max": "Maкс",
            "avg": "Среднее",
            "sum": "Сумма",
            "count": "Количество",
            "none": "Без агрегации"
        },
        "admin": {
            "general": "Общие",
            "general-settings": "Общие настройки",
            "outgoing-mail": "Исходящая почта",
            "outgoing-mail-settings": "Настройки исходящей почты",
            "system-settings": "Системные настройки",
            "test-mail-sent": "Пробное письмо успешно отправлено!",
            "base-url": "Базовая URL",
            "base-url-required": "Базовая URL обязательна.",
            "mail-from": "Отправитель",
            "mail-from-required": "Отправитель обязателен.",
            "smtp-protocol": "SMTP протокол",
            "smtp-host": "SMTP хост",
            "smtp-host-required": "SMTP хост обязателен.",
            "smtp-port": "SMTP порт",
            "smtp-port-required": "SMTP порт обязателен.",
            "smtp-port-invalid": "Недействительный SMTP порт.",
            "timeout-msec": "Таймаут (мс)",
            "timeout-required": "Таймаут обязателен.",
            "timeout-invalid": "Недействительный таймаут.",
            "enable-tls": "Включить TLS",
            "send-test-mail": "Отправить пробное письмо"
        },
        "alarm": { // TODO
            "alarm": "Alarm",
            "alarms": "Alarms",
            "select-alarm": "Select alarm",
            "no-alarms-matching": "No alarms matching '{{entity}}' were found.",
            "alarm-required": "Alarm is required",
            "alarm-status": "Alarm status",
            "search-status": {
                "ANY": "Any",
                "ACTIVE": "Active",
                "CLEARED": "Cleared",
                "ACK": "Acknowledged",
                "UNACK": "Unacknowledged"
            },
            "display-status": {
                "ACTIVE_UNACK": "Active Unacknowledged",
                "ACTIVE_ACK": "Active Acknowledged",
                "CLEARED_UNACK": "Cleared Unacknowledged",
                "CLEARED_ACK": "Cleared Acknowledged"
            },
            "no-alarms-prompt": "No alarms found",
            "created-time": "Created time",
            "type": "Type",
            "severity": "Severity",
            "originator": "Originator",
            "originator-type": "Originator type",
            "details": "Details",
            "status": "Status",
            "alarm-details": "Alarm details",
            "start-time": "Start time",
            "end-time": "End time",
            "ack-time": "Acknowledged time",
            "clear-time": "Cleared time",
            "severity-critical": "Critical",
            "severity-major": "Major",
            "severity-minor": "Minor",
            "severity-warning": "Warning",
            "severity-indeterminate": "Indeterminate",
            "acknowledge": "Acknowledge",
            "clear": "Clear",
            "search": "Search alarms",
            "selected-alarms": "{ count, select, 1 {1 alarm} other {# alarms} } selected",
            "no-data": "No data to display",
            "polling-interval": "Alarms polling interval (sec)",
            "polling-interval-required": "Alarms polling interval is required.",
            "min-polling-interval-message": "At least 1 sec polling interval is allowed.",
            "aknowledge-alarms-title": "Acknowledge { count, select, 1 {1 alarm} other {# alarms} }",
            "aknowledge-alarms-text": "Are you sure you want to acknowledge { count, select, 1 {1 alarm} other {# alarms} }?",
            "clear-alarms-title": "Clear { count, select, 1 {1 alarm} other {# alarms} }",
            "clear-alarms-text": "Are you sure you want to clear { count, select, 1 {1 alarm} other {# alarms} }?"
        },
        "alias": { // TODO
            "add": "Add alias",
            "edit": "Edit alias",
            "name": "Alias name",
            "name-required": "Alias name is required",
            "duplicate-alias": "Alias with same name is already exists.",
            "filter-type-single-entity": "Single entity",
            "filter-type-entity-list": "Entity list",
            "filter-type-entity-name": "Entity name",
            "filter-type-state-entity": "Entity from dashboard state",
            "filter-type-state-entity-description": "Entity taken from dashboard state parameters",
            "filter-type-asset-type": "Asset type",
            "filter-type-asset-type-description": "Assets of type '{{assetType}}'",
            "filter-type-asset-type-and-name-description": "Assets of type '{{assetType}}' and with name starting with '{{prefix}}'",
            "filter-type-device-type": "Device type",
            "filter-type-device-type-description": "Devices of type '{{deviceType}}'",
            "filter-type-device-type-and-name-description": "Devices of type '{{deviceType}}' and with name starting with '{{prefix}}'",
            "filter-type-relations-query": "Relations query",
            "filter-type-relations-query-description": "{{entities}} that have {{relationType}} relation {{direction}} {{rootEntity}}",
            "filter-type-asset-search-query": "Asset search query",
            "filter-type-asset-search-query-description": "Assets with types {{assetTypes}} that have {{relationType}} relation {{direction}} {{rootEntity}}",
            "filter-type-device-search-query": "Device search query",
            "filter-type-device-search-query-description": "Devices with types {{deviceTypes}} that have {{relationType}} relation {{direction}} {{rootEntity}}",
            "entity-filter": "Entity filter",
            "resolve-multiple": "Resolve as multiple entities",
            "filter-type": "Filter type",
            "filter-type-required": "Filter type is required.",
            "entity-filter-no-entity-matched": "No entities matching specified filter were found.",
            "no-entity-filter-specified": "No entity filter specified",
            "root-state-entity": "Use dashboard state entity as root",
            "root-entity": "Root entity",
            "state-entity-parameter-name": "State entity parameter name",
            "default-state-entity": "Default state entity",
            "default-entity-parameter-name": "By default",
            "max-relation-level": "Max relation level",
            "unlimited-level": "Unlimited level",
            "state-entity": "Dashboard state entity",
            "all-entities": "All entities",
            "any-relation": "any"
        },
        "asset": { // TODO
            "asset": "Asset",
            "assets": "Assets",
            "management": "Asset management",
            "view-assets": "View Assets",
            "add": "Add Asset",
            "assign-to-customer": "Assign to customer",
            "assign-asset-to-customer": "Assign Asset(s) To Customer",
            "assign-asset-to-customer-text": "Please select the assets to assign to the customer",
            "no-assets-text": "No assets found",
            "assign-to-customer-text": "Please select the customer to assign the asset(s)",
            "public": "Public",
            "assignedToCustomer": "Assigned to customer",
            "make-public": "Make asset public",
            "make-private": "Make asset private",
            "unassign-from-customer": "Unassign from customer",
            "delete": "Delete asset",
            "asset-public": "Asset is public",
            "asset-type": "Asset type",
            "asset-type-required": "Asset type is required.",
            "select-asset-type": "Select asset type",
            "enter-asset-type": "Enter asset type",
            "any-asset": "Any asset",
            "no-asset-types-matching": "No asset types matching '{{entitySubtype}}' were found.",
            "asset-type-list-empty": "No asset types selected.",
            "asset-types": "Asset types",
            "name": "Name",
            "name-required": "Name is required.",
            "description": "Description",
            "type": "Type",
            "type-required": "Type is required.",
            "details": "Details",
            "events": "Events",
            "add-asset-text": "Add new asset",
            "asset-details": "Asset details",
            "assign-assets": "Assign assets",
            "assign-assets-text": "Assign { count, select, 1 {1 asset} other {# assets} } to customer",
            "delete-assets": "Delete assets",
            "unassign-assets": "Unassign assets",
            "unassign-assets-action-title": "Unassign { count, select, 1 {1 asset} other {# assets} } from customer",
            "assign-new-asset": "Assign new asset",
            "delete-asset-title": "Are you sure you want to delete the asset '{{assetName}}'?",
            "delete-asset-text": "Be careful, after the confirmation the asset and all related data will become unrecoverable.",
            "delete-assets-title": "Are you sure you want to delete { count, select, 1 {1 asset} other {# assets} }?",
            "delete-assets-action-title": "Delete { count, select, 1 {1 asset} other {# assets} }",
            "delete-assets-text": "Be careful, after the confirmation all selected assets will be removed and all related data will become unrecoverable.",
            "make-public-asset-title": "Are you sure you want to make the asset '{{assetName}}' public?",
            "make-public-asset-text": "After the confirmation the asset and all its data will be made public and accessible by others.",
            "make-private-asset-title": "Are you sure you want to make the asset '{{assetName}}' private?",
            "make-private-asset-text": "After the confirmation the asset and all its data will be made private and won't be accessible by others.",
            "unassign-asset-title": "Are you sure you want to unassign the asset '{{assetName}}'?",
            "unassign-asset-text": "After the confirmation the asset will be unassigned and won't be accessible by the customer.",
            "unassign-asset": "Unassign asset",
            "unassign-assets-title": "Are you sure you want to unassign { count, select, 1 {1 asset} other {# assets} }?",
            "unassign-assets-text": "After the confirmation all selected assets will be unassigned and won't be accessible by the customer.",
            "copyId": "Copy asset Id",
            "idCopiedMessage": "Asset Id has been copied to clipboard",
            "select-asset": "Select asset",
            "no-assets-matching": "No assets matching '{{entity}}' were found.",
            "asset-required": "Asset is required",
            "name-starts-with": "Asset name starts with"
        },
        "attribute": {
            "attributes": "Атрибуты",
            "latest-telemetry": "Последняя телеметрия",
            "attributes-scope": "Контекст атрибутов устройства",
            "scope-latest-telemetry": "Последняя телеметрия",
            "scope-client": "Клиентские атрибуты",
            "scope-server": "Серверные атрибуты",
            "scope-shared": "Общие атрибуты",
            "add": "Добавить атрибут",
            "key": "Ключ",
            "key-required": "Ключ атрибута обязателен.",
            "value": "Значение",
            "value-required": "Значение атрибута обязательно.",
            "delete-attributes-title": "Вы уверенны, что хотите удалить { count, plural, one {1 атрибут} few {# атрибута} other {# атрибутов} }? ",
            "delete-attributes-text": "Внимание, после подтверждения выбранные атрибуты будут удалены.",
            "delete-attributes": "Удалить атрибуты",
            "enter-attribute-value": "Введите значение атрибута",
            "show-on-widget": "Показать на виджете",
            "widget-mode": "Виджет-режим",
            "next-widget": "Следующий виджет",
            "prev-widget": "Предыдущий виджет",
            "add-to-dashboard": "Добавить на дашборд",
            "add-widget-to-dashboard": "Добавить виджет на дашборд",
            "selected-attributes": "{ count, plural, 1 {Выбран} other {Выбраны} } { count, plural, one {1 атрибут} few {# атрибута} other {# атрибутов} }",
            "selected-telemetry": "{ count, plural, 1 {Выбран} other {Выбраны} } { count, plural, 1 {1 параметр} few {# параметра} other {# параметров} } телеметрии"
        },
        "audit-log": { // TODO
            "audit": "Audit",
            "audit-logs": "Audit Logs",
            "timestamp": "Timestamp",
            "entity-type": "Entity Type",
            "entity-name": "Entity Name",
            "user": "User",
            "type": "Type",
            "status": "Status",
            "details": "Details",
            "type-added": "Added",
            "type-deleted": "Deleted",
            "type-updated": "Updated",
            "type-attributes-updated": "Attributes updated",
            "type-attributes-deleted": "Attributes deleted",
            "type-rpc-call": "RPC call",
            "type-credentials-updated": "Credentials updated",
            "type-assigned-to-customer": "Assigned to Customer",
            "type-unassigned-from-customer": "Unassigned from Customer",
            "type-activated": "Activated",
            "type-suspended": "Suspended",
            "type-credentials-read": "Credentials read",
            "type-attributes-read": "Attributes read",
            "status-success": "Success",
            "status-failure": "Failure",
            "audit-log-details": "Audit log details",
            "no-audit-logs-prompt": "No logs found",
            "action-data": "Action data",
            "failure-details": "Failure details",
            "search": "Search audit logs",
            "clear-search": "Clear search"
        },
        "confirm-on-exit": {
            "message": "У вас есть несохраненные изменения. Вы точно хотите покинуть эту страницу?",
            "html-message": "У вас есть несохраненные изменения.<br/>Вы точно хотите покинуть эту страницу?",
            "title": "Несохраненные изменения"
        },
        "contact": {
            "country": "Страна",
            "city": "Город",
            "state": "Штат",
            "postal-code": "Почтовый код",
            "postal-code-invalid": "Допустимы только цифры",
            "address": "Адрес",
            "address2": "Адрес 2",
            "phone": "Телефон",
            "email": "Эл. адрес",
            "no-address": "Адрес не указан"
        },
        "common": {
            "username": "Имя пользователя",
            "password": "Пароль",
            "enter-username": "Введите имя пользователя",
            "enter-password": "Введите пароль",
            "enter-search": "Введите условие поиска"
        },
        "content-type": { // TODO
            "json": "Json",
            "text": "Text",
            "binary": "Binary (Base64)"
        },
        "customer": {
            "customers": "Клиенты",
            "management": "Управление клиентами",
            "dashboard": "Дашборд клиентов",
            "dashboards": "Дашборды клиентов",
            "devices": "Устройства клиента",
            "public-dashboards": "Общедоступные дашборды",
            "public-devices": "Общедоступные устройства",
            "add": "Добавить клиента",
            "delete": "Удалить клиента",
            "manage-customer-users": "Управление пользователями клиента",
            "manage-customer-devices": "Управление устройствами клиента",
            "manage-customer-dashboards": "Управление дашбордами клиента",
            "manage-public-devices": "Управление общедоступными устройствами",
            "manage-public-dashboards": "Управление общедоступными дашбордами",
            "add-customer-text": "Добавить нового клиента",
            "no-customers-text": "Клиенты не найдены",
            "customer-details": "Подробности о клиенте",
            "delete-customer-title": "Вы точно хотите удалить клиента '{{customerTitle}}'?",
            "delete-customer-text": "Внимание, после подтверждения клиент и вся связанная с ним информация будут безвозвратно утеряны.",
            "delete-customers-title": "Вы точно хотите удалить { count, plural, one {1 клиента} other {# клиентов} }?",
            "delete-customers-action-title": "Удалить { count, plural, one {1 клиента} other {# клиентов} } }",
            "delete-customers-text": "Внимание, после подтверждения клиенты и вся связанная с ними информация будут безвозвратно утеряны.",
            "manage-users": "Управление пользователями",
            "manage-assets": "Manage assets", // TODO
            "manage-devices": "Управление устройствами",
            "manage-dashboards": "Управление дашбордами",
            "title": "Имя",
            "title-required": "Название обязательно.",
            "description": "Описание",
            "details": "Details", // TODO
            "events": "Events", // TODO
            "copyId": "Copy customer Id", // TODO
            "idCopiedMessage": "Customer Id has been copied to clipboard", // TODO
            "select-customer": "Select customer", // TODO
            "no-customers-matching": "No customers matching '{{entity}}' were found.", // TODO
            "customer-required": "Customer is required", // TODO
            "select-default-customer": "Select default customer", // TODO
            "default-customer": "Default customer", // TODO
            "default-customer-required": "Default customer is required in order to debug dashboard on Tenant level" // TODO
        },
        "datetime": {
            "date-from": "Дата с",
            "time-from": "Время с",
            "date-to": "Дата до",
            "time-to": "Время до"
        },
        "dashboard": {
            "dashboard": "Дашборд",
            "dashboards": "Дашборды",
            "management": "Управление дашбордами",
            "view-dashboards": "Просмотреть дашборды",
            "add": "Добавить дашборд",
            "assign-dashboard-to-customer": "Прикрепить дашборд(ы) к клиенту",
            "assign-dashboard-to-customer-text": "Пожалуйста, выберите дашборды, которые нужно прикрепить к клиенту",
            "assign-to-customer-text": "Пожалуйста, выберите клиента, к которому нужно прикрепить дашборд(ы)",
            "assign-to-customer": "Прикрепить к клиенту",
            "unassign-from-customer": "Открепить от клиента",
            "make-public": "Открыть дашборд для общего доступа",
            "make-private": "Закрыть дашборд для общего доступа",
            "no-dashboards-text": "Дашборды не найдены",
            "no-widgets": "Виджеты не сконфигурированы",
            "add-widget": "Добавить новый виджет",
            "title": "Название",
            "select-widget-title": "Выберите виджет",
            "select-widget-subtitle": "Список доступных виджетов",
            "delete": "Удалить дашборд",
            "title-required": "Название обязательно.",
            "description": "Описание",
            "details": "Подробности",
            "dashboard-details": "Подробности о дашборде",
            "add-dashboard-text": "Добавить новый дашборд",
            "assign-dashboards": "Прикрепить дашборды",
            "assign-new-dashboard": "Прикрепить новый дашборд",
            "assign-dashboards-text": "Прикрепить { count, plural, 1 {1 дашборд} other {# дашборда} } к клиенту",
            "delete-dashboards": "Удалить дашборды",
            "unassign-dashboards": "Открепить дашборды",
            "unassign-dashboards-action-title": "Открепить { count, plural, one {1 дашборд} few {# дашборда} other {# дашбордов} } от клиента",
            "delete-dashboard-title": "Вы точно хотите удалить дашборд '{{dashboardTitle}}'?",
            "delete-dashboard-text": "Внимание, после подтверждения дашборд и все связанные с ним данные будут безвозвратно утеряны.",
            "delete-dashboards-title": "Вы точно хотите удалить { count, plural, one {1 дашборд} few {# дашборда} other {# дашбордов} }?",
            "delete-dashboards-action-title": "Удалить { count, plural, one {1 дашборд} few {# дашборда} other {# дашбордов} }",
            "delete-dashboards-text": "Внимание, после подтверждения дашборды и все связанные с ними данные будут безвозвратно утеряны.",
            "unassign-dashboard-title": "Вы точно хотите открепить дашборд '{{dashboardTitle}}'?",
            "unassign-dashboard-text": "После подтверждения дашборд не будет доступен клиенту.",
            "unassign-dashboard": "Открепить дашборд",
            "unassign-dashboards-title": "Вы точно хотите открепить { count, plural, one {1 дашборд} few {# дашборда} other {# дашбордов} }?",
            "unassign-dashboards-text": "После подтверждения выбранные дашборды не будут доступны клиенту.",
            "public-dashboard-title": "Теперь дашборд общедоступный",
            "public-dashboard-text": "Теперь ваш дашборд <b>{{dashboardTitle}}</b> доступен всем по <a href='{{publicLink}}' target='_blank'>ссылке</a>:",
            "public-dashboard-notice": "<b>Примечание:</b> Для получения доступа к данным устройства нужно открыть общий доступ к этому устройству.",
            "make-private-dashboard-title": "Вы точно хотите закрыть общий доступ к дашборду '{{dashboardTitle}}'?",
            "make-private-dashboard-text": "После подтверждения дашборд будет закрыт для общего доступа.",
            "make-private-dashboard": "Закрыть дашборд для общего доступа",
            "socialshare-text": "'{{dashboardTitle}}' сделано ThingsBoard",
            "socialshare-title": "'{{dashboardTitle}}' сделано ThingsBoard",
            "select-dashboard": "Выберите дашборд",
            "no-dashboards-matching": "Дашборд '{{entity}}' не найден.",
            "dashboard-required": "Дашборд обязателен.",
            "select-existing": "Выберите существующий дашборд",
            "create-new": "Создать новый дашборд",
            "new-dashboard-title": "Новое название дашборда",
            "open-dashboard": "Открыть дашборд",
            "set-background": "Установить фон",
            "background-color": "Фоновый цвет",
            "background-image": "Фоновая картинка",
            "background-size-mode": "Размер фона",
            "no-image": "Картинка не выбрана",
            "drop-image": "Перетащите картинку или кликните для выбора файла.",
            "settings": "Настройки",
            "columns-count": "Количество колонок",
            "columns-count-required": "Количество колонок обязательно.",
            "min-columns-count-message": "Минимальное число колонок - 10.",
            "max-columns-count-message": "Максимальное число колонок - 1000.",
            "widgets-margins": "Величина отступа между виджетами",
            "horizontal-margin": "Величина горизонтального отступа",
            "horizontal-margin-required": "Величина горизонтального отступа обязательна.",
            "min-horizontal-margin-message": "Минимальная величина горизонтального отступа - 0.",
            "max-horizontal-margin-message": "Максимальная величина горизонтального отступа - 50.",
            "vertical-margin": "Величина вертикального отступа",
            "vertical-margin-required": "Величина вертикального отступа обязательна.",
            "min-vertical-margin-message": "Минимальная величина вертикального отступа - 0.",
            "max-vertical-margin-message": "Максимальная величина вертикального отступа - 50.",
            "display-title": "Показать название дашборда",
            "title-color": "Цвет названия",
            "display-device-selection": "Показать выборку устройств",
            "display-dashboard-timewindow": "Показать временное окно",
            "display-dashboard-export": "Показать экспорт",
            "import": "Импортировать дашборд",
            "export": "Экспортировать дашборд",
            "export-failed-error": "Не удалось экспортировать дашборд: {{error}}",
            "create-new-dashboard": "Создать новый дашборд",
            "dashboard-file": "Файл дашборда",
            "invalid-dashboard-file-error": "Не удалось импортировать дашборд: неизвестная схема данных дашборда.",
            "dashboard-import-missing-aliases-title": "Конфигурировать псевдонимы импортированного дашборда",
            "create-new-widget": "Создать новый виджет",
            "import-widget": "Импортировать новый виджет",
            "widget-file": "Файл виджета",
            "invalid-widget-file-error": "Не удалось импортировать виджет: неизвестная схема данных виджета.",
            "widget-import-missing-aliases-title": "Конфигурировать псевдонимы импортированного виджета",
            "open-toolbar": "Открыть панель инструментов",
            "close-toolbar": "Закрыть панель инструментов",
            "configuration-error": "Ошибка конфигурирования",
            "alias-resolution-error-title": "Ошибка конфигурирования псевдонимов дашборда",
            "invalid-aliases-config": "Не удалось найти устройства, соответствующие фильтру псевдонимов.<br/>" +
                "Пожалуйста, свяжитесь с администратором для устранения этой проблемы.",
            "select-devices": "Выберите устройства",
            "assignedToCustomer": "Прикреплен к клиенту",
            "public": "Общедоступный",
            "public-link": "Общедоступная ссылка",
            "copy-public-link": "Скопировать общедоступную ссылку",
            "public-link-copied-message": "Общедоступная ссылка на дашборд скопирована в буфер обмена",
            "manage-states": "Manage dashboard states", // TODO
            "states": "Dashboard states", // TODO
            "search-states": "Search dashboard states", // TODO
            "selected-states": "{ count, select, 1 {1 dashboard state} other {# dashboard states} } selected", // TODO
            "edit-state": "Edit dashboard state", // TODO
            "delete-state": "Delete dashboard state", // TODO
            "add-state": "Add dashboard state", // TODO
            "state": "Dashboard state", // TODO
            "state-name": "Name", // TODO
            "state-name-required": "Dashboard state name is required.", // TODO
            "state-id": "State Id", // TODO
            "state-id-required": "Dashboard state id is required.", // TODO
            "state-id-exists": "Dashboard state with the same id is already exists.", // TODO
            "is-root-state": "Root state", // TODO
            "delete-state-title": "Delete dashboard state", // TODO
            "delete-state-text": "Are you sure you want delete dashboard state with name '{{stateName}}'?", // TODO
            "show-details": "Show details", // TODO
            "hide-details": "Hide details", // TODO
            "select-state": "Select target state", // TODO
            "state-controller": "State controller" // TODO
        },
        "datakey": {
            "settings": "Настройки",
            "advanced": "Дополнительно",
            "label": "Метка",
            "color": "Цвет",
            "units": "Special symbol to show next to value", // TODO
            "decimals": "Number of digits after floating point", // TODO
            "data-generation-func": "Функция генерации данных",
            "use-data-post-processing-func": "Использовать функцию пост-обработки данных",
            "configuration": "Конфигурация ключа данных",
            "timeseries": "Выборка по времени",
            "attributes": "Атрибуты",
            "timeseries-required": "Выборка по времени обязательна.",
            "timeseries-or-attributes-required": "Выборка по времени/атрибуты обязательны.",
            "maximum-timeseries-or-attributes": "Maximum { count, select, 1 {1 timeseries/attribute is allowed.} other {# timeseries/attributes are allowed} }", // TODO
            "alarm-fields-required": "Alarm fields are required.", // TODO
            "function-types": "Тип функции",
            "function-types-required": "Тип функции обязателен.",
            "maximum-function-types": "Maximum { count, select, 1 {1 function type is allowed.} other {# function types are allowed} }" // TODO
        },
        "datasource": {
            "type": "Тип источника данных",
            "add-datasource-prompt": "Пожалуйста, добавьте источник данных"
        },
        "details": {
            "edit-mode": "Режим редактирования",
            "toggle-edit-mode": "Режим редактирования"
        },
        "device": {
            "device": "Устройство",
            "device-required": "Устройство обязательно.",
            "devices": "Устройства",
            "management": "Управление устройствами",
            "view-devices": "Просмотреть устройства",
            "device-alias": "Псевдоним устройства",
            "aliases": "Псевдонимы устройства",
            "no-alias-matching": "'{{alias}}' не найден.",
            "no-aliases-found": "Псевдонимы не найдены.",
            "no-key-matching": "'{{key}}' не найден.",
            "no-keys-found": "Ключи не найдены.",
            "create-new-alias": "Создать новый!",
            "create-new-key": "Создать новый!",
            "duplicate-alias-error": "Найден дублирующийся псевдоним '{{alias}}'.<br>В рамках дашборда псевдонимы устройств должны быть уникальными.",
            "configure-alias": "Конфигурировать '{{alias}}' псевдоним",
            "no-devices-matching": "Устройство '{{entity}}' не найдено.",
            "alias": "Псевдоним",
            "alias-required": "Псевдоним устройства обязателен.",
            "remove-alias": "Удалить псевдоним устройства",
            "add-alias": "Добавить псевдоним устройства",
            "name-starts-with": "Название начинается с",
            "device-list": "Список устройств",
            "use-device-name-filter": "Использовать фильтр",
            "device-list-empty": "Устройства не выбраны.",
            "device-name-filter-required": "Фильтр названия устройства обязателен.",
            "device-name-filter-no-device-matched": "Устройства, названия которых начинаются с '{{device}}', не найдены.",
            "add": "Добавить устройство",
            "assign-to-customer": "Присвоить клиенту",
            "assign-device-to-customer": "Присвоить устройство(а) клиенту",
            "assign-device-to-customer-text": "Пожалуйста, выберите устройства, которые нужно присвоить клиенту",
            "make-public": "Открыть общий доступ к устройству",
            "make-private": "Закрыть общий доступ к устройству",
            "no-devices-text": "Устройства не найдены",
            "assign-to-customer-text": "Пожалуйста, выберите клиента, которому нужно присвоить устройство(а)",
            "device-details": "Подробности об устройстве",
            "add-device-text": "Добавить новое устройство",
            "credentials": "Учетные данные",
            "manage-credentials": "Управление учетными данными",
            "delete": "Удалить устройство",
            "assign-devices": "Присвоить устройство",
            "assign-devices-text": "Присвоить { count, plural, one {1 устройство} few {# устройства} other {# устройств} } клиенту",
            "delete-devices": "Удалить устройства",
            "unassign-from-customer": "Отменить присвоение клиенту",
            "unassign-devices": "Отменить присвоение устройств",
            "unassign-devices-action-title": "Отменить присвоение { count, plural, one {1 устройства} few {# устройств} other {# устройств} } клиенту",
            "assign-new-device": "Присвоить новое устройство",
            "make-public-device-title": "Вы точно хотите открыть общий доступ к устройству '{{deviceName}}'?",
            "make-public-device-text": "После подтверждения устройство и все связанные с ним данные будут общедоступными.",
            "make-private-device-title": "Вы точно хотите закрыть общий доступ к устройству '{{deviceName}}'",
            "make-private-device-text": "После подтверждения устройство и все связанные с ним данные будут закрыты для общего доступа.",
            "view-credentials": "Просмотреть учетные данные",
            "delete-device-title": "Вы точно хотите удалить устройство '{{deviceName}}'?",
            "delete-device-text": "Внимание, после подтверждения устройство и все связанные с ним данные будут безвозвратно утеряны.",
            "delete-devices-title": "Вы точно хотите удалить { count, plural, one {1 устройство} few {# устройства} other {# устройств} }?",
            "delete-devices-action-title": "Удалить { count, plural, one {1 устройство} few {# устройства} other {# устройств} } }",
            "delete-devices-text": "Внимание, после подтверждения выбранные устройства и все связанные с ними данные будут безвозвратно утеряны..",
            "unassign-device-title": "Вы точно хотите отменить присвоение устройства '{{deviceName}}'?",
            "unassign-device-text": "После подтверждения устройство будет недоступно клиенту.",
            "unassign-device": "Отменить присвоение устройства",
            "unassign-devices-title": "Вы точно хотите отменить присвоение { count, plural, one {1 устройство} few {# устройства} other {# устройств} } }?",
            "unassign-devices-text": "После подтверждения выбранные устройства будут недоступны клиенту.",
            "device-credentials": "Учетные данные устройства",
            "credentials-type": "Тип учетных данных",
            "access-token": "Токен",
            "access-token-required": "Токен обязателен.",
            "access-token-invalid": "Длина токена должна быть от 1 до 20 символов.",
            "rsa-key": "Открытый ключ RSA",
            "rsa-key-required": "Открытый ключ RSA обязателен.",
            "secret": "Секрет",
            "secret-required": "Секрет обязателен.",
            "name": "Название",
            "name-required": "Название обязательно.",
            "description": "Описание",
            "events": "События",
            "details": "Подробности",
            "copyId": "Копировать идентификатор устройства",
            "copyAccessToken": "Копировать токен",
            "idCopiedMessage": "Идентификатор устройства скопирован в буфер обмена",
            "accessTokenCopiedMessage": "Токен устройства скопирован в буфер обмена",
            "assignedToCustomer": "Присвоен клиенту",
            "unable-delete-device-alias-title": "Не удалось удалить псевдоним устройства",
            "unable-delete-device-alias-text": "Не удалось удалить псевдоним '{{deviceAlias}}' устройства, т.к. он используется следующими виджетами:<br/>{{widgetsList}}",
            "is-gateway": "Гейтвей",
            "public": "Общедоступный",
            "device-public": "Устройство общедоступно"
        },
        "dialog": {
            "close": "Закрыть диалог"
        },
        "error": {
            "unable-to-connect": "Не удалось подключиться к серверу! Пожалуйста, проверьте интернет-соединение.",
            "unhandled-error-code": "Код необработанной ошибки: {{errorCode}}",
            "unknown-error": "Неизвестная ошибка"
        },
        "entity": { // TODO
            "entity": "Entity",
            "entities": "Entities",
            "aliases": "Entity aliases",
            "entity-alias": "Entity alias",
            "unable-delete-entity-alias-title": "Unable to delete entity alias",
            "unable-delete-entity-alias-text": "Entity alias '{{entityAlias}}' can't be deleted as it used by the following widget(s):<br/>{{widgetsList}}",
            "duplicate-alias-error": "Duplicate alias found '{{alias}}'.<br>Entity aliases must be unique whithin the dashboard.",
            "missing-entity-filter-error": "Filter is missing for alias '{{alias}}'.",
            "configure-alias": "Configure '{{alias}}' alias",
            "alias": "Alias",
            "alias-required": "Entity alias is required.",
            "remove-alias": "Remove entity alias",
            "add-alias": "Add entity alias",
            "entity-list": "Entity list",
            "entity-type": "Entity type",
            "entity-types": "Entity types",
            "entity-type-list": "Entity type list",
            "any-entity": "Any entity",
            "enter-entity-type": "Enter entity type",
            "no-entities-matching": "No entities matching '{{entity}}' were found.",
            "no-entity-types-matching": "No entity types matching '{{entityType}}' were found.",
            "name-starts-with": "Name starts with",
            "use-entity-name-filter": "Use filter",
            "entity-list-empty": "No entities selected.",
            "entity-type-list-empty": "No entity types selected.",
            "entity-name-filter-required": "Entity name filter is required.",
            "entity-name-filter-no-entity-matched": "No entities starting with '{{entity}}' were found.",
            "all-subtypes": "All",
            "select-entities": "Select entities",
            "no-aliases-found": "No aliases found.",
            "no-alias-matching": "'{{alias}}' not found.",
            "create-new-alias": "Create a new one!",
            "key": "Key",
            "key-name": "Key name",
            "no-keys-found": "No keys found.",
            "no-key-matching": "'{{key}}' not found.",
            "create-new-key": "Create a new one!",
            "type": "Type",
            "type-required": "Entity type is required.",
            "type-device": "Device",
            "type-devices": "Devices",
            "list-of-devices": "{ count, select, 1 {One device} other {List of # devices} }",
            "device-name-starts-with": "Devices whose names start with '{{prefix}}'",
            "type-asset": "Asset",
            "type-assets": "Assets",
            "list-of-assets": "{ count, select, 1 {One asset} other {List of # assets} }",
            "asset-name-starts-with": "Assets whose names start with '{{prefix}}'",
            "type-rule": "Rule",
            "type-rules": "Rules",
            "list-of-rules": "{ count, select, 1 {One rule} other {List of # rules} }",
            "rule-name-starts-with": "Rules whose names start with '{{prefix}}'",
            "type-plugin": "Plugin",
            "type-plugins": "Plugins",
            "list-of-plugins": "{ count, select, 1 {One plugin} other {List of # plugins} }",
            "plugin-name-starts-with": "Plugins whose names start with '{{prefix}}'",
            "type-tenant": "Tenant",
            "type-tenants": "Tenants",
            "list-of-tenants": "{ count, select, 1 {One tenant} other {List of # tenants} }",
            "tenant-name-starts-with": "Tenants whose names start with '{{prefix}}'",
            "type-customer": "Customer",
            "type-customers": "Customers",
            "list-of-customers": "{ count, select, 1 {One customer} other {List of # customers} }",
            "customer-name-starts-with": "Customers whose names start with '{{prefix}}'",
            "type-user": "User",
            "type-users": "Users",
            "list-of-users": "{ count, select, 1 {One user} other {List of # users} }",
            "user-name-starts-with": "Users whose names start with '{{prefix}}'",
            "type-dashboard": "Dashboard",
            "type-dashboards": "Dashboards",
            "list-of-dashboards": "{ count, select, 1 {One dashboard} other {List of # dashboards} }",
            "dashboard-name-starts-with": "Dashboards whose names start with '{{prefix}}'",
            "type-alarm": "Alarm",
            "type-alarms": "Alarms",
            "list-of-alarms": "{ count, select, 1 {One alarms} other {List of # alarms} }",
            "alarm-name-starts-with": "Alarms whose names start with '{{prefix}}'",
            "type-rulechain": "Rule chain",
            "type-rulechains": "Rule chains",
            "list-of-rulechains": "{ count, select, 1 {One rule chain} other {List of # rule chains} }",
            "rulechain-name-starts-with": "Rule chains whose names start with '{{prefix}}'",
            "type-current-customer": "Current Customer",
            "search": "Search entities",
            "selected-entities": "{ count, select, 1 {1 entity} other {# entities} } selected",
            "entity-name": "Entity name",
            "details": "Entity details",
            "no-entities-prompt": "No entities found",
            "no-data": "No data to display"
        },
        "event": {
            "event-type": "Тип события",
            "type-error": "Ошибка",
            "type-lc-event": "Событие жизненного цикла",
            "type-stats": "Статистика",
            "type-debug-rule-node": "Debug", // TODO
            "type-debug-rule-chain": "Debug", // TODO
            "no-events-prompt": "События не найдены",
            "error": "Ошибка",
            "alarm": "Аварийное оповещение",
            "event-time": "Время возникновения события",
            "server": "Сервер",
            "body": "Тело",
            "method": "Метод",
            "type": "Type", // TODO
            "entity": "Entity", // TODO
            "message-id": "Message Id", // TODO
            "message-type": "Message Type", // TODO
            "data-type": "Data Type", // TODO
            "relation-type": "Relation Type", // TODO
            "metadata": "Metadata", // TODO
            "data": "Data", // TODO
            "event": "Событие",
            "status": "Статус",
            "success": "Успех",
            "failed": "Неудача",
            "messages-processed": "Сообщения обработаны",
            "errors-occurred": "Возникли ошибки"
        },
        "extension": { // TODO
            "extensions": "Extensions",
            "selected-extensions": "{ count, select, 1 {1 extension} other {# extensions} } selected",
            "type": "Type",
            "key": "Key",
            "value": "Value",
            "id": "Id",
            "extension-id": "Extension id",
            "extension-type": "Extension type",
            "transformer-json": "JSON *",
            "unique-id-required": "Current extension id already exists.",
            "delete": "Delete extension",
            "add": "Add extension",
            "edit": "Edit extension",
            "delete-extension-title": "Are you sure you want to delete the extension '{{extensionId}}'?",
            "delete-extension-text": "Be careful, after the confirmation the extension and all related data will become unrecoverable.",
            "delete-extensions-title": "Are you sure you want to delete { count, select, 1 {1 extension} other {# extensions} }?",
            "delete-extensions-text": "Be careful, after the confirmation all selected extensions will be removed.",
            "converters": "Converters",
            "converter-id": "Converter id",
            "configuration": "Configuration",
            "converter-configurations": "Converter configurations",
            "token": "Security token",
            "add-converter": "Add converter",
            "add-config": "Add converter configuration",
            "device-name-expression": "Device name expression",
            "device-type-expression": "Device type expression",
            "custom": "Custom",
            "to-double": "To Double",
            "transformer": "Transformer",
            "json-required": "Transformer json is required.",
            "json-parse": "Unable to parse transformer json.",
            "attributes": "Attributes",
            "add-attribute": "Add attribute",
            "add-map": "Add mapping element",
            "timeseries": "Timeseries",
            "add-timeseries": "Add timeseries",
            "field-required": "Field is required",
            "brokers": "Brokers",
            "add-broker": "Add broker",
            "host": "Host",
            "port": "Port",
            "port-range": "Port should be in a range from 1 to 65535.",
            "ssl": "Ssl",
            "credentials": "Credentials",
            "username": "Username",
            "password": "Password",
            "retry-interval": "Retry interval in milliseconds",
            "anonymous": "Anonymous",
            "basic": "Basic",
            "pem": "PEM",
            "ca-cert": "CA certificate file *",
            "private-key": "Private key file *",
            "cert": "Certificate file *",
            "no-file": "No file selected.",
            "drop-file": "Drop a file or click to select a file to upload.",
            "mapping": "Mapping",
            "topic-filter": "Topic filter",
            "converter-type": "Converter type",
            "converter-json": "Json",
            "json-name-expression": "Device name json expression",
            "topic-name-expression": "Device name topic expression",
            "json-type-expression": "Device type json expression",
            "topic-type-expression": "Device type topic expression",
            "attribute-key-expression": "Attribute key expression",
            "attr-json-key-expression": "Attribute key json expression",
            "attr-topic-key-expression": "Attribute key topic expression",
            "request-id-expression": "Request id expression",
            "request-id-json-expression": "Request id json expression",
            "request-id-topic-expression": "Request id topic expression",
            "response-topic-expression": "Response topic expression",
            "value-expression": "Value expression",
            "topic": "Topic",
            "timeout": "Timeout in milliseconds",
            "converter-json-required": "Converter json is required.",
            "converter-json-parse": "Unable to parse converter json.",
            "filter-expression": "Filter expression",
            "connect-requests": "Connect requests",
            "add-connect-request": "Add connect request",
            "disconnect-requests": "Disconnect requests",
            "add-disconnect-request": "Add disconnect request",
            "attribute-requests": "Attribute requests",
            "add-attribute-request": "Add attribute request",
            "attribute-updates": "Attribute updates",
            "add-attribute-update": "Add attribute update",
            "server-side-rpc": "Server side RPC",
            "add-server-side-rpc-request": "Add server-side RPC request",
            "device-name-filter": "Device name filter",
            "attribute-filter": "Attribute filter",
            "method-filter": "Method filter",
            "request-topic-expression": "Request topic expression",
            "response-timeout": "Response timeout in milliseconds",
            "topic-expression": "Topic expression",
            "client-scope": "Client scope",
            "add-device": "Add device",
            "opc-server": "Servers",
            "opc-add-server": "Add server",
            "opc-add-server-prompt": "Please add server",
            "opc-application-name": "Application name",
            "opc-application-uri": "Application uri",
            "opc-scan-period-in-seconds": "Scan period in seconds",
            "opc-security": "Security",
            "opc-identity": "Identity",
            "opc-keystore": "Keystore",
            "opc-type": "Type",
            "opc-keystore-type": "Type",
            "opc-keystore-location": "Location *",
            "opc-keystore-password": "Password",
            "opc-keystore-alias": "Alias",
            "opc-keystore-key-password": "Key password",
            "opc-device-node-pattern": "Device node pattern",
            "opc-device-name-pattern": "Device name pattern",
            "modbus-server": "Servers/slaves",
            "modbus-add-server": "Add server/slave",
            "modbus-add-server-prompt": "Please add server/slave",
            "modbus-transport": "Transport",
            "modbus-port-name": "Serial port name",
            "modbus-encoding": "Encoding",
            "modbus-parity": "Parity",
            "modbus-baudrate": "Baud rate",
            "modbus-databits": "Data bits",
            "modbus-stopbits": "Stop bits",
            "modbus-databits-range": "Data bits should be in a range from 7 to 8.",
            "modbus-stopbits-range": "Stop bits should be in a range from 1 to 2.",
            "modbus-unit-id": "Unit ID",
            "modbus-unit-id-range": "Unit ID should be in a range from 1 to 247.",
            "modbus-device-name": "Device name",
            "modbus-poll-period": "Poll period (ms)",
            "modbus-attributes-poll-period": "Attributes poll period (ms)",
            "modbus-timeseries-poll-period": "Timeseries poll period (ms)",
            "modbus-poll-period-range": "Poll period should be positive value.",
            "modbus-tag": "Tag",
            "modbus-function": "Function",
            "modbus-register-address": "Register address",
            "modbus-register-address-range": "Register address should be in a range from 0 to 65535.",
            "modbus-register-bit-index": "Bit index",
            "modbus-register-bit-index-range": "Bit index should be in a range from 0 to 15.",
            "modbus-register-count": "Register count",
            "modbus-register-count-range": "Register count should be a positive value.",
            "modbus-byte-order": "Byte order",

            "sync": {
                "status": "Status",
                "sync": "Sync",
                "not-sync": "Not sync",
                "last-sync-time": "Last sync time",
                "not-available": "Not available"
            },

            "export-extensions-configuration": "Export extensions configuration",
            "import-extensions-configuration": "Import extensions configuration",
            "import-extensions": "Import extensions",
            "import-extension": "Import extension",
            "export-extension": "Export extension",
            "file": "Extensions file",
            "invalid-file-error": "Invalid extension file"
        },
        "fullscreen": {
            "expand": "Во весь экран",
            "exit": "Выйти из полноэкранного режима",
            "toggle": "Во весь экран",
            "fullscreen": "Полноэкранный режим"
        },
        "function": {
            "function": "Функция"
        },
        "grid": {
            "delete-item-title": "Вы точно хотите удалить этот объект?",
            "delete-item-text": "Внимание, после подтверждения объект и все связанные с ним данные будут безвозвратно утеряны.",
            "delete-items-title": "Вы точно хотите удалить { count, plural, one {1 объект} few {# объекта} other {# объектов} }?",
            "delete-items-action-title": "Удалить { count, plural, one {1 объект} few {# объекта} other {# объектов}",
            "delete-items-text": "Внимание, после подтверждения выбранные объекты и все связанные с ними данные будут безвозвратно утеряны.",
            "add-item-text": "Добавить новый объект",
            "no-items-text": "Объекты не найдены",
            "item-details": "Подробности об объекте",
            "delete-item": "Удалить объект",
            "delete-items": "Удалить объекты",
            "scroll-to-top": "Прокрутка к началу"
        },
        "help": {
            "goto-help-page": "Перейти к справке"
        },
        "home": {
            "home": "Главная",
            "profile": "Профиль",
            "logout": "Выйти из системы",
            "menu": "Меню",
            "avatar": "Аватар",
            "open-user-menu": "Открыть меню пользователя"
        },
        "import": {
            "no-file": "Файл не выбран",
            "drop-file": "Перетащите JSON файл или кликните для выбора файла."
        },
        "item": {
            "selected": "Выбранные"
        },
        "js-func": {
            "no-return-error": "Функция должна возвращать значение!",
            "return-type-mismatch": "Функция должна возвращать значение типа '{{type}}'!",
            "tidy": "Tidy" // TODO
        },
        "key-val": { // TODO
            "key": "Key",
            "value": "Value",
            "remove-entry": "Remove entry",
            "add-entry": "Add entry",
            "no-data": "No entries"
        },
        "layout": { // TODO
            "layout": "Layout",
            "manage": "Manage layouts",
            "settings": "Layout settings",
            "color": "Color",
            "main": "Main",
            "right": "Right",
            "select": "Select target layout"
        },
        "legend": {
            "position": "Расположение легенды",
            "show-max": "Показать максимальное значение",
            "show-min": "Показать минимальное значение",
            "show-avg": "Показать среднее значение",
            "show-total": "Показать сумму",
            "settings": "Настройки легенды",
            "min": "Мин",
            "max": "Макс",
            "avg": "Среднее",
            "total": "Сумма"
        },
        "login": {
            "login": "Войти",
            "request-password-reset": "Запрос на сброс пароля",
            "reset-password": "Сбросить пароль",
            "create-password": "Создать пароль",
            "passwords-mismatch-error": "Введенные пароли должны быть одинаковыми!",
            "password-again": "Введите пароль еще раз",
            "sign-in": "Пожалуйста, войдите в систему",
            "username": "Имя пользователя (эл. адрес)",
            "remember-me": "Запомнить меня",
            "forgot-password": "Забыли пароль?",
            "password-reset": "Пароль сброшен",
            "new-password": "Новый пароль",
            "new-password-again": "Повторите новый пароль",
            "password-link-sent-message": "Ссылка для сброса пароля была успешно отправлена!",
            "email": "Эл. адрес"
        },
        "position": {
            "top": "Верх",
            "bottom": "Низ",
            "left": "Левый край",
            "right": "Правый край"
        },
        "profile": {
            "profile": "Профиль",
            "change-password": "Изменить пароль",
            "current-password": "Текущий пароль"
        },
        "relation": { // TODO
            "relations": "Relations",
            "direction": "Direction",
            "search-direction": {
                "FROM": "From",
                "TO": "To"
            },
            "direction-type": {
                "FROM": "from",
                "TO": "to"
            },
            "from-relations": "Outbound relations",
            "to-relations": "Inbound relations",
            "selected-relations": "{ count, select, 1 {1 relation} other {# relations} } selected",
            "type": "Type",
            "to-entity-type": "To entity type",
            "to-entity-name": "To entity name",
            "from-entity-type": "From entity type",
            "from-entity-name": "From entity name",
            "to-entity": "To entity",
            "from-entity": "From entity",
            "delete": "Delete relation",
            "relation-type": "Relation type",
            "relation-type-required": "Relation type is required.",
            "any-relation-type": "Any type",
            "add": "Add relation",
            "edit": "Edit relation",
            "delete-to-relation-title": "Are you sure you want to delete relation to the entity '{{entityName}}'?",
            "delete-to-relation-text": "Be careful, after the confirmation the entity '{{entityName}}' will be unrelated from the current entity.",
            "delete-to-relations-title": "Are you sure you want to delete { count, select, 1 {1 relation} other {# relations} }?",
            "delete-to-relations-text": "Be careful, after the confirmation all selected relations will be removed and corresponding entities will be unrelated from the current entity.",
            "delete-from-relation-title": "Are you sure you want to delete relation from the entity '{{entityName}}'?",
            "delete-from-relation-text": "Be careful, after the confirmation current entity will be unrelated from the entity '{{entityName}}'.",
            "delete-from-relations-title": "Are you sure you want to delete { count, select, 1 {1 relation} other {# relations} }?",
            "delete-from-relations-text": "Be careful, after the confirmation all selected relations will be removed and current entity will be unrelated from the corresponding entities.",
            "remove-relation-filter": "Remove relation filter",
            "add-relation-filter": "Add relation filter",
            "any-relation": "Any relation",
            "relation-filters": "Relation filters",
            "additional-info": "Additional info (JSON)",
            "invalid-additional-info": "Unable to parse additional info json."
        },
        "rulechain": { // TODO
            "rulechain": "Rule chain",
            "rulechains": "Rule chains",
            "root": "Root",
            "delete": "Delete rule chain",
            "name": "Name",
            "name-required": "Name is required.",
            "description": "Description",
            "add": "Add Rule Chain",
            "set-root": "Make rule chain root",
            "set-root-rulechain-title": "Are you sure you want to make the rule chain '{{ruleChainName}}' root?",
            "set-root-rulechain-text": "After the confirmation the rule chain will become root and will handle all incoming transport messages.",
            "delete-rulechain-title": "Are you sure you want to delete the rule chain '{{ruleChainName}}'?",
            "delete-rulechain-text": "Be careful, after the confirmation the rule chain and all related data will become unrecoverable.",
            "delete-rulechains-title": "Are you sure you want to delete { count, select, 1 {1 rule chain} other {# rule chains} }?",
            "delete-rulechains-action-title": "Delete { count, select, 1 {1 rule chain} other {# rule chains} }",
            "delete-rulechains-text": "Be careful, after the confirmation all selected rule chains will be removed and all related data will become unrecoverable.",
            "add-rulechain-text": "Add new rule chain",
            "no-rulechains-text": "No rule chains found",
            "rulechain-details": "Rule chain details",
            "details": "Details",
            "events": "Events",
            "system": "System",
            "import": "Import rule chain",
            "export": "Export rule chain",
            "export-failed-error": "Unable to export rule chain: {{error}}",
            "create-new-rulechain": "Create new rule chain",
            "rulechain-file": "Rule chain file",
            "invalid-rulechain-file-error": "Unable to import rule chain: Invalid rule chain data structure.",
            "copyId": "Copy rule chain Id",
            "idCopiedMessage": "Rule chain Id has been copied to clipboard",
            "select-rulechain": "Select rule chain",
            "no-rulechains-matching": "No rule chains matching '{{entity}}' were found.",
            "rulechain-required": "Rule chain is required",
            "management": "Rules management",
            "debug-mode": "Debug mode"
        },
        "rulenode": { // TODO
            "details": "Details",
            "events": "Events",
            "search": "Search nodes",
            "open-node-library": "Open node library",
            "add": "Add rule node",
            "name": "Name",
            "name-required": "Name is required.",
            "type": "Type",
            "description": "Description",
            "delete": "Delete rule node",
            "select-all-objects": "Select all nodes and connections",
            "deselect-all-objects": "Deselect all nodes and connections",
            "delete-selected-objects": "Delete selected nodes and connections",
            "delete-selected": "Delete selected",
            "select-all": "Select all",
            "copy-selected": "Copy selected",
            "deselect-all": "Deselect all",
            "rulenode-details": "Rule node details",
            "debug-mode": "Debug mode",
            "configuration": "Configuration",
            "link": "Link",
            "link-details": "Rule node link details",
            "add-link": "Add link",
            "link-label": "Link label",
            "link-label-required": "Link label is required.",
            "custom-link-label": "Custom link label",
            "custom-link-label-required": "Custom link label is required.",
            "type-filter": "Filter",
            "type-filter-details": "Filter incoming messages with configured conditions",
            "type-enrichment": "Enrichment",
            "type-enrichment-details": "Add additional information into Message Metadata",
            "type-transformation": "Transformation",
            "type-transformation-details": "Change Message payload and Metadata",
            "type-action": "Action",
            "type-action-details": "Perform special action",
            "type-external": "External",
            "type-external-details": "Interacts with external system",
            "type-rule-chain": "Rule Chain",
            "type-rule-chain-details": "Forwards incoming messages to specified Rule Chain",
            "type-input": "Input",
            "type-input-details": "Logical input of Rule Chain, forwards incoming messages to next related Rule Node",
            "directive-is-not-loaded": "Defined configuration directive '{{directiveName}}' is not available.",
            "ui-resources-load-error": "Failed to load configuration ui resources.",
            "invalid-target-rulechain": "Unable to resolve target rule chain!",
            "test-script-function": "Test script function",
            "message": "Message",
            "message-type": "Message type",
            "message-type-required": "Message type is required",
            "metadata": "Metadata",
            "metadata-required": "Metadata entries can't be empty.",
            "output": "Output",
            "test": "Test",
            "help": "Help"
        },
        "tenant": {
            "tenants": "Владельцы",
            "management": "Управление владельцами",
            "add": "Добавить владельца",
            "admins": "Администраторы",
            "manage-tenant-admins": "Управление администраторами владельца",
            "delete": "Удалить владельца",
            "add-tenant-text": "Добавить нового владельца",
            "no-tenants-text": "Владельцы не найдены",
            "tenant-details": "Подробности об владельце",
            "delete-tenant-title": "Вы точно хотите удалить владельца '{{tenantTitle}}'?",
            "delete-tenant-text": "Внимание, после подтверждения владелец и все связанные с ним данные будут безвозвратно утеряны.",
            "delete-tenants-title": "Вы точно хотите удалить { count, plural, one {1 владельца}  other {# владельцев} }?",
            "delete-tenants-action-title": "Удалить { count, plural, one {1 владельца}  other {# владельцев} }",
            "delete-tenants-text": "Внимание, после подтверждения выбранные Владельцы и все связанные с ними данные будут безвозвратно утеряны.",
            "title": "Имя",
            "title-required": "Имя обязательно.",
            "description": "Описание"
        },
        "timeinterval": {
            "seconds-interval": "{ seconds, plural, one {1 секунда} few {# секунды} other {# секунд} }",
            "minutes-interval": "{ minutes, plural, one {1 минута} few {# минуты} other {# минут} }",
            "hours-interval": "{ hours, plural, one {1 час} few {# часа} other {# часов} }",
            "days-interval": "{ days, plural, one {1 день} few {# дня} other {# дней} }",
            "days": "Дни",
            "hours": "Часы",
            "minutes": "Минуты",
            "seconds": "Секунды",
            "advanced": "Дополнительно"
        },
        "timewindow": {
            "days": "{ days, plural, one {1 день} few {# дня} other {# дней} }",
            "hours": "{ hours, plural, one {1 час} few {# часа} other {# часов} }",
            "minutes": "{ minutes, plural, one {1 минута} few {# минуты} other {# минут} }",
            "seconds": "{ seconds, plural, one {1 секунда} few {# секунды} other {# секунд} }",
            "realtime": "Режим реального времени",
            "history": "История",
            "last-prefix": "Последние",
            "period": "с {{ startTime }} до {{ endTime }}",
            "edit": "Изменить временное окно",
            "date-range": "Диапазон дат",
            "last": "Последние",
            "time-period": "Период времени"
        },
        "user": {
            "users": "Пользователи",
            "customer-users": "Пользователи клиента",
            "tenant-admins": "Администраторы владельца",
            "sys-admin": "Системный администратор",
            "tenant-admin": "Администратор владельца",
            "customer": "Клиент",
            "anonymous": "Аноним",
            "add": "Добавить пользователя",
            "delete": "Удалить пользователя",
            "add-user-text": "Добавить нового пользователя",
            "no-users-text": "Пользователи не найдены",
            "user-details": "Подробности о пользователе",
            "delete-user-title": "Вы точно хотите удалить пользователя '{{userEmail}}'?",
            "delete-user-text": "Внимание, после подтверждения пользователь и все связанные с ним данные будут безвозвратно утеряны.",
            "delete-users-title": "Вы точно хотите удалить { count, plural, one {1 пользователя} other {# пользователей} }?",
            "delete-users-action-title": "Удалить { count, plural, one {1 пользователя} other {# пользователей} }",
            "delete-users-text": "Внимание, после подтверждения выбранные пользователи и все связанные с ними данные будут безвозвратно утеряны.",
            "activation-email-sent-message": "Активационное письмо успешно отправлено!",
            "resend-activation": "Повторить отправку активационного письма",
            "email": "Эл. адрес",
            "email-required": "Эл. адрес обязателен.",
            "first-name": "Имя",
            "last-name": "Фамилия",
            "description": "Описание",
            "default-dashboard": "Дашборд по умолчанию",
            "always-fullscreen": "Всегда во весь экран"
        },
        "value": {
            "type": "Тип значения",
            "string": "Строка",
            "string-value": "Строковое значение",
            "integer": "Целое число",
            "integer-value": "Целочисленное значение",
            "invalid-integer-value": "Неправильный формат целого числа",
            "double": "Число двойной точности",
            "double-value": "Значение двойной точности",
            "boolean": "Логический тип",
            "boolean-value": "Логическое значение",
            "false": "Ложь",
            "true": "Правда"
        },
        "widget": {
            "widget-library": "Галерея виджетов",
            "widget-bundle": "Набор виджетов",
            "select-widgets-bundle": "Выберите набор виджетов",
            "management": "Управление виджетами",
            "editor": "Редактор виджетов",
            "widget-type-not-found": "Ошибка при загрузке конфигурации виджета.<br>Возможно, связанный с ней\n    тип виджета уже удален.",
            "widget-type-load-error": "Не удалось загрузить виджет по следующим причинам:",
            "remove": "Удалить виджет",
            "edit": "Редактировать виджет",
            "remove-widget-title": "Вы точно хотите удалить виджет '{{widgetTitle}}'?",
            "remove-widget-text": "Внимание, после подтверждения виджет и все связанные с ним данные будут безвозвратно утеряны.",
            "timeseries": "Выборка по времени",
            "latest-values": "Последние значения",
            "rpc": "Управляющий виджет",
            "static": "Статический виджет",
            "select-widget-type": "Выберите тип виджета",
            "missing-widget-title-error": "Укажите название виджета!",
            "widget-saved": "Виджет сохранен",
            "unable-to-save-widget-error": "Не удалось сохранить виджет! Виджет содержит ошибки!",
            "save": "Сохранить виджет",
            "saveAs": "Сохранить виджет как",
            "save-widget-type-as": "Сохранить тип виджета как",
            "save-widget-type-as-text": "Пожалуйста, введите название виджета и/или укажите целевой набор виджетов",
            "toggle-fullscreen": "Во весь экран",
            "run": "Запустить виджет",
            "title": "Название виджета",
            "title-required": "Название виджета обязательно.",
            "type": "Тип виджета",
            "resources": "Ресурсы",
            "resource-url": "JavaScript/CSS URL",
            "remove-resource": "Удалить ресурс",
            "add-resource": "Добавить ресурс",
            "html": "HTML",
            "tidy": "Форматировать",
            "css": "CSS",
            "settings-schema": "Схема конфигурации",
            "datakey-settings-schema": "Схема конфигурации ключа данных",
            "javascript": "Javascript",
            "remove-widget-type-title": "Вы точно хотите удалить виджет '{{widgetName}}'?",
            "remove-widget-type-text": "Внимание, после подтверждения тип виджета и все связанные с ним данные будут безвозвратно утеряны.",
            "remove-widget-type": "Удалить тип виджета",
            "add-widget-type": "Добавить новый тип виджета",
            "widget-type-load-failed-error": "Не удалось загрузить тип виджета!",
            "widget-template-load-failed-error": "Не удалось загрузить шаблон виджета!",
            "add": "Добавить виджет",
            "undo": "Откатить изменения в виджете",
            "export": "Экспортировать виджет"
        },
        "widget-action": { // TODO
            "header-button": "Widget header button",
            "open-dashboard-state": "Navigate to new dashboard state",
            "update-dashboard-state": "Update current dashboard state",
            "open-dashboard": "Navigate to other dashboard",
            "custom": "Custom action",
            "target-dashboard-state": "Target dashboard state",
            "target-dashboard-state-required": "Target dashboard state is required",
            "set-entity-from-widget": "Set entity from widget",
            "target-dashboard": "Target dashboard",
            "open-right-layout": "Open right dashboard layout (mobile view)"
        },
        "widgets-bundle": {
            "current": "Текущий набор",
            "widgets-bundles": "Наборы виджетов",
            "add": "Добавить набор виджетов",
            "delete": "Удалить набор виджетов",
            "title": "Название",
            "title-required": "Название обязательно.",
            "add-widgets-bundle-text": "Добавить новый набор виджетов",
            "no-widgets-bundles-text": "Наборы виджетов не найдены",
            "empty": "Пустой набор виджетов",
            "details": "Подробности",
            "widgets-bundle-details": "Подробности о наборе виджетов",
            "delete-widgets-bundle-title": "Вы точно хотите удалить набор виджетов '{{widgetsBundleTitle}}'?",
            "delete-widgets-bundle-text": "Внимание, после подтверждения набор виджетов и все связанные с ним данные будут безвозвратно утеряны.",
            "delete-widgets-bundles-title": "Вы точно хотите удалить { count, plural, one {1 набор виджетов} few {# набора виджетов} other {# наборов виджетов} }?",
            "delete-widgets-bundles-action-title": "Удалить { count, plural, one {1 набор виджетов} few {# набора виджетов} other {# наборов виджетов} }",
            "delete-widgets-bundles-text": "Внимание, после подтверждения выбранные наборы виджетов и все связанные с ними данные будут безвозвратно утеряны..",
            "no-widgets-bundles-matching": "Набор виджетов '{{widgetsBundle}}' не найден.",
            "widgets-bundle-required": "Набор виджетов обязателен.",
            "system": "Системный",
            "import": "Импортировать набор виджетов",
            "export": "Экспортировать набор виджетов",
            "export-failed-error": "Не удалось экспортировать набор виджетов: {{error}}",
            "create-new-widgets-bundle": "Создать новый набор виджетов",
            "widgets-bundle-file": "Файл набора виджетов",
            "invalid-widgets-bundle-file-error": "Не удалось импортировать набор виджетов: неизвестная схема данных набора виджетов."
        },
        "widget-config": {
            "data": "Данные",
            "settings": "Настройки",
            "advanced": "Дополнительно",
            "title": "Название",
            "general-settings": "Общие настройки",
            "display-title": "Показать название",
            "drop-shadow": "Тень",
            "enable-fullscreen": "Во весь экран",
            "background-color": "Цвет фона",
            "text-color": "Цвет текста",
            "padding": "Отступ",
            "title-style": "Стиль названия",
            "mobile-mode-settings": "Настройки мобильного режима",
            "order": "Порядок",
            "height": "Высота",
            "units": "Специальный символ после значения",
            "decimals": "Количество цифр после запятой",
            "timewindow": "Временное окно",
            "use-dashboard-timewindow": "Использовать временное окно дашборда",
            "display-legend": "Показать легенду",
            "datasources": "Источники данных",
            "datasource-type": "Тип",
            "datasource-parameters": "Параметры",
            "remove-datasource": "Удалить источник данных",
            "add-datasource": "Добавить источник данных",
            "target-device": "Целевое устройство"
        },
        "widget-type": {
            "import": "Импортировать тип виджета",
            "export": "Экспортировать тип виджета",
            "export-failed-error": "Не удалось экспортировать тип виджета: {{error}}",
            "create-new-widget-type": "Создать новый тип виджета",
            "widget-type-file": "Файл типа виджета",
            "invalid-widget-type-file-error": "Не удалось импортировать виджет: неизвестная схема данных типа виджета."
        },
        "icon": { // TODO
            "icon": "Icon",
            "select-icon": "Select icon",
            "material-icons": "Material icons",
            "show-all": "Show all icons"
        },
        "custom": { // TODO
            "widget-action": {
                "action-cell-button": "Action cell button",
                "row-click": "On row click",
                "marker-click": "On marker click",
                "tooltip-tag-action": "Tooltip tag action"
            }
        },
        "language": {
            "language": "Язык",
            "en_US": "Английский",
            "ko_KR": "Корейский",
            "zh_CN": "Китайский",
            "ru_RU": "Русский",
            "es_ES": "испанский"

        }
    };
    angular.extend(locales, { 'ru_RU': ru_RU });
}