/*
 * Copyright © 2016-2017 The Thingsboard Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

export default function addLocaleChinese(locales) {
    var zh_CN = {
        "access" : {
            "unauthorized" : "未授权",
            "unauthorized-access" : "未授权访问",
            "unauthorized-access-text" : "您需要登陆才能访问这个资源！",
            "access-forbidden" : "禁止访问",
            "access-forbidden-text" : "您没有访问此位置的权限<br/>如果您仍希望访问此位置,请尝试使用其他用户登录。",
            "refresh-token-expired" : "会话已过期",
            "refresh-token-failed" : "无法刷新会话"
        },
        "action" : {
            "activate" : "激活",
            "suspend" : "暂停",
            "save" : "保存",
            "saveAs" : "另存为",
            "cancel" : "取消",
            "ok" : "确定",
            "delete" : "删除",
            "add" : "添加",
            "yes" : "是",
            "no" : "否",
            "update" : "更新",
            "remove" : "移除",
            "search" : "查询",
            "assign" : "分配",
            "unassign" : "取消分配",
            "share" : "分享",
            "make-private" : "私有",
            "apply" : "应用",
            "apply-changes" : "应用更改",
            "edit-mode" : "编辑模式",
            "enter-edit-mode" : "进入编辑模式",
            "decline-changes" : "拒绝变更",
            "close" : "关闭",
            "back" : "后退",
            "run" : "运行",
            "sign-in" : "登录！",
            "edit" : "编辑",
            "view" : "查看",
            "create" : "创建",
            "drag" : "拖拽",
            "refresh" : "刷新",
            "undo" : "撤销",
            "copy" : "复制",
            "paste" : "粘贴",
            "import" : "导入",
            "export" : "导出",
            "share-via" : "通过 {{provider}}分享"
        },
        "aggregation" : {
            "aggregation" : "聚合",
            "function" : "数据聚合功能",
            "limit" : "最大值",
            "group-interval" : "分组间隔",
            "min" : "最少值",
            "max" : "最大值",
            "avg" : "平均值",
            "sum" : "求和",
            "count" : "计数",
            "none" : "空"
        },
        "admin" : {
            "general" : "常规",
            "general-settings" : "常规设置",
            "outgoing-mail" : "发送邮件",
            "outgoing-mail-settings" : "发送邮件设置",
            "system-settings" : "系统设置",
            "test-mail-sent" : "测试邮件发送成功！",
            "base-url" : "基本URL",
            "base-url-required" : "基本URL是必须的。",
            "mail-from" : "邮件来自",
            "mail-from-required" : "邮件发件人是必须的。",
            "smtp-protocol" : "SMTP协议",
            "smtp-host" : "SMTP主机",
            "smtp-host-required" : "SMTP主机是必须的。",
            "smtp-port" : "SMTP端口",
            "smtp-port-required" : "您必须提供一个smtp端口。",
            "smtp-port-invalid" : "这看起来不是有效的smtp端口。",
            "timeout-msec" : "超时（ms）",
            "timeout-required" : "超时是必须的。",
            "timeout-invalid" : "这看起来不像有效的超时值。",
            "enable-tls" : "启用TLS",
            "send-test-mail" : "发送测试邮件"
        },
        "attribute" : {
            "attributes" : "属性",
            "latest-telemetry" : "最新遥测",
            "attributes-scope" : "设备属性范围",
            "scope-latest-telemetry" : "最新遥测",
            "scope-client" : "客户端属性",
            "scope-server" : "服务端属性",
            "scope-shared" : "共享属性",
            "add" : "添加属性",
            "key" : "键",
            "key-required" : "属性键是必需的。",
            "value" : "值",
            "value-required" : "属性值是必需的。",
            "delete-attributes-title" : "您确定要删除 { count, select, 1 {1 attribute} other {# attributes} }吗？",
            "delete-attributes-text" : "注意,确认后所有选中的属性都会被删除。",
            "delete-attributes" : "删除属性",
            "enter-attribute-value" : "输入属性值",
            "show-on-widget" : "在部件上显示",
            "widget-mode" : "部件模式",
            "next-widget" : "下一个部件",
            "prev-widget" : "上一个部件",
            "add-to-dashboard" : "添加到仪表板",
            "add-widget-to-dashboard" : "将部件添加到仪表板",
            "selected-attributes" : "{ count, select, 1 {1 attribute} other {# attributes} } 被选中",
            "selected-telemetry" : "{ count, select, 1 {1 telemetry unit} other {# telemetry units} } 被选中"
        },
        "confirm-on-exit" : {
            "message" : "您有未保存的更改。确定要离开此页吗？",
            "html-message" : "您有未保存的更改。<br/> 确定要离开此页面吗？",
            "title" : "未保存的更改"
        },
        "contact" : {
            "country" : "国家",
            "city" : "城市",
            "state" : "州",
            "postal-code" : "邮政编码",
            "postal-code-invalid" : "只允许数字。",
            "address" : "地址",
            "address2" : "地址2",
            "phone" : "手机",
            "email" : "邮箱",
            "no-address" : "无地址"
        },
        "common" : {
            "username" : "用户名",
            "password" : "密码",
            "enter-username" : "输入用户名",
            "enter-password" : "输入密码",
            "enter-search" : "输入检索条件"
        },
        "customer" : {
            "customers" : "客户",
            "management" : "客户管理",
            "dashboard" : "客户仪表板",
            "dashboards" : "客户仪表板",
            "devices" : "客户设备",
            "public-dashboards" : "公共仪表板",
            "public-devices" : "公共设备",
            "add" : "添加客户",
            "delete" : "删除客户",
            "manage-customer-users" : "管理客户用户",
            "manage-customer-devices" : "管理客户设备",
            "manage-customer-dashboards" : "管理客户仪表板",
            "manage-public-devices" : "管理公共设备",
            "manage-public-dashboards" : "管理公共仪表板",
            "add-customer-text" : "添加新客户",
            "no-customers-text" : "没有找到客户",
            "customer-details" : "客户详情",
            "delete-customer-title" : "您确定要删除客户'{{customerTitle}}'吗？",
            "delete-customer-text" : "小心！确认后，客户及其所有相关数据将不可恢复。",
            "delete-customers-title" : "您确定要删除 { count, select, 1 {1 customer} other {# customers} }吗？",
            "delete-customers-action-title" : "删除 { count, select, 1 {1 customer} other {# customers} }",
            "delete-customers-text" : "小心！确认后，所有选定的客户将被删除，所有相关数据将不可恢复。",
            "manage-users" : "管理用户",
            "manage-devices" : "管理设备",
            "manage-dashboards" : "管理仪表板",
            "title" : "标题",
            "title-required" : "需要标题。",
            "description" : "描述"
        },
        "datetime" : {
            "date-from" : "日期从",
            "time-from" : "时间从",
            "date-to" : "日期到",
            "time-to" : "时间到"
        },
        "dashboard" : {
            "dashboard" : "仪表板",
            "dashboards" : "仪表板库",
            "management" : "仪表板管理",
            "view-dashboards" : "查看仪表板",
            "add" : "添加仪表板",
            "assign-dashboard-to-customer" : "将仪表板分配给客户",
            "assign-dashboard-to-customer-text" : "请选择要分配给客户的仪表板",
            "assign-to-customer-text" : "请选择客户分配仪表板",
            "assign-to-customer" : "分配给客户",
            "unassign-from-customer" : "取消分配客户",
            "make-public" : "使仪表板公有",
            "make-private" : "使仪表板私有",
            "no-dashboards-text" : "没有找到仪表板",
            "no-widgets" : "没有配置部件",
            "add-widget" : "添加新的部件",
            "title" : "标题",
            "select-widget-title" : "选择部件",
            "select-widget-subtitle" : "可用的部件类型列表",
            "delete" : "删除仪表板",
            "title-required" : "需要标题。",
            "description" : "描述",
            "details" : "详情",
            "dashboard-details" : "仪表板详情",
            "add-dashboard-text" : "添加新的仪表板",
            "assign-dashboards" : "分配仪表板",
            "assign-new-dashboard" : "分配新的仪表板",
            "assign-dashboards-text" : "分配 { count, select, 1 {1 dashboard} other {# dashboards} } 给客户",
            "delete-dashboards" : "删除仪表板",
            "unassign-dashboards" : "取消分配仪表板",
            "unassign-dashboards-action-title" : "取消分配 { count, select, 1 {1 dashboard} other {# dashboards} } from customer",
            "delete-dashboard-title" : "您确定要删除仪表板 '{{dashboardTitle}}'吗？",
            "delete-dashboard-text" : "小心！确认后仪表板及其所有相关数据将不可恢复。",
            "delete-dashboards-title" : "你确定你要删除 { count, select, 1 {1 dashboard} other {# dashboards} }吗？",
            "delete-dashboards-action-title" : "删除 { count, select, 1 {1 dashboard} other {# dashboards} }",
            "delete-dashboards-text" : "小心！确认后所有选定的仪表板将被删除，所有相关数据将不可恢复。",
            "unassign-dashboard-title" : "您确定要取消分配仪表板 '{{dashboardTitle}}'吗？",
            "unassign-dashboard-text" : "确认后，面板将被取消分配，客户将无法访问。",
            "unassign-dashboard" : "取消分配仪表板",
            "unassign-dashboards-title" : "您确定要取消分配仪表板 { count, select, 1 {1 dashboard} other {# dashboards} } 吗？",
            "unassign-dashboards-text" : "确认后，所有选定的仪表板将被取消分配，客户将无法访问。",
            "public-dashboard-title" : "仪表板现已公布",
            "public-dashboard-text" : "你的仪表板 <b>{{dashboardTitle}}</b> 已被公开，可通过如下 <a href='{{publicLink}}' target='_blank'>链接</a>访问:",
            "public-dashboard-notice" : "<b>提示：</b> 不要忘记将相关设备公开以访问其数据。",
            "make-private-dashboard-title" : "您确定要使仪表板 '{{dashboardTitle}}' 私有吗？",
            "make-private-dashboard-text" : "确认后，仪表板将被私有，不能被其他人访问。",
            "make-private-dashboard" : "仪表板私有",
            "socialshare-text" : "'{{dashboardTitle}}' 由ThingsBoard提供支持",
            "socialshare-title" : "'{{dashboardTitle}}' 由ThingsBoard提供支持",
            "select-dashboard" : "选择仪表板",
            "no-dashboards-matching" : "找不到符合 '{{entity}}' 的仪表板。",
            "dashboard-required" : "仪表板是必需的。",
            "select-existing" : "选择现有仪表板",
            "create-new" : "创建新的仪表板",
            "new-dashboard-title" : "新仪表板标题",
            "open-dashboard" : "打开仪表板",
            "set-background" : "设置背景",
            "background-color" : "背景颜色",
            "background-image" : "背景图片",
            "background-size-mode" : "背景大小模式",
            "no-image" : "无图像选择",
            "drop-image" : "拖拽图像或单击以选择要上传的文件。",
            "settings" : "设置",
            "columns-count" : "列数",
            "columns-count-required" : "需要列数。",
            "min-columns-count-message" : "只允许最少10列",
            "max-columns-count-message" : "只允许最多1000列",
            "widgets-margins" : "部件间边距",
            "horizontal-margin" : "水平边距",
            "horizontal-margin-required" : "需要水平边距值。",
            "min-horizontal-margin-message" : "只允许0作为最小水平边距值。",
            "max-horizontal-margin-message" : "只允许50作为最大水平边距值。",
            "vertical-margin" : "垂直边距",
            "vertical-margin-required" : "需要垂直边距值。",
            "min-vertical-margin-message" : "只允许0作为最小垂直边距值。",
            "max-vertical-margin-message" : "只允许50作为最大垂直边距值。",
            "display-title" : "显示仪表板标题",
            "title-color" : "标题颜色",
            "display-device-selection" : "显示设备选择",
            "display-dashboard-timewindow" : "显示时间窗口",
            "display-dashboard-export" : "显示导出",
            "import" : "导入仪表板",
            "export" : "导出仪表板",
            "export-failed-error" : "无法导出仪表板: {{error}}",
            "create-new-dashboard" : "创建新的仪表板",
            "dashboard-file" : "仪表板文件",
            "invalid-dashboard-file-error" : "无法导入仪表板: 仪表板数据结构无效。",
            "dashboard-import-missing-aliases-title" : "配置导入仪表板使用的别名",
            "create-new-widget" : "创建新部件",
            "import-widget" : "导入部件",
            "widget-file" : "部件文件",
            "invalid-widget-file-error" : "无法导入窗口部件: 窗口部件数据结构无效。",
            "widget-import-missing-aliases-title" : "配置导入的窗口部件使用的别名",
            "open-toolbar" : "打开仪表板工具栏",
            "close-toolbar" : "关闭工具栏",
            "configuration-error" : "配置错误",
            "alias-resolution-error-title" : "仪表板别名配置错误",
            "invalid-aliases-config" : "无法找到与某些别名过滤器匹配的任何设备。<br/>" +
                "请联系您的管理员以解决此问题。",
            "select-devices" : "选择设备",
            "assignedToCustomer" : "分配给客户",
            "public" : "公共",
            "public-link" : "公共链接",
            "copy-public-link" : "复制公共链接",
            "public-link-copied-message" : "仪表板的公共链接已被复制到剪贴板"
        },
        "datakey" : {
            "settings": "设置",
            "advanced": "高级",
            "label": "标签",
            "color": "颜色",
            "data-generation-func": "数据生成功能",
            "use-data-post-processing-func": "使用数据后处理功能",
            "configuration": "数据键配置",
            "timeseries": "时间序列",
            "attributes": "属性",
            "timeseries-required": "需要设备时间序列。",
            "timeseries-or-attributes-required": "设备时间/属性是必需的。",
            "function-types": "函数类型",
            "function-types-required": "需要函数类型。"
        },
        "datasource" : {
            "type": "数据源类型",
            "add-datasource-prompt": "请添加数据源"
        },
        "details" : {
            "edit-mode": "编辑模式",
            "toggle-edit-mode": "切换编辑模式"
        },
        "device" : {
            "device": "设备",
            "device-required": "设备是必需的",
            "devices": "设备",
            "management": "设备管理",
            "view-devices": "查看设备",
            "device-alias": "设备别名",
            "aliases": "设备别名",
            "no-alias-matching" : "'{{alias}}' 没有找到。",
            "no-aliases-found" : "找不到别名。",
            "no-key-matching" : "'{{key}}' 没有找到。",
            "no-keys-found" : "找不到密钥。",
            "create-new-alias": "创建一个新的！",
            "create-new-key": "创建一个新的！",
            "duplicate-alias-error" : "找到重复别名 '{{alias}}'。 <br> 设备别名必须是唯一的。",
            "configure-alias" : "配置 '{{alias}}' 别名",
            "no-devices-matching" : "找不到与 '{{entity}}' 匹配的设备。",
            "alias" : "别名",
            "alias-required" : "需要设备别名。",
            "remove-alias": "删除设备别名",
            "add-alias": "添加设备别名",
            "name-starts-with" : "名称前缀",
            "device-list" : "设备列表",
            "use-device-name-filter" : "使用过滤器",
            "device-list-empty" : "没有被选中的设备",
            "device-name-filter-required" : "设备名称过滤器是必需得。",
            "device-name-filter-no-device-matched" : "找不到以'{{device}}' 开头的设备。",
            "add" : "添加设备",
            "assign-to-customer": "分配给客户",
            "assign-device-to-customer": "将设备分配给客户",
            "assign-device-to-customer-text": "请选择要分配给客户的设备",
            "make-public" : "公有",
            "make-private" : "私有",
            "no-devices-text": "找不到设备",
            "assign-to-customer-text": "请选择客户分配设备",
            "device-details": "设备详细信息",
            "add-device-text": "添加新设备",
            "credentials": "凭据",
            "manage-credentials": "管理凭据",
            "delete": "删除设备",
            "assign-devices": "分配设备",
            "assign-devices-text": "将{count,select,1 {1 device} other {# devices}}分配给客户",
            "delete-devices": "删除设备",
            "unassign-from-customer": "取消分配客户",
            "unassign-devices": "取消分配设备",
            "unassign-devices-action-title": "从客户处取消分配{count,select,1 {1 device} other {# devices}}",
            "assign-new-device": "分配新设备",
            "make-public-device-title" : "您确定要将设备 '{{deviceName}}' 设为公开吗？",
            "make-public-device-text" : "确认后，设备及其所有数据将被公开并可被其他人访问。",
            "make-private-device-title" : "您确定要将设备 '{{deviceName}}' 设为私有吗？",
            "make-private-device-text" : "确认后，设备及其所有数据将被私有化，不被其他人访问。",
            "view-credentials": "查看凭据",
            "delete-device-title": "您确定要删除设备的{{deviceName}}吗？",
            "delete-device-text": "小心！确认后设备及其所有相关数据将不可恢复。",
            "delete-devices-title": "您确定要删除{count,select,1 {1 device} other {# devices}} 吗？",
            "delete-devices-action-title": "删除 {count,select,1 {1 device} other {# devices}}",
            "delete-devices-text": "小心！确认后所有选定的设备将被删除,所有相关数据将不可恢复。",
            "unassign-device-title": "您确定要取消分配设备 '{{deviceName}}'？",
            "unassign-device-text": "确认后,设备将被取消分配,客户将无法访问。",
            "unassign-device": "取消分配设备",
            "unassign-devices-title": "您确定要取消分配{count,select,1 {1 device} other {# devices}} 吗？",
            "unassign-devices-text": "确认后,所有选定的设备将被取消分配,并且客户将无法访问。",
            "device-credentials": "设备凭据",
            "credentials-type": "凭据类型",
            "access-token": "访问令牌",
            "access-token-required": "需要访问令牌",
            "access-token-invalid": "访问令牌长度必须为1到20个字符。",
            "rsa-key": "RSA公钥",
            "rsa-key-required": "需要RSA公钥",
            "secret": "密钥",
            "secret-required": "密钥是必需的",
            "name": "名称",
            "name-required": "名称是必需的。",
            "description": "说明",
            "events": "事件",
            "details": "详细信息",
            "copyId": "复制设备ID",
            "copyAccessToken": "复制访问令牌",
            "idCopiedMessage": "设备ID已复制到剪贴板",
            "accessTokenCopiedMessage": "设备访问令牌已复制到剪贴板",
            "assignedToCustomer": "分配给客户",
            "unable-delete-device-alias-title": "无法删除设备别名",
            "unable-delete-device-alias-text": "设备别名 '{{deviceAlias}}' 不能够被删除，因为它被下列部件所使用: <br/> {{widgetsList}}",
            "is-gateway": "是网关",
            "public" : "公共",
            "device-public" : "设备是公共的"
        },
        "dialog" : {
            "close" : "关闭对话框"
        },
        "error" : {
            "unable-to-connect": "无法连接到服务器！请检查您的互联网连接。",
            "unhandled-error-code": "未处理的错误代码: {{errorCode}}",
            "unknown-error": "未知错误"
        },
        "event" : {
            "event-type": "事件类型",
            "type-alarm": "报警",
            "type-error": "错误",
            "type-lc-event": "生命周期事件",
            "type-stats": "类型统计",
            "no-events-prompt": "找不到事件",
            "error": "错误",
            "alarm": "报警",
            "event-time": "事件时间",
            "server": "服务器",
            "body": "整体",
            "method": "方法",
            "event": "事件",
            "status": "状态",
            "success": "成功",
            "failed": "失败",
            "messages-processed": "消息处理",
            "errors-occurred": "错误发生"
        },
        "fullscreen" : {
            "expand": "展开到全屏",
            "exit": "退出全屏",
            "toggle": "切换全屏模式",
            "fullscreen": "全屏"
        },
        "function" : {
            "function" : "函数"
        },
        "grid" : {
            "delete-item-title": "您确定要删除此项吗？",
            "delete-item-text": "注意,确认后此项及其所有相关数据将变得不可恢复。",
            "delete-items-title" : "你确定你要删除 { count, select, 1 {1 item} other {# items} }吗？",
            "delete-items-action-title" : "删除 { count, select, 1 {1 item} other {# items} }",
            "delete-items-text": "注意,确认后所有选择的项目将被删除,所有相关数据将不可恢复。",
            "add-item-text": "添加新项目",
            "no-items-text": "没有找到项目",
            "item-details": "项目详细信息",
            "delete-item": "删除项目",
            "delete-items": "删除项目",
            "scroll-to-top": "滚动到顶部"
        },
        "help" : {
            "goto-help-page" : "转到帮助页面"
        },
        "home" : {
            "home": "首页",
            "profile": "属性",
            "logout": "注销",
            "menu": "菜单",
            "avatar": "头像",
            "open-user-menu": "打开用户菜单"
        },
        "import" : {
            "no-file" : "没有选择文件",
            "drop-file" : "拖动一个JSON文件或者单击以选择要上传的文件。"
        },
        "item" : {
            "selected" : "选择"
        },
        "js-func" : {
            "no-return-error": "函数必须返回值！",
            "return-type-mismatch": "函数必须返回 '{{type}}' 类型的值！"
        },
        "legend" : {
            "position" : "图例位置",
            "show-max" : "显示最大值",
            "show-min" : "显示最小值",
            "show-avg" : "显示平均值",
            "show-total" : "显示总数",
            "settings" : "图例设置",
            "min" : "最小值",
            "max" : "最大值",
            "avg" : "平均值",
            "total" : "总数"
        },
        "login" : {
            "login": "登录",
            "request-password-reset": "请求密码重置",
            "reset-password": "重置密码",
            "create-password": "创建密码",
            "passwords-mismatch-error": "输入的密码必须相同！",
            "password-again": "再次输入密码",
            "sign-in": "登录 ",
            "username": "用户名（电子邮件）",
            "remember-me": "记住我",
            "forgot-password": "忘记密码？",
            "password-reset": "密码重置",
            "new-password": "新密码",
            "new-password-again": "再次输入新密码",
            "password-link-sent-message": "密码重置链接已成功发送！",
            "email": "电子邮件"
        },
        "plugin" : {
            "plugins" : "插件",
            "delete" : "删除插件",
            "activate" : "激活插件",
            "suspend" : "暂停插件",
            "active" : "激活",
            "suspended" : "暂停",
            "name" : "名称",
            "name-required" : "名称是必填项。",
            "description" : "描述",
            "add" : "添加插件",
            "delete-plugin-title" : "你确定要删除插件 '{{pluginName}}' 吗？",
            "delete-plugin-text" : "小心！确认后，插件和所有相关数据将不可恢复。",
            "delete-plugins-title" : "你确定你要删除 { count, select, 1 {1 plugin} other {# plugins} } 吗？",
            "delete-plugins-action-title" : "删除 { count, select, 1 {1 plugin} other {# plugins} }",
            "delete-plugins-text" : "小心！确认后，所有选定的插件将被删除，所有相关数据将不可恢复。",
            "add-plugin-text" : "添加新的插件",
            "no-plugins-text" : "没有找到插件",
            "plugin-details" : "插件详细信息",
            "api-token" : "API令牌",
            "api-token-required" : "API令牌是必需的。",
            "type" : "插件类型",
            "type-required" : "插件类型是必需的。",
            "configuration" : "插件配置",
            "system" : "系统",
            "select-plugin" : "选择插件",
            "plugin" : "插件",
            "no-plugins-matching" : "没有找到匹配'{{entity}}'的插件。",
            "plugin-required" : "插件是必需的。",
            "plugin-require-match" : "请选择一个现有的插件。",
            "events" : "事件",
            "details" : "详情",
            "import" : "导入插件",
            "export" : "导出插件",
            "export-failed-error" : "无法导出插件：{{error}}",
            "create-new-plugin" : "创建新的插件",
            "plugin-file" : "插件文件",
            "invalid-plugin-file-error" : "无法导入插件：插件数据结构无效。"
        },
        "position" : {
            "top" : "顶部",
            "bottom" : "底部",
            "left" : "左侧",
            "right" : "右侧"
        },
        "profile" : {
            "profile": "属性",
            "change-password": "更改密码",
            "current-password": "当前密码"
        },
        "rule" : {
            "rules" : "规则",
            "delete" : "删除规则",
            "activate" : "激活规则",
            "suspend" : "暂停规则",
            "active" : "激活",
            "suspended" : "暂停",
            "name" : "名称",
            "name-required" : "名称是必填项。",
            "description" : "描述",
            "add" : "添加规则",
            "delete-rule-title" : "您确定要删除规则'{{ruleName}}'吗？",
            "delete-rule-text" : "小心！确认后，规则和所有相关数据将不可恢复。",
            "delete-rules-title" : "你确定要删除 {count, select, 1 {1 rule} other {# rules}} 吗？",
            "delete-rules-action-title" : "删除 { count, select, 1 {1 rule} other {# rules} }",
            "delete-rules-text" : "小心！确认后，所有选定的规则将被删除，所有相关数据将不可恢复。",
            "add-rule-text" : "添加新规则",
            "no-rules-text" : "没有找到规则",
            "rule-details" : "规则详情",
            "filters" : "过滤器",
            "filter" : "过滤器",
            "add-filter-prompt" : "请添加过滤器",
            "remove-filter" : "删除过滤器",
            "add-filter" : "添加过滤器",
            "filter-name" : "过滤器名称",
            "filter-type" : "过滤器类型",
            "edit-filter" : "编辑过滤器",
            "view-filter" : "查看过滤器",
            "component-name" : "名称",
            "component-name-required" : "名称是必填项。",
            "component-type" : "类型",
            "component-type-required" : "类型是必填项。",
            "processor" : "处理器",
            "no-processor-configured" : "未配置处理器",
            "create-processor" : "创建处理器",
            "processor-name" : "处理器名称",
            "processor-type" : "处理器类型",
            "plugin-action" : "插件动作",
            "action-name" : "动作名称",
            "action-type" : "动作类型",
            "create-action-prompt" : "请创建动作",
            "create-action" : "创建动作",
            "details" : "详情",
            "events" : "事件",
            "system" : "系统",
            "import" : "导入规则",
            "export" : "导出规则",
            "export-failed-error" : "无法导出规则：{{error}}",
            "create-new-rule" : "创建新规则",
            "rule-file" : "规则文件",
            "invalid-rule-file-error" : "无法导入规则：规则数据结构无效。"
        },
        "rule-plugin" : {
            "management" : "规则和插件管理"
        },
        "tenant" : {
            "tenants" : "租户",
            "management" : "租户管理",
            "add" : "添加租户",
            "admins" : "管理员",
            "manage-tenant-admins" : "管理租户管理员",
            "delete" : "删除租户",
            "add-tenant-text" : "添加新租户",
            "no-tenants-text" : "没有找到租户",
            "tenant-details" : "租客详情",
            "delete-tenant-title" : "您确定要删除租户'{{tenantTitle}}'吗？",
            "delete-tenant-text" : "小心！确认后，租户和所有相关数据将不可恢复。",
            "delete-tenants-title" : "您确定要删除 {count,select,1 {1 tenant} other {# tenants}} 吗？",
            "delete-tenants-action-title" : "删除 { count, select, 1 {1 tenant} other {# tenants} }",
            "delete-tenants-text" : "小心！确认后，所有选定的租户将被删除，所有相关数据将不可恢复。",
            "title" : "标题",
            "title-required" : "标题是必填项。",
            "description" : "描述"
        },
        "timeinterval" : {
            "seconds-interval" : "{ seconds, select, 1 {1 second} other {# seconds} }",
            "minutes-interval" : "{ minutes, select, 1 {1 minute} other {# minutes} }",
            "hours-interval" : "{ hours, select, 1 {1 hour} other {# hours} }",
            "days-interval" : "{ days, select, 1 {1 day} other {# days} }",
            "days" : "天",
            "hours" : "时",
            "minutes" : "分",
            "seconds" : "秒",
            "advanced" : "高级"
        },
        "timewindow" : {
            "days" : "{ days, select, 1 { day } other {# days } }",
            "hours" : "{ hours, select, 0 { hour } 1 {1 hour } other {# hours } }",
            "minutes" : "{ minutes, select, 0 { minute } 1 {1 minute } other {# minutes } }",
            "seconds" : "{ seconds, select, 0 { second } 1 {1 second } other {# seconds } }",
            "realtime" : "实时",
            "history" : "历史",
            "last-prefix" : "最后",
            "period" : "从 {{ startTime }} 到 {{ endTime }}",
            "edit" : "编辑时间窗口",
            "date-range" : "日期范围",
            "last" : "最后",
            "time-period" : "时间段"
        },
        "user" : {
            "users" : "用户",
            "customer-users" : "客户用户",
            "tenant-admins" : "租户管理员",
            "sys-admin" : "系统管理员",
            "tenant-admin" : "租户管理员",
            "customer" : "客户",
            "anonymous" : "匿名",
            "add" : "添加用户",
            "delete" : "删除用户",
            "add-user-text" : "添加新用户",
            "no-users-text" : "找不到用户",
            "user-details" : "用户详细信息",
            "delete-user-title" : "您确定要删除用户 '{{userEmail}}' 吗？",
            "delete-user-text" : "小心！确认后，用户和所有相关数据将不可恢复。",
            "delete-users-title" : "你确定你要删除 { count, select, 1 {1 user} other {# users} } 吗？",
            "delete-users-action-title" : "删除  { count, select, 1 {1 user} other {# users} }",
            "delete-users-text" : "小心！确认后，所有选定的用户将被删除，所有相关数据将不可恢复。",
            "activation-email-sent-message" : "激活电子邮件已成功发送！",
            "resend-activation" : "重新发送激活",
            "email" : "电子邮件",
            "email-required" : "电子邮件是必需的。",
            "first-name" : "名字",
            "last-name" : "姓",
            "description" : "描述",
            "default-dashboard" : "默认面板",
            "always-fullscreen" : "始终全屏"
        },
        "value" : {
            "type" : "值类型",
            "string" : "字符串",
            "string-value" : "字符串值",
            "integer" : "数字",
            "integer-value" : "数字值",
            "invalid-integer-value" : "整数值无效",
            "double" : "双精度小数",
            "double-value" : "双精度小数值",
            "boolean" : "布尔",
            "boolean-value" : "布尔值",
            "false" : "假",
            "true" : "真"
        },
        "widget" : {
            "widget-library" : "部件库",
            "widget-bundle" : "部件包",
            "select-widgets-bundle" : "选择部件包",
            "management" : "部件管理",
            "editor" : "部件编辑器",
            "widget-type-not-found" : "加载部件配置时出现问题。<br> 可能关联的\n 部件类型已删除。",
            "widget-type-load-error" : "由于以下错误，部件未加载：",
            "remove" : "删除部件",
            "edit" : "编辑部件",
            "remove-widget-title" : "您确定要删除部件 '{{widgetTitle}}' 吗？",
            "remove-widget-text" : "确认后，窗口部件和所有相关数据将不可恢复。",
            "timeseries" : "时间序列",
            "latest-values" : "最新值",
            "rpc" : "控件部件",
            "static" : "静态部件",
            "select-widget-type" : "选择窗口部件类型",
            "missing-widget-title-error" : "部件标题必须指定！",
            "widget-saved" : "部件已保存",
            "unable-to-save-widget-error" : "无法保存窗口部件！ 部件有错误！",
            "save" : "保存部件",
            "saveAs" : "将部件另存为",
            "save-widget-type-as" : "将部件类型另存为",
            "save-widget-type-as-text" : "请输入新的部件标题和/或选择目标部件包",
            "toggle-fullscreen" : "切换全屏",
            "run" : "运行部件",
            "title" : "部件标题",
            "title-required" : "需要部件标题。",
            "type" : "部件类型",
            "resources" : "资源",
            "resource-url" : "JavaScript/CSS URL",
            "remove-resource" : "删除资源",
            "add-resource" : "添加资源",
            "html" : "HTML",
            "tidy" : "整理",
            "css" : "CSS",
            "settings-schema" : "设置模式",
            "datakey-settings-schema" : "数据键设置模式",
            "javascript" : "Javascript",
            "remove-widget-type-title" : "您确定要删除部件类型 '{{widgetName}}'吗？",
            "remove-widget-type-text" : "确认后，窗口部件类型和所有相关数据将不可恢复。",
            "remove-widget-type" : "删除部件类型",
            "add-widget-type" : "添加新的部件类型",
            "widget-type-load-failed-error" : "无法加载部件类型！",
            "widget-template-load-failed-error" : "无法加载部件模板！",
            "add" : "添加部件",
            "undo" : "撤消部件更改",
            "export" : "导出部件"
        },
        "widgets-bundle" : {
            "current" : "当前包",
            "widgets-bundles" : "部件包",
            "add" : "添加部件包",
            "delete" : "删除部件包",
            "title" : "标题",
            "title-required" : "标题是必填项。",
            "add-widgets-bundle-text" : "添加新的部件包",
            "no-widgets-bundles-text" : "找不到部件包",
            "empty" : "部件包是空的",
            "details" : "详情",
            "widgets-bundle-details" : "部件包详细信息",
            "delete-widgets-bundle-title" : "您确定要删除部件包 '{{widgetsBundleTitle}}'吗？",
            "delete-widgets-bundle-text" : "小心！确认后，部件包和所有相关数据将不可恢复。",
            "delete-widgets-bundles-title" : "你确定你要删除 { count, select, 1 {1 widgets bundle} other {# widgets bundles} } 吗？",
            "delete-widgets-bundles-action-title" : "删除  { count, select, 1 {1 widgets bundle} other {# widgets bundles} }",
            "delete-widgets-bundles-text" : "小心！确认后，所有选定的部件包将被删除，所有相关数据将不可恢复。",
            "no-widgets-bundles-matching" : "没有找到与 '{{widgetsBundle}}' 匹配的部件包。",
            "widgets-bundle-required" : "需要部件包。",
            "system" : "系统",
            "import" : "导入部件包",
            "export" : "导出部件包",
            "export-failed-error" : "无法导出部件包： {{error}}",
            "create-new-widgets-bundle" : "创建新的部件包",
            "widgets-bundle-file" : "部件包文件",
            "invalid-widgets-bundle-file-error" : "无法导入部件包：无效的部件包数据结构。"
        },
        "widget-config" : {
            "data" : "数据",
            "settings" : "设置",
            "advanced" : "高级",
            "title" : "标题",
            "general-settings" : "常规设置",
            "display-title" : "显示标题",
            "drop-shadow" : "阴影",
            "enable-fullscreen" : "启用全屏",
            "background-color" : "背景颜色",
            "text-color" : "文字颜色",
            "padding" : "填充",
            "title-style" : "标题风格",
            "mobile-mode-settings" : "移动模式设置",
            "order" : "顺序",
            "height" : "高度",
            "units" : "特殊符号展示值",
            "decimals" : "浮点数后的位数",
            "timewindow" : "时间窗口",
            "use-dashboard-timewindow" : "使用仪表板的时间窗口",
            "display-legend" : "显示图例",
            "datasources" : "数据源",
            "datasource-type" : "类型",
            "datasource-parameters" : "参数",
            "remove-datasource" : "移除数据源",
            "add-datasource" : "添加数据源",
            "target-device" : "目标设备"
        },
        "widget-type" : {
            "import" : "导入部件类型",
            "export" : "导出部件类型",
            "export-failed-error" : "无法导出部件类型： {{error}}",
            "create-new-widget-type" : "创建新的部件类型",
            "widget-type-file" : "部件类型文件",
            "invalid-widget-type-file-error" : "无法导入部件类型：无效的部件类型数据结构。"
        },
        "language" : {
            "language" : "语言",
            "en_US" : "英语",
            "ko_KR" : "韩语",
            "zh_CN" : "汉语",
            "ru_RU" : "俄语",
            "es_ES": "西班牙语"
        }
    };
    angular.extend(locales, {
        'zh_CN' : zh_CN
    });
}
