# Docker configuration for ThingsBoard Microservices 

This folder containing scripts and Docker Compose configurations to run ThingsBoard in Microservices mode.

## Prerequisites

ThingsBoard Microservices are running in dockerized environment.
Before starting please make sure [Docker CE](https://docs.docker.com/install/) and [Docker Compose](https://docs.docker.com/compose/install/) are installed in your system.

## Installation

Before performing initial installation you can configure the type of database to be used with ThinsBoard.
In order to set database type change the value of `DATABASE` variable in `.env` file to one of the following:

- `local` - use local embedded HSQLDB database;
- `postgres` - use PostgreSQL database;
- `cassandra` - use Cassandra database;
 
**NOTE**: In case of `postgres` or `cassandra` corresponding docker service will be deployed (see `docker-compose.postgres.yml`, `docker-compose.cassandra.yml` for details).  

Execute the following command to run installation:

` 
$ ./docker-install-tb.sh --loadDemo
` 

Where:

- `--loadDemo` - optional argument. Whether to load additional demo data.

## Running

Execute the following command to start services:

` 
$ ./docker-start-services.sh
` 

After a while when all services will be successfully started you can open `http://{yor-host-ip}` in you browser (for ex. `http://localhost`).
You should see ThingsBoard login page.

Use the following default credentials:

- **Systen Administrator**: sysadmin@thingsboard.org / sysadmin

If you installed DataBase with demo data (using `--loadDemo` flag) you can also use the following credentials:

- **Tenant Administrator**: tenant@thingsboard.org / tenant
- **Customer User**: customer@thingsboard.org / customer

In case of any issues you can examine service logs for errors. 
For example to see ThingsBoard node logs execute the following command:

` 
$ docker-compose logs -f tb
` 

Or use `docker-compose ps` to see the state of all the containers.
Use `docker-compose logs --f` to inspect the logs of all running services.
See [docker-compose logs](https://docs.docker.com/compose/reference/logs/) command reference for details.  

Execute the following command to stop services:

` 
$ ./docker-stop-services.sh
` 

Execute the following command to stop and completely remove deployed docker containers:

` 
$ ./docker-remove-services.sh
` 

Execute the following command to update particular or all services (pull newer docker image and rebuild container):

` 
$ ./docker-update-service.sh [SERVICE...]
` 

Where:

- `[SERVICE...]` - list of services to update (defined in docker-compose configurations). If not specified all services will be updated. 

## Upgrading 

In case when database upgrade is needed, execute the following commands:

```
$ ./docker-stop-services.sh
$ ./docker-upgrade-tb.sh --fromVersion=[FROM_VERSION]
$ ./docker-start-services.sh
```

Where:

- `FROM_VERSION` - from which version upgrade should be started. See [Upgrade Instructions](https://thingsboard.io/docs/user-guide/install/upgrade-instructions) for valid `fromVersion` values.
