/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.applicationtracer;

import br.ufrgs.inf.prosoft.jsonserialiser.JSONSerialiser;
import br.ufrgs.inf.prosoft.trace.Parameter;
import br.ufrgs.inf.prosoft.trace.Return;
import br.ufrgs.inf.prosoft.trace.Trace;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

/**
 *
 * @author romulo
 */
@Aspect
public class TracerAspect {

    @Pointcut("execution(!void *(..))")
    public void anyMethodExecution() {
    }

    @Around("anyMethodExecution()")
    public Object serializeMethodCall(ProceedingJoinPoint joinPoint) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object proceed = joinPoint.proceed();
        long endTime = System.currentTimeMillis();
        if (startTime == endTime) {
            return proceed;
        }
        List<String> blacklist;
        try {
            blacklist = Files.readAllLines(Paths.get("./blacklist"));
        } catch (IOException ex) {
            blacklist = new ArrayList<>();
        }
        try {
            String longsignature = joinPoint.getSignature().toLongString();
            if (blacklist.contains(longsignature)) {
                System.out.println("[ApplicationTracer] skipping " + longsignature);
                return proceed;
            }
            System.out.println("[ApplicationTracer] tracing " + longsignature);
            String[] split = longsignature.substring(0, longsignature.length() - 1).split("\\(");
            String[] modifiersReturnAndName = split[0].split(" ");
            String[] modifiers = Arrays.copyOf(modifiersReturnAndName, modifiersReturnAndName.length - 2);
            String methodName = modifiersReturnAndName[modifiersReturnAndName.length - 1];
            String returnType = modifiersReturnAndName[modifiersReturnAndName.length - 2];
            List<Parameter> parameters = new ArrayList<>();
            if (split.length > 1) {
                String[] parameterTypes = split[1].split(", ");
                Object[] parametersData = joinPoint.getArgs();
                for (int i = 0; i < parametersData.length; i++) {
                    parameters.add(new Parameter(parameterTypes[i], parametersData[i]));
                }
            }
            Return returnValue = new Return(returnType, proceed);
            String instance;
            try {
                instance = String.valueOf(joinPoint.getThis().hashCode());
            } catch (Exception ex) {
                instance = "s";
            }
            Trace trace = new Trace(instance, Arrays.asList(modifiers), returnValue, methodName, parameters, startTime, endTime);
            synchronized (TracerAspect.class) {
                System.out.println("[ApplicationTracer] serialising " + System.currentTimeMillis());
                try (FileWriter fileWriter = new FileWriter("./trace", true)) {
                    try {
                        JSONSerialiser.serialiseAcylicObject(trace, fileWriter);
                    } catch (IOException ex) {
                        System.err.println("[ApplicationTracer] Unable to serialise due IOException");
                    }
                    fileWriter.append("\n");
                }
                System.out.println("[ApplicationTracer] serialised " + System.currentTimeMillis());
            }
        } catch (Exception ex) {
            System.err.println("[ApplicationTracer] exception: " + ex);
        }
        return proceed;
    }
}
