/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.applicationtracer;

import br.ufrgs.inf.prosoft.trace.Parameter;
import br.ufrgs.inf.prosoft.trace.Return;
import br.ufrgs.inf.prosoft.trace.Trace;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.json.JSONObject;

/**
 *
 * @author romulo
 */
@Aspect
public class TracerAspect {

    @Pointcut("execution(!void *(..))")
    public void anyMethodExecution() {
    }

    @Around("anyMethodExecution()")
    public Object serializeMethodCall(ProceedingJoinPoint joinPoint) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object proceed = joinPoint.proceed();
        long endTime = System.currentTimeMillis();
        if (startTime == endTime) {
            return proceed;
        }
        try {
            String longsignature = joinPoint.getSignature().toLongString();
            String[] split = longsignature.substring(0, longsignature.length() - 1).split("\\(");
            String[] modifiersReturnAndName = split[0].split(" ");
            String[] modifiers = Arrays.copyOf(modifiersReturnAndName, modifiersReturnAndName.length - 2);
            String methodName = modifiersReturnAndName[modifiersReturnAndName.length - 1];
            String returnType = modifiersReturnAndName[modifiersReturnAndName.length - 2];
            List<Parameter> parameters = new ArrayList<>();
            List<Parameter> parametersDigested = new ArrayList<>();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            if (split.length > 1) {
                String[] parameterTypes = split[1].split(", ");
                Object[] parametersData = joinPoint.getArgs();
                for (int i = 0; i < parametersData.length; i++) {
                    String parameter = JSONObject.createCyclicFields(parametersData[i]).toString();
                    parametersDigested.add(new Parameter(parameterTypes[i], messageDigest.digest(parameter.getBytes()).toString()));
                    parameters.add(new Parameter(parameterTypes[i], parametersData[i]));
                }
            }
            Return returnValueDigested = new Return(returnType, messageDigest.digest(JSONObject.createCyclicFields(proceed).toString().getBytes()).toString());
            Return returnValue = new Return(returnType, proceed);
            String instance;
            try {
                instance = String.valueOf(joinPoint.getThis().hashCode());
            } catch (Exception ex) {
                instance = "s";
            }
            Trace traceDigested = new Trace(instance, Arrays.asList(modifiers), returnValueDigested, methodName, parametersDigested, startTime, endTime);
            Trace trace = new Trace(instance, Arrays.asList(modifiers), returnValue, methodName, parameters, startTime, endTime);
            String signature = JSONObject.createAcyclicFields(trace).toString();
            signature += "\n";
            String signatureDigested = JSONObject.createAcyclicFields(traceDigested).toString();
            signatureDigested += "\n";
            try {
                Files.write(Paths.get("./trace"), signature.getBytes(), StandardOpenOption.APPEND);
            } catch (NoSuchFileException e) {
                Files.write(Paths.get("./trace"), signature.getBytes(), StandardOpenOption.CREATE);
            }
            try {
                Files.write(Paths.get("./traceDigested"), signatureDigested.getBytes(), StandardOpenOption.APPEND);
            } catch (NoSuchFileException e) {
                Files.write(Paths.get("./traceDigested"), signatureDigested.getBytes(), StandardOpenOption.CREATE);
            }
        } catch (Exception ex) {
            System.err.println("[Application Tracer] exception: " + ex);
        }
        return proceed;
    }
}
