/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.applicationsdumpler;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.json.JSONObject;

/**
 *
 * @author romulo
 */
@Aspect
public class Dumpler {

    @Pointcut("execution(!void *(..))")
    public void anyMethodExecution() {
    }

    @Around("anyMethodExecution()")
    public Object serializeMethodCall(ProceedingJoinPoint joinPoint) throws Throwable {
        StringBuilder signature = new StringBuilder();
        signature.append(joinPoint.getSignature().getDeclaringTypeName());
        signature.append(".");
        signature.append(joinPoint.getSignature().getName());
        signature.append("(");
        Object[] args = joinPoint.getArgs();
        if (args.length != 0) {
            int i = 0;
            while (true) {
                if (args[i] instanceof String) {
                    signature.append("\"").append(args[i]).append("\" ");
                } else {
                    JSONObject jsonobject = new JSONObject(args[i]);
                    signature.append(jsonobject);
                }
                if (++i == args.length) {
                    break;
                }
                signature.append(", ");
            }
        }
        signature.append(")");
        Object proceed = joinPoint.proceed();
        if (proceed instanceof String) {
            signature.insert(0, "\"" + proceed + "\" ");
        } else {
            JSONObject jsonobject = new JSONObject(proceed);
            signature.insert(0, jsonobject + " ");
        }
        System.out.println(signature);
        return proceed;
    }
}
