/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.applicationsdumpler;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.json.JSONObject;

/**
 *
 * @author romulo
 */
@Aspect
public class Dumpler {

    @Pointcut("execution(!void *(..))")
    public void anyMethodExecution() {
    }

    @Around("anyMethodExecution()")
    public Object serializeMethodCall(ProceedingJoinPoint joinPoint) throws Throwable {
        String longsignature = joinPoint.getSignature().toLongString();
        int indexOfParenthesis = longsignature.lastIndexOf("(");
        String[] argumentClassesName = longsignature.substring(indexOfParenthesis + 1, longsignature.length() - 1).split(", ");
        String returnClassName = longsignature.substring(0, indexOfParenthesis);
        returnClassName = returnClassName.substring(0, returnClassName.lastIndexOf(" "));
        int indexOfEndOfModifiersSpace = returnClassName.lastIndexOf(" ");
        String modifiers = returnClassName.substring(0, indexOfEndOfModifiersSpace);
        returnClassName = returnClassName.substring(indexOfEndOfModifiersSpace + 1, returnClassName.length());
        StringBuilder signature = new StringBuilder();
        signature.append(joinPoint.getSignature().getDeclaringTypeName());
        signature.append(".");
        signature.append(joinPoint.getSignature().getName());
        signature.append("(").append("[");
        Object[] args = joinPoint.getArgs();
        if (args.length != 0) {
            int i = 0;
            while (true) {
                signature.append("\"").append(argumentClassesName[i]).append("\":");
                if (args[i] instanceof String) {
                    String argument = (String) args[i];
                    signature.append("\"").append(argument.replace("\n", "\\n")).append("\"");
                } else {
                    JSONObject jsonobject = new JSONObject(args[i]);
                    signature.append(jsonobject);
                }
                if (++i == args.length) {
                    break;
                }
                signature.append(", ");
            }
        }
        signature.append("]").append(")");
        Object proceed = joinPoint.proceed();
        if (proceed instanceof String) {
            String proceedCast = (String) proceed;
            signature.insert(0, "\"" + proceedCast.replace("\n", "\\n") + "\" ");
        } else {
            JSONObject jsonobject = new JSONObject(proceed);
            signature.insert(0, jsonobject + " ");
        }
        signature.insert(0, "\"" + returnClassName + "\":");
        signature.insert(0, modifiers + " ");
        signature.append("\n");
        Files.write(Paths.get("./trace"), signature.toString().getBytes(), StandardOpenOption.APPEND);
        System.out.print(signature);
        return proceed;
    }
}
