/*
 * Copyright © 2016-2018 The Thingsboard Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
export default function addLocaleKorean(locales) {
    var ko_KR = {
        "access": {
            "unauthorized": "권한 없음.",
            "unauthorized-access": "허가되지 않은 접근",
            "unauthorized-access-text": "이 리소스에 접근하려면 로그인해야 합니다!",
            "access-forbidden": "접근 금지",
            "access-forbidden-text": "접근 권한이 없습니다.!<br> 만일 이 페이지에 계속 접근하려면 다른 사용자로 로그인 하세요.",
            "refresh-token-expired": "세션이 만료되었습니다.",
            "refresh-token-failed": "세션을 새로 고칠 수 없습니다."
        },
        "action": {
            "activate": "활설화",
            "suspend": "비활성화",
            "save": "저장",
            "saveAs": "다른 이름으로 저장",
            "cancel": "취소",
            "ok": "확인",
            "delete": "삭제",
            "add": "추가",
            "yes": "네",
            "no": "아니오",
            "update": "업데이트",
            "remove": "제거",
            "search": "검색",
            "clear-search": "Clear search", // TODO
            "assign": "할당",
            "unassign": "비할당",
            "share": "Share", // TODO
            "make-private": "Make private", // TODO
            "apply": "적용",
            "apply-changes": "변경사항 적용",
            "edit-mode": "수정 모드",
            "enter-edit-mode": "수정 모드 진입",
            "decline-changes": "변경사항 포기",
            "close": "닫기",
            "back": "뒤로",
            "run": "실행",
            "sign-in": "로그인!",
            "edit": "수정",
            "view": "보기",
            "create": "만들기",
            "drag": "끌기",
            "refresh": "새로고침",
            "undo": "취소",
            "copy": "복사",
            "paste": "붙여넣기",
            "copy-reference": "Copy reference", // TODO
            "paste-reference": "Paste reference", // TODO
            "import": "가져오기",
            "export": "내보내기",
            "share-via": "Share via {{provider}}" // TODO
        },
        "aggregation": {
            "aggregation": "집합",
            "function": "데이터 집합 함수",
            "limit": "최대 값",
            "group-interval": "그룹 간격",
            "min": "최소",
            "max": "최대",
            "avg": "평균",
            "sum": "합계",
            "count": "숫자",
            "none": "없음"
        },
        "admin": {
            "general": "일반",
            "general-settings": "일반 설정",
            "outgoing-mail": "메일 전송",
            "outgoing-mail-settings": "메일 전송 설정",
            "system-settings": "시스템 설정",
            "test-mail-sent": "테스트 메일이 성공적으로 전송되었습니다!",
            "base-url": "기본 URL",
            "base-url-required": "기본 URL을 입력해야 합니다.",
            "mail-from": "보내는 사람",
            "mail-from-required": "보내는 사람을 입력해야 합니다.",
            "smtp-protocol": "SMTP 프로토콜",
            "smtp-host": "SMTP 호스트",
            "smtp-host-required": "SMTP 호스트를 입력해야 합니다.",
            "smtp-port": "SMTP 포트",
            "smtp-port-required": "SMTP 포트를 입력해야 합니다.",
            "smtp-port-invalid": "올바른 SMTP 포트가 아닙니다.",
            "timeout-msec": "제한시간 (msec)",
            "timeout-required": "제한시간을 입력해야 합니다.",
            "timeout-invalid": "올바른 제한시간이 아닙니다.",
            "enable-tls": "TLS 사용",
            "send-test-mail": "테스트 메일 보내기"
        },

        "alarm": { // TODO
            "alarm": "Alarm",
            "alarms": "Alarms",
            "select-alarm": "Select alarm",
            "no-alarms-matching": "No alarms matching '{{entity}}' were found.",
            "alarm-required": "Alarm is required",
            "alarm-status": "Alarm status",
            "search-status": {
                "ANY": "Any",
                "ACTIVE": "Active",
                "CLEARED": "Cleared",
                "ACK": "Acknowledged",
                "UNACK": "Unacknowledged"
            },
            "display-status": {
                "ACTIVE_UNACK": "Active Unacknowledged",
                "ACTIVE_ACK": "Active Acknowledged",
                "CLEARED_UNACK": "Cleared Unacknowledged",
                "CLEARED_ACK": "Cleared Acknowledged"
            },
            "no-alarms-prompt": "No alarms found",
            "created-time": "Created time",
            "type": "Type",
            "severity": "Severity",
            "originator": "Originator",
            "originator-type": "Originator type",
            "details": "Details",
            "status": "Status",
            "alarm-details": "Alarm details",
            "start-time": "Start time",
            "end-time": "End time",
            "ack-time": "Acknowledged time",
            "clear-time": "Cleared time",
            "severity-critical": "Critical",
            "severity-major": "Major",
            "severity-minor": "Minor",
            "severity-warning": "Warning",
            "severity-indeterminate": "Indeterminate",
            "acknowledge": "Acknowledge",
            "clear": "Clear",
            "search": "Search alarms",
            "selected-alarms": "{ count, select, 1 {1 alarm} other {# alarms} } selected",
            "no-data": "No data to display",
            "polling-interval": "Alarms polling interval (sec)",
            "polling-interval-required": "Alarms polling interval is required.",
            "min-polling-interval-message": "At least 1 sec polling interval is allowed.",
            "aknowledge-alarms-title": "Acknowledge { count, select, 1 {1 alarm} other {# alarms} }",
            "aknowledge-alarms-text": "Are you sure you want to acknowledge { count, select, 1 {1 alarm} other {# alarms} }?",
            "clear-alarms-title": "Clear { count, select, 1 {1 alarm} other {# alarms} }",
            "clear-alarms-text": "Are you sure you want to clear { count, select, 1 {1 alarm} other {# alarms} }?"
        },
        "alias": { // TODO
            "add": "Add alias",
            "edit": "Edit alias",
            "name": "Alias name",
            "name-required": "Alias name is required",
            "duplicate-alias": "Alias with same name is already exists.",
            "filter-type-single-entity": "Single entity",
            "filter-type-entity-list": "Entity list",
            "filter-type-entity-name": "Entity name",
            "filter-type-state-entity": "Entity from dashboard state",
            "filter-type-state-entity-description": "Entity taken from dashboard state parameters",
            "filter-type-asset-type": "Asset type",
            "filter-type-asset-type-description": "Assets of type '{{assetType}}'",
            "filter-type-asset-type-and-name-description": "Assets of type '{{assetType}}' and with name starting with '{{prefix}}'",
            "filter-type-device-type": "Device type",
            "filter-type-device-type-description": "Devices of type '{{deviceType}}'",
            "filter-type-device-type-and-name-description": "Devices of type '{{deviceType}}' and with name starting with '{{prefix}}'",
            "filter-type-relations-query": "Relations query",
            "filter-type-relations-query-description": "{{entities}} that have {{relationType}} relation {{direction}} {{rootEntity}}",
            "filter-type-asset-search-query": "Asset search query",
            "filter-type-asset-search-query-description": "Assets with types {{assetTypes}} that have {{relationType}} relation {{direction}} {{rootEntity}}",
            "filter-type-device-search-query": "Device search query",
            "filter-type-device-search-query-description": "Devices with types {{deviceTypes}} that have {{relationType}} relation {{direction}} {{rootEntity}}",
            "entity-filter": "Entity filter",
            "resolve-multiple": "Resolve as multiple entities",
            "filter-type": "Filter type",
            "filter-type-required": "Filter type is required.",
            "entity-filter-no-entity-matched": "No entities matching specified filter were found.",
            "no-entity-filter-specified": "No entity filter specified",
            "root-state-entity": "Use dashboard state entity as root",
            "root-entity": "Root entity",
            "state-entity-parameter-name": "State entity parameter name",
            "default-state-entity": "Default state entity",
            "default-entity-parameter-name": "By default",
            "max-relation-level": "Max relation level",
            "unlimited-level": "Unlimited level",
            "state-entity": "Dashboard state entity",
            "all-entities": "All entities",
            "any-relation": "any"
        },
        "asset": { // TODO
            "asset": "Asset",
            "assets": "Assets",
            "management": "Asset management",
            "view-assets": "View Assets",
            "add": "Add Asset",
            "assign-to-customer": "Assign to customer",
            "assign-asset-to-customer": "Assign Asset(s) To Customer",
            "assign-asset-to-customer-text": "Please select the assets to assign to the customer",
            "no-assets-text": "No assets found",
            "assign-to-customer-text": "Please select the customer to assign the asset(s)",
            "public": "Public",
            "assignedToCustomer": "Assigned to customer",
            "make-public": "Make asset public",
            "make-private": "Make asset private",
            "unassign-from-customer": "Unassign from customer",
            "delete": "Delete asset",
            "asset-public": "Asset is public",
            "asset-type": "Asset type",
            "asset-type-required": "Asset type is required.",
            "select-asset-type": "Select asset type",
            "enter-asset-type": "Enter asset type",
            "any-asset": "Any asset",
            "no-asset-types-matching": "No asset types matching '{{entitySubtype}}' were found.",
            "asset-type-list-empty": "No asset types selected.",
            "asset-types": "Asset types",
            "name": "Name",
            "name-required": "Name is required.",
            "description": "Description",
            "type": "Type",
            "type-required": "Type is required.",
            "details": "Details",
            "events": "Events",
            "add-asset-text": "Add new asset",
            "asset-details": "Asset details",
            "assign-assets": "Assign assets",
            "assign-assets-text": "Assign { count, select, 1 {1 asset} other {# assets} } to customer",
            "delete-assets": "Delete assets",
            "unassign-assets": "Unassign assets",
            "unassign-assets-action-title": "Unassign { count, select, 1 {1 asset} other {# assets} } from customer",
            "assign-new-asset": "Assign new asset",
            "delete-asset-title": "Are you sure you want to delete the asset '{{assetName}}'?",
            "delete-asset-text": "Be careful, after the confirmation the asset and all related data will become unrecoverable.",
            "delete-assets-title": "Are you sure you want to delete { count, select, 1 {1 asset} other {# assets} }?",
            "delete-assets-action-title": "Delete { count, select, 1 {1 asset} other {# assets} }",
            "delete-assets-text": "Be careful, after the confirmation all selected assets will be removed and all related data will become unrecoverable.",
            "make-public-asset-title": "Are you sure you want to make the asset '{{assetName}}' public?",
            "make-public-asset-text": "After the confirmation the asset and all its data will be made public and accessible by others.",
            "make-private-asset-title": "Are you sure you want to make the asset '{{assetName}}' private?",
            "make-private-asset-text": "After the confirmation the asset and all its data will be made private and won't be accessible by others.",
            "unassign-asset-title": "Are you sure you want to unassign the asset '{{assetName}}'?",
            "unassign-asset-text": "After the confirmation the asset will be unassigned and won't be accessible by the customer.",
            "unassign-asset": "Unassign asset",
            "unassign-assets-title": "Are you sure you want to unassign { count, select, 1 {1 asset} other {# assets} }?",
            "unassign-assets-text": "After the confirmation all selected assets will be unassigned and won't be accessible by the customer.",
            "copyId": "Copy asset Id",
            "idCopiedMessage": "Asset Id has been copied to clipboard",
            "select-asset": "Select asset",
            "no-assets-matching": "No assets matching '{{entity}}' were found.",
            "asset-required": "Asset is required",
            "name-starts-with": "Asset name starts with"
        },
        "attribute": {
            "attributes": "속성",
            "latest-telemetry": "최근 데이터",
            "attributes-scope": "디바이스 속성 범위",
            "scope-latest-telemetry": "최근 데이터",
            "scope-client": "클라이언트 속성",
            "scope-server": "서버 속성",
            "scope-shared": "공유 속성",
            "add": "속성 추가",
            "key": "Key", // TODO
            "key-required": "속성 key를 입력하세요.",
            "value": "Value", // TODO
            "value-required": "속성 value를 입력하세요.",
            "delete-attributes-title": "{ count, select, 1 {속성} other {여러 속성들을} } 삭제하시겠습니까??",
            "delete-attributes-text": "모든 선택된 속성들이 제거 될 것이므로 주의하십시오.",
            "delete-attributes": "속성 삭제",
            "enter-attribute-value": "속성 값 입력",
            "show-on-widget": "위젯 보기",
            "widget-mode": "위젯 모드",
            "next-widget": "다음 위젯",
            "prev-widget": "이전 위젯",
            "add-to-dashboard": "대시보드에 추가",
            "add-widget-to-dashboard": "대시보드에 위젯 추가",
            "selected-attributes": "{ count, select, 1 {속성 1개} other {속성 #개} } 선택됨",
            "selected-telemetry": "{ count, select, 1 {최근 데이터 1개} other {최근 데이터 #개} } 선택됨"
        },
        "audit-log": { // TODO
            "audit": "Audit",
            "audit-logs": "Audit Logs",
            "timestamp": "Timestamp",
            "entity-type": "Entity Type",
            "entity-name": "Entity Name",
            "user": "User",
            "type": "Type",
            "status": "Status",
            "details": "Details",
            "type-added": "Added",
            "type-deleted": "Deleted",
            "type-updated": "Updated",
            "type-attributes-updated": "Attributes updated",
            "type-attributes-deleted": "Attributes deleted",
            "type-rpc-call": "RPC call",
            "type-credentials-updated": "Credentials updated",
            "type-assigned-to-customer": "Assigned to Customer",
            "type-unassigned-from-customer": "Unassigned from Customer",
            "type-activated": "Activated",
            "type-suspended": "Suspended",
            "type-credentials-read": "Credentials read",
            "type-attributes-read": "Attributes read",
            "status-success": "Success",
            "status-failure": "Failure",
            "audit-log-details": "Audit log details",
            "no-audit-logs-prompt": "No logs found",
            "action-data": "Action data",
            "failure-details": "Failure details",
            "search": "Search audit logs",
            "clear-search": "Clear search"
        },
        "confirm-on-exit": {
            "message": "변경 사항을 저장하지 않았습니다. 이 페이지를 나가시겠습니까?",
            "html-message": "변경 사항을 저장하지 않았습니다.<br/>이 페이지를 나가시겠습니까?",
            "title": "저장되지 않은 변경사항"
        },
        "contact": {
            "country": "국가",
            "city": "시",
            "state": "도",
            "postal-code": "우편 번호",
            "postal-code-invalid": "숫자만 입력하세요.",
            "address": "주소",
            "address2": "상세주소",
            "phone": "전화번호",
            "email": "Email",
            "no-address": "주소 정보 없음"
        },
        "common": {
            "username": "사용자명",
            "password": "비밀번호",
            "enter-username": "사용자명을 입력하세요.",
            "enter-password": "비밀번호를 입력하세요.",
            "enter-search": "검색어 입력"
        },
        "content-type": { // TODO
            "json": "Json",
            "text": "Text",
            "binary": "Binary (Base64)"
        },
        "customer": {
            "customers": "커스터머",
            "management": "커스터머 관리",
            "dashboard": "커스터머 대시보드",
            "dashboards": "커스터머 대시보드",
            "devices": "커스터머 디바이스",
            "add": "커스터머 추가",
            "delete": "커스터머 삭제",
            "manage-customer-users": "커스터머 사용자 관리",
            "manage-customer-devices": "커스터머 디바이스 관리",
            "manage-customer-dashboards": "커스터머 대시보드 관리",
            "manage-public-devices": "Manage public devices", // TODO
            "manage-public-dashboards": "Manage public dashboards", // TODO
            "manage-customer-assets": "Manage customer assets", // TODO
            "manage-public-assets": "Manage public assets", // TODO
            "add-customer-text": "커스터머 추가",
            "no-customers-text": "커스터머가 없습니다.",
            "customer-details": "커스터머 상세정보",
            "delete-customer-title": "'{{customerTitle}}' 커스터머를 삭제하시겠습니까?",
            "delete-customer-text": "커스터머 및 관련된 모든 데이터를 복구할 수 없으므로 주의하십시오.",
            "delete-customers-title": "{ count, select, 1 {커스터머 1개} other {커스터머 #개} }를 삭제하시겠습니까?",
            "delete-customers-action-title": "{ count, select, 1 {커스터머 1개} other {커스터머 #개} } 삭제",
            "delete-customers-text": "선택된 커스터머는 삭제되고 관련된 모든 데이터를 복구할 수 없으므로 주의하십시오.",
            "manage-users": "사용자 관리",
            "manage-devices": "디바이스 관리",
            "manage-dashboards": "대시보드 관리",
            "title": "타이틀",
            "title-required": "타이틀을 입력하세요.",
            "description": "설명",
            "details": "Details",
            "events": "Events",
            "copyId": "Copy customer Id",
            "idCopiedMessage": "Customer Id has been copied to clipboard",
            "select-customer": "Select customer",
            "no-customers-matching": "No customers matching '{{entity}}' were found.",
            "customer-required": "Customer is required",
            "select-default-customer": "Select default customer",
            "default-customer": "Default customer",
            "default-customer-required": "Default customer is required in order to debug dashboard on Tenant level"
        },
        "datetime": {
            "date-from": "시작 날짜",
            "time-from": "시작 시간",
            "date-to": "종료 날짜",
            "time-to": "종료 시간"
        },
        "dashboard": {
            "dashboard": "대시보드",
            "dashboards": "대시보드",
            "management": "대시보드 관리",
            "view-dashboards": "대시보드 보기",
            "add": "대시보드 추가",
            "assign-dashboard-to-customer": "대시보드 커스터머 선택",
            "assign-dashboard-to-customer-text": "대시보드 커스터머를 선택하세요.",
            "assign-to-customer-text": "대시보드 커스터머를 선택하세요.",
            "assign-to-customer": "커스터머 선택",
            "unassign-from-customer": "커스터머 해제",
            "no-dashboards-text": "대시보드가 없습니다",
            "no-widgets": "설정된 위젯 없음",
            "add-widget": "위젯 추가",
            "title": "타이틀",
            "select-widget-title": "위젯 선택",
            "select-widget-subtitle": "사용가능한 위젯 타입 목록",
            "delete": "대시보드 삭제",
            "title-required": "타이틀을 입력하세요.",
            "description": "설명",
            "details": "상세",
            "dashboard-details": "대시보드 상세정보",
            "add-dashboard-text": "대시보드 추가",
            "assign-dashboards": "대시보드 지정",
            "assign-new-dashboard": "새 대시보드 할당",
            "assign-dashboards-text": "{ count, select, 1 {대시보드 1개} other {대시보드 #개} }를 커스터머 할당",
            "delete-dashboards": "대시보드 삭제",
            "unassign-dashboards": "대시보드 할당 취소",
            "unassign-dashboards-action-title": "{ count, select, 1 {대시보드 1개} other {대시보드 #개} }를 커스터머 할당 취소",
            "delete-dashboard-title": "'{{dashboardTitle}}' 대시보드를 삭제하시겠습니까?",
            "delete-dashboard-text": "대시보드 및 관련된 모든 데이터를 복구할 수 없으므로 주의하십시오.",
            "delete-dashboards-title": "{ count, select, 1 {대시보드 1개} other {대시보드 #개} }를 삭제하시겠습니까?",
            "delete-dashboards-action-title": "{ count, select, 1 {대시보드 1개} other {대시보드 #개} } 삭제",
            "delete-dashboards-text": "선택된 대시보드가 삭제되고 관련된 모든 데이터를 복구할 수 없으므로 주의하십시오.",
            "unassign-dashboard-title": "'{{dashboardTitle}}' 대시보드 할당을 해제하시겠습니까?",
            "unassign-dashboard-text": "대시보드가 할당 해제되고 커스터머는 액세스 할 수 없게됩니다.",
            "unassign-dashboard": "대시보드 할달 취소",
            "unassign-dashboards-title": "{ count, select, 1 {대시보드 1개} other {대시보드 #개} }의 할당을 취소하시겠습니까?",
            "unassign-dashboards-text": "선택된 대시보드가 할당 해제되고 커스터머는 액세스 할 수 없게됩니다.",
            "select-dashboard": "대시보드 선택",
            "no-dashboards-matching": "'{{entity}}'와 일치하는 대시보드가 없습니다.",
            "dashboard-required": "대시보드를 입력하세요.",
            "select-existing": "기존 대시보드 선택",
            "create-new": "대시보드 생성",
            "new-dashboard-title": "새로운 대시보드 타이틀",
            "open-dashboard": "대시보드 열기",
            "set-background": "대시보드 설정",
            "background-color": "배경색",
            "background-image": "배경 이미지",
            "background-size-mode": "배경 사이즈 모드",
            "no-image": "이미지 없음",
            "drop-image": "이곳에 이미지를 끌어다놓거나 이곳을 클릭하여 파일을 선택하고 업로드하세요.",
            "settings": "설정",
            "columns-count": "열 개수",
            "columns-count-required": "열 개수를 입력하세요.",
            "min-columns-count-message": "열 개수를 최소 10 이상 입력하세요.",
            "max-columns-count-message": "열 개수를 최대 100 이하로 입력하세요.",
            "widgets-margins": "위젯 사이 여백 크기",
            "horizontal-margin": "세로 여백",
            "horizontal-margin-required": "세로 여백 값을 입력하세요.",
            "min-horizontal-margin-message": "세로 여백 값을 최소 0 이상 입력하세요.",
            "max-horizontal-margin-message": "세로 여백 값을 최대 50 이하로 입력하세요.",
            "vertical-margin": "가로 여백",
            "vertical-margin-required": "가로 여백 값을 입력하세요.",
            "min-vertical-margin-message": "가로 여백 값을 최소 0 이상 입력하세요.",
            "max-vertical-margin-message": "가로 여백 값을 최대 50 이하로 입력하세요.",
            "display-title": "대시보드 타이틀 표시",
            "title-color": "타이틀 색상",
            "import": "대시보드 가져오기",
            "export": "대시보드 내보내기",
            "export-failed-error": "대시보드 내보내기를 할 수 없습니다.: {error}",
            "create-new-dashboard": "대시보드 생성",
            "dashboard-file": "대시보드 파일",
            "invalid-dashboard-file-error": "대시보드 가져오기를 할 수 없습니다.: 대시보드 데이터 구조가 잘못되었습니다.",
            "dashboard-import-missing-aliases-title": "대시보드 앨리어스를 위해 누락 된 디바이스 선택",
            "create-new-widget": "새로운 위젯 생성",
            "import-widget": "위젯 가져오기",
            "widget-file": "위젯 파일",
            "invalid-widget-file-error": "위젯 가져오기를 할 수 없습니다: 위젯 데이터 구조가 잘못되었습니다.",
            "widget-import-missing-aliases-title": "위젯에서 사용하는 누락 된 디바이스 선택",
            "open-toolbar": "대시보드 툴바 열기",
            "close-toolbar": "툴바 닫기",
            "configuration-error": "구성 오류",
            "alias-resolution-error-title": "대시보드 앨리어스 구성 오류",
            "invalid-aliases-config": "일부 앨리어스 필터와 일치하는 디바이스를 찾을 수 없습니다.<br>이 문제를 해결하려면 관리자에게 문의하십시오.",
            "select-devices": "디바이스 선택",
            "assignedToCustomer": "커스터머에 할당됨"
        },
        "datakey": {
            "settings": "설정",
            "advanced": "고급",
            "label": "Label",
            "color": "색상",
            "data-generation-func": "데이터 생성 기능",
            "use-data-post-processing-func": "데이터 후처리 기능 사용",
            "configuration": "데이터 key 구성",
            "timeseries": "Timeseries",
            "attributes": "Attributes",
            "timeseries-required": "디바이스 timeseries 를 입력하세요.",
            "timeseries-or-attributes-required": "디바이스 timeseries/attributes 를 입력하세요.",
            "maximum-timeseries-or-attributes": "Maximum { count, select, 1 {1 timeseries/attribute is allowed.} other {# timeseries/attributes are allowed} }", // TODO
            "alarm-fields-required": "Alarm fields are required.", // TODO
            "function-types": "함수 유형",
            "function-types-required": "함수 유형을 입력하세요.",
            "maximum-function-types": "Maximum { count, select, 1 {1 function type is allowed.} other {# function types are allowed} }" // TODO
        },
        "datasource": {
            "type": "데이터소스 유형",
            "name": "Name", // TODO
            "add-datasource-prompt": "데이터소스를 추가하세요."
        },
        "details": {
            "edit-mode": "편집 모드",
            "toggle-edit-mode": "편집 모드 전환"
        },
        "device": {
            "device": "디바이스",
            "device-required": "디바이스를 입력하세요.",
            "devices": "디바이스",
            "management": "디바이스 관리",
            "view-devices": "디바이스 보기",
            "device-alias": "디바이스 앨리어스",
            "aliases": "디바이스 앨리어스",
            "no-alias-matching": "'{{alias}}' 를 찾을 수 없습니다.",
            "no-aliases-found": "앨리어스가 없습니다.",
            "no-key-matching": "'{{key}}' 를 찾을 수 없습니다.",
            "no-keys-found": "Key가 없습니다.",
            "create-new-alias": "새로 만들기!",
            "create-new-key": "새로 만들기!",
            "duplicate-alias-error": "중복된 '{{alias}}' 앨리어스가 있습니다.<br> 디바이스 앨리어스는 대시보드 내에서 고유해야 합니다.",
            "configure-alias": "'{{alias}}' 앨리어스 구성",
            "no-devices-matching": "'{{entity}}'와 일치하는 디바이스를 찾을 수 없습니다.",
            "alias": "앨리어스",
            "alias-required": "디바이스 앨리어스를 입력하세요.",
            "remove-alias": "디바이스 앨리어스 삭제",
            "add-alias": "디바이스 앨리어스 추가",
            "name-starts-with": "시작되는 이름",
            "device-list": "디바이스 리스트",
            "use-device-name-filter": "필터 사용",
            "device-list-empty": "선택된 디바이스가 없습니다.",
            "device-name-filter-required": "디바이스 필터 이름을 입력하세요.",
            "device-name-filter-no-device-matched": "'{{device}}' 로 시작되는 디바이스를 찾을 수 없습니다.",
            "add": "디바이스 추가",
            "assign-to-customer": "커스터머에게 할당",
            "assign-device-to-customer": "디바이스를 커스터머에게 할당",
            "assign-device-to-customer-text": "고객에게 할당할 디바이스를 선택하십시오.",
            "no-devices-text": "디바이스 없음",
            "assign-to-customer-text": "디바이스를 할당할 커스터머를 선택하세요.",
            "device-details": "디바이스 상세정보",
            "add-device-text": "디바이스 추가",
            "credentials": "크리덴셜",
            "manage-credentials": "크리덴셜 관리",
            "delete": "디바이스 삭제",
            "assign-devices": "디바이스 할당",
            "assign-devices-text": "{ count, select, 1 {디바이스 1개} other {디바이스 #개} }를 커서터머에 할당",
            "delete-devices": "디바이스 삭제",
            "unassign-from-customer": "커스터머 할당 해제",
            "unassign-devices": "디바이스 할당 취소",
            "unassign-devices-action-title": "{ count, select, 1 {디바이스 1개} other {디바이스 #개} }를 커스터머에게서 할당 해제",
            "assign-new-device": "새로운 디바이스 할당",
            "view-credentials": "크리덴셜 보기",
            "delete-device-title": "'{{deviceName}}' 디바이스를 삭제하시겠습니까?",
            "delete-device-text": "디바이스 및 관련된 모든 데이터를 복구할 수 없으므로 주의하십시오.",
            "delete-devices-title": "{ count, select, 1 {디바이스 1개} other {디바이스 #개} }를 삭제하시겠습니까?",
            "delete-devices-action-title": "{ count, select, 1 {디바이스 1개} other {디바이스 #개} } 삭제",
            "delete-devices-text": "선택된 디바이스가 삭제되고 관련된 모든 데이터를 복구할 수 없으므로 주의하십시오.",
            "unassign-device-title": "'{{deviceName}}' 디바이스 할당을 해제하시겠습니까?",
            "unassign-device-text": "디바이스가 할당 해제되고 커스터머는 액세스 할 수 없게됩니다.",
            "unassign-device": "디바이스 할당 취소",
            "unassign-devices-title": "{ count, select, 1 {디바이스 1개} other {디바이스 #개} }의  할당을 해제하시겠습니까??",
            "unassign-devices-text": "선택된 디바이스가 할당 해제되고 커스터머는 액세스 할 수 없게됩니다.",
            "device-credentials": "디바이스 크리덴셜",
            "credentials-type": "크리덴셜 타입",
            "access-token": "억세스 토큰",
            "access-token-required": "액세스 토큰을 입력하세요.",
            "access-token-invalid": "액세스 토큰 길이는 1 - 20 자 여야합니다.",
            "rsa-key": "RSA public key",
            "rsa-key-required": "RSA public key 를 입력하세요.",
            "secret": "시크릿",
            "secret-required": "시크릿을 입력하세요.",
            "name": "이름",
            "name-required": "이름을 입력하세요.",
            "description": "설명",
            "events": "이벤트",
            "details": "상세",
            "copyId": "디바이스 아이디 복사",
            "copyAccessToken": "억세스 토큰 복사",
            "idCopiedMessage": "디바이스 아이디가 클립보드에 복사되었습니다.",
            "accessTokenCopiedMessage": "디바이스 억세스 토큰이 클립보드에 복사되었습니다.",
            "assignedToCustomer": "커스터머에 할당됨",
            "unable-delete-device-alias-title": "디바이스 앨리어스를 삭제할 수 없습니다.",
            "unable-delete-device-alias-text": "'{{deviceAlias}}' 디바이스 앨리어스를 삭제할 수 없습니다. 다음 위젯에서 사용하고 있습니다.<br/>{{widgetsList}}",
            "is-gateway": "게이트웨이 여부"
        },
        "dialog": {
            "close": "다이얼로그 닫기"
        },
        "error": {
            "unable-to-connect": "서버에 연결할 수 없습니다! 인터넷 연결을 확인하십시오.",
            "unhandled-error-code": "처리되지 않은 오류 코드: {{errorCode}}",
            "unknown-error": "알 수 없는 오류"
        },
        "entity": { // TODO
            "entity": "Entity",
            "entities": "Entities",
            "aliases": "Entity aliases",
            "entity-alias": "Entity alias",
            "unable-delete-entity-alias-title": "Unable to delete entity alias",
            "unable-delete-entity-alias-text": "Entity alias '{{entityAlias}}' can't be deleted as it used by the following widget(s):<br/>{{widgetsList}}",
            "duplicate-alias-error": "Duplicate alias found '{{alias}}'.<br>Entity aliases must be unique whithin the dashboard.",
            "missing-entity-filter-error": "Filter is missing for alias '{{alias}}'.",
            "configure-alias": "Configure '{{alias}}' alias",
            "alias": "Alias",
            "alias-required": "Entity alias is required.",
            "remove-alias": "Remove entity alias",
            "add-alias": "Add entity alias",
            "entity-list": "Entity list",
            "entity-type": "Entity type",
            "entity-types": "Entity types",
            "entity-type-list": "Entity type list",
            "any-entity": "Any entity",
            "enter-entity-type": "Enter entity type",
            "no-entities-matching": "No entities matching '{{entity}}' were found.",
            "no-entity-types-matching": "No entity types matching '{{entityType}}' were found.",
            "name-starts-with": "Name starts with",
            "use-entity-name-filter": "Use filter",
            "entity-list-empty": "No entities selected.",
            "entity-type-list-empty": "No entity types selected.",
            "entity-name-filter-required": "Entity name filter is required.",
            "entity-name-filter-no-entity-matched": "No entities starting with '{{entity}}' were found.",
            "all-subtypes": "All",
            "select-entities": "Select entities",
            "no-aliases-found": "No aliases found.",
            "no-alias-matching": "'{{alias}}' not found.",
            "create-new-alias": "Create a new one!",
            "key": "Key",
            "key-name": "Key name",
            "no-keys-found": "No keys found.",
            "no-key-matching": "'{{key}}' not found.",
            "create-new-key": "Create a new one!",
            "type": "Type",
            "type-required": "Entity type is required.",
            "type-device": "Device",
            "type-devices": "Devices",
            "list-of-devices": "{ count, select, 1 {One device} other {List of # devices} }",
            "device-name-starts-with": "Devices whose names start with '{{prefix}}'",
            "type-asset": "Asset",
            "type-assets": "Assets",
            "list-of-assets": "{ count, select, 1 {One asset} other {List of # assets} }",
            "asset-name-starts-with": "Assets whose names start with '{{prefix}}'",
            "type-rule": "Rule",
            "type-rules": "Rules",
            "list-of-rules": "{ count, select, 1 {One rule} other {List of # rules} }",
            "rule-name-starts-with": "Rules whose names start with '{{prefix}}'",
            "type-plugin": "Plugin",
            "type-plugins": "Plugins",
            "list-of-plugins": "{ count, select, 1 {One plugin} other {List of # plugins} }",
            "plugin-name-starts-with": "Plugins whose names start with '{{prefix}}'",
            "type-tenant": "Tenant",
            "type-tenants": "Tenants",
            "list-of-tenants": "{ count, select, 1 {One tenant} other {List of # tenants} }",
            "tenant-name-starts-with": "Tenants whose names start with '{{prefix}}'",
            "type-customer": "Customer",
            "type-customers": "Customers",
            "list-of-customers": "{ count, select, 1 {One customer} other {List of # customers} }",
            "customer-name-starts-with": "Customers whose names start with '{{prefix}}'",
            "type-user": "User",
            "type-users": "Users",
            "list-of-users": "{ count, select, 1 {One user} other {List of # users} }",
            "user-name-starts-with": "Users whose names start with '{{prefix}}'",
            "type-dashboard": "Dashboard",
            "type-dashboards": "Dashboards",
            "list-of-dashboards": "{ count, select, 1 {One dashboard} other {List of # dashboards} }",
            "dashboard-name-starts-with": "Dashboards whose names start with '{{prefix}}'",
            "type-alarm": "Alarm",
            "type-alarms": "Alarms",
            "list-of-alarms": "{ count, select, 1 {One alarms} other {List of # alarms} }",
            "alarm-name-starts-with": "Alarms whose names start with '{{prefix}}'",
            "type-rulechain": "Rule chain",
            "type-rulechains": "Rule chains",
            "list-of-rulechains": "{ count, select, 1 {One rule chain} other {List of # rule chains} }",
            "rulechain-name-starts-with": "Rule chains whose names start with '{{prefix}}'",
            "type-current-customer": "Current Customer",
            "search": "Search entities",
            "selected-entities": "{ count, select, 1 {1 entity} other {# entities} } selected",
            "entity-name": "Entity name",
            "details": "Entity details",
            "no-entities-prompt": "No entities found",
            "no-data": "No data to display"
        },
        "event": {
            "event-type": "이벤트 타입",
            "type-error": "에러",
            "type-lc-event": "주기적 이벤트",
            "type-stats": "통계",
            "type-debug-rule-node": "Debug", // TODO
            "type-debug-rule-chain": "Debug", // TODO
            "no-events-prompt": "이벤트 없음",
            "error": "에러",
            "alarm": "알람",
            "event-time": "이벤트 발생 시간",
            "server": "서버",
            "body": "Body",
            "method": "Method",
            "type": "Type", // TODO
            "entity": "Entity", // TODO
            "message-id": "Message Id", // TODO
            "message-type": "Message Type", // TODO
            "data-type": "Data Type", // TODO
            "relation-type": "Relation Type", // TODO
            "metadata": "Metadata", // TODO
            "data": "Data", // TODO
            "event": "이벤트",
            "status": "상태",
            "success": "성공",
            "failed": "실패",
            "messages-processed": "처리된 메시지",
            "errors-occurred": "오류가 발생했습니다"
        },
        "extension": { // TODO
            "extensions": "Extensions",
            "selected-extensions": "{ count, select, 1 {1 extension} other {# extensions} } selected",
            "type": "Type",
            "key": "Key",
            "value": "Value",
            "id": "Id",
            "extension-id": "Extension id",
            "extension-type": "Extension type",
            "transformer-json": "JSON *",
            "unique-id-required": "Current extension id already exists.",
            "delete": "Delete extension",
            "add": "Add extension",
            "edit": "Edit extension",
            "delete-extension-title": "Are you sure you want to delete the extension '{{extensionId}}'?",
            "delete-extension-text": "Be careful, after the confirmation the extension and all related data will become unrecoverable.",
            "delete-extensions-title": "Are you sure you want to delete { count, select, 1 {1 extension} other {# extensions} }?",
            "delete-extensions-text": "Be careful, after the confirmation all selected extensions will be removed.",
            "converters": "Converters",
            "converter-id": "Converter id",
            "configuration": "Configuration",
            "converter-configurations": "Converter configurations",
            "token": "Security token",
            "add-converter": "Add converter",
            "add-config": "Add converter configuration",
            "device-name-expression": "Device name expression",
            "device-type-expression": "Device type expression",
            "custom": "Custom",
            "to-double": "To Double",
            "transformer": "Transformer",
            "json-required": "Transformer json is required.",
            "json-parse": "Unable to parse transformer json.",
            "attributes": "Attributes",
            "add-attribute": "Add attribute",
            "add-map": "Add mapping element",
            "timeseries": "Timeseries",
            "add-timeseries": "Add timeseries",
            "field-required": "Field is required",
            "brokers": "Brokers",
            "add-broker": "Add broker",
            "host": "Host",
            "port": "Port",
            "port-range": "Port should be in a range from 1 to 65535.",
            "ssl": "Ssl",
            "credentials": "Credentials",
            "username": "Username",
            "password": "Password",
            "retry-interval": "Retry interval in milliseconds",
            "anonymous": "Anonymous",
            "basic": "Basic",
            "pem": "PEM",
            "ca-cert": "CA certificate file *",
            "private-key": "Private key file *",
            "cert": "Certificate file *",
            "no-file": "No file selected.",
            "drop-file": "Drop a file or click to select a file to upload.",
            "mapping": "Mapping",
            "topic-filter": "Topic filter",
            "converter-type": "Converter type",
            "converter-json": "Json",
            "json-name-expression": "Device name json expression",
            "topic-name-expression": "Device name topic expression",
            "json-type-expression": "Device type json expression",
            "topic-type-expression": "Device type topic expression",
            "attribute-key-expression": "Attribute key expression",
            "attr-json-key-expression": "Attribute key json expression",
            "attr-topic-key-expression": "Attribute key topic expression",
            "request-id-expression": "Request id expression",
            "request-id-json-expression": "Request id json expression",
            "request-id-topic-expression": "Request id topic expression",
            "response-topic-expression": "Response topic expression",
            "value-expression": "Value expression",
            "topic": "Topic",
            "timeout": "Timeout in milliseconds",
            "converter-json-required": "Converter json is required.",
            "converter-json-parse": "Unable to parse converter json.",
            "filter-expression": "Filter expression",
            "connect-requests": "Connect requests",
            "add-connect-request": "Add connect request",
            "disconnect-requests": "Disconnect requests",
            "add-disconnect-request": "Add disconnect request",
            "attribute-requests": "Attribute requests",
            "add-attribute-request": "Add attribute request",
            "attribute-updates": "Attribute updates",
            "add-attribute-update": "Add attribute update",
            "server-side-rpc": "Server side RPC",
            "add-server-side-rpc-request": "Add server-side RPC request",
            "device-name-filter": "Device name filter",
            "attribute-filter": "Attribute filter",
            "method-filter": "Method filter",
            "request-topic-expression": "Request topic expression",
            "response-timeout": "Response timeout in milliseconds",
            "topic-expression": "Topic expression",
            "client-scope": "Client scope",
            "add-device": "Add device",
            "opc-server": "Servers",
            "opc-add-server": "Add server",
            "opc-add-server-prompt": "Please add server",
            "opc-application-name": "Application name",
            "opc-application-uri": "Application uri",
            "opc-scan-period-in-seconds": "Scan period in seconds",
            "opc-security": "Security",
            "opc-identity": "Identity",
            "opc-keystore": "Keystore",
            "opc-type": "Type",
            "opc-keystore-type": "Type",
            "opc-keystore-location": "Location *",
            "opc-keystore-password": "Password",
            "opc-keystore-alias": "Alias",
            "opc-keystore-key-password": "Key password",
            "opc-device-node-pattern": "Device node pattern",
            "opc-device-name-pattern": "Device name pattern",
            "modbus-server": "Servers/slaves",
            "modbus-add-server": "Add server/slave",
            "modbus-add-server-prompt": "Please add server/slave",
            "modbus-transport": "Transport",
            "modbus-port-name": "Serial port name",
            "modbus-encoding": "Encoding",
            "modbus-parity": "Parity",
            "modbus-baudrate": "Baud rate",
            "modbus-databits": "Data bits",
            "modbus-stopbits": "Stop bits",
            "modbus-databits-range": "Data bits should be in a range from 7 to 8.",
            "modbus-stopbits-range": "Stop bits should be in a range from 1 to 2.",
            "modbus-unit-id": "Unit ID",
            "modbus-unit-id-range": "Unit ID should be in a range from 1 to 247.",
            "modbus-device-name": "Device name",
            "modbus-poll-period": "Poll period (ms)",
            "modbus-attributes-poll-period": "Attributes poll period (ms)",
            "modbus-timeseries-poll-period": "Timeseries poll period (ms)",
            "modbus-poll-period-range": "Poll period should be positive value.",
            "modbus-tag": "Tag",
            "modbus-function": "Function",
            "modbus-register-address": "Register address",
            "modbus-register-address-range": "Register address should be in a range from 0 to 65535.",
            "modbus-register-bit-index": "Bit index",
            "modbus-register-bit-index-range": "Bit index should be in a range from 0 to 15.",
            "modbus-register-count": "Register count",
            "modbus-register-count-range": "Register count should be a positive value.",
            "modbus-byte-order": "Byte order",

            "sync": {
                "status": "Status",
                "sync": "Sync",
                "not-sync": "Not sync",
                "last-sync-time": "Last sync time",
                "not-available": "Not available"
            },

            "export-extensions-configuration": "Export extensions configuration",
            "import-extensions-configuration": "Import extensions configuration",
            "import-extensions": "Import extensions",
            "import-extension": "Import extension",
            "export-extension": "Export extension",
            "file": "Extensions file",
            "invalid-file-error": "Invalid extension file"
        },
        "fullscreen": {
            "expand": "전체화면으로 확장",
            "exit": "전체화면 종료",
            "toggle": "전체화면 모드 전환",
            "fullscreen": "전체화면"
        },
        "function": {
            "function": "기능"
        },
        "grid": {
            "delete-item-title": "이 항목을 삭제 하시겠습니까?",
            "delete-item-text": "항목과 모든 관련 데이터를 복구 할 수 없으므로 주의하십시오.",
            "delete-items-title": "{ count, select, 1 {아이템 1개} other {아이템 #개} }를 삭제하시겠습니까?",
            "delete-items-action-title": "{ count, select, 1 {아이템 1개} other {아이템 #개} } 삭제",
            "delete-items-text": "선택한 모든 아이템이 제거되고 관련된 모든 데이터는 복구 할 수 없으므로 주의하십시오.",
            "add-item-text": "새로운 아이템 추가",
            "no-items-text": "아이템이 없습니다.",
            "item-details": "아이템 상세",
            "delete-item": "아이템 삭제",
            "delete-items": "아이템 삭제",
            "scroll-to-top": "스크롤 맨 위로"
        },
        "help": {
            "goto-help-page": "도움"
        },
        "home": {
            "home": "홈",
            "profile": "프로파일",
            "logout": "로그아웃",
            "menu": "메뉴",
            "avatar": "Avatar",
            "open-user-menu": "사용자 메뉴 열기"
        },
        "import": {
            "no-file": "선택된 파일이 없습니다.",
            "drop-file": "JSON 파일을 끌어다 놓거나 클릭하여 업로드 할 파일을 선택하십시오."
        },
        "item": {
            "selected": "선택됨"
        },
        "js-func": {
            "no-return-error": "함수는 값을 반환해야 합니다!",
            "return-type-mismatch": "함수는 '{{type}}' 유형의 값을 반환해야 합니다!",
            "tidy": "Tidy" // TODO
        },
        "key-val": { // TODO
            "key": "Key",
            "value": "Value",
            "remove-entry": "Remove entry",
            "add-entry": "Add entry",
            "no-data": "No entries"
        },
        "layout": { // TODO
            "layout": "Layout",
            "manage": "Manage layouts",
            "settings": "Layout settings",
            "color": "Color",
            "main": "Main",
            "right": "Right",
            "select": "Select target layout"
        },
        "legend": {
            "position": "범례 위치",
            "show-max": "최대값 표시",
            "show-min": "최소값 표시",
            "show-avg": "평균값 표시",
            "show-total": "총합 표시",
            "settings": "범례 설정",
            "min": "최소",
            "max": "최대",
            "avg": "평균",
            "total": "합계"
        },
        "login": {
            "login": "로그인",
            "request-password-reset": "비밀번호 재설정",
            "reset-password": "비밀번호 재설정",
            "create-password": "비밀번호 생성",
            "passwords-mismatch-error": "입력된 비밀번호는 같아야 합니다!",
            "password-again": "비밀번호 확인",
            "sign-in": "로그인",
            "username": "사용자명 (이메일)",
            "remember-me": "아이디 저장",
            "forgot-password": "비밀번호찾기",
            "password-reset": "비밀번호 재설정",
            "new-password": "새 비밀번호",
            "new-password-again": "새 비밀번호 확인",
            "password-link-sent-message": "비밀번호 재설정 링크가 성공적으로 전송되었습니다!",
            "email": "이메일"
        },
        "position": {
            "top": "상단",
            "bottom": "하단",
            "left": "왼쪽",
            "right": "오른쪽"
        },
        "profile": {
            "profile": "프로파일",
            "change-password": "비밀번호 변경",
            "current-password": "현재 비밀번호"
        },
        "relation": { // TODO
            "relations": "Relations",
            "direction": "Direction",
            "search-direction": {
                "FROM": "From",
                "TO": "To"
            },
            "direction-type": {
                "FROM": "from",
                "TO": "to"
            },
            "from-relations": "Outbound relations",
            "to-relations": "Inbound relations",
            "selected-relations": "{ count, select, 1 {1 relation} other {# relations} } selected",
            "type": "Type",
            "to-entity-type": "To entity type",
            "to-entity-name": "To entity name",
            "from-entity-type": "From entity type",
            "from-entity-name": "From entity name",
            "to-entity": "To entity",
            "from-entity": "From entity",
            "delete": "Delete relation",
            "relation-type": "Relation type",
            "relation-type-required": "Relation type is required.",
            "any-relation-type": "Any type",
            "add": "Add relation",
            "edit": "Edit relation",
            "delete-to-relation-title": "Are you sure you want to delete relation to the entity '{{entityName}}'?",
            "delete-to-relation-text": "Be careful, after the confirmation the entity '{{entityName}}' will be unrelated from the current entity.",
            "delete-to-relations-title": "Are you sure you want to delete { count, select, 1 {1 relation} other {# relations} }?",
            "delete-to-relations-text": "Be careful, after the confirmation all selected relations will be removed and corresponding entities will be unrelated from the current entity.",
            "delete-from-relation-title": "Are you sure you want to delete relation from the entity '{{entityName}}'?",
            "delete-from-relation-text": "Be careful, after the confirmation current entity will be unrelated from the entity '{{entityName}}'.",
            "delete-from-relations-title": "Are you sure you want to delete { count, select, 1 {1 relation} other {# relations} }?",
            "delete-from-relations-text": "Be careful, after the confirmation all selected relations will be removed and current entity will be unrelated from the corresponding entities.",
            "remove-relation-filter": "Remove relation filter",
            "add-relation-filter": "Add relation filter",
            "any-relation": "Any relation",
            "relation-filters": "Relation filters",
            "additional-info": "Additional info (JSON)",
            "invalid-additional-info": "Unable to parse additional info json."
        },
        "rulechain": { // TODO
            "rulechain": "Rule chain",
            "rulechains": "Rule chains",
            "root": "Root",
            "delete": "Delete rule chain",
            "name": "Name",
            "name-required": "Name is required.",
            "description": "Description",
            "add": "Add Rule Chain",
            "set-root": "Make rule chain root",
            "set-root-rulechain-title": "Are you sure you want to make the rule chain '{{ruleChainName}}' root?",
            "set-root-rulechain-text": "After the confirmation the rule chain will become root and will handle all incoming transport messages.",
            "delete-rulechain-title": "Are you sure you want to delete the rule chain '{{ruleChainName}}'?",
            "delete-rulechain-text": "Be careful, after the confirmation the rule chain and all related data will become unrecoverable.",
            "delete-rulechains-title": "Are you sure you want to delete { count, select, 1 {1 rule chain} other {# rule chains} }?",
            "delete-rulechains-action-title": "Delete { count, select, 1 {1 rule chain} other {# rule chains} }",
            "delete-rulechains-text": "Be careful, after the confirmation all selected rule chains will be removed and all related data will become unrecoverable.",
            "add-rulechain-text": "Add new rule chain",
            "no-rulechains-text": "No rule chains found",
            "rulechain-details": "Rule chain details",
            "details": "Details",
            "events": "Events",
            "system": "System",
            "import": "Import rule chain",
            "export": "Export rule chain",
            "export-failed-error": "Unable to export rule chain: {{error}}",
            "create-new-rulechain": "Create new rule chain",
            "rulechain-file": "Rule chain file",
            "invalid-rulechain-file-error": "Unable to import rule chain: Invalid rule chain data structure.",
            "copyId": "Copy rule chain Id",
            "idCopiedMessage": "Rule chain Id has been copied to clipboard",
            "select-rulechain": "Select rule chain",
            "no-rulechains-matching": "No rule chains matching '{{entity}}' were found.",
            "rulechain-required": "Rule chain is required",
            "management": "Rules management",
            "debug-mode": "Debug mode"
        },
        "rulenode": { // TODO
            "details": "Details",
            "events": "Events",
            "search": "Search nodes",
            "open-node-library": "Open node library",
            "add": "Add rule node",
            "name": "Name",
            "name-required": "Name is required.",
            "type": "Type",
            "description": "Description",
            "delete": "Delete rule node",
            "select-all-objects": "Select all nodes and connections",
            "deselect-all-objects": "Deselect all nodes and connections",
            "delete-selected-objects": "Delete selected nodes and connections",
            "delete-selected": "Delete selected",
            "select-all": "Select all",
            "copy-selected": "Copy selected",
            "deselect-all": "Deselect all",
            "rulenode-details": "Rule node details",
            "debug-mode": "Debug mode",
            "configuration": "Configuration",
            "link": "Link",
            "link-details": "Rule node link details",
            "add-link": "Add link",
            "link-label": "Link label",
            "link-label-required": "Link label is required.",
            "custom-link-label": "Custom link label",
            "custom-link-label-required": "Custom link label is required.",
            "type-filter": "Filter",
            "type-filter-details": "Filter incoming messages with configured conditions",
            "type-enrichment": "Enrichment",
            "type-enrichment-details": "Add additional information into Message Metadata",
            "type-transformation": "Transformation",
            "type-transformation-details": "Change Message payload and Metadata",
            "type-action": "Action",
            "type-action-details": "Perform special action",
            "type-external": "External",
            "type-external-details": "Interacts with external system",
            "type-rule-chain": "Rule Chain",
            "type-rule-chain-details": "Forwards incoming messages to specified Rule Chain",
            "type-input": "Input",
            "type-input-details": "Logical input of Rule Chain, forwards incoming messages to next related Rule Node",
            "directive-is-not-loaded": "Defined configuration directive '{{directiveName}}' is not available.",
            "ui-resources-load-error": "Failed to load configuration ui resources.",
            "invalid-target-rulechain": "Unable to resolve target rule chain!",
            "test-script-function": "Test script function",
            "message": "Message",
            "message-type": "Message type",
            "message-type-required": "Message type is required",
            "metadata": "Metadata",
            "metadata-required": "Metadata entries can't be empty.",
            "output": "Output",
            "test": "Test",
            "help": "Help"
        },
        "tenant": {
            "tenants": "테넌트",
            "management": "테넌트 관리",
            "add": "테넌트 추가",
            "admins": "Admins",
            "manage-tenant-admins": "테넌트 관리자 관리",
            "delete": "테넌트 삭제",
            "add-tenant-text": "테넌트 추가",
            "no-tenants-text": "테넌트가 없습니다.",
            "tenant-details": "테넌트 상세정보",
            "delete-tenant-title": "'{{tenantTitle}}' 테넌트를 삭제하시겠습니까?",
            "delete-tenant-text": "테넌트와 관련된 모든 정보를 복구할 수 없으므로 주의하십시오.",
            "delete-tenants-title": "{ count, select, 1 {테넌트 1개} other {테넌트 #개} }를 삭제하시겠습니까?",
            "delete-tenants-action-title": "{ count, select, 1 {테넌트 1개} other {테넌트 #개} } 삭제",
            "delete-tenants-text": "선택된 테넌트가 삭제되고 관련된 모든 정보를 복구할 수 없으므로 주의하십시오.",
            "title": "타이틀",
            "title-required": "타이틀을 입력하세요.",
            "description": "설명",
            "details": "Details", // TODO
            "events": "Events", // TODO
            "copyId": "Copy tenant Id", // TODO
            "idCopiedMessage": "Tenant Id has been copied to clipboard", // TODO
            "select-tenant": "Select tenant", // TODO
            "no-tenants-matching": "No tenants matching '{{entity}}' were found.",
            "tenant-required": "Tenant is required" // TODO
        },
        "timeinterval": {
            "seconds-interval": "{ seconds, select, 1 {1 second} other {# seconds} }",
            "minutes-interval": "{ minutes, select, 1 {1 minute} other {# minutes} }",
            "hours-interval": "{ hours, select, 1 {1 hour} other {# hours} }",
            "days-interval": "{ days, select, 1 {1 day} other {# days} }",
            "days": "Days",
            "hours": "Hours",
            "minutes": "Minutes",
            "seconds": "Seconds",
            "advanced": "고급"
        },
        "timewindow": {
            "days": "{ days, select, 1 { day } other {# days } }",
            "hours": "{ hours, select, 0 { hour } 1 {1 hour } other {# hours } }",
            "minutes": "{ minutes, select, 0 { minute } 1 {1 minute } other {# minutes } }",
            "seconds": "{ seconds, select, 0 { second } 1 {1 second } other {# seconds } }",
            "realtime": "Realtime",
            "history": "History",
            "last-prefix": "last",
            "period": "from {{ startTime }} to {{ endTime }}",
            "edit": "타임윈도우 편집",
            "date-range": "날짜 범위",
            "last": "Last",
            "time-period": "기간"
        },
        "user": {
            "users": "사용자",
            "customer-users": "커스터머 사용자",
            "tenant-admins": "테넌트 관리자",
            "sys-admin": "시스템 관리자",
            "tenant-admin": "테넌트 관리자",
            "customer": "커스터머",
            "anonymous": "Anonymous",
            "add": "사용자 추가",
            "delete": "사용자 삭제",
            "add-user-text": "새로운 사용자 추가",
            "no-users-text": "사용자가 없습니다.",
            "user-details": "사용자 상세정보",
            "delete-user-title": "'{{userEmail}}' 사용자를 삭제하시겠습니까?",
            "delete-user-text": "사용자와 관련된 모든 데이터를 복구할 수 없으므로 주의하십시오.",
            "delete-users-title": "{ count, select, 1 {사용자 1명} other {사용자 #명} }을 삭제하시겠니까?",
            "delete-users-action-title": "{ count, select, 1 {사용자 1명} other {사용자 #명} } 삭제",
            "delete-users-text": "선택된 사용자가 삭제된고 관련된 모든 데이터를 복구할 수 없으므로 주의하십시오.",
            "activation-email-sent-message": "활성화 이메일을 보냈습니다!",
            "resend-activation": "활성화 재전송",
            "email": "Email",
            "email-required": "Email을 입력하세요.",
            "first-name": "이름",
            "last-name": "성",
            "description": "설명",
            "default-dashboard": "기본 대시보드",
            "always-fullscreen": "항상 전체화면",
            "select-user": "Select user", // TODO
            "no-users-matching": "No users matching '{{entity}}' were found.", // TODO
            "user-required": "User is required", // TODO
            "activation-method": "Activation method", // TODO
            "display-activation-link": "Display activation link", // TODO
            "send-activation-mail": "Send activation mail", // TODO
            "activation-link": "User activation link", // TODO
            "activation-link-text": "In order to activate user use the following <a href='{{activationLink}}' target='_blank'>activation link</a> :", // TODO
            "copy-activation-link": "Copy activation link", // TODO
            "activation-link-copied-message": "User activation link has been copied to clipboard", // TODO
            "details": "Details" // TODO
        },
        "value": {
            "type": "Value type",
            "string": "String",
            "string-value": "String value",
            "integer": "Integer",
            "integer-value": "Integer value",
            "invalid-integer-value": "Invalid integer value",
            "double": "Double",
            "double-value": "Double value",
            "boolean": "Boolean",
            "boolean-value": "Boolean value",
            "false": "False",
            "true": "True"
        },
        "widget": {
            "widget-library": "위젯 저장소",
            "widget-bundle": "위젯 번들",
            "select-widgets-bundle": "위젯 번들 선택",
            "management": "위젯 관리",
            "editor": "위젯 편집기",
            "widget-type-not-found": "위젯 구성을 로드하는 중 문제가 발생했습니다.<br>연결된 위젯 타입이 삭제되었습니다.",
            "widget-type-load-error": "다음과 같은 오류로 인해 위젯이로드되지 않았습니다:",
            "remove": "위젯 삭제",
            "edit": "위젯 수정",
            "remove-widget-title": "'{{widgetTitle}}' 위젯을 삭제하시겠습니까?",
            "remove-widget-text": "위젯과 관련된 모든 데이터를 복구할 수 없으므로 주의하십시오.",
            "timeseries": "Time series",
            "latest-values": "Latest values",
            "rpc": "Control 위젯",
            "static": "Static 위젯",
            "select-widget-type": "위젯 타입 선택",
            "missing-widget-title-error": "위젯 타이틀을 입력하세요!",
            "widget-saved": "위젯이 저장되었습니다.",
            "unable-to-save-widget-error": "위젯을 저장할 수 없습니다! 위젯에 오류가 있습니다!",
            "save": "위젯 저장",
            "saveAs": "다른 이름으로 위젯 저장",
            "save-widget-type-as": "다른 이름으로 위젯 타입 저장",
            "save-widget-type-as-text": "새로운 위젯 이름과 위젯 번들을 선택하세요.",
            "toggle-fullscreen": "전체화면 전환",
            "run": "위젯 실행",
            "title": "위젯 타이틀",
            "title-required": "위젯 타이틀을 입력하세요.",
            "type": "위젯 타입",
            "resources": "리소스",
            "resource-url": "JavaScript/CSS URI",
            "remove-resource": "리소스 삭제",
            "add-resource": "리소스 추가",
            "html": "HTML",
            "tidy": "Tidy",
            "css": "CSS",
            "settings-schema": "스키마 설정",
            "datakey-settings-schema": "데이터 키 설정 스키마",
            "javascript": "Javascript",
            "remove-widget-type-title": "'{{widgetName}}' 위젯 타입을 삭제하시겠습니까?",
            "remove-widget-type-text": "위젯 타입과 관련된 모든 데이터를 복구할 수 없으므로 주의하십시오.",
            "remove-widget-type": "위젯 타입 삭제",
            "add-widget-type": "새로운 위젯 타입 추가",
            "widget-type-load-failed-error": "위젯 타입을 로드하지 못했습니다!",
            "widget-template-load-failed-error": "위젯 템플릿을 로드하지 못했습니다!",
            "add": "위젯 추가",
            "undo": "위젯 변경사항 취소",
            "export": "위젯 내보내기"
        },
        "widget-action": { // TODO
            "header-button": "Widget header button",
            "open-dashboard-state": "Navigate to new dashboard state",
            "update-dashboard-state": "Update current dashboard state",
            "open-dashboard": "Navigate to other dashboard",
            "custom": "Custom action",
            "target-dashboard-state": "Target dashboard state",
            "target-dashboard-state-required": "Target dashboard state is required",
            "set-entity-from-widget": "Set entity from widget",
            "target-dashboard": "Target dashboard",
            "open-right-layout": "Open right dashboard layout (mobile view)"
        },
        "widgets-bundle": {
            "current": "현재 번들",
            "widgets-bundles": "위젯 번들",
            "add": "위젯 번들 추가",
            "delete": "위젯 번들 삭제",
            "title": "타이틀",
            "title-required": "타이틀을 입력하세요.",
            "add-widgets-bundle-text": "위젯 번들 추가",
            "no-widgets-bundles-text": "위젯 번들이 없습니다.",
            "empty": "위젯 번들이 비어있습니다.",
            "details": "상세",
            "widgets-bundle-details": "위젯 번들 상세정보",
            "delete-widgets-bundle-title": "'{{widgetsBundleTitle}}' 위젯 번들을 삭제하시겠습니까?",
            "delete-widgets-bundle-text": "위젯 번들과 관련된 모든 데이터를 복구할 수 없으므로 주의하십시오.",
            "delete-widgets-bundles-title": "{ count, select, 1 {위젯 번들 1개} other {위젯 번들 #개} }를 삭제하시겠습니까?",
            "delete-widgets-bundles-action-title": "{ count, select, 1 {위젯 번들 1개} other {위젯 번들 #개} } 삭제",
            "delete-widgets-bundles-text": "선택된 위젯 번들이 삭제되고 관련된 모든 데이터를 복구할 수 없으므로 주의하십시오.",
            "no-widgets-bundles-matching": "'{{widgetsBundle}}' 와(과) 일치하는 위젯 번들을 찾을 수 없습니다.",
            "widgets-bundle-required": "위젯 번들을 입력하세요.",
            "system": "시스템",
            "import": "위젯 번들 가져오기",
            "export": "위젯 번들 내보내기",
            "export-failed-error": "위젯 번들을 내보내기 할 수 없습니다.: {{error}}",
            "create-new-widgets-bundle": "새로운 위젯 번들 생성",
            "widgets-bundle-file": "위젯 번들 파일",
            "invalid-widgets-bundle-file-error": "위젯 번들을 가져오기 할 수 없습니다.: 잘못된 위젯 번들 데이터 구조입니다."
        },
        "widget-config": {
            "data": "데이터",
            "settings": "설정",
            "advanced": "고급",
            "title": "타이틀",
            "general-settings": "일반 설정",
            "display-title": "타이틀 표시",
            "drop-shadow": "그림자",
            "enable-fullscreen": "전체화면 사용 ",
            "background-color": "배경 색",
            "text-color": "글자 색",
            "padding": "패딩",
            "title-style": "타이틀 스타일",
            "mobile-mode-settings": "모바일 모드 설정",
            "order": "순서",
            "height": "높이",
            "units": "값 옆에 표시할 특수 기호",
            "decimals": "소수점 이하 자릿수",
            "timewindow": "타임윈도우",
            "use-dashboard-timewindow": "대시보드 타임윈도우",
            "display-legend": "범례 표시",
            "datasources": "데이터소스",
            "datasource-type": "유형",
            "datasource-parameters": "파라미터",
            "remove-datasource": "데이터소스 삭제",
            "add-datasource": "데이터소스 추가",
            "target-device": "대상 디바이스"
        },
        "widget-type": {
            "import": "위젯 타입 가져오기",
            "export": "위젯 타입 내보내기",
            "export-failed-error": "위젯 타입을 내보내기 할 수 없습니다.: {{error}}",
            "create-new-widget-type": "새로운 위젯 타입 생성",
            "widget-type-file": "위젯 타입 파일",
            "invalid-widget-type-file-error": "위젯 타입을 가져오기 할 수 없습니다.: 잘못된 위젯 타입 데이터 구조입니다."
        },
        "icon": { // TODO
            "icon": "Icon",
            "select-icon": "Select icon",
            "material-icons": "Material icons",
            "show-all": "Show all icons"
        },
        "custom": {
            "widget-action": {
                "action-cell-button": "Action cell button",
                "row-click": "On row click",
                "marker-click": "On marker click",
                "tooltip-tag-action": "Tooltip tag action"
            }
        },
        "language": {
            "language": "언어",
            "en_US": "영어",
            "ko_KR": "한글",
            "zh_CN": "중국어",
            "ru_RU": "러시아어",
            "es_ES": "스페인어"
        }
    };
    angular.extend(locales, { 'ko_KR': ko_KR });
}