package org.keycloak.models;

import java.util.Set;

/**
 * @author <a href="mailto:bill@burkecentral.com">Bill Burke</a>
 * @version $Revision: 1 $
 */
public interface RoleModel {
    String getName();

    String getDescription();

    void setDescription(String description);

    String getId();

    void setName(String name);

    boolean isScopeParamRequired();

    void setScopeParamRequired(boolean scopeParamRequired);

    boolean isComposite();

    void addCompositeRole(RoleModel role);

    void removeCompositeRole(RoleModel role);

    Set<RoleModel> getComposites();

    RoleContainerModel getContainer();

    boolean hasRole(RoleModel role);

}
