/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.aplcache.metadata;

import br.ufrgs.inf.prosoft.aplcache.flowchart.metrics.Metrics;
import br.ufrgs.inf.prosoft.aplcache.flowchart.metrics.Thresholds;
import org.apache.commons.lang3.builder.EqualsBuilder;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

/**
 * @author romulo
 */
public class GroupOfOccurrences {

  private final Metrics metrics;
  private final List<Occurrence> occurrences;
  private final String parameters;

  public GroupOfOccurrences(String parameters) {
    this.parameters = parameters;
    this.metrics = new Metrics();
    this.occurrences = new ArrayList<>();
  }

  public Metrics getMetrics() {
    return metrics;
  }

  public void addOccurrence(Occurrence occurrence) {
    this.occurrences.add(occurrence);
  }

  public String getParameters() {
    return parameters;
  }

  public int getOccurrencesSize() {
    return this.occurrences.size();
  }

  public Stream<Occurrence> occurrences() {
    return this.occurrences.stream();
  }

  protected void calculateMetrics() {
    if (this.occurrences.size() == 1) {
      this.metrics.addSameOccurrence(this.occurrences.get(0));
      return;
    }
    for (int i = 0; i < this.occurrences.size(); i++) {
      Occurrence occurrence = this.occurrences.get(i);
      Object returnValue = occurrence.getReturnValue();
      for (int j = i + 1; j < this.occurrences.size(); j++) {
        Occurrence other = this.occurrences.get(j);
        if (EqualsBuilder.reflectionEquals(returnValue, other.getReturnValue())) {
          this.metrics.addSameOccurrence(occurrence);
          continue;
        }
        this.metrics.addDifferentReturnOccurrence();
      }
    }
  }

  protected void calculateThresholds() {
    Thresholds.sumExecutionTime += this.metrics.getSameOccurrencesTotalExecutionTime();
    Thresholds.executionTimes.add(this.metrics.getSameOccurrencesTotalExecutionTime());

    Thresholds.sumHitRatio += this.metrics.getHitRatio();
    Thresholds.hitRatios.add(this.metrics.getHitRatio());

    Thresholds.sumMissRatio += this.metrics.getMissRatio();
    Thresholds.missRatios.add(this.metrics.getMissRatio());

    Thresholds.sumShareability += this.metrics.getShareability();
    Thresholds.shareabilities.add(this.metrics.getShareability());

    Thresholds.sumFrequency += this.metrics.getNumberOfSameOccurrences();
    Thresholds.frequencies.add(this.metrics.getNumberOfSameOccurrences());
  }

}
