/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata;

import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.stats.Stats;
import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.stats.Thresholds;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;

/**
 *
 * @author romulo
 */
public class GroupOfOccurrences {

    private final Stats stats;
    private final List<Occurrence> occurrences;

    public GroupOfOccurrences() {
        this.stats = new Stats();
        this.occurrences = new ArrayList<>();
    }

    public Stats getStats() {
        return stats;
    }

    public void addOccurrence(Occurrence occurrence) {
        this.occurrences.add(occurrence);
    }

    protected void countStats() {
        if (this.occurrences.size() == 1) {
            this.stats.addSameOccurrence(this.occurrences.get(0));
            return;
        }
        for (int i = 0; i < this.occurrences.size(); i++) {
            Occurrence occurrence = this.occurrences.get(i);
//            load concrete
            for (int j = i + 1; j < this.occurrences.size(); j++) {
                Occurrence other = this.occurrences.get(j);
                if (EqualsBuilder.reflectionEquals(occurrence.getReturnValue(), other.getReturnValue())) {
                    this.stats.addSameOccurrence(occurrence);
                    continue;
                }
                this.stats.addDifferentReturnOccurrence();
            }
//            remove
        }
    }

    protected void calculateThresholds() {
        Thresholds.sumExecutionTime += this.stats.getSameOccurrencesTotalExecutionTime();
        Thresholds.executionTimes.add(this.stats.getSameOccurrencesTotalExecutionTime());

        Thresholds.sumHitRatio += this.stats.getHitRatio();
        Thresholds.hitRatios.add(this.stats.getHitRatio());

        Thresholds.sumMissRatio += this.stats.getMissRatio();
        Thresholds.missRatios.add(this.stats.getMissRatio());

        Thresholds.sumShareability += this.stats.getShareability();
        Thresholds.shareabilities.add(this.stats.getShareability());

        Thresholds.sumFrequency += this.stats.getNumberOfSameOccurrences();
        Thresholds.frequencies.add(this.stats.getNumberOfSameOccurrences());
    }

}
