package br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata;

import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.ehcache.sizeof.SizeOf;

public abstract class Occurrence {

    private final long startTime;
    private final long endTime;
    private final String userId;

    public Occurrence(long startTime, long endTime, String userId) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.userId = userId;
    }

    public long getExecutionTime() {
        return endTime - startTime;
    }

    public String getUserId() {
        return userId;
    }

    public abstract Object[] getParameters();

    public abstract Object getReturnValue();

    public long getSizeOfReturnedValue() {
        SizeOf sizeOf = SizeOf.newInstance();
        return sizeOf.sizeOf(getReturnValue());
    }

    @Deprecated
    public boolean equalsWithoutReturnedValue(Occurrence o) {
        System.out.println("DEPRECATED");

        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Object[] thisArguments = getParameters();
        Object[] otherArguments = o.getParameters();
        return Objects.deepEquals(thisArguments, otherArguments)
                || EqualsBuilder.reflectionEquals(thisArguments, otherArguments);
    }

    @Override
    @Deprecated
    public int hashCode() {
        System.out.println("DEPRECATED");
        int result = (int) (startTime ^ (startTime >>> 32));
        result = 31 * result + (int) (endTime ^ (endTime >>> 32));
        result = 31 * result + (userId != null ? userId.hashCode() : 0);
        return result;
    }

    @Override
    @Deprecated
    public boolean equals(Object o) {
        System.out.println("DEPRECATED");
        if (this == o) {
            return true;
        }
        if (!(o instanceof Occurrence)) {
            return false;
        }
        Occurrence logTrace = (Occurrence) o;
        if (endTime != logTrace.endTime) {
            return false;
        }
        if (startTime != logTrace.startTime) {
            return false;
        }
        if (userId != null ? !userId.equals(logTrace.userId) : logTrace.userId != null) {
            return false;
        }
        Object[] thisArguments = getParameters();
        Object[] thatArguments = logTrace.getParameters();
        if (!EqualsBuilder.reflectionEquals(thisArguments, thatArguments)) {
            return false;
        }
        thisArguments = null;
        thatArguments = null;
        Object thisReturnedValue = getReturnValue();
        Object thatReturnedValue = logTrace.getReturnValue();
        return EqualsBuilder.reflectionEquals(thisReturnedValue, thatReturnedValue)
                || Objects.deepEquals(thisReturnedValue, thatReturnedValue);
    }
}
