/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata;

import br.ufrgs.inf.prosoft.trace.TraceConcrete;
import br.ufrgs.inf.prosoft.trace.reader.Traces;
import java.util.stream.Collectors;

/**
 *
 * @author romulo
 */
public class OccurrenceReference extends Occurrence {

    private final int index;

    public OccurrenceReference(int index, long startTime, long endTime, String userId) {
        super(startTime, endTime, userId);
        this.index = index;
    }

    @Override
    public Object[] getParameters() {
        TraceConcrete traceConcrete = Traces.getTraceConcrete(index);
        return traceConcrete.getParameters().stream()
                .map(trace -> trace.getData())
                .collect(Collectors.toList())
                .toArray();
    }

    @Override
    public Object getReturnValue() {
        TraceConcrete traceConcrete = Traces.getTraceConcrete(index);
        return traceConcrete.getReturn().getData();
    }
}
