/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.approachescomparison.adapter;

import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.FlowchartWorkFlow;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.Method;
import br.ufrgs.inf.prosoft.trace.Trace;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author romulo
 */
public class Main {

    private static final Logger logger = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT+%1$tL] [%4$-7s] [APLCache] %5$s %n");

        String path = null;
        if (args.length < 1) {
            System.err.println("No path provided");
            System.exit(1);
        } else {
            path = args[0];
        }
        logger.log(Level.INFO, "Reading traces");
        List<Trace> traces = TraceReader.partiallyParseFile(path);
        logger.log(Level.INFO, "Grouping by methods");
        Collection<Method> methods = TraceReader.groupByMethods(traces);
        FlowchartWorkFlow flowchartWorkFlow = new FlowchartWorkFlow();
        flowchartWorkFlow.setMethods(methods);
        logger.log(Level.INFO, "Filtering cacheable methods");
        flowchartWorkFlow.filterCacheableInputs();
    }
}
