package br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.stats;

import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.GroupOfOccurrences;
import java.util.Optional;

public class CacheabilityMetrics {

    public static Optional<Boolean> isStaticData(GroupOfOccurrences groupOfOccurrences) {
        if (groupOfOccurrences.getMetrics().getNumberOfSameOccurrences() < Thresholds.frequencyThreshold(0)) {
            return Optional.empty();
        }
        if (groupOfOccurrences.getMetrics().getHitRatio() == 100.0) {
            return Optional.of(true);
        } else {
            return Optional.of(false);
        }
    }

    public static Optional<Boolean> changeMoreThanUsed(GroupOfOccurrences groupOfOccurrences) {
        //+/- k sds
        if (groupOfOccurrences.getMetrics().getMissRatio() > Thresholds.missThreshold(0)) {
            return Optional.of(true);
        } else {
            return Optional.of(false);
        }
    }

    public static Optional<Boolean> usedByManyRequests(GroupOfOccurrences groupOfOccurrences) {
        if (groupOfOccurrences.getMetrics().getNumberOfSameOccurrences() >= Thresholds.frequencyThreshold(0)) {
            return Optional.of(true);
        } else {
            return Optional.of(false);
        }
    }

    public static Optional<Boolean> isUserSpecific(GroupOfOccurrences groupOfOccurrences) {
        if (groupOfOccurrences.getMetrics().getAmountOfIdentifiedSameOccurences() == 0) {
            return Optional.empty();
        }

        //the less shareable, the more user specific
        if (groupOfOccurrences.getMetrics().getShareability() < Thresholds.shareabilityThreshold(0)) {
            return Optional.of(true);
        } else {
            return Optional.of(false);
        }
    }

    public static Optional<Boolean> isExpensive(GroupOfOccurrences groupOfOccurrences) {
        if (groupOfOccurrences.getMetrics().getSameOccurrencesAverageExecutionTime() >= Thresholds.expensivenessThreshold(0)) {
            return Optional.of(true);
        } else {
            return Optional.of(false);
        }
    }

}
