package br.ufrgs.inf.prosoft.aplcache.flowchart.metrics;

import br.ufrgs.inf.prosoft.aplcache.metadata.GroupOfOccurrences;
import java.util.Optional;

public class CacheabilityMetrics {

    public static int K_STANDARD_DEVIATION = 0;

    public static Optional<Boolean> isStaticData(GroupOfOccurrences groupOfOccurrences) {
        if (groupOfOccurrences.getMetrics().getNumberOfSameOccurrences() < Thresholds.frequencyThreshold(K_STANDARD_DEVIATION)) {
            return Optional.empty();
        }
        return Optional.of(groupOfOccurrences.getMetrics().getHitRatio() == 100.0);
    }

    public static Optional<Boolean> changeMoreThanUsed(GroupOfOccurrences groupOfOccurrences) {
        //+/- k sds
        return Optional.of(groupOfOccurrences.getMetrics().getMissRatio() > Thresholds.missThreshold(K_STANDARD_DEVIATION));
    }

    public static Optional<Boolean> usedByManyRequests(GroupOfOccurrences groupOfOccurrences) {
        return Optional.of(groupOfOccurrences.getMetrics().getNumberOfSameOccurrences() >= Thresholds.frequencyThreshold(K_STANDARD_DEVIATION));
    }

    public static Optional<Boolean> isUserSpecific(GroupOfOccurrences groupOfOccurrences) {
        if (groupOfOccurrences.getMetrics().getAmountOfIdentifiedSameOccurences() == 0) {
            return Optional.empty();
        }
        //the less shareable, the more user specific
        return Optional.of(groupOfOccurrences.getMetrics().getShareability() < Thresholds.shareabilityThreshold(K_STANDARD_DEVIATION));
    }

    public static Optional<Boolean> isExpensive(GroupOfOccurrences groupOfOccurrences) {
        return Optional.of(groupOfOccurrences.getMetrics().getSameOccurrencesAverageExecutionTime() >= Thresholds.expensivenessThreshold(K_STANDARD_DEVIATION));
    }
}
