package br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata;

import org.apache.commons.lang3.builder.EqualsBuilder;

import java.util.Objects;
import org.ehcache.sizeof.SizeOf;

public class MethodInfo {

    private String signature;

    private transient Object[] arguments;

    private transient Object returnedValue;

    
    private long sizeOfReturnedValue;

//    private Integer hashedReturnedValue;
//    private Integer hashedArguments;

    public MethodInfo(String signature, Object[] arguments) {
        this.signature = signature;
        this.arguments = arguments;

//        try {
//            //TODO hash or not???
//            this.hashedArguments = HashCodeBuilder.reflectionHashCode(arguments);
//        } catch (Exception e) {
//        }
    }

    public MethodInfo(String signature, Object[] arguments, Object returnedValue) {
        this(signature, arguments);
        this.returnedValue = returnedValue;
        SizeOf sizeOf = SizeOf.newInstance();
        this.sizeOfReturnedValue = sizeOf.sizeOf(this.returnedValue);

//        try {
//            //TODO hash or not???
//            this.hashedArguments = HashCodeBuilder.reflectionHashCode(arguments);
//            this.hashedReturnedValue = HashCodeBuilder.reflectionHashCode(returnedValue);
//        } catch (Exception e) {
//        }
    }
    
    public String getSignature() {
        return this.signature;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public Object getReturnedValue() {
        return this.returnedValue;
    }
    public boolean equalsWithoutReturnedValue(MethodInfo o) {

        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        if (!signature.equals(o.signature)) {
            return false;
        }
        if (!(Objects.deepEquals(arguments, o.arguments) || EqualsBuilder.reflectionEquals(arguments, o.arguments))) {
            return false;
        }

        return true;
        //return EqualsBuilder.reflectionEquals(this, o, "returnedValue", "key");
    }

    @Override
    public boolean equals(Object o) {
//        return EqualsBuilder.reflectionEquals(this, o, "key");

        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        MethodInfo that = (MethodInfo) o;

        if (!signature.equals(that.signature)) {
            return false;
        }
        if (!EqualsBuilder.reflectionEquals(arguments, that.arguments)) {
            return false;
        }
        return EqualsBuilder.reflectionEquals(returnedValue, that.returnedValue) || Objects.deepEquals(returnedValue, that.returnedValue);
    }

//    public boolean equalsHashed(Object o) {
//        if (this == o) return true;
//        if (o == null || getClass() != o.getClass()) return false;
//
//        MethodInfo that = (MethodInfo) o;
//
//        if (!signature.equals(that.signature)) return false;
//        if (!Objects.deepEquals(hashedArguments, that.hashedArguments)) return false;
//        return hashedReturnedValue != null ? Objects.deepEquals(hashedReturnedValue, that.hashedReturnedValue) : that.hashedReturnedValue == null;
//    }
//
//    public boolean equalsHashedWithoutReturnedValue(Object o) {
//        if (this == o) return true;
//        if (o == null || getClass() != o.getClass()) return false;
//
//        MethodInfo that = (MethodInfo) o;
//
//        if (!signature.equals(that.signature)) return false;
//        if (!Objects.deepEquals(hashedArguments, that.hashedArguments)) return false;
//        return true;
//    }
//    public Integer getHashedReturnedValue() {
//        return hashedReturnedValue;
//    }
//
//    public Integer getHashedArguments() {
//        return hashedArguments;
//    }
//
//    public void setArguments(Object[] arguments) {
//        this.arguments = arguments;
//    }
//
//    public void setReturnedValue(Object returnedValue) {
//        this.returnedValue = returnedValue;
//    }
    @Override
    public int hashCode() {
        //TODO equals is enough to distinghish, not able to get a unique hashcode
        return 1;
        //return HashCodeBuilder.reflectionHashCode(this, "key");
    }

    public String toString() {
        return "br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.MethodInfo(signature=" + this.signature + ", arguments=" + this.arguments + ", returnedValue=" + this.returnedValue + ")";
    }

    public long getSizeOfReturnedValue() {
        return this.sizeOfReturnedValue;
    }
}
